/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-04-07 00:21:39 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `wp13_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp13_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp13_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `attempts` int(11) NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1083 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp13_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=2035 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp13_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp13_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=3229 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp13_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp13_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp13_duplicator_backups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `archive_name` varchar(350) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `status` int(11) NOT NULL,
  `progress` float NOT NULL DEFAULT '0',
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE') COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `version` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`(191)),
  KEY `archive_name` (`archive_name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp13_duplicator_entities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value_1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_2` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_3` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_4` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_5` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `version` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`(191)),
  KEY `value_2` (`value_2`(191)),
  KEY `value_3` (`value_3`(191)),
  KEY `value_4` (`value_4`(191)),
  KEY `value_5` (`value_5`(191))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp13_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp13_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=24609 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp13_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=309 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp13_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp13_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp13_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp13_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp13_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp13_wpforms_tasks_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `action` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `wp13_users` VALUES 
("1","Admin","$P$BBtYFuleolV1gNMu1pXPbkLkA6TtdG.","Admin","gen@pmoadvisory.com","https://iexperipress.com","2021-07-12 04:07:19","","0","Admin");

INSERT IGNORE INTO `wp13_usermeta` VALUES 
("1","1","nickname","Admin"),
("2","1","first_name",""),
("3","1","last_name",""),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","wp13_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("13","1","wp13_user_level","10"),
("14","1","dismissed_wp_pointers","om-welcome-pointer,omapi_please_connect_notice"),
("15","1","show_welcome_panel","1"),
("16","1","session_tokens","a:2:{s:64:\"985bea3ce97df340d0bb4f8e27d7dd1982cb4892a646627604ad371f04cf0ff1\";a:4:{s:10:\"expiration\";i:1712611879;s:2:\"ip\";s:12:\"186.84.22.91\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/123.0.0.0 Safari/537.36\";s:5:\"login\";i:1712439079;}s:64:\"1817d3a5171e5ea7838beb7508ec68338cd4fdd9b11b99761e4b07b5f352d79b\";a:4:{s:10:\"expiration\";i:1712612055;s:2:\"ip\";s:12:\"186.84.22.91\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/123.0.0.0 Safari/537.36\";s:5:\"login\";i:1712439255;}}"),
("17","1","eig_last_login","2021-07-12T04:08:40+00:00"),
("18","1","jetpack_tracks_anon_id","jetpack:fmdtuOSDgY94iuBfaHbmhvSo"),
("19","1","wp13_dashboard_quick_press_last_post_id","75"),
("20","1","community-events-location","a:1:{s:2:\"ip\";s:11:\"186.84.22.0\";}"),
("21","1","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("22","1","metaboxhidden_nav-menus","a:5:{i:0;s:21:\"add-post-type-project\";i:1;s:12:\"add-post_tag\";i:2;s:15:\"add-post_format\";i:3;s:20:\"add-project_category\";i:4;s:15:\"add-project_tag\";}");

INSERT IGNORE INTO `wp13_actionscheduler_actions` VALUES 
("1043","wpforms_admin_addons_cache_update","complete","2024-03-11 11:08:50","2024-03-11 11:08:50","{\"tasks_meta_id\":2}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1710155330;s:18:\"\0*\0first_timestamp\";i:1626667729;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1710155330;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}","2","1","2024-03-11 12:19:34","2024-03-11 12:19:34","0",NULL),
("1044","wpforms_email_summaries_fetch_info_blocks","complete","2024-03-11 11:08:50","2024-03-11 11:08:50","{\"tasks_meta_id\":null}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1710155330;s:18:\"\0*\0first_timestamp\";i:1625894106;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1710155330;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}","2","1","2024-03-11 12:19:34","2024-03-11 12:19:34","0",NULL),
("1046","wpforms_process_entry_emails_meta_cleanup","complete","2024-03-06 16:35:38","2024-03-06 16:35:38","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1709742938;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1709742938;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-03-07 01:26:36","2024-03-07 01:26:36","0",NULL),
("1047","wpforms_process_entry_emails_meta_cleanup","complete","2024-03-08 01:26:36","2024-03-08 01:26:36","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1709861196;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1709861196;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-03-08 07:20:29","2024-03-08 07:20:29","0",NULL),
("1048","wpforms_process_entry_emails_meta_cleanup","complete","2024-03-09 07:20:29","2024-03-09 07:20:29","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1709968829;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1709968829;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-03-09 09:00:24","2024-03-09 09:00:24","0",NULL),
("1049","wpforms_process_entry_emails_meta_cleanup","complete","2024-03-10 09:00:24","2024-03-10 09:00:24","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1710061224;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1710061224;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-03-10 11:15:56","2024-03-10 11:15:56","0",NULL),
("1050","wpforms_process_entry_emails_meta_cleanup","complete","2024-03-11 11:15:56","2024-03-11 11:15:56","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1710155756;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1710155756;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-03-11 12:19:34","2024-03-11 12:19:34","0",NULL),
("1051","wpforms_admin_addons_cache_update","complete","2024-03-18 12:19:34","2024-03-18 12:19:34","{\"tasks_meta_id\":2}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1710764374;s:18:\"\0*\0first_timestamp\";i:1626667729;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1710764374;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}","2","1","2024-03-18 16:24:54","2024-03-18 16:24:54","0",NULL),
("1052","wpforms_email_summaries_fetch_info_blocks","complete","2024-03-18 12:19:34","2024-03-18 12:19:34","{\"tasks_meta_id\":null}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1710764374;s:18:\"\0*\0first_timestamp\";i:1625894106;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1710764374;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}","2","1","2024-03-18 16:24:54","2024-03-18 16:24:54","0",NULL),
("1053","wpforms_process_entry_emails_meta_cleanup","complete","2024-03-12 12:19:34","2024-03-12 12:19:34","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1710245974;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1710245974;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-03-12 13:36:48","2024-03-12 13:36:48","0",NULL),
("1054","wpforms_process_entry_emails_meta_cleanup","complete","2024-03-13 13:36:48","2024-03-13 13:36:48","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1710337008;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1710337008;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-03-13 18:38:39","2024-03-13 18:38:39","0",NULL),
("1055","wpforms_process_entry_emails_meta_cleanup","complete","2024-03-14 18:38:39","2024-03-14 18:38:39","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1710441519;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1710441519;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-03-14 23:29:26","2024-03-14 23:29:26","0",NULL),
("1056","wpforms_process_entry_emails_meta_cleanup","complete","2024-03-15 23:29:26","2024-03-15 23:29:26","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1710545366;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1710545366;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-03-16 06:58:24","2024-03-16 06:58:24","0",NULL),
("1057","wpforms_process_entry_emails_meta_cleanup","complete","2024-03-17 06:58:24","2024-03-17 06:58:24","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1710658704;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1710658704;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-03-17 11:39:28","2024-03-17 11:39:28","0",NULL),
("1058","wpforms_process_entry_emails_meta_cleanup","complete","2024-03-18 11:39:28","2024-03-18 11:39:28","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1710761968;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1710761968;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-03-18 16:24:54","2024-03-18 16:24:54","0",NULL),
("1059","wpforms_admin_addons_cache_update","complete","2024-03-25 16:24:54","2024-03-25 16:24:54","{\"tasks_meta_id\":2}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711383894;s:18:\"\0*\0first_timestamp\";i:1626667729;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711383894;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}","2","1","2024-03-25 16:42:38","2024-03-25 16:42:38","0",NULL),
("1060","wpforms_email_summaries_fetch_info_blocks","complete","2024-03-25 16:24:54","2024-03-25 16:24:54","{\"tasks_meta_id\":null}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711383894;s:18:\"\0*\0first_timestamp\";i:1625894106;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711383894;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}","2","1","2024-03-25 16:42:39","2024-03-25 16:42:39","0",NULL),
("1061","wpforms_process_entry_emails_meta_cleanup","complete","2024-03-19 16:24:54","2024-03-19 16:24:54","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1710865494;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1710865494;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-03-19 17:00:32","2024-03-19 17:00:32","0",NULL),
("1062","wpforms_process_entry_emails_meta_cleanup","complete","2024-03-20 17:00:32","2024-03-20 17:00:32","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1710954032;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1710954032;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-03-20 17:50:34","2024-03-20 17:50:34","0",NULL),
("1063","wpforms_process_entry_emails_meta_cleanup","complete","2024-03-21 17:50:34","2024-03-21 17:50:34","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711043434;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711043434;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-03-22 00:28:21","2024-03-22 00:28:21","0",NULL),
("1064","wpforms_process_entry_emails_meta_cleanup","complete","2024-03-23 00:28:21","2024-03-23 00:28:21","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711153701;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711153701;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-03-23 00:33:06","2024-03-23 00:33:06","0",NULL),
("1065","wpforms_process_entry_emails_meta_cleanup","complete","2024-03-24 00:33:06","2024-03-24 00:33:06","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711240386;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711240386;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-03-24 02:02:20","2024-03-24 02:02:20","0",NULL),
("1066","wpforms_process_entry_emails_meta_cleanup","complete","2024-03-25 02:02:20","2024-03-25 02:02:20","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711332140;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711332140;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-03-25 07:32:18","2024-03-25 07:32:18","0",NULL),
("1067","wpforms_process_entry_emails_meta_cleanup","complete","2024-03-26 07:32:18","2024-03-26 07:32:18","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711438338;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711438338;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-03-26 23:16:09","2024-03-26 23:16:09","0",NULL),
("1068","wpforms_admin_addons_cache_update","complete","2024-04-01 16:42:38","2024-04-01 16:42:38","{\"tasks_meta_id\":2}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711989758;s:18:\"\0*\0first_timestamp\";i:1626667729;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711989758;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}","2","1","2024-04-01 21:10:58","2024-04-01 21:10:58","0",NULL),
("1069","wpforms_email_summaries_fetch_info_blocks","complete","2024-04-01 16:42:39","2024-04-01 16:42:39","{\"tasks_meta_id\":null}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711989759;s:18:\"\0*\0first_timestamp\";i:1625894106;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711989759;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}","2","1","2024-04-01 21:10:58","2024-04-01 21:10:58","0",NULL),
("1070","wpforms_process_entry_emails_meta_cleanup","complete","2024-03-27 23:16:09","2024-03-27 23:16:09","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711581369;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711581369;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-03-28 11:17:19","2024-03-28 11:17:19","0",NULL),
("1071","wpforms_process_entry_emails_meta_cleanup","complete","2024-03-29 11:17:19","2024-03-29 11:17:19","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711711039;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711711039;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-03-29 11:30:46","2024-03-29 11:30:46","0",NULL),
("1072","wpforms_process_entry_emails_meta_cleanup","complete","2024-03-30 11:30:46","2024-03-30 11:30:46","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711798246;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711798246;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-03-30 20:25:40","2024-03-30 20:25:40","0",NULL),
("1073","wpforms_process_entry_emails_meta_cleanup","complete","2024-03-31 20:25:40","2024-03-31 20:25:40","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711916740;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711916740;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-03-31 22:18:04","2024-03-31 22:18:04","0",NULL),
("1074","wpforms_process_entry_emails_meta_cleanup","complete","2024-04-01 22:18:04","2024-04-01 22:18:04","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1712009884;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1712009884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-04-02 02:06:01","2024-04-02 02:06:01","0",NULL),
("1075","wpforms_admin_addons_cache_update","pending","2024-04-08 21:10:58","2024-04-08 21:10:58","{\"tasks_meta_id\":2}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1712610658;s:18:\"\0*\0first_timestamp\";i:1626667729;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1712610658;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}","2","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("1076","wpforms_email_summaries_fetch_info_blocks","pending","2024-04-08 21:10:58","2024-04-08 21:10:58","{\"tasks_meta_id\":null}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1712610658;s:18:\"\0*\0first_timestamp\";i:1625894106;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1712610658;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}","2","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("1077","wpforms_process_entry_emails_meta_cleanup","complete","2024-04-03 02:06:01","2024-04-03 02:06:01","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1712109961;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1712109961;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-04-03 03:30:19","2024-04-03 03:30:19","0",NULL),
("1078","wpforms_process_entry_emails_meta_cleanup","complete","2024-04-04 03:30:19","2024-04-04 03:30:19","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1712201419;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1712201419;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-04-04 04:06:15","2024-04-04 04:06:15","0",NULL),
("1079","wpforms_process_entry_emails_meta_cleanup","complete","2024-04-05 04:06:15","2024-04-05 04:06:15","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1712289975;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1712289975;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-04-05 06:25:45","2024-04-05 06:25:45","0",NULL),
("1080","wpforms_process_entry_emails_meta_cleanup","complete","2024-04-06 06:25:45","2024-04-06 06:25:45","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1712384745;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1712384745;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-04-06 09:08:22","2024-04-06 09:08:22","0",NULL),
("1081","wpforms_process_entry_emails_meta_cleanup","pending","2024-04-07 09:08:22","2024-04-07 09:08:22","{\"tasks_meta_id\":1}","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1712480902;s:18:\"\0*\0first_timestamp\";i:1626134400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1712480902;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("1082","wpforms_admin_notifications_update","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","{\"tasks_meta_id\":5}","O:28:\"ActionScheduler_NullSchedule\":0:{}","2","1","2024-04-06 21:32:24","2024-04-06 21:32:24","0",NULL);

INSERT IGNORE INTO `wp13_actionscheduler_groups` VALUES 
("1","action-scheduler-migration"),
("2","wpforms");

INSERT IGNORE INTO `wp13_actionscheduler_logs` VALUES 
("3111","1043","action created","2024-03-04 11:08:50","2024-03-04 11:08:50"),
("3114","1044","action created","2024-03-04 11:08:50","2024-03-04 11:08:50"),
("3120","1046","action created","2024-03-05 16:35:38","2024-03-05 16:35:38"),
("3121","1046","action started via WP Cron","2024-03-07 01:26:36","2024-03-07 01:26:36"),
("3122","1046","action complete via WP Cron","2024-03-07 01:26:36","2024-03-07 01:26:36"),
("3123","1047","action created","2024-03-07 01:26:36","2024-03-07 01:26:36"),
("3124","1047","action started via WP Cron","2024-03-08 07:20:29","2024-03-08 07:20:29"),
("3125","1047","action complete via WP Cron","2024-03-08 07:20:29","2024-03-08 07:20:29"),
("3126","1048","action created","2024-03-08 07:20:29","2024-03-08 07:20:29"),
("3127","1048","action started via WP Cron","2024-03-09 09:00:24","2024-03-09 09:00:24"),
("3128","1048","action complete via WP Cron","2024-03-09 09:00:24","2024-03-09 09:00:24"),
("3129","1049","action created","2024-03-09 09:00:24","2024-03-09 09:00:24"),
("3130","1049","action started via WP Cron","2024-03-10 11:15:56","2024-03-10 11:15:56"),
("3131","1049","action complete via WP Cron","2024-03-10 11:15:56","2024-03-10 11:15:56"),
("3132","1050","action created","2024-03-10 11:15:56","2024-03-10 11:15:56"),
("3133","1043","action started via WP Cron","2024-03-11 12:19:34","2024-03-11 12:19:34"),
("3134","1043","action complete via WP Cron","2024-03-11 12:19:34","2024-03-11 12:19:34"),
("3135","1051","action created","2024-03-11 12:19:34","2024-03-11 12:19:34"),
("3136","1044","action started via WP Cron","2024-03-11 12:19:34","2024-03-11 12:19:34"),
("3137","1044","action complete via WP Cron","2024-03-11 12:19:34","2024-03-11 12:19:34"),
("3138","1052","action created","2024-03-11 12:19:34","2024-03-11 12:19:34"),
("3139","1050","action started via WP Cron","2024-03-11 12:19:34","2024-03-11 12:19:34"),
("3140","1050","action complete via WP Cron","2024-03-11 12:19:34","2024-03-11 12:19:34"),
("3141","1053","action created","2024-03-11 12:19:34","2024-03-11 12:19:34"),
("3142","1053","action started via WP Cron","2024-03-12 13:36:48","2024-03-12 13:36:48"),
("3143","1053","action complete via WP Cron","2024-03-12 13:36:48","2024-03-12 13:36:48"),
("3144","1054","action created","2024-03-12 13:36:48","2024-03-12 13:36:48"),
("3145","1054","action started via WP Cron","2024-03-13 18:38:39","2024-03-13 18:38:39"),
("3146","1054","action complete via WP Cron","2024-03-13 18:38:39","2024-03-13 18:38:39"),
("3147","1055","action created","2024-03-13 18:38:39","2024-03-13 18:38:39"),
("3148","1055","action started via WP Cron","2024-03-14 23:29:26","2024-03-14 23:29:26"),
("3149","1055","action complete via WP Cron","2024-03-14 23:29:26","2024-03-14 23:29:26"),
("3150","1056","action created","2024-03-14 23:29:26","2024-03-14 23:29:26"),
("3151","1056","action started via WP Cron","2024-03-16 06:58:24","2024-03-16 06:58:24"),
("3152","1056","action complete via WP Cron","2024-03-16 06:58:24","2024-03-16 06:58:24"),
("3153","1057","action created","2024-03-16 06:58:24","2024-03-16 06:58:24"),
("3154","1057","action started via WP Cron","2024-03-17 11:39:28","2024-03-17 11:39:28"),
("3155","1057","action complete via WP Cron","2024-03-17 11:39:28","2024-03-17 11:39:28"),
("3156","1058","action created","2024-03-17 11:39:28","2024-03-17 11:39:28"),
("3157","1051","action started via Async Request","2024-03-18 16:24:54","2024-03-18 16:24:54"),
("3158","1051","action complete via Async Request","2024-03-18 16:24:54","2024-03-18 16:24:54"),
("3159","1059","action created","2024-03-18 16:24:54","2024-03-18 16:24:54"),
("3160","1052","action started via Async Request","2024-03-18 16:24:54","2024-03-18 16:24:54"),
("3161","1052","action complete via Async Request","2024-03-18 16:24:54","2024-03-18 16:24:54"),
("3162","1060","action created","2024-03-18 16:24:54","2024-03-18 16:24:54"),
("3163","1058","action started via Async Request","2024-03-18 16:24:54","2024-03-18 16:24:54"),
("3164","1058","action complete via Async Request","2024-03-18 16:24:54","2024-03-18 16:24:54"),
("3165","1061","action created","2024-03-18 16:24:54","2024-03-18 16:24:54"),
("3166","1061","action started via WP Cron","2024-03-19 17:00:32","2024-03-19 17:00:32"),
("3167","1061","action complete via WP Cron","2024-03-19 17:00:32","2024-03-19 17:00:32"),
("3168","1062","action created","2024-03-19 17:00:32","2024-03-19 17:00:32"),
("3169","1062","action started via WP Cron","2024-03-20 17:50:34","2024-03-20 17:50:34"),
("3170","1062","action complete via WP Cron","2024-03-20 17:50:34","2024-03-20 17:50:34"),
("3171","1063","action created","2024-03-20 17:50:34","2024-03-20 17:50:34"),
("3172","1063","action started via WP Cron","2024-03-22 00:28:21","2024-03-22 00:28:21"),
("3173","1063","action complete via WP Cron","2024-03-22 00:28:21","2024-03-22 00:28:21"),
("3174","1064","action created","2024-03-22 00:28:21","2024-03-22 00:28:21"),
("3175","1064","action started via WP Cron","2024-03-23 00:33:06","2024-03-23 00:33:06"),
("3176","1064","action complete via WP Cron","2024-03-23 00:33:06","2024-03-23 00:33:06"),
("3177","1065","action created","2024-03-23 00:33:06","2024-03-23 00:33:06"),
("3178","1065","action started via WP Cron","2024-03-24 02:02:20","2024-03-24 02:02:20"),
("3179","1065","action complete via WP Cron","2024-03-24 02:02:20","2024-03-24 02:02:20"),
("3180","1066","action created","2024-03-24 02:02:20","2024-03-24 02:02:20"),
("3181","1066","action started via WP Cron","2024-03-25 07:32:18","2024-03-25 07:32:18"),
("3182","1066","action complete via WP Cron","2024-03-25 07:32:18","2024-03-25 07:32:18"),
("3183","1067","action created","2024-03-25 07:32:18","2024-03-25 07:32:18"),
("3184","1059","action started via WP Cron","2024-03-25 16:42:38","2024-03-25 16:42:38"),
("3185","1059","action complete via WP Cron","2024-03-25 16:42:38","2024-03-25 16:42:38"),
("3186","1068","action created","2024-03-25 16:42:38","2024-03-25 16:42:38"),
("3187","1060","action started via WP Cron","2024-03-25 16:42:38","2024-03-25 16:42:38"),
("3188","1060","action complete via WP Cron","2024-03-25 16:42:39","2024-03-25 16:42:39"),
("3189","1069","action created","2024-03-25 16:42:39","2024-03-25 16:42:39"),
("3190","1067","action started via WP Cron","2024-03-26 23:16:09","2024-03-26 23:16:09"),
("3191","1067","action complete via WP Cron","2024-03-26 23:16:09","2024-03-26 23:16:09"),
("3192","1070","action created","2024-03-26 23:16:09","2024-03-26 23:16:09"),
("3193","1070","action started via WP Cron","2024-03-28 11:17:19","2024-03-28 11:17:19"),
("3194","1070","action complete via WP Cron","2024-03-28 11:17:19","2024-03-28 11:17:19"),
("3195","1071","action created","2024-03-28 11:17:19","2024-03-28 11:17:19"),
("3196","1071","action started via WP Cron","2024-03-29 11:30:46","2024-03-29 11:30:46"),
("3197","1071","action complete via WP Cron","2024-03-29 11:30:46","2024-03-29 11:30:46"),
("3198","1072","action created","2024-03-29 11:30:46","2024-03-29 11:30:46"),
("3199","1072","action started via WP Cron","2024-03-30 20:25:40","2024-03-30 20:25:40"),
("3200","1072","action complete via WP Cron","2024-03-30 20:25:40","2024-03-30 20:25:40"),
("3201","1073","action created","2024-03-30 20:25:40","2024-03-30 20:25:40"),
("3202","1073","action started via WP Cron","2024-03-31 22:18:04","2024-03-31 22:18:04"),
("3203","1073","action complete via WP Cron","2024-03-31 22:18:04","2024-03-31 22:18:04"),
("3204","1074","action created","2024-03-31 22:18:04","2024-03-31 22:18:04"),
("3205","1068","action started via WP Cron","2024-04-01 21:10:58","2024-04-01 21:10:58"),
("3206","1068","action complete via WP Cron","2024-04-01 21:10:58","2024-04-01 21:10:58"),
("3207","1075","action created","2024-04-01 21:10:58","2024-04-01 21:10:58"),
("3208","1069","action started via WP Cron","2024-04-01 21:10:58","2024-04-01 21:10:58"),
("3209","1069","action complete via WP Cron","2024-04-01 21:10:58","2024-04-01 21:10:58"),
("3210","1076","action created","2024-04-01 21:10:58","2024-04-01 21:10:58"),
("3211","1074","action started via WP Cron","2024-04-02 02:06:01","2024-04-02 02:06:01"),
("3212","1074","action complete via WP Cron","2024-04-02 02:06:01","2024-04-02 02:06:01"),
("3213","1077","action created","2024-04-02 02:06:01","2024-04-02 02:06:01"),
("3214","1077","action started via WP Cron","2024-04-03 03:30:19","2024-04-03 03:30:19"),
("3215","1077","action complete via WP Cron","2024-04-03 03:30:19","2024-04-03 03:30:19"),
("3216","1078","action created","2024-04-03 03:30:19","2024-04-03 03:30:19"),
("3217","1078","action started via WP Cron","2024-04-04 04:06:15","2024-04-04 04:06:15"),
("3218","1078","action complete via WP Cron","2024-04-04 04:06:15","2024-04-04 04:06:15"),
("3219","1079","action created","2024-04-04 04:06:15","2024-04-04 04:06:15"),
("3220","1079","action started via WP Cron","2024-04-05 06:25:45","2024-04-05 06:25:45"),
("3221","1079","action complete via WP Cron","2024-04-05 06:25:45","2024-04-05 06:25:45"),
("3222","1080","action created","2024-04-05 06:25:45","2024-04-05 06:25:45"),
("3223","1080","action started via WP Cron","2024-04-06 09:08:22","2024-04-06 09:08:22"),
("3224","1080","action complete via WP Cron","2024-04-06 09:08:22","2024-04-06 09:08:22"),
("3225","1081","action created","2024-04-06 09:08:22","2024-04-06 09:08:22"),
("3226","1082","action created","2024-04-06 21:31:21","2024-04-06 21:31:21"),
("3227","1082","action started via WP Cron","2024-04-06 21:32:24","2024-04-06 21:32:24"),
("3228","1082","action complete via WP Cron","2024-04-06 21:32:24","2024-04-06 21:32:24");

INSERT IGNORE INTO `wp13_comments` VALUES 
("1","1","A WordPress Commenter","wapuu@wordpress.example","https://wordpress.org/","","2021-07-12 04:07:19","2021-07-12 04:07:19","Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com\">Gravatar</a>.","0","1","","comment","0","0");

INSERT IGNORE INTO `wp13_duplicator_backups` VALUES 
("1","20240407_iexpress","f44b95cb59db8fbd6483_20240407002115","20240407_iexpress_f44b95cb59db8fbd6483_20240407002115_archive.zip","20","20","MANUAL,ZIP_ARCHIVE","{\n    \"ID\": 1,\n    \"VersionWP\": \"6.5\",\n    \"VersionDB\": \"5.6.41\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240407_iexpress\",\n    \"Hash\": \"f44b95cb59db8fbd6483_20240407002115\",\n    \"NameHash\": \"20240407_iexpress_f44b95cb59db8fbd6483_20240407002115\",\n    \"Type\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/iexperipress.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240407_iexpress_f44b95cb59db8fbd6483_20240407002115_scan.json\",\n    \"timer_start\": 1712449298.45802593231201171875,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/.opcache\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/.tmb\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/ai1wm-backups\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/backups-dup-lite\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/backups-dup-pro\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/backupwordpress\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/bps-backup\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/cache\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/content\\/cache\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/contents\\/cache\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/managewp\\/backups\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/old-cache\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/updraft\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/wfcache\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/wishlist-backup\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/wpvividbackups\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/.htaccess\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/.user.ini\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/php.ini\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/web.config\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-config.php\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/debug.log\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/wpforms\\/.htaccess.cpmh3129\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240407_iexpress_f44b95cb59db8fbd6483_20240407002115_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home3\\/pmoadvisory\\/iexperipress.com\",\n        \"Size\": 215187845,\n        \"Dirs\": [],\n        \"DirCount\": 1891,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 10476,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [\n                    \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/wpforms\\/.htaccess.cpmh3129\"\n                ]\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240407_iexpress_f44b95cb59db8fbd6483_20240407002115_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"6J0ej5tm\\/PZNqWgQ7UMYUtMSyzUbDPQYAIC3A95JMcK3UZNX9qEl8Ulo0lS\\/0Cb5gwCmGN17P+Pjyf516MltBA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"pmoadvis_wp74\",\n            \"tablesBaseCount\": 19,\n            \"tablesFinalCount\": 19,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 792,\n            \"tablesSizeOnDisk\": 2850816,\n            \"tablesList\": {\n                \"wp13_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"40\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp13_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp13_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp13_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"108\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp13_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp13_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp13_duplicator_backups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 147456\n                },\n                \"wp13_duplicator_entities\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp13_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp13_options\": {\n                    \"inaccurateRows\": \"241\",\n                    \"insertedRows\": 0,\n                    \"size\": 1097728\n                },\n                \"wp13_postmeta\": {\n                    \"inaccurateRows\": \"290\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp13_posts\": {\n                    \"inaccurateRows\": \"70\",\n                    \"insertedRows\": 0,\n                    \"size\": 557056\n                },\n                \"wp13_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp13_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp13_term_relationships\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp13_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp13_usermeta\": {\n                    \"inaccurateRows\": \"20\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp13_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp13_wpforms_tasks_meta\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"5.6.41\",\n            \"versionComment\": \"Percona Server (GPL), Release 84.1, Revision b308619\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20240407_iexpress_f44b95cb59db8fbd6483_20240407002115_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release 84.1, Revision b308619\",\n        \"dbStorePathPublic\": \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/backups-dup-pro\\/tmp\\/20240407_iexpress_f44b95cb59db8fbd6483_20240407002115_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 20,\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": 1712449299,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"wp13_users\",\n            \"wp13_usermeta\",\n            \"wp13_actionscheduler_actions\",\n            \"wp13_actionscheduler_claims\",\n            \"wp13_actionscheduler_groups\",\n            \"wp13_actionscheduler_logs\",\n            \"wp13_commentmeta\",\n            \"wp13_comments\",\n            \"wp13_duplicator_backups\",\n            \"wp13_duplicator_entities\",\n            \"wp13_links\",\n            \"wp13_options\",\n            \"wp13_postmeta\",\n            \"wp13_posts\",\n            \"wp13_termmeta\",\n            \"wp13_terms\",\n            \"wp13_term_relationships\",\n            \"wp13_term_taxonomy\",\n            \"wp13_wpforms_tasks_meta\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1712449298.4807989597320556640625,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 793,\n            \"tables\": {\n                \"wp13_users\": {\n                    \"start\": \"1\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp13_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp13_actionscheduler_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp13_actionscheduler_claims\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp13_actionscheduler_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp13_actionscheduler_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp13_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp13_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp13_duplicator_backups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp13_duplicator_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp13_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp13_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp13_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp13_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp13_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp13_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp13_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp13_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp13_wpforms_tasks_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": 6,\n    \"version\": \"4.5.15.1\",\n    \"created\": \"2024-04-07 00:21:26\",\n    \"updated\": \"2024-04-07 00:21:39\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.15.1","2024-04-07 00:21:26","2024-04-07 00:21:39");

INSERT IGNORE INTO `wp13_duplicator_entities` VALUES 
("1","DUP_PRO_Global_Entity","","","","","","{\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": false,\n    \"crypt\": true,\n    \"email_summary_frequency\": \"weekly\",\n    \"email_summary_recipients\": [\n        \"gen@pmoadvisory.com\"\n    ],\n    \"usageTracking\": true,\n    \"amNotices\": true,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 1,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 32,\n    \"homepath_as_abspath\": false,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 20,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"gen@pmoadvisory.com\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 1,\n    \"ajax_protocol\": \"https\",\n    \"custom_ajax_url\": \"https:\\/\\/iexperipress.com\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"chunk_size\": 2048,\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"max_default_store_files\": 20,\n    \"purge_default_package_record\": false,\n    \"dropbox_upload_chunksize_in_kb\": null,\n    \"dropbox_transfer_mode\": null,\n    \"gdrive_upload_chunksize_in_kb\": null,\n    \"gdrive_transfer_mode\": null,\n    \"s3_upload_part_size_in_kb\": null,\n    \"onedrive_upload_chunksize_in_kb\": null,\n    \"local_upload_chunksize_in_MB\": null,\n    \"manual_mode_storage_ids\": [\n        3\n    ],\n    \"license_status\": 0,\n    \"license_expiration_time\": -1,\n    \"license_no_activations_left\": false,\n    \"license_key_visible\": 1,\n    \"lkp\": \"\",\n    \"license_type\": -1,\n    \"license_limit\": 800,\n    \"last_system_check_timestamp\": 0,\n    \"initial_activation_timestamp\": 1712449033,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"debug_on\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"recoveryCustomPath\": \"\",\n    \"id\": 1,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.15.1\",\n    \"created\": \"2024-04-07 00:17:13\",\n    \"updated\": \"2024-04-07 00:21:15\"\n}","4.5.15.1","2024-04-07 00:17:13","2024-04-07 00:21:15"),
("2","DUP_PRO_Secure_Global_Entity","","","","","","{\n    \"basic_auth_password\": \"\",\n    \"lkp\": \"\",\n    \"id\": 2,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.15.1\",\n    \"created\": \"2024-04-07 00:17:13\",\n    \"updated\": \"2024-04-07 00:17:13\"\n}","4.5.15.1","2024-04-07 00:17:13","2024-04-07 00:17:13"),
("3","DUP_PRO_Storage_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"notes\": \"The default location for storage on this server.\",\n    \"storage_type\": -2,\n    \"config\": \"8odpoWMzNUydDQ8C4Ysg4GlQXKjQUzx6jFDIAj9C9+Em4nbSu+VsqmtEfEY5UNf+dqxebYExYgJLjLkP7jOWzLPk7KwsXBw0GvY9U2XEDfNgbyUa1UKD\\/ttSV1haYgqmdmB7k1kN+vszJn5t\\/HR\\/UTWA2DWEBh3+2bTcsdRzINn4A4XoCxotq0SB6WTR+PsWs3AILJpYab2vNQ8YMmrs55HPJ6EMBSNipFElqLGjFT4vOQLoiKWhW0CbW0UJbqGWDhXDpWoPJyB6g3zK7LSjr8icO8WVYsaVn2rOuA2eTFc=\",\n    \"legacyEntity\": false,\n    \"local_storage_folder\": \"\",\n    \"local_max_files\": 10,\n    \"local_filter_protection\": true,\n    \"purge_package_record\": true,\n    \"dropbox_access_token\": \"\",\n    \"dropbox_access_token_secret\": \"\",\n    \"dropbox_v2_access_token\": \"\",\n    \"dropbox_storage_folder\": \"\",\n    \"dropbox_max_files\": 10,\n    \"dropbox_authorization_state\": 0,\n    \"onedrive_endpoint_url\": \"\",\n    \"onedrive_resource_id\": \"\",\n    \"onedrive_access_token\": \"\",\n    \"onedrive_refresh_token\": \"\",\n    \"onedrive_token_obtained\": 0,\n    \"onedrive_user_id\": \"\",\n    \"onedrive_storage_folder\": \"\",\n    \"onedrive_max_files\": 10,\n    \"onedrive_storage_folder_id\": \"\",\n    \"onedrive_authorization_state\": 0,\n    \"onedrive_storage_folder_web_url\": \"\",\n    \"ftp_server\": \"\",\n    \"ftp_port\": 21,\n    \"ftp_username\": \"\",\n    \"ftp_password\": \"\",\n    \"ftp_use_curl\": false,\n    \"ftp_storage_folder\": \"\",\n    \"ftp_max_files\": 10,\n    \"ftp_timeout_in_secs\": 15,\n    \"ftp_ssl\": false,\n    \"ftp_passive_mode\": false,\n    \"sftp_server\": \"\",\n    \"sftp_port\": 22,\n    \"sftp_username\": \"\",\n    \"sftp_password\": \"\",\n    \"sftp_private_key\": \"\",\n    \"sftp_private_key_password\": \"\",\n    \"sftp_storage_folder\": \"\",\n    \"sftp_timeout_in_secs\": 15,\n    \"sftp_max_files\": 10,\n    \"sftp_disable_chunking_mode\": false,\n    \"gdrive_access_token_set_json\": \"\",\n    \"gdrive_refresh_token\": \"\",\n    \"gdrive_storage_folder\": \"\",\n    \"gdrive_max_files\": 10,\n    \"gdrive_authorization_state\": 0,\n    \"gdrive_client_number\": -1,\n    \"s3_access_key\": \"\",\n    \"s3_bucket\": \"\",\n    \"s3_max_files\": 10,\n    \"s3_provider\": \"amazon\",\n    \"s3_region\": \"\",\n    \"s3_endpoint\": \"\",\n    \"s3_secret_key\": \"\",\n    \"s3_storage_class\": \"STANDARD\",\n    \"s3_storage_folder\": \"\",\n    \"s3_ACL_full_control\": true,\n    \"id\": 3,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.15.1\",\n    \"created\": \"2024-04-07 00:17:13\",\n    \"updated\": \"2024-04-07 00:17:13\"\n}","4.5.15.1","2024-04-07 00:17:13","2024-04-07 00:17:13"),
("4","EmailSummary","","","","","","{\n    \"manualPackageIds\": [],\n    \"scheduledPackageIds\": [],\n    \"failedPackageIds\": [],\n    \"scheduleIds\": [],\n    \"storageIds\": [\n        3\n    ],\n    \"id\": 4,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.15.1\",\n    \"created\": \"2024-04-07 00:17:13\",\n    \"updated\": \"2024-04-07 00:17:13\"\n}","4.5.15.1","2024-04-07 00:17:13","2024-04-07 00:17:13"),
("5","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"rJbvu0Vcp57R10NImoyr6UjiSq2k54VAAAPFpZnHMRgwoC0lWKoWAjazDAj5ZY9Wvh\\/6yoC2kD1gGNALgCKWzg==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"id\": 5,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.15.1\",\n    \"created\": \"2024-04-07 00:17:13\",\n    \"updated\": \"2024-04-07 00:17:13\"\n}","4.5.15.1","2024-04-07 00:17:13","2024-04-07 00:17:13"),
("6","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"[Manual Mode]\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"teBfs5C1eQjEyYRqhQbqmfa+aZ\\/uGFg52c3KZccgY30yuVqAmiCK6wKnmKttzIIGsjrniBFSqiiMwOwmEMGaCw==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": 0,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"id\": 6,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.15.1\",\n    \"created\": \"2024-04-07 00:17:13\",\n    \"updated\": \"2024-04-07 00:21:15\"\n}","4.5.15.1","2024-04-07 00:17:13","2024-04-07 00:21:15"),
("7","Dynamic_Entity","","","","","","{\n    \"data\": {\n        \"dropbox_upload_chunksize_in_kb\": 2000,\n        \"dropbox_transfer_mode\": 1,\n        \"gdrive_upload_chunksize_in_kb\": 1024,\n        \"gdrive_transfer_mode\": 0,\n        \"s3_upload_part_size_in_kb\": 6000,\n        \"onedrive_upload_chunksize_in_kb\": 3200,\n        \"local_upload_chunksize_in_MB\": 16\n    },\n    \"id\": 7,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.15.1\",\n    \"created\": \"2024-04-07 00:17:13\",\n    \"updated\": \"2024-04-07 00:17:13\"\n}","4.5.15.1","2024-04-07 00:17:13","2024-04-07 00:17:13"),
("8","DUP_PRO_System_Global_Entity","","","","","","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1712449298,\n    \"id\": 8,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.15.1\",\n    \"created\": \"2024-04-07 00:17:14\",\n    \"updated\": \"2024-04-07 00:21:38\"\n}","4.5.15.1","2024-04-07 00:17:14","2024-04-07 00:21:38");

INSERT IGNORE INTO `wp13_options` VALUES 
("1","siteurl","https://iexperipress.com","yes"),
("2","home","https://iexperipress.com","yes"),
("3","blogname","iExpress","yes"),
("4","blogdescription","My WordPress Blog","yes"),
("5","users_can_register","0","yes"),
("6","admin_email","gen@pmoadvisory.com","yes"),
("7","start_of_week","1","yes"),
("8","use_balanceTags","0","yes"),
("9","use_smilies","1","yes"),
("10","require_name_email","1","yes"),
("11","comments_notify","1","yes"),
("12","posts_per_rss","10","yes"),
("13","rss_use_excerpt","0","yes"),
("14","mailserver_url","mail.example.com","yes"),
("15","mailserver_login","login@example.com","yes"),
("16","mailserver_pass","password","yes"),
("17","mailserver_port","110","yes"),
("18","default_category","1","yes"),
("19","default_comment_status","open","yes"),
("20","default_ping_status","open","yes"),
("21","default_pingback_flag","1","yes"),
("22","posts_per_page","10","yes"),
("23","date_format","F j, Y","yes"),
("24","time_format","g:i a","yes"),
("25","links_updated_date_format","F j, Y g:i a","yes"),
("26","comment_moderation","0","yes"),
("27","moderation_notify","1","yes"),
("28","permalink_structure","/%postname%/","yes"),
("29","rewrite_rules","a:212:{s:10:\"project/?$\";s:27:\"index.php?post_type=project\";s:40:\"project/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:35:\"project/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:27:\"project/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=project&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:35:\"project/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"project/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"project/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"project/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"project/([^/]+)/embed/?$\";s:40:\"index.php?project=$matches[1]&embed=true\";s:28:\"project/([^/]+)/trackback/?$\";s:34:\"index.php?project=$matches[1]&tb=1\";s:48:\"project/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:43:\"project/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:36:\"project/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&paged=$matches[2]\";s:43:\"project/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&cpage=$matches[2]\";s:32:\"project/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?project=$matches[1]&page=$matches[2]\";s:24:\"project/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"project/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"project/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"project/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"project_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project_category=$matches[1]&feed=$matches[2]\";s:52:\"project_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project_category=$matches[1]&feed=$matches[2]\";s:33:\"project_category/([^/]+)/embed/?$\";s:49:\"index.php?project_category=$matches[1]&embed=true\";s:45:\"project_category/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?project_category=$matches[1]&paged=$matches[2]\";s:27:\"project_category/([^/]+)/?$\";s:38:\"index.php?project_category=$matches[1]\";s:52:\"project_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project_tag=$matches[1]&feed=$matches[2]\";s:47:\"project_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project_tag=$matches[1]&feed=$matches[2]\";s:28:\"project_tag/([^/]+)/embed/?$\";s:44:\"index.php?project_tag=$matches[1]&embed=true\";s:40:\"project_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?project_tag=$matches[1]&paged=$matches[2]\";s:22:\"project_tag/([^/]+)/?$\";s:33:\"index.php?project_tag=$matches[1]\";s:44:\"et_theme_builder/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_theme_builder/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_theme_builder/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_theme_builder/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_theme_builder/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_theme_builder/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_theme_builder/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_theme_builder&name=$matches[1]&embed=true\";s:37:\"et_theme_builder/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_theme_builder&name=$matches[1]&tb=1\";s:45:\"et_theme_builder/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_builder&name=$matches[1]&paged=$matches[2]\";s:52:\"et_theme_builder/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_builder&name=$matches[1]&cpage=$matches[2]\";s:41:\"et_theme_builder/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_theme_builder&name=$matches[1]&page=$matches[2]\";s:33:\"et_theme_builder/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_theme_builder/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_theme_builder/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_theme_builder/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_theme_builder/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_theme_builder/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"et_template/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"et_template/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"et_template/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"et_template/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"et_template/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"et_template/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"et_template/([^/]+)/embed/?$\";s:59:\"index.php?post_type=et_template&name=$matches[1]&embed=true\";s:32:\"et_template/([^/]+)/trackback/?$\";s:53:\"index.php?post_type=et_template&name=$matches[1]&tb=1\";s:40:\"et_template/([^/]+)/page/?([0-9]{1,})/?$\";s:66:\"index.php?post_type=et_template&name=$matches[1]&paged=$matches[2]\";s:47:\"et_template/([^/]+)/comment-page-([0-9]{1,})/?$\";s:66:\"index.php?post_type=et_template&name=$matches[1]&cpage=$matches[2]\";s:36:\"et_template/([^/]+)(?:/([0-9]+))?/?$\";s:65:\"index.php?post_type=et_template&name=$matches[1]&page=$matches[2]\";s:28:\"et_template/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"et_template/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"et_template/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"et_template/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"et_template/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"et_template/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"et_header_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_header_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_header_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_header_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_header_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_header_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_header_layout/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_header_layout&name=$matches[1]&embed=true\";s:37:\"et_header_layout/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_header_layout&name=$matches[1]&tb=1\";s:45:\"et_header_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_header_layout&name=$matches[1]&paged=$matches[2]\";s:52:\"et_header_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_header_layout&name=$matches[1]&cpage=$matches[2]\";s:41:\"et_header_layout/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_header_layout&name=$matches[1]&page=$matches[2]\";s:33:\"et_header_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_header_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_header_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_header_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_header_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_header_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"et_body_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"et_body_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"et_body_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"et_body_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"et_body_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"et_body_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"et_body_layout/([^/]+)/embed/?$\";s:62:\"index.php?post_type=et_body_layout&name=$matches[1]&embed=true\";s:35:\"et_body_layout/([^/]+)/trackback/?$\";s:56:\"index.php?post_type=et_body_layout&name=$matches[1]&tb=1\";s:43:\"et_body_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?post_type=et_body_layout&name=$matches[1]&paged=$matches[2]\";s:50:\"et_body_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:69:\"index.php?post_type=et_body_layout&name=$matches[1]&cpage=$matches[2]\";s:39:\"et_body_layout/([^/]+)(?:/([0-9]+))?/?$\";s:68:\"index.php?post_type=et_body_layout&name=$matches[1]&page=$matches[2]\";s:31:\"et_body_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"et_body_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"et_body_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"et_body_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"et_body_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"et_body_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"et_footer_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_footer_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_footer_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_footer_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_footer_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_footer_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_footer_layout/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_footer_layout&name=$matches[1]&embed=true\";s:37:\"et_footer_layout/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_footer_layout&name=$matches[1]&tb=1\";s:45:\"et_footer_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_footer_layout&name=$matches[1]&paged=$matches[2]\";s:52:\"et_footer_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_footer_layout&name=$matches[1]&cpage=$matches[2]\";s:41:\"et_footer_layout/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_footer_layout&name=$matches[1]&page=$matches[2]\";s:33:\"et_footer_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_footer_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_footer_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_footer_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_footer_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_footer_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=26&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","yes"),
("30","hack_file","0","yes"),
("31","blog_charset","UTF-8","yes"),
("32","moderation_keys","","no"),
("33","active_plugins","a:3:{i:0;s:33:\"duplicator-pro/duplicator-pro.php\";i:1;s:77:\"minimal-coming-soon-maintenance-mode/minimal-coming-soon-maintenance-mode.php\";i:2;s:24:\"wpforms-lite/wpforms.php\";}","yes"),
("34","category_base","","yes"),
("35","ping_sites","http://rpc.pingomatic.com/","yes"),
("36","comment_max_links","2","yes"),
("37","gmt_offset","0","yes"),
("38","default_email_category","1","yes"),
("39","recently_edited","","no"),
("40","template","Divi","yes"),
("41","stylesheet","Divi","yes"),
("42","comment_registration","0","yes"),
("43","html_type","text/html","yes"),
("44","use_trackback","0","yes"),
("45","default_role","subscriber","yes"),
("46","db_version","57155","yes"),
("47","uploads_use_yearmonth_folders","1","yes"),
("48","upload_path","","yes"),
("49","blog_public","1","yes"),
("50","default_link_category","2","yes"),
("51","show_on_front","page","yes"),
("52","tag_base","","yes"),
("53","show_avatars","1","yes"),
("54","avatar_rating","G","yes"),
("55","upload_url_path","","yes"),
("56","thumbnail_size_w","150","yes"),
("57","thumbnail_size_h","150","yes"),
("58","thumbnail_crop","1","yes"),
("59","medium_size_w","300","yes"),
("60","medium_size_h","300","yes"),
("61","avatar_default","mystery","yes"),
("62","large_size_w","1024","yes"),
("63","large_size_h","1024","yes"),
("64","image_default_link_type","none","yes"),
("65","image_default_size","","yes"),
("66","image_default_align","","yes"),
("67","close_comments_for_old_posts","0","yes"),
("68","close_comments_days_old","14","yes"),
("69","thread_comments","1","yes"),
("70","thread_comments_depth","5","yes"),
("71","page_comments","0","yes"),
("72","comments_per_page","50","yes"),
("73","default_comments_page","newest","yes"),
("74","comment_order","asc","yes"),
("75","sticky_posts","a:0:{}","yes"),
("76","widget_categories","a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes"),
("77","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("78","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("79","uninstall_plugins","a:1:{s:37:\"optinmonster/optin-monster-wp-api.php\";s:32:\"optin_monster_api_uninstall_hook\";}","no"),
("80","timezone_string","","yes"),
("81","page_for_posts","0","yes"),
("82","page_on_front","26","yes"),
("83","default_post_format","0","yes"),
("84","link_manager_enabled","0","yes"),
("85","finished_splitting_shared_terms","1","yes"),
("86","site_icon","0","yes"),
("87","medium_large_size_w","768","yes"),
("88","medium_large_size_h","0","yes"),
("89","wp_page_for_privacy_policy","3","yes"),
("90","show_comments_cookies_opt_in","1","yes"),
("91","admin_email_lifespan","1641614839","yes"),
("92","disallowed_keys","","no"),
("93","comment_previously_approved","1","yes"),
("94","auto_plugin_theme_update_emails","a:0:{}","no"),
("95","auto_update_core_dev","enabled","yes"),
("96","auto_update_core_minor","enabled","yes"),
("97","auto_update_core_major","enabled","yes"),
("98","initial_db_version","49752","yes"),
("99","wp13_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:76:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"et_support_center\";b:1;s:24:\"et_support_center_system\";b:1;s:31:\"et_support_center_remote_access\";b:1;s:31:\"et_support_center_documentation\";b:1;s:27:\"et_support_center_safe_mode\";b:1;s:22:\"et_support_center_logs\";b:1;s:20:\"duplicator_pro_basic\";b:1;s:21:\"duplicator_pro_create\";b:1;s:23:\"duplicator_pro_schedule\";b:1;s:22:\"duplicator_pro_storage\";b:1;s:29:\"duplicator_pro_backup_restore\";b:1;s:21:\"duplicator_pro_import\";b:1;s:21:\"duplicator_pro_export\";b:1;s:23:\"duplicator_pro_settings\";b:1;s:22:\"duplicator_pro_license\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","yes"),
("100","fresh_site","0","yes"),
("101","widget_search","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("102","widget_recent-posts","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes"),
("103","widget_recent-comments","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes"),
("104","widget_archives","a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes"),
("105","widget_meta","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("106","sidebars_widgets","a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:0:{}s:9:\"sidebar-7\";a:0:{}s:13:\"array_version\";i:3;}","yes"),
("107","cron","a:17:{i:1712449304;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1712452043;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1712452122;a:1:{s:14:\"mm_cron_hourly\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1712455907;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"87201d3637e485f7d6563d69209cf3f4\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:76;}}}}i:1712462839;a:4:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1712462857;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1712462921;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1712462922;a:3:{s:13:\"mm_cron_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:18:\"mm_cron_twicedaily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1712476410;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1712549322;a:1:{s:14:\"mm_cron_weekly\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1712584800;a:2:{s:28:\"wpforms_email_summaries_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:30:\"wpforms_email_summaries_weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:33:\"duplicator_pro_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1712635639;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1712689423;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1713163398;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1714018122;a:1:{s:15:\"mm_cron_monthly\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:7:\"monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2592000;}}}i:1714191474;a:1:{s:32:\"et_core_page_resource_auto_clear\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:7:\"monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2592000;}}}s:7:\"version\";i:2;}","yes"),
("108","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("109","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("110","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("111","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("112","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("113","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("114","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("115","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("116","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("118","recovery_keys","a:0:{}","yes"),
("119","theme_mods_twentytwentyone","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1626063473;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}","no"),
("120","https_detection_errors","a:1:{s:19:\"bad_response_source\";a:1:{i:0;s:55:\"It looks like the response did not come from this site.\";}}","yes"),
("138","jetpack_activated","1","yes"),
("141","jetpack_activation_source","a:2:{i:0;s:6:\"wp-cli\";i:1;N;}","yes"),
("143","jetpack_options","a:3:{s:7:\"version\";s:14:\"9.9:1626062856\";s:11:\"old_version\";s:14:\"9.9:1626062856\";s:14:\"last_heartbeat\";i:1626062858;}","yes"),
("144","_transient_jetpack_autoloader_plugin_paths","a:0:{}","yes"),
("145","jetpack_connection_active_plugins","a:1:{s:7:\"jetpack\";a:1:{s:4:\"name\";s:7:\"Jetpack\";}}","yes"),
("149","optin_monster_api","a:11:{s:3:\"api\";a:0:{}s:10:\"is_expired\";b:0;s:11:\"is_disabled\";b:0;s:10:\"is_invalid\";b:0;s:9:\"installed\";i:1626062860;s:9:\"connected\";s:0:\"\";s:4:\"beta\";b:0;s:12:\"auto_updates\";s:0:\"\";s:14:\"usage_tracking\";b:0;s:18:\"hide_announcements\";b:0;s:7:\"welcome\";a:1:{s:6:\"status\";s:8:\"welcomed\";}}","yes"),
("150","omapi_review","a:2:{s:4:\"time\";i:1626062860;s:9:\"dismissed\";b:0;}","yes"),
("151","widget_optin-monster-api","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("154","action_scheduler_hybrid_store_demarkation","4","yes"),
("155","schema-ActionScheduler_StoreSchema","3.0.1626062864","yes"),
("156","schema-ActionScheduler_LoggerSchema","2.0.1626062864","yes"),
("159","wpforms_version","1.6.7.3","yes"),
("160","wpforms_version_lite","1.6.7.3","yes"),
("161","wpforms_activated","a:1:{s:4:\"lite\";i:1626062864;}","yes"),
("166","widget_wpforms-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("172","ce4wp_activation_redirect","0","yes"),
("173","ce4wp_referred_by","a:3:{s:6:\"plugin\";s:9:\"HostGator\";s:6:\"source\";s:12:\"preinstalled\";s:8:\"campaign\";s:18:\"HostGator_Standard\";}","yes"),
("174","mm_brand","HostGator","yes"),
("175","jetpack_affiliate_code","57686","yes"),
("176","endurance_cache_level","2","yes"),
("179","action_scheduler_lock_async-request-runner","1712449308","yes"),
("182","eig_last_site_login","2021-07-12T04:08:40+00:00","yes"),
("183","ce4wp_handshake_token","23BD6A5E-51EC-410E-8FE9-1D1EBAB659F6","yes"),
("184","ce4wp_handshake_expiration","1626066521","yes"),
("185","ce4wp_instance_uuid","60ebc04967c19","yes"),
("193","do_activate","0","yes"),
("198","mm_install_date","Jul 12, 2021","yes"),
("199","mm_cron","a:1:{s:6:\"hourly\";a:1:{s:9:\"installed\";a:5:{s:1:\"t\";s:5:\"event\";s:2:\"ec\";s:13:\"plugin_status\";s:2:\"ea\";s:9:\"installed\";s:2:\"el\";s:26:\"Install date: Jul 12, 2021\";s:4:\"keep\";b:0;}}}","yes"),
("200","wpforms_admin_notices","a:1:{s:14:\"review_request\";a:2:{s:4:\"time\";i:1626062922;s:9:\"dismissed\";b:0;}}","yes"),
("210","jetpack_available_modules","a:1:{s:3:\"9.9\";a:42:{s:8:\"carousel\";s:3:\"1.5\";s:13:\"comment-likes\";s:3:\"5.1\";s:8:\"comments\";s:3:\"1.4\";s:12:\"contact-form\";s:3:\"1.3\";s:9:\"copy-post\";s:3:\"7.0\";s:20:\"custom-content-types\";s:3:\"3.1\";s:10:\"custom-css\";s:3:\"1.7\";s:21:\"enhanced-distribution\";s:3:\"1.2\";s:16:\"google-analytics\";s:3:\"4.5\";s:19:\"gravatar-hovercards\";s:3:\"1.1\";s:15:\"infinite-scroll\";s:3:\"2.0\";s:8:\"json-api\";s:3:\"1.9\";s:5:\"latex\";s:3:\"1.1\";s:11:\"lazy-images\";s:5:\"5.6.0\";s:5:\"likes\";s:3:\"2.2\";s:8:\"markdown\";s:3:\"2.8\";s:9:\"masterbar\";s:3:\"4.8\";s:7:\"monitor\";s:3:\"2.6\";s:5:\"notes\";s:3:\"1.9\";s:10:\"photon-cdn\";s:3:\"6.6\";s:6:\"photon\";s:3:\"2.0\";s:13:\"post-by-email\";s:3:\"2.0\";s:7:\"protect\";s:3:\"3.4\";s:9:\"publicize\";s:3:\"2.0\";s:13:\"related-posts\";s:3:\"2.9\";s:6:\"search\";s:3:\"5.0\";s:9:\"seo-tools\";s:3:\"4.4\";s:10:\"sharedaddy\";s:3:\"1.1\";s:10:\"shortcodes\";s:3:\"1.1\";s:10:\"shortlinks\";s:3:\"1.1\";s:8:\"sitemaps\";s:3:\"3.9\";s:3:\"sso\";s:3:\"2.6\";s:5:\"stats\";s:3:\"1.1\";s:13:\"subscriptions\";s:3:\"1.2\";s:13:\"tiled-gallery\";s:3:\"2.1\";s:10:\"vaultpress\";s:5:\"0:1.2\";s:18:\"verification-tools\";s:3:\"3.0\";s:10:\"videopress\";s:3:\"2.5\";s:17:\"widget-visibility\";s:3:\"2.4\";s:7:\"widgets\";s:3:\"1.2\";s:21:\"woocommerce-analytics\";s:3:\"8.4\";s:7:\"wordads\";s:5:\"4.5.0\";}}","yes"),
("214","om_notifications","a:4:{s:7:\"updated\";i:1626062928;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}","no"),
("216","_transient_wpforms_htaccess_file","a:3:{s:4:\"size\";i:737;s:5:\"mtime\";i:1648668218;s:5:\"ctime\";i:1648668218;}","yes"),
("231","finished_updating_comment_type","1","yes"),
("232","wpforms_email_summaries_fetch_info_blocks_last_run","1712005858","yes"),
("236","wpforms_notifications","a:4:{s:6:\"update\";i:1712439144;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}","yes"),
("243","current_theme","Divi","yes"),
("244","theme_mods_Divi","a:5:{i:0;b:0;s:18:\"custom_css_post_id\";i:-1;s:16:\"et_pb_css_synced\";s:3:\"yes\";s:18:\"nav_menu_locations\";a:1:{s:12:\"primary-menu\";i:2;}s:39:\"et_updated_layouts_built_for_post_types\";s:3:\"yes\";}","yes"),
("245","theme_switched","","yes"),
("248","et_pb_cache_notice","a:1:{s:5:\"4.9.7\";s:6:\"ignore\";}","yes"),
("253","et_core_version","4.9.7","yes"),
("255","et_divi","a:60:{s:39:\"static_css_custom_css_safety_check_done\";b:1;s:23:\"2_5_flush_rewrite_rules\";s:4:\"done\";s:30:\"et_flush_rewrite_rules_library\";s:5:\"4.9.7\";s:31:\"divi_previous_installed_version\";s:0:\"\";s:29:\"divi_latest_installed_version\";s:5:\"4.9.7\";s:27:\"divi_skip_font_subset_force\";b:1;s:27:\"et_pb_clear_templates_cache\";b:1;s:23:\"builder_custom_defaults\";O:8:\"stdClass\":0:{}s:33:\"customizer_settings_migrated_flag\";b:1;s:34:\"builder_custom_defaults_unmigrated\";b:0;s:40:\"divi_email_provider_credentials_migrated\";b:1;s:22:\"builder_global_presets\";O:8:\"stdClass\":0:{}s:29:\"custom_defaults_migrated_flag\";b:1;s:15:\"divi_1_3_images\";s:7:\"checked\";s:21:\"et_pb_layouts_updated\";b:1;s:30:\"library_removed_legacy_layouts\";b:1;s:30:\"divi_2_4_documentation_message\";s:9:\"triggered\";s:19:\"product_tour_status\";a:1:{i:1;s:3:\"off\";}s:32:\"et_fb_pref_settings_bar_location\";s:6:\"bottom\";s:28:\"et_fb_pref_builder_animation\";s:4:\"true\";s:41:\"et_fb_pref_builder_display_modal_settings\";s:5:\"false\";s:39:\"et_fb_pref_builder_enable_dummy_content\";s:4:\"true\";s:21:\"et_fb_pref_event_mode\";s:5:\"hover\";s:20:\"et_fb_pref_view_mode\";s:7:\"desktop\";s:32:\"et_fb_pref_hide_disabled_modules\";s:5:\"false\";s:28:\"et_fb_pref_history_intervals\";i:1;s:29:\"et_fb_pref_page_creation_flow\";s:7:\"default\";s:42:\"et_fb_pref_quick_actions_always_start_with\";s:7:\"nothing\";s:44:\"et_fb_pref_quick_actions_show_recent_queries\";s:3:\"off\";s:39:\"et_fb_pref_quick_actions_recent_queries\";s:0:\"\";s:40:\"et_fb_pref_quick_actions_recent_category\";s:0:\"\";s:27:\"et_fb_pref_modal_preference\";s:7:\"default\";s:30:\"et_fb_pref_modal_snap_location\";s:0:\"\";s:21:\"et_fb_pref_modal_snap\";s:5:\"false\";s:27:\"et_fb_pref_modal_fullscreen\";s:5:\"false\";s:32:\"et_fb_pref_modal_dimension_width\";i:400;s:33:\"et_fb_pref_modal_dimension_height\";i:400;s:27:\"et_fb_pref_modal_position_x\";i:30;s:27:\"et_fb_pref_modal_position_y\";i:50;s:24:\"et_fb_pref_toolbar_click\";s:5:\"false\";s:26:\"et_fb_pref_toolbar_desktop\";s:4:\"true\";s:23:\"et_fb_pref_toolbar_grid\";s:5:\"false\";s:24:\"et_fb_pref_toolbar_hover\";s:5:\"false\";s:24:\"et_fb_pref_toolbar_phone\";s:4:\"true\";s:25:\"et_fb_pref_toolbar_tablet\";s:4:\"true\";s:28:\"et_fb_pref_toolbar_wireframe\";s:4:\"true\";s:23:\"et_fb_pref_toolbar_zoom\";s:4:\"true\";s:36:\"et_fb_pref_lv_modal_dimension_height\";i:0;s:35:\"et_fb_pref_lv_modal_dimension_width\";i:0;s:30:\"et_fb_pref_lv_modal_position_x\";i:0;s:30:\"et_fb_pref_lv_modal_position_y\";i:0;s:34:\"et_fb_pref_responsive_tablet_width\";i:768;s:35:\"et_fb_pref_responsive_tablet_height\";i:0;s:33:\"et_fb_pref_responsive_phone_width\";i:400;s:34:\"et_fb_pref_responsive_phone_height\";i:0;s:35:\"et_fb_pref_responsive_minimum_width\";i:320;s:35:\"et_fb_pref_responsive_maximum_width\";i:980;s:24:\"footer_widget_text_color\";s:7:\"#ffffff\";s:24:\"footer_widget_link_color\";s:7:\"#ffffff\";s:16:\"show_search_icon\";b:0;}","yes"),
("256","widget_aboutmewidget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("257","widget_adsensewidget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("258","widget_advwidget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("259","shop_catalog_image_size","a:3:{s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"400\";s:4:\"crop\";i:1;}","yes"),
("260","shop_single_image_size","a:3:{s:5:\"width\";s:3:\"510\";s:6:\"height\";s:4:\"9999\";s:4:\"crop\";i:0;}","yes"),
("261","shop_thumbnail_image_size","a:3:{s:5:\"width\";s:3:\"157\";s:6:\"height\";s:3:\"157\";s:4:\"crop\";i:1;}","yes"),
("262","et_safe_mode_plugins_allowlist","a:8:{i:0;s:15:\"etdev/etdev.php\";i:1;s:15:\"bloom/bloom.php\";i:2;s:19:\"monarch/monarch.php\";i:3;s:29:\"divi-builder/divi-builder.php\";i:4;s:27:\"ari-adminer/ari-adminer.php\";i:5;s:31:\"query-monitor/query-monitor.php\";i:6;s:27:\"woocommerce/woocommerce.php\";i:7;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";}","yes"),
("263","et_support_center_installed","true","yes"),
("264","et_images_temp_folder","/home3/pmoadvisory/iexperipress.com/wp-content/uploads/et_temp","yes"),
("265","et_schedule_clean_images_last_time","1711911239","yes"),
("266","et_bfb_settings","a:2:{s:10:\"enable_bfb\";s:2:\"on\";s:10:\"toggle_bfb\";s:2:\"on\";}","yes"),
("267","_transient_et_builder_show_bfb_welcome_modal","1","yes"),
("268","et_pb_builder_options","a:2:{i:0;b:0;s:35:\"email_provider_credentials_migrated\";b:1;}","yes"),
("269","et_support_center_setup_done","processed","yes"),
("271","et_account_status","active","no"),
("275","recently_activated","a:0:{}","yes"),
("330","et_automatic_updates_options","a:2:{s:8:\"username\";s:11:\"pmoadvisory\";s:7:\"api_key\";s:40:\"71e3498732a9076747f8403ee4b8ba109c00b790\";}","no"),
("331","et_support_site_id","yfv+atU5ORIS^W40*(HY","yes"),
("335","et_pb_signup_acafb339ba08b646e11af2dd76cd8314","off","yes"),
("361","et_pb_contact_form_4488772b12a146aafca7ea190146f2c6","off","yes"),
("379","et_pb_signup_4cbb79812f0cdc8731dc31fd0c8707e1","off","yes"),
("383","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}","yes"),
("390","WPLANG","","yes"),
("391","new_admin_email","gen@pmoadvisory.com","yes"),
("392","mm_cache_settings","a:2:{s:4:\"page\";s:7:\"enabled\";s:7:\"browser\";s:7:\"enabled\";}","yes"),
("393","epc_filetype_expirations","a:9:{s:9:\"image/jpg\";s:8:\"24 hours\";s:10:\"image/jpeg\";s:8:\"24 hours\";s:9:\"image/gif\";s:8:\"24 hours\";s:9:\"image/png\";s:8:\"24 hours\";s:8:\"text/css\";s:8:\"24 hours\";s:15:\"application/pdf\";s:6:\"1 week\";s:15:\"text/javascript\";s:8:\"24 hours\";s:9:\"text/html\";s:9:\"5 minutes\";s:7:\"default\";s:8:\"24 hours\";}","yes"),
("440","action_scheduler_migration_status","complete","yes"),
("583","_transient_health-check-site-status-result","{\"good\":19,\"recommended\":4,\"critical\":0}","yes"),
("608","category_children","a:0:{}","yes"),
("928","signals_csmm_options","a:199:{s:4:\"mode\";s:6:\"layout\";s:9:\"csmm_page\";i:38;s:8:\"mc_lists\";b:0;s:6:\"status\";i:1;s:5:\"title\";s:23:\"iExpress is coming soon\";s:11:\"description\";s:95:\"We are doing some work on our site. Please come back later. We\'ll be up and running in no time.\";s:11:\"header_text\";s:14:\"Coming Soon...\";s:14:\"secondary_text\";s:147:\"<p>We are doing some work on our site. It won\'t take long, we promise. Come back and visit us again in a few days. Thank you for your patience!</p>\";s:17:\"content_1col_font\";s:5:\"Karla\";s:22:\"content_1col_font_size\";i:16;s:23:\"content_1col_font_color\";s:6:\"ffffff\";s:22:\"content_2col_text_left\";s:66:\"<ul><li>Unlimited Disk Space </li><li>Unlimited Traffic</li></ul>\";s:23:\"content_2col_text_right\";s:60:\"<ul><li>Free Domain Space</li><li>5 Domains Hosted</li></ul>\";s:17:\"content_2col_font\";s:5:\"Karla\";s:22:\"content_2col_font_size\";i:16;s:23:\"content_2col_font_color\";s:6:\"cccccc\";s:26:\"content_2col_divider_width\";s:1:\"1\";s:26:\"content_2col_divider_color\";s:6:\"cccccc\";s:20:\"content_2col_padding\";s:2:\"10\";s:14:\"divider_height\";i:1;s:13:\"divider_color\";s:6:\"000000\";s:18:\"divider_margin_top\";i:10;s:21:\"divider_margin_bottom\";i:10;s:13:\"antispam_text\";s:22:\"Yes, we hate spam too!\";s:16:\"custom_login_url\";s:0:\"\";s:14:\"show_logged_in\";i:1;s:10:\"exclude_se\";s:1:\"2\";s:8:\"block_se\";i:0;s:7:\"arrange\";s:16:\"header,countdown\";s:9:\"analytics\";s:0:\"\";s:14:\"tracking_pixel\";s:0:\"\";s:13:\"mailchimp_api\";s:0:\"\";s:18:\"mail_system_to_use\";s:2:\"mc\";s:14:\"target_keyword\";s:11:\"coming soon\";s:17:\"signals_show_name\";i:1;s:24:\"signal_zapier_action_url\";s:0:\"\";s:20:\"signal_ua_action_url\";s:0:\"\";s:16:\"signal_ua_method\";s:3:\"get\";s:26:\"signal_ua_email_field_name\";s:0:\"\";s:25:\"signal_ua_name_field_name\";s:0:\"\";s:25:\"signal_ua_additional_data\";s:0:\"\";s:20:\"signals_double_optin\";i:0;s:10:\"mail_debug\";i:0;s:27:\"signals_csmm_message_noname\";s:9:\"Your name\";s:14:\"mailchimp_list\";s:0:\"\";s:15:\"message_noemail\";s:37:\"Please provide a valid email address.\";s:15:\"message_no_name\";s:22:\"Please enter your name\";s:18:\"message_subscribed\";s:27:\"You are already subscribed!\";s:13:\"message_wrong\";s:59:\"Something went wrong. Please reload the page and try again.\";s:12:\"message_done\";s:29:\"Thank you! We\'ll be in touch!\";s:4:\"logo\";s:71:\"https://assets.comingsoonwp.com/themes/walking-away-video/csmm-logo.png\";s:7:\"favicon\";s:64:\"https://assets.comingsoonwp.com//themes/default/csmm-favicon.png\";s:14:\"social_preview\";s:71:\"https://assets.comingsoonwp.com//themes/default/csmm-social-preview.jpg\";s:8:\"bg_cover\";s:63:\"https://assets.comingsoonwp.com//themes/default/mountain-bg.jpg\";s:25:\"background_video_fallback\";s:65:\"https://comingsoonwp.com/app/wp-content/uploads/2020/08/thumb.png\";s:15:\"content_overlay\";i:1;s:22:\"content_overlay_mobile\";i:2;s:13:\"content_width\";i:670;s:8:\"bg_color\";s:6:\"ffffff\";s:16:\"content_position\";s:6:\"middle\";s:11:\"header_font\";s:5:\"Junge\";s:14:\"secondary_font\";s:5:\"Karla\";s:16:\"header_font_size\";s:2:\"50\";s:19:\"secondary_font_size\";s:2:\"16\";s:17:\"header_font_color\";s:6:\"c79d24\";s:20:\"secondary_font_color\";s:6:\"ffffff\";s:10:\"link_color\";s:6:\"0096ff\";s:16:\"link_hover_color\";s:6:\"57baff\";s:18:\"antispam_font_size\";s:2:\"12\";s:19:\"antispam_font_color\";s:6:\"bbbbbb\";s:13:\"logo_link_url\";s:0:\"\";s:12:\"submit_align\";s:4:\"left\";s:10:\"input_text\";s:23:\"Your best email address\";s:9:\"gdpr_text\";s:0:\"\";s:16:\"gdpr_policy_text\";s:0:\"\";s:15:\"gdpr_error_text\";s:61:\"Please confirm the subscription terms with the checkbox below\";s:11:\"button_text\";s:9:\"Subscribe\";s:18:\"ignore_form_styles\";i:1;s:15:\"input_font_size\";s:2:\"13\";s:16:\"button_font_size\";s:2:\"12\";s:16:\"input_font_color\";s:6:\"ffffff\";s:17:\"button_font_color\";s:6:\"ffffff\";s:8:\"input_bg\";s:6:\"ffffff\";s:9:\"button_bg\";s:6:\"0f0f0f\";s:14:\"input_bg_hover\";s:6:\"eeeeee\";s:15:\"button_bg_hover\";s:6:\"0a0a0a\";s:12:\"input_border\";s:6:\"eeeeee\";s:13:\"button_border\";s:6:\"0f0f0f\";s:18:\"input_border_hover\";s:6:\"bbbbbb\";s:19:\"button_border_hover\";s:6:\"0a0a0a\";s:18:\"success_background\";s:6:\"90c695\";s:13:\"success_color\";s:6:\"ffffff\";s:16:\"error_background\";s:6:\"e08283\";s:11:\"error_color\";s:6:\"ffffff\";s:22:\"form_placeholder_color\";s:6:\"dedede\";s:16:\"disable_settings\";i:0;s:16:\"disable_adminbar\";i:0;s:8:\"forcessl\";i:0;s:11:\"track_stats\";i:1;s:6:\"wprest\";i:0;s:11:\"wpm_replace\";N;s:9:\"wpm_title\";s:0:\"\";s:11:\"wpm_content\";s:0:\"\";s:11:\"custom_html\";s:0:\"\";s:18:\"custom_html_layout\";s:0:\"\";s:10:\"custom_css\";s:37:\".header-text {\r\nfont-size: 76px;\r\n}\r\n\";s:20:\"signals_ip_whitelist\";s:0:\"\";s:16:\"per_url_settings\";s:0:\"\";s:22:\"per_url_enable_disable\";s:0:\"\";s:18:\"direct_access_link\";s:0:\"\";s:22:\"direct_access_password\";s:0:\"\";s:13:\"site_password\";s:0:\"\";s:15:\"password_button\";i:0;s:12:\"login_button\";s:0:\"\";s:17:\"login_button_text\";s:15:\"Access the Site\";s:13:\"login_message\";s:44:\"Please enter the password to access the site\";s:25:\"login_wrong_password_text\";s:14:\"Wrong password\";s:22:\"wplogin_button_tooltip\";s:22:\"Access WordPress admin\";s:20:\"login_button_tooltip\";s:19:\"Direct Access login\";s:9:\"icon_size\";s:6:\"medium\";s:18:\"social_icons_color\";s:6:\"ffffff\";s:15:\"logo_max_height\";i:150;s:10:\"logo_title\";s:27:\"Our new site is coming soon\";s:15:\"social_list_url\";a:4:{i:0;s:1:\"#\";i:1;s:1:\"#\";i:2;s:1:\"#\";i:3;s:1:\"#\";}s:16:\"social_list_icon\";a:4:{i:0;s:5:\"57706\";i:1;s:5:\"57706\";i:2;s:5:\"57710\";i:3;s:5:\"57702\";}s:11:\"map_address\";s:13:\"New York, USA\";s:8:\"map_zoom\";i:15;s:10:\"map_height\";i:250;s:11:\"map_api_key\";s:39:\"AIzaSyAAznHhsGtU4J4ua8btTu_qHH2KBngDT3A\";s:13:\"overlay_color\";s:6:\"000000\";s:18:\"transparency_level\";s:2:\"27\";s:13:\"module_margin\";i:25;s:7:\"nocache\";i:1;s:10:\"video_type\";s:7:\"youtube\";s:8:\"video_id\";s:11:\"YE7VzlLtp-4\";s:14:\"video_autoplay\";i:0;s:10:\"video_mute\";i:0;s:13:\"video_minimal\";i:1;s:16:\"video_embed_code\";s:0:\"\";s:16:\"custom_head_code\";s:0:\"\";s:16:\"custom_foot_code\";s:0:\"\";s:19:\"progress_percentage\";i:33;s:15:\"progress_height\";i:35;s:19:\"progress_label_size\";i:20;s:14:\"progress_color\";s:6:\"ff0000\";s:20:\"progress_label_color\";s:6:\"ffffff\";s:14:\"countdown_date\";s:16:\"2021-04-25 12:00\";s:15:\"countdown_color\";s:6:\"c79d24\";s:22:\"countdown_labels_color\";s:6:\"ab871f\";s:14:\"countdown_size\";i:31;s:21:\"countdown_labels_size\";i:16;s:14:\"countdown_days\";s:4:\"days\";s:15:\"countdown_hours\";s:5:\"hours\";s:17:\"countdown_minutes\";s:3:\"min\";s:17:\"countdown_seconds\";s:3:\"sec\";s:15:\"background_type\";s:5:\"video\";s:23:\"background_video_filter\";s:0:\"\";s:16:\"background_video\";s:11:\"Q3d2ZYgix-A\";s:19:\"background_size_opt\";s:5:\"cover\";s:19:\"background_position\";s:13:\"center center\";s:23:\"background_image_filter\";s:0:\"\";s:12:\"twitter_site\";s:0:\"\";s:13:\"facebook_site\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:10:\"whitelabel\";i:0;s:17:\"contact_show_name\";s:1:\"1\";s:21:\"contact_email_subject\";s:38:\"New message from your Coming Soon page\";s:19:\"contact_admin_email\";s:19:\"gen@pmoadvisory.com\";s:22:\"contact_message_noname\";s:9:\"Your name\";s:18:\"contact_input_text\";s:23:\"Your best email address\";s:20:\"contact_message_text\";s:26:\"Write your awesome message\";s:19:\"contact_button_text\";s:12:\"Send Message\";s:17:\"contact_gdpr_text\";s:80:\"I understand the site\'s privacy policy and am willingly sharing my email address\";s:23:\"contact_gdpr_error_text\";s:61:\"Please confirm the subscription terms with the checkbox below\";s:24:\"contact_gdpr_policy_text\";s:0:\"\";s:16:\"contact_antispam\";s:22:\"Yes, we hate spam too!\";s:20:\"contact_submit_align\";s:4:\"left\";s:21:\"contact_antispam_size\";s:2:\"12\";s:22:\"contact_antispam_color\";s:6:\"bbbbbb\";s:18:\"contact_success_bg\";s:6:\"90c695\";s:21:\"contact_success_color\";s:6:\"ffffff\";s:16:\"contact_error_bg\";s:6:\"e08283\";s:19:\"contact_error_color\";s:6:\"ffffff\";s:25:\"contact_placeholder_color\";s:6:\"8f8f8f\";s:21:\"contact_ignore_styles\";s:1:\"1\";s:18:\"contact_input_size\";s:2:\"13\";s:19:\"contact_button_size\";s:2:\"12\";s:20:\"contact_button_color\";s:6:\"ffffff\";s:16:\"contact_input_bg\";s:6:\"ffffff\";s:17:\"contact_button_bg\";s:6:\"0f0f0f\";s:23:\"contact_button_bg_hover\";s:6:\"0a0a0a\";s:20:\"contact_input_border\";s:6:\"eeeeee\";s:21:\"contact_button_border\";s:6:\"0f0f0f\";s:26:\"contact_input_border_hover\";s:6:\"bbbbbb\";s:27:\"contact_button_border_hover\";s:6:\"0a0a0a\";s:19:\"contact_input_color\";s:6:\"000000\";s:9:\"recaptcha\";s:8:\"disabled\";s:18:\"recaptcha_site_key\";s:0:\"\";s:20:\"recaptcha_secret_key\";s:0:\"\";}","yes"),
("929","signals_csmm_meta","a:7:{s:12:\"license_type\";s:0:\"\";s:15:\"license_expires\";s:0:\"\";s:14:\"license_active\";b:0;s:11:\"license_key\";s:0:\"\";s:13:\"first_version\";s:4:\"6.31\";s:17:\"first_install_gmt\";i:1626575506;s:13:\"first_install\";i:1626575506;}","yes"),
("930","wf_licensing_csmm","a:7:{s:11:\"license_key\";s:26:\"7A0FD0CD-C9630BE0-75251B58\";s:5:\"error\";s:116:\"Error querying licensing server. cURL error 28: Connection timeout after 10001 ms Please try again in a few moments.\";s:4:\"name\";s:0:\"\";s:10:\"last_check\";i:0;s:11:\"valid_until\";s:0:\"\";s:4:\"meta\";a:0:{}s:10:\"access_key\";s:32:\"enUdN9dOd5OE8fqnfwsIsJmVTUfywls7\";}","yes"),
("940","_mm_cache","Clear cache","yes"),
("943","csmm_stats","a:2:{s:7:\"general\";a:4:{s:9:\"countries\";a:95:{s:7:\"unknown\";i:4743;s:13:\"United States\";i:40816;s:6:\"France\";i:2008;s:6:\"Russia\";i:2625;s:8:\"Thailand\";i:59;s:6:\"Sweden\";i:472;s:6:\"Canada\";i:1296;s:4:\"Iran\";i:445;s:9:\"Singapore\";i:6245;s:6:\"Poland\";i:234;s:14:\"United Kingdom\";i:6545;s:11:\"Netherlands\";i:2716;s:7:\"Vietnam\";i:228;s:6:\"Taiwan\";i:61;s:5:\"Japan\";i:443;s:9:\"Sri Lanka\";i:1;s:7:\"Germany\";i:7330;s:5:\"India\";i:783;s:6:\"Norway\";i:101;s:5:\"Italy\";i:210;s:11:\"South Korea\";i:66;s:5:\"China\";i:721;s:9:\"Hong Kong\";i:191;s:7:\"Ukraine\";i:978;s:6:\"Israel\";i:23;s:6:\"Greece\";i:23;s:6:\"Brazil\";i:104;s:5:\"Chile\";i:11;s:7:\"Czechia\";i:560;s:7:\"Ireland\";i:1070;s:11:\"Switzerland\";i:363;s:7:\"Romania\";i:1364;s:12:\"South Africa\";i:41;s:7:\"Denmark\";i:112;s:4:\"Iraq\";i:11;s:8:\"Slovenia\";i:8;s:9:\"Indonesia\";i:190;s:7:\"Austria\";i:112;s:11:\"New Zealand\";i:3;s:7:\"Belgium\";i:62;s:9:\"Macedonia\";i:6;s:6:\"Serbia\";i:4;s:7:\"Iceland\";i:6;s:5:\"Spain\";i:743;s:7:\"Estonia\";i:4;s:21:\"Republic of Lithuania\";i:68;s:8:\"Malaysia\";i:26;s:19:\"Republic of Moldova\";i:60;s:7:\"Georgia\";i:21;s:8:\"Honduras\";i:2;s:9:\"Australia\";i:1122;s:6:\"Turkey\";i:256;s:8:\"Slovakia\";i:21;s:8:\"Bulgaria\";i:3499;s:8:\"Portugal\";i:48;s:7:\"Finland\";i:134;s:10:\"Kazakhstan\";i:19;s:22:\"Bosnia and Herzegovina\";i:3;s:9:\"Argentina\";i:24;s:6:\"Latvia\";i:9;s:10:\"Bangladesh\";i:6;s:10:\"Luxembourg\";i:2728;s:10:\"Seychelles\";i:6;s:6:\"Panama\";i:1;s:10:\"Kyrgyzstan\";i:3;s:11:\"Philippines\";i:22;s:7:\"Lebanon\";i:43;s:5:\"Macao\";i:2;s:8:\"Colombia\";i:4;s:12:\"Saudi Arabia\";i:1;s:10:\"Costa Rica\";i:1;s:7:\"Croatia\";i:1;s:6:\"Mexico\";i:13;s:7:\"Hungary\";i:5;s:8:\"Pakistan\";i:20;s:7:\"Belarus\";i:1;s:20:\"United Arab Emirates\";i:17;s:10:\"Azerbaijan\";i:2;s:27:\"Hashemite Kingdom of Jordan\";i:2;s:13:\"French Guiana\";i:1;s:4:\"Oman\";i:24;s:7:\"Albania\";i:971;s:7:\"Morocco\";i:36;s:8:\"Mongolia\";i:9;s:7:\"Ecuador\";i:1;s:7:\"Tunisia\";i:1;s:8:\"Cambodia\";i:76;s:8:\"Guernsey\";i:1;s:7:\"Algeria\";i:13;s:6:\"Kuwait\";i:51;s:4:\"Peru\";i:3;s:6:\"Angola\";i:1;s:5:\"Kenya\";i:1;s:5:\"Congo\";i:21;s:22:\"British Virgin Islands\";i:1;}s:8:\"browsers\";a:49:{s:7:\"unknown\";i:14671;s:6:\"Chrome\";i:33654;s:7:\"Firefox\";i:12097;s:17:\"Internet Explorer\";i:3714;s:5:\"Opera\";i:2200;s:6:\"Safari\";i:317;s:4:\"Edge\";i:97;s:10:\"UC Browser\";i:183;s:14:\"Yandex Browser\";i:17;s:15:\"Android Browser\";i:25;s:16:\"Samsung Internet\";i:14;s:14:\"Sogou Explorer\";i:1;s:9:\"GNOME Web\";i:3;s:12:\"Opera Mobile\";i:15;s:6:\"Galeon\";i:2;s:17:\"360 Safe Explorer\";i:70;s:7:\"Maxthon\";i:5;s:18:\"BlackBerry Browser\";i:5;s:10:\"Opera Mini\";i:3;s:8:\"Chromium\";i:3;s:12:\"MIUI Browser\";i:3;s:7:\"OmniWeb\";i:4;s:20:\"WebKit Nightly Build\";i:2;s:24:\"Mobile Internet Explorer\";i:7;s:6:\"ELinks\";i:1;s:7:\"Vivaldi\";i:13;s:9:\"Konqueror\";i:4;s:6:\"Puffin\";i:3;s:13:\"webOS Browser\";i:1;s:14:\"Firefox Mobile\";i:5;s:6:\"WeChat\";i:1;s:10:\"QQ Browser\";i:2;s:8:\"NetFront\";i:5;s:8:\"QupZilla\";i:1;s:9:\"Iceweasel\";i:2;s:6:\"iTunes\";i:3;s:9:\"SeaMonkey\";i:6;s:25:\"Motorola Internet Browser\";i:1;s:8:\"Openwave\";i:2;s:13:\"Avant Browser\";i:1;s:6:\"Blazer\";i:1;s:13:\"Quark Browser\";i:1;s:16:\"Download Manager\";i:1;s:4:\"Silk\";i:1;s:12:\"SEMC Browser\";i:1;s:9:\"Flipboard\";i:1;s:6:\"LieBao\";i:1;s:9:\"Pale Moon\";i:1;s:6:\"Dolfin\";i:1;}s:7:\"devices\";a:5:{s:7:\"unknown\";i:0;s:7:\"desktop\";i:51178;s:3:\"bot\";i:26366;s:6:\"tablet\";i:13849;s:6:\"mobile\";i:2145;}s:7:\"traffic\";a:2:{s:7:\"unknown\";i:26366;s:5:\"human\";i:67172;}}s:6:\"visits\";a:995:{s:10:\"2021-07-18\";i:82;s:10:\"2021-07-19\";i:69;s:10:\"2021-07-20\";i:37;s:10:\"2021-07-21\";i:115;s:10:\"2021-07-22\";i:35;s:10:\"2021-07-23\";i:48;s:10:\"2021-07-24\";i:46;s:10:\"2021-07-25\";i:47;s:10:\"2021-07-26\";i:38;s:10:\"2021-07-27\";i:139;s:10:\"2021-07-28\";i:25;s:10:\"2021-07-29\";i:30;s:10:\"2021-07-30\";i:79;s:10:\"2021-07-31\";i:80;s:10:\"2021-08-01\";i:43;s:10:\"2021-08-02\";i:40;s:10:\"2021-08-03\";i:53;s:10:\"2021-08-04\";i:92;s:10:\"2021-08-05\";i:39;s:10:\"2021-08-06\";i:39;s:10:\"2021-08-07\";i:39;s:10:\"2021-08-08\";i:70;s:10:\"2021-08-09\";i:39;s:10:\"2021-08-10\";i:53;s:10:\"2021-08-11\";i:35;s:10:\"2021-08-12\";i:73;s:10:\"2021-08-13\";i:42;s:10:\"2021-08-14\";i:34;s:10:\"2021-08-15\";i:57;s:10:\"2021-08-16\";i:23;s:10:\"2021-08-17\";i:50;s:10:\"2021-08-18\";i:20;s:10:\"2021-08-19\";i:39;s:10:\"2021-08-20\";i:45;s:10:\"2021-08-21\";i:35;s:10:\"2021-08-22\";i:55;s:10:\"2021-08-23\";i:31;s:10:\"2021-08-24\";i:33;s:10:\"2021-08-25\";i:38;s:10:\"2021-08-26\";i:23;s:10:\"2021-08-27\";i:31;s:10:\"2021-08-28\";i:20;s:10:\"2021-08-29\";i:26;s:10:\"2021-08-30\";i:28;s:10:\"2021-08-31\";i:49;s:10:\"2021-09-01\";i:28;s:10:\"2021-09-02\";i:24;s:10:\"2021-09-03\";i:30;s:10:\"2021-09-04\";i:36;s:10:\"2021-09-05\";i:21;s:10:\"2021-09-06\";i:33;s:10:\"2021-09-07\";i:19;s:10:\"2021-09-08\";i:23;s:10:\"2021-09-09\";i:25;s:10:\"2021-09-10\";i:89;s:10:\"2021-09-11\";i:31;s:10:\"2021-09-12\";i:79;s:10:\"2021-09-13\";i:20;s:10:\"2021-09-14\";i:51;s:10:\"2021-09-15\";i:24;s:10:\"2021-09-16\";i:48;s:10:\"2021-09-17\";i:54;s:10:\"2021-09-18\";i:50;s:10:\"2021-09-19\";i:63;s:10:\"2021-09-20\";i:39;s:10:\"2021-09-21\";i:50;s:10:\"2021-09-22\";i:79;s:10:\"2021-09-23\";i:55;s:10:\"2021-09-24\";i:253;s:10:\"2021-09-25\";i:58;s:10:\"2021-09-26\";i:57;s:10:\"2021-09-27\";i:39;s:10:\"2021-09-28\";i:51;s:10:\"2021-09-29\";i:42;s:10:\"2021-09-30\";i:20;s:10:\"2021-10-01\";i:26;s:10:\"2021-10-02\";i:24;s:10:\"2021-10-03\";i:29;s:10:\"2021-10-04\";i:31;s:10:\"2021-10-05\";i:24;s:10:\"2021-10-06\";i:31;s:10:\"2021-10-07\";i:75;s:10:\"2021-10-08\";i:65;s:10:\"2021-10-09\";i:37;s:10:\"2021-10-10\";i:54;s:10:\"2021-10-11\";i:46;s:10:\"2021-10-12\";i:46;s:10:\"2021-10-13\";i:59;s:10:\"2021-10-14\";i:30;s:10:\"2021-10-15\";i:26;s:10:\"2021-10-16\";i:32;s:10:\"2021-10-17\";i:15;s:10:\"2021-10-18\";i:22;s:10:\"2021-10-19\";i:30;s:10:\"2021-10-20\";i:27;s:10:\"2021-10-21\";i:42;s:10:\"2021-10-22\";i:22;s:10:\"2021-10-23\";i:32;s:10:\"2021-10-24\";i:24;s:10:\"2021-10-25\";i:16;s:10:\"2021-10-26\";i:60;s:10:\"2021-10-27\";i:27;s:10:\"2021-10-28\";i:25;s:10:\"2021-10-29\";i:58;s:10:\"2021-10-30\";i:26;s:10:\"2021-10-31\";i:49;s:10:\"2021-11-01\";i:12;s:10:\"2021-11-02\";i:23;s:10:\"2021-11-03\";i:18;s:10:\"2021-11-04\";i:37;s:10:\"2021-11-05\";i:42;s:10:\"2021-11-06\";i:28;s:10:\"2021-11-07\";i:55;s:10:\"2021-11-08\";i:67;s:10:\"2021-11-09\";i:94;s:10:\"2021-11-10\";i:31;s:10:\"2021-11-11\";i:22;s:10:\"2021-11-12\";i:27;s:10:\"2021-11-13\";i:31;s:10:\"2021-11-14\";i:20;s:10:\"2021-11-15\";i:46;s:10:\"2021-11-16\";i:44;s:10:\"2021-11-17\";i:34;s:10:\"2021-11-18\";i:43;s:10:\"2021-11-19\";i:34;s:10:\"2021-11-20\";i:21;s:10:\"2021-11-21\";i:13;s:10:\"2021-11-22\";i:34;s:10:\"2021-11-23\";i:33;s:10:\"2021-11-24\";i:35;s:10:\"2021-11-25\";i:20;s:10:\"2021-11-26\";i:39;s:10:\"2021-11-27\";i:15;s:10:\"2021-11-28\";i:33;s:10:\"2021-11-29\";i:39;s:10:\"2021-11-30\";i:93;s:10:\"2021-12-01\";i:29;s:10:\"2021-12-02\";i:23;s:10:\"2021-12-03\";i:27;s:10:\"2021-12-04\";i:35;s:10:\"2021-12-05\";i:26;s:10:\"2021-12-06\";i:24;s:10:\"2021-12-07\";i:20;s:10:\"2021-12-08\";i:51;s:10:\"2021-12-09\";i:80;s:10:\"2021-12-10\";i:36;s:10:\"2021-12-11\";i:35;s:10:\"2021-12-12\";i:26;s:10:\"2021-12-13\";i:44;s:10:\"2021-12-14\";i:24;s:10:\"2021-12-15\";i:32;s:10:\"2021-12-16\";i:42;s:10:\"2021-12-17\";i:20;s:10:\"2021-12-18\";i:15;s:10:\"2021-12-19\";i:39;s:10:\"2021-12-20\";i:21;s:10:\"2021-12-21\";i:25;s:10:\"2021-12-22\";i:13;s:10:\"2021-12-23\";i:23;s:10:\"2021-12-24\";i:31;s:10:\"2021-12-25\";i:30;s:10:\"2021-12-26\";i:44;s:10:\"2021-12-27\";i:39;s:10:\"2021-12-28\";i:37;s:10:\"2021-12-29\";i:77;s:10:\"2021-12-30\";i:12;s:10:\"2021-12-31\";i:36;s:10:\"2022-01-01\";i:12;s:10:\"2022-01-02\";i:38;s:10:\"2022-01-03\";i:52;s:10:\"2022-01-04\";i:100;s:10:\"2022-01-05\";i:18;s:10:\"2022-01-06\";i:25;s:10:\"2022-01-07\";i:18;s:10:\"2022-01-08\";i:17;s:10:\"2022-01-09\";i:22;s:10:\"2022-01-10\";i:8;s:10:\"2022-01-11\";i:24;s:10:\"2022-01-12\";i:25;s:10:\"2022-01-13\";i:18;s:10:\"2022-01-14\";i:19;s:10:\"2022-01-15\";i:58;s:10:\"2022-01-16\";i:17;s:10:\"2022-01-17\";i:41;s:10:\"2022-01-18\";i:19;s:10:\"2022-01-19\";i:34;s:10:\"2022-01-20\";i:25;s:10:\"2022-01-21\";i:60;s:10:\"2022-01-22\";i:15;s:10:\"2022-01-23\";i:11;s:10:\"2022-01-24\";i:18;s:10:\"2022-01-25\";i:25;s:10:\"2022-01-26\";i:18;s:10:\"2022-01-27\";i:67;s:10:\"2022-01-28\";i:19;s:10:\"2022-01-29\";i:25;s:10:\"2022-01-30\";i:15;s:10:\"2022-01-31\";i:27;s:10:\"2022-02-01\";i:27;s:10:\"2022-02-02\";i:20;s:10:\"2022-02-03\";i:29;s:10:\"2022-02-04\";i:16;s:10:\"2022-02-05\";i:37;s:10:\"2022-02-06\";i:20;s:10:\"2022-02-07\";i:41;s:10:\"2022-02-08\";i:16;s:10:\"2022-02-09\";i:15;s:10:\"2022-02-10\";i:25;s:10:\"2022-02-11\";i:34;s:10:\"2022-02-12\";i:16;s:10:\"2022-02-13\";i:12;s:10:\"2022-02-14\";i:16;s:10:\"2022-02-15\";i:119;s:10:\"2022-02-16\";i:8;s:10:\"2022-02-17\";i:33;s:10:\"2022-02-18\";i:24;s:10:\"2022-02-19\";i:10;s:10:\"2022-02-20\";i:111;s:10:\"2022-02-21\";i:20;s:10:\"2022-02-22\";i:67;s:10:\"2022-02-23\";i:54;s:10:\"2022-02-24\";i:25;s:10:\"2022-02-25\";i:37;s:10:\"2022-02-26\";i:29;s:10:\"2022-02-27\";i:17;s:10:\"2022-02-28\";i:33;s:10:\"2022-03-01\";i:17;s:10:\"2022-03-02\";i:28;s:10:\"2022-03-03\";i:19;s:10:\"2022-03-04\";i:30;s:10:\"2022-03-05\";i:13;s:10:\"2022-03-06\";i:10;s:10:\"2022-03-07\";i:106;s:10:\"2022-03-08\";i:22;s:10:\"2022-03-09\";i:98;s:10:\"2022-03-10\";i:94;s:10:\"2022-03-11\";i:125;s:10:\"2022-03-12\";i:44;s:10:\"2022-03-13\";i:17;s:10:\"2022-03-14\";i:29;s:10:\"2022-03-15\";i:35;s:10:\"2022-03-16\";i:115;s:10:\"2022-03-17\";i:55;s:10:\"2022-03-18\";i:58;s:10:\"2022-03-19\";i:18;s:10:\"2022-03-20\";i:117;s:10:\"2022-03-21\";i:144;s:10:\"2022-03-22\";i:82;s:10:\"2022-03-23\";i:88;s:10:\"2022-03-24\";i:33;s:10:\"2022-03-25\";i:79;s:10:\"2022-03-26\";i:54;s:10:\"2022-03-27\";i:25;s:10:\"2022-03-28\";i:24;s:10:\"2022-03-29\";i:79;s:10:\"2022-03-30\";i:64;s:10:\"2022-03-31\";i:51;s:10:\"2022-04-01\";i:25;s:10:\"2022-04-02\";i:87;s:10:\"2022-04-03\";i:82;s:10:\"2022-04-04\";i:35;s:10:\"2022-04-05\";i:19;s:10:\"2022-04-06\";i:28;s:10:\"2022-04-07\";i:42;s:10:\"2022-04-08\";i:40;s:10:\"2022-04-09\";i:70;s:10:\"2022-04-10\";i:57;s:10:\"2022-04-11\";i:16;s:10:\"2022-04-12\";i:36;s:10:\"2022-04-13\";i:16;s:10:\"2022-04-14\";i:16;s:10:\"2022-04-15\";i:17;s:10:\"2022-04-16\";i:48;s:10:\"2022-04-17\";i:45;s:10:\"2022-04-18\";i:23;s:10:\"2022-04-19\";i:44;s:10:\"2022-04-20\";i:22;s:10:\"2022-04-21\";i:40;s:10:\"2022-04-22\";i:92;s:10:\"2022-04-23\";i:26;s:10:\"2022-04-24\";i:74;s:10:\"2022-04-25\";i:27;s:10:\"2022-04-26\";i:54;s:10:\"2022-04-27\";i:19;s:10:\"2022-04-28\";i:61;s:10:\"2022-04-29\";i:33;s:10:\"2022-04-30\";i:37;s:10:\"2022-05-01\";i:37;s:10:\"2022-05-02\";i:12;s:10:\"2022-05-03\";i:71;s:10:\"2022-05-04\";i:13;s:10:\"2022-05-05\";i:22;s:10:\"2022-05-06\";i:25;s:10:\"2022-05-07\";i:71;s:10:\"2022-05-08\";i:26;s:10:\"2022-05-09\";i:17;s:10:\"2022-05-10\";i:42;s:10:\"2022-05-11\";i:95;s:10:\"2022-05-12\";i:25;s:10:\"2022-05-13\";i:14;s:10:\"2022-05-14\";i:76;s:10:\"2022-05-15\";i:12;s:10:\"2022-05-16\";i:54;s:10:\"2022-05-17\";i:26;s:10:\"2022-05-18\";i:81;s:10:\"2022-05-19\";i:23;s:10:\"2022-05-20\";i:33;s:10:\"2022-05-21\";i:105;s:10:\"2022-05-22\";i:23;s:10:\"2022-05-23\";i:13;s:10:\"2022-05-24\";i:100;s:10:\"2022-05-25\";i:117;s:10:\"2022-05-26\";i:21;s:10:\"2022-05-27\";i:123;s:10:\"2022-05-28\";i:20;s:10:\"2022-05-29\";i:74;s:10:\"2022-05-30\";i:88;s:10:\"2022-05-31\";i:32;s:10:\"2022-06-01\";i:22;s:10:\"2022-06-02\";i:31;s:10:\"2022-06-03\";i:154;s:10:\"2022-06-04\";i:85;s:10:\"2022-06-05\";i:138;s:10:\"2022-06-06\";i:30;s:10:\"2022-06-07\";i:37;s:10:\"2022-06-08\";i:74;s:10:\"2022-06-09\";i:26;s:10:\"2022-06-10\";i:95;s:10:\"2022-06-11\";i:35;s:10:\"2022-06-12\";i:27;s:10:\"2022-06-13\";i:23;s:10:\"2022-06-14\";i:29;s:10:\"2022-06-15\";i:49;s:10:\"2022-06-16\";i:21;s:10:\"2022-06-17\";i:22;s:10:\"2022-06-18\";i:35;s:10:\"2022-06-19\";i:27;s:10:\"2022-06-20\";i:22;s:10:\"2022-06-21\";i:32;s:10:\"2022-06-22\";i:27;s:10:\"2022-06-23\";i:43;s:10:\"2022-06-24\";i:19;s:10:\"2022-06-25\";i:26;s:10:\"2022-06-26\";i:116;s:10:\"2022-06-27\";i:74;s:10:\"2022-06-28\";i:28;s:10:\"2022-06-29\";i:24;s:10:\"2022-06-30\";i:63;s:10:\"2022-07-01\";i:45;s:10:\"2022-07-02\";i:30;s:10:\"2022-07-03\";i:28;s:10:\"2022-07-04\";i:44;s:10:\"2022-07-05\";i:103;s:10:\"2022-07-06\";i:42;s:10:\"2022-07-07\";i:36;s:10:\"2022-07-08\";i:44;s:10:\"2022-07-09\";i:18;s:10:\"2022-07-10\";i:23;s:10:\"2022-07-11\";i:171;s:10:\"2022-07-12\";i:25;s:10:\"2022-07-13\";i:43;s:10:\"2022-07-14\";i:73;s:10:\"2022-07-15\";i:69;s:10:\"2022-07-16\";i:17;s:10:\"2022-07-17\";i:55;s:10:\"2022-07-18\";i:129;s:10:\"2022-07-19\";i:155;s:10:\"2022-07-20\";i:137;s:10:\"2022-07-21\";i:28;s:10:\"2022-07-22\";i:21;s:10:\"2022-07-23\";i:45;s:10:\"2022-07-24\";i:24;s:10:\"2022-07-25\";i:29;s:10:\"2022-07-26\";i:182;s:10:\"2022-07-27\";i:168;s:10:\"2022-07-28\";i:75;s:10:\"2022-07-29\";i:25;s:10:\"2022-07-30\";i:23;s:10:\"2022-07-31\";i:48;s:10:\"2022-08-01\";i:99;s:10:\"2022-08-02\";i:37;s:10:\"2022-08-03\";i:97;s:10:\"2022-08-04\";i:89;s:10:\"2022-08-05\";i:110;s:10:\"2022-08-06\";i:39;s:10:\"2022-08-07\";i:19;s:10:\"2022-08-08\";i:45;s:10:\"2022-08-09\";i:70;s:10:\"2022-08-10\";i:30;s:10:\"2022-08-11\";i:149;s:10:\"2022-08-12\";i:82;s:10:\"2022-08-13\";i:19;s:10:\"2022-08-14\";i:95;s:10:\"2022-08-15\";i:39;s:10:\"2022-08-16\";i:94;s:10:\"2022-08-17\";i:27;s:10:\"2022-08-18\";i:25;s:10:\"2022-08-19\";i:43;s:10:\"2022-08-20\";i:71;s:10:\"2022-08-21\";i:95;s:10:\"2022-08-22\";i:92;s:10:\"2022-08-23\";i:135;s:10:\"2022-08-24\";i:37;s:10:\"2022-08-25\";i:35;s:10:\"2022-08-26\";i:46;s:10:\"2022-08-27\";i:40;s:10:\"2022-08-28\";i:26;s:10:\"2022-08-29\";i:35;s:10:\"2022-08-30\";i:26;s:10:\"2022-08-31\";i:8;s:10:\"2022-09-01\";i:13;s:10:\"2022-09-02\";i:47;s:10:\"2022-09-03\";i:15;s:10:\"2022-09-04\";i:11;s:10:\"2022-09-05\";i:8;s:10:\"2022-09-06\";i:10;s:10:\"2022-09-07\";i:24;s:10:\"2022-09-08\";i:19;s:10:\"2022-09-09\";i:30;s:10:\"2022-09-10\";i:107;s:10:\"2022-09-11\";i:82;s:10:\"2022-09-12\";i:46;s:10:\"2022-09-13\";i:90;s:10:\"2022-09-14\";i:47;s:10:\"2022-09-15\";i:44;s:10:\"2022-09-16\";i:121;s:10:\"2022-09-17\";i:54;s:10:\"2022-09-18\";i:31;s:10:\"2022-09-19\";i:166;s:10:\"2022-09-20\";i:216;s:10:\"2022-09-21\";i:82;s:10:\"2022-09-22\";i:24;s:10:\"2022-09-23\";i:41;s:10:\"2022-09-24\";i:23;s:10:\"2022-09-25\";i:40;s:10:\"2022-09-26\";i:35;s:10:\"2022-09-27\";i:37;s:10:\"2022-09-28\";i:72;s:10:\"2022-09-29\";i:45;s:10:\"2022-09-30\";i:26;s:10:\"2022-10-01\";i:42;s:10:\"2022-10-02\";i:73;s:10:\"2022-10-03\";i:110;s:10:\"2022-10-04\";i:41;s:10:\"2022-10-05\";i:45;s:10:\"2022-10-06\";i:31;s:10:\"2022-10-07\";i:99;s:10:\"2022-10-08\";i:71;s:10:\"2022-10-09\";i:28;s:10:\"2022-10-10\";i:48;s:10:\"2022-10-11\";i:96;s:10:\"2022-10-12\";i:53;s:10:\"2022-10-13\";i:73;s:10:\"2022-10-14\";i:43;s:10:\"2022-10-15\";i:51;s:10:\"2022-10-16\";i:36;s:10:\"2022-10-17\";i:91;s:10:\"2022-10-18\";i:91;s:10:\"2022-10-19\";i:135;s:10:\"2022-10-20\";i:101;s:10:\"2022-10-21\";i:36;s:10:\"2022-10-22\";i:30;s:10:\"2022-10-23\";i:67;s:10:\"2022-10-24\";i:53;s:10:\"2022-10-25\";i:40;s:10:\"2022-10-26\";i:78;s:10:\"2022-10-27\";i:40;s:10:\"2022-10-28\";i:38;s:10:\"2022-10-29\";i:72;s:10:\"2022-10-30\";i:96;s:10:\"2022-10-31\";i:215;s:10:\"2022-11-01\";i:82;s:10:\"2022-11-02\";i:144;s:10:\"2022-11-03\";i:35;s:10:\"2022-11-04\";i:54;s:10:\"2022-11-05\";i:31;s:10:\"2022-11-06\";i:134;s:10:\"2022-11-07\";i:120;s:10:\"2022-11-08\";i:40;s:10:\"2022-11-09\";i:40;s:10:\"2022-11-10\";i:34;s:10:\"2022-11-11\";i:34;s:10:\"2022-11-12\";i:34;s:10:\"2022-11-13\";i:46;s:10:\"2022-11-14\";i:46;s:10:\"2022-11-15\";i:44;s:10:\"2022-11-16\";i:46;s:10:\"2022-11-17\";i:36;s:10:\"2022-11-18\";i:49;s:10:\"2022-11-19\";i:106;s:10:\"2022-11-20\";i:71;s:10:\"2022-11-21\";i:48;s:10:\"2022-11-22\";i:51;s:10:\"2022-11-23\";i:93;s:10:\"2022-11-24\";i:23;s:10:\"2022-11-25\";i:28;s:10:\"2022-11-26\";i:33;s:10:\"2022-11-27\";i:27;s:10:\"2022-11-28\";i:28;s:10:\"2022-11-29\";i:41;s:10:\"2022-11-30\";i:43;s:10:\"2022-12-01\";i:25;s:10:\"2022-12-02\";i:300;s:10:\"2022-12-03\";i:135;s:10:\"2022-12-04\";i:35;s:10:\"2022-12-05\";i:109;s:10:\"2022-12-06\";i:34;s:10:\"2022-12-07\";i:25;s:10:\"2022-12-08\";i:27;s:10:\"2022-12-09\";i:42;s:10:\"2022-12-10\";i:28;s:10:\"2022-12-11\";i:18;s:10:\"2022-12-12\";i:32;s:10:\"2022-12-13\";i:23;s:10:\"2022-12-14\";i:26;s:10:\"2022-12-15\";i:29;s:10:\"2022-12-16\";i:38;s:10:\"2022-12-17\";i:125;s:10:\"2022-12-18\";i:12;s:10:\"2022-12-19\";i:31;s:10:\"2022-12-20\";i:101;s:10:\"2022-12-21\";i:21;s:10:\"2022-12-22\";i:28;s:10:\"2022-12-23\";i:35;s:10:\"2022-12-24\";i:45;s:10:\"2022-12-25\";i:113;s:10:\"2022-12-26\";i:13;s:10:\"2022-12-27\";i:17;s:10:\"2022-12-28\";i:27;s:10:\"2022-12-29\";i:42;s:10:\"2022-12-30\";i:32;s:10:\"2022-12-31\";i:134;s:10:\"2023-01-01\";i:37;s:10:\"2023-01-02\";i:31;s:10:\"2023-01-03\";i:114;s:10:\"2023-01-04\";i:36;s:10:\"2023-01-05\";i:29;s:10:\"2023-01-06\";i:161;s:10:\"2023-01-07\";i:73;s:10:\"2023-01-08\";i:122;s:10:\"2023-01-09\";i:40;s:10:\"2023-01-10\";i:23;s:10:\"2023-01-11\";i:17;s:10:\"2023-01-12\";i:77;s:10:\"2023-01-13\";i:50;s:10:\"2023-01-14\";i:49;s:10:\"2023-01-15\";i:56;s:10:\"2023-01-16\";i:28;s:10:\"2023-01-17\";i:41;s:10:\"2023-01-18\";i:35;s:10:\"2023-01-19\";i:37;s:10:\"2023-01-20\";i:363;s:10:\"2023-01-21\";i:41;s:10:\"2023-01-22\";i:37;s:10:\"2023-01-23\";i:37;s:10:\"2023-01-24\";i:43;s:10:\"2023-01-25\";i:57;s:10:\"2023-01-26\";i:29;s:10:\"2023-01-27\";i:26;s:10:\"2023-01-28\";i:85;s:10:\"2023-01-29\";i:69;s:10:\"2023-01-30\";i:70;s:10:\"2023-01-31\";i:33;s:10:\"2023-02-01\";i:53;s:10:\"2023-02-02\";i:32;s:10:\"2023-02-03\";i:58;s:10:\"2023-02-04\";i:33;s:10:\"2023-02-05\";i:31;s:10:\"2023-02-06\";i:56;s:10:\"2023-02-07\";i:34;s:10:\"2023-02-08\";i:19;s:10:\"2023-02-09\";i:20;s:10:\"2023-02-10\";i:16;s:10:\"2023-02-11\";i:44;s:10:\"2023-02-12\";i:23;s:10:\"2023-02-13\";i:46;s:10:\"2023-02-14\";i:38;s:10:\"2023-02-15\";i:52;s:10:\"2023-02-16\";i:27;s:10:\"2023-02-17\";i:39;s:10:\"2023-02-18\";i:118;s:10:\"2023-02-19\";i:20;s:10:\"2023-02-20\";i:22;s:10:\"2023-02-21\";i:19;s:10:\"2023-02-22\";i:17;s:10:\"2023-02-23\";i:152;s:10:\"2023-02-24\";i:118;s:10:\"2023-02-25\";i:29;s:10:\"2023-02-26\";i:93;s:10:\"2023-02-27\";i:203;s:10:\"2023-02-28\";i:123;s:10:\"2023-03-01\";i:24;s:10:\"2023-03-02\";i:35;s:10:\"2023-03-03\";i:28;s:10:\"2023-03-04\";i:17;s:10:\"2023-03-05\";i:21;s:10:\"2023-03-06\";i:30;s:10:\"2023-03-07\";i:25;s:10:\"2023-03-08\";i:25;s:10:\"2023-03-09\";i:15;s:10:\"2023-03-10\";i:20;s:10:\"2023-03-11\";i:27;s:10:\"2023-03-12\";i:18;s:10:\"2023-03-13\";i:81;s:10:\"2023-03-14\";i:208;s:10:\"2023-03-15\";i:16;s:10:\"2023-03-16\";i:22;s:10:\"2023-03-17\";i:28;s:10:\"2023-03-18\";i:14;s:10:\"2023-03-19\";i:8;s:10:\"2023-03-20\";i:120;s:10:\"2023-03-21\";i:21;s:10:\"2023-03-22\";i:170;s:10:\"2023-03-23\";i:30;s:10:\"2023-03-24\";i:44;s:10:\"2023-03-25\";i:43;s:10:\"2023-03-26\";i:35;s:10:\"2023-03-27\";i:19;s:10:\"2023-03-28\";i:30;s:10:\"2023-03-29\";i:18;s:10:\"2023-03-30\";i:42;s:10:\"2023-03-31\";i:45;s:10:\"2023-04-01\";i:43;s:10:\"2023-04-02\";i:38;s:10:\"2023-04-03\";i:24;s:10:\"2023-04-04\";i:41;s:10:\"2023-04-05\";i:68;s:10:\"2023-04-06\";i:93;s:10:\"2023-04-07\";i:216;s:10:\"2023-04-08\";i:42;s:10:\"2023-04-09\";i:44;s:10:\"2023-04-10\";i:76;s:10:\"2023-04-11\";i:33;s:10:\"2023-04-12\";i:36;s:10:\"2023-04-13\";i:23;s:10:\"2023-04-14\";i:38;s:10:\"2023-04-15\";i:35;s:10:\"2023-04-16\";i:30;s:10:\"2023-04-17\";i:45;s:10:\"2023-04-18\";i:29;s:10:\"2023-04-19\";i:62;s:10:\"2023-04-20\";i:45;s:10:\"2023-04-21\";i:52;s:10:\"2023-04-22\";i:13;s:10:\"2023-04-23\";i:34;s:10:\"2023-04-24\";i:39;s:10:\"2023-04-25\";i:33;s:10:\"2023-04-26\";i:139;s:10:\"2023-04-27\";i:18;s:10:\"2023-04-28\";i:59;s:10:\"2023-04-29\";i:31;s:10:\"2023-04-30\";i:28;s:10:\"2023-05-01\";i:51;s:10:\"2023-05-02\";i:62;s:10:\"2023-05-03\";i:37;s:10:\"2023-05-04\";i:32;s:10:\"2023-05-05\";i:31;s:10:\"2023-05-06\";i:63;s:10:\"2023-05-07\";i:27;s:10:\"2023-05-08\";i:20;s:10:\"2023-05-09\";i:36;s:10:\"2023-05-10\";i:140;s:10:\"2023-05-11\";i:40;s:10:\"2023-05-12\";i:30;s:10:\"2023-05-13\";i:68;s:10:\"2023-05-14\";i:187;s:10:\"2023-05-15\";i:76;s:10:\"2023-05-16\";i:85;s:10:\"2023-05-17\";i:31;s:10:\"2023-05-18\";i:35;s:10:\"2023-05-19\";i:65;s:10:\"2023-05-20\";i:79;s:10:\"2023-05-21\";i:15;s:10:\"2023-05-22\";i:32;s:10:\"2023-05-23\";i:42;s:10:\"2023-05-24\";i:43;s:10:\"2023-05-25\";i:32;s:10:\"2023-05-26\";i:25;s:10:\"2023-05-27\";i:41;s:10:\"2023-05-28\";i:24;s:10:\"2023-05-29\";i:51;s:10:\"2023-05-30\";i:15;s:10:\"2023-05-31\";i:28;s:10:\"2023-06-01\";i:85;s:10:\"2023-06-02\";i:23;s:10:\"2023-06-03\";i:22;s:10:\"2023-06-04\";i:26;s:10:\"2023-06-05\";i:36;s:10:\"2023-06-06\";i:14;s:10:\"2023-06-07\";i:85;s:10:\"2023-06-08\";i:36;s:10:\"2023-06-09\";i:40;s:10:\"2023-06-10\";i:30;s:10:\"2023-06-11\";i:105;s:10:\"2023-06-12\";i:281;s:10:\"2023-06-13\";i:69;s:10:\"2023-06-14\";i:20;s:10:\"2023-06-15\";i:25;s:10:\"2023-06-16\";i:90;s:10:\"2023-06-17\";i:102;s:10:\"2023-06-18\";i:200;s:10:\"2023-06-19\";i:104;s:10:\"2023-06-20\";i:33;s:10:\"2023-06-21\";i:73;s:10:\"2023-06-22\";i:25;s:10:\"2023-06-23\";i:45;s:10:\"2023-06-24\";i:87;s:10:\"2023-06-25\";i:90;s:10:\"2023-06-26\";i:154;s:10:\"2023-06-27\";i:65;s:10:\"2023-06-28\";i:137;s:10:\"2023-06-29\";i:26;s:10:\"2023-06-30\";i:22;s:10:\"2023-07-01\";i:27;s:10:\"2023-07-02\";i:68;s:10:\"2023-07-03\";i:326;s:10:\"2023-07-04\";i:186;s:10:\"2023-07-05\";i:27;s:10:\"2023-07-06\";i:46;s:10:\"2023-07-07\";i:106;s:10:\"2023-07-08\";i:38;s:10:\"2023-07-09\";i:176;s:10:\"2023-07-10\";i:89;s:10:\"2023-07-11\";i:115;s:10:\"2023-07-12\";i:61;s:10:\"2023-07-13\";i:46;s:10:\"2023-07-14\";i:40;s:10:\"2023-07-15\";i:47;s:10:\"2023-07-16\";i:43;s:10:\"2023-07-17\";i:24;s:10:\"2023-07-18\";i:76;s:10:\"2023-07-19\";i:280;s:10:\"2023-07-20\";i:53;s:10:\"2023-07-21\";i:34;s:10:\"2023-07-22\";i:64;s:10:\"2023-07-23\";i:256;s:10:\"2023-07-24\";i:31;s:10:\"2023-07-25\";i:69;s:10:\"2023-07-26\";i:89;s:10:\"2023-07-27\";i:34;s:10:\"2023-07-28\";i:33;s:10:\"2023-07-29\";i:39;s:10:\"2023-07-30\";i:301;s:10:\"2023-07-31\";i:80;s:10:\"2023-08-01\";i:65;s:10:\"2023-08-02\";i:42;s:10:\"2023-08-03\";i:99;s:10:\"2023-08-04\";i:70;s:10:\"2023-08-05\";i:70;s:10:\"2023-08-06\";i:136;s:10:\"2023-08-07\";i:271;s:10:\"2023-08-08\";i:451;s:10:\"2023-08-09\";i:162;s:10:\"2023-08-10\";i:50;s:10:\"2023-08-11\";i:62;s:10:\"2023-08-12\";i:44;s:10:\"2023-08-13\";i:27;s:10:\"2023-08-14\";i:324;s:10:\"2023-08-15\";i:31;s:10:\"2023-08-16\";i:77;s:10:\"2023-08-17\";i:217;s:10:\"2023-08-18\";i:53;s:10:\"2023-08-19\";i:130;s:10:\"2023-08-20\";i:82;s:10:\"2023-08-21\";i:44;s:10:\"2023-08-22\";i:82;s:10:\"2023-08-23\";i:264;s:10:\"2023-08-24\";i:475;s:10:\"2023-08-25\";i:24;s:10:\"2023-08-26\";i:197;s:10:\"2023-08-27\";i:133;s:10:\"2023-08-28\";i:46;s:10:\"2023-08-29\";i:24;s:10:\"2023-08-30\";i:44;s:10:\"2023-08-31\";i:54;s:10:\"2023-09-01\";i:101;s:10:\"2023-09-02\";i:210;s:10:\"2023-09-03\";i:132;s:10:\"2023-09-04\";i:117;s:10:\"2023-09-05\";i:114;s:10:\"2023-09-06\";i:228;s:10:\"2023-09-07\";i:68;s:10:\"2023-09-08\";i:418;s:10:\"2023-09-09\";i:524;s:10:\"2023-09-10\";i:51;s:10:\"2023-09-11\";i:547;s:10:\"2023-09-12\";i:75;s:10:\"2023-09-13\";i:261;s:10:\"2023-09-14\";i:152;s:10:\"2023-09-15\";i:263;s:10:\"2023-09-16\";i:56;s:10:\"2023-09-17\";i:44;s:10:\"2023-09-18\";i:79;s:10:\"2023-09-19\";i:47;s:10:\"2023-09-20\";i:52;s:10:\"2023-09-21\";i:30;s:10:\"2023-09-22\";i:37;s:10:\"2023-09-23\";i:64;s:10:\"2023-09-24\";i:182;s:10:\"2023-09-25\";i:24;s:10:\"2023-09-26\";i:34;s:10:\"2023-09-27\";i:97;s:10:\"2023-09-28\";i:26;s:10:\"2023-09-29\";i:32;s:10:\"2023-09-30\";i:71;s:10:\"2023-10-01\";i:36;s:10:\"2023-10-02\";i:15;s:10:\"2023-10-03\";i:243;s:10:\"2023-10-04\";i:88;s:10:\"2023-10-05\";i:42;s:10:\"2023-10-06\";i:101;s:10:\"2023-10-07\";i:21;s:10:\"2023-10-08\";i:40;s:10:\"2023-10-09\";i:11;s:10:\"2023-10-10\";i:174;s:10:\"2023-10-11\";i:508;s:10:\"2023-10-12\";i:23;s:10:\"2023-10-13\";i:57;s:10:\"2023-10-14\";i:23;s:10:\"2023-10-15\";i:62;s:10:\"2023-10-16\";i:28;s:10:\"2023-10-17\";i:70;s:10:\"2023-10-18\";i:29;s:10:\"2023-10-19\";i:52;s:10:\"2023-10-20\";i:50;s:10:\"2023-10-21\";i:20;s:10:\"2023-10-22\";i:33;s:10:\"2023-10-23\";i:82;s:10:\"2023-10-24\";i:50;s:10:\"2023-10-25\";i:600;s:10:\"2023-10-26\";i:32;s:10:\"2023-10-27\";i:60;s:10:\"2023-10-28\";i:28;s:10:\"2023-10-29\";i:48;s:10:\"2023-10-30\";i:85;s:10:\"2023-10-31\";i:182;s:10:\"2023-11-01\";i:85;s:10:\"2023-11-02\";i:80;s:10:\"2023-11-03\";i:56;s:10:\"2023-11-04\";i:275;s:10:\"2023-11-05\";i:98;s:10:\"2023-11-06\";i:49;s:10:\"2023-11-07\";i:109;s:10:\"2023-11-08\";i:166;s:10:\"2023-11-09\";i:82;s:10:\"2023-11-10\";i:138;s:10:\"2023-11-11\";i:62;s:10:\"2023-11-12\";i:49;s:10:\"2023-11-13\";i:49;s:10:\"2023-11-14\";i:69;s:10:\"2023-11-15\";i:34;s:10:\"2023-11-16\";i:59;s:10:\"2023-11-17\";i:78;s:10:\"2023-11-18\";i:48;s:10:\"2023-11-19\";i:108;s:10:\"2023-11-20\";i:40;s:10:\"2023-11-21\";i:33;s:10:\"2023-11-22\";i:301;s:10:\"2023-11-23\";i:286;s:10:\"2023-11-24\";i:44;s:10:\"2023-11-25\";i:370;s:10:\"2023-11-26\";i:196;s:10:\"2023-11-27\";i:66;s:10:\"2023-11-28\";i:175;s:10:\"2023-11-29\";i:342;s:10:\"2023-11-30\";i:273;s:10:\"2023-12-01\";i:36;s:10:\"2023-12-02\";i:82;s:10:\"2023-12-03\";i:98;s:10:\"2023-12-04\";i:30;s:10:\"2023-12-05\";i:34;s:10:\"2023-12-06\";i:32;s:10:\"2023-12-07\";i:32;s:10:\"2023-12-08\";i:47;s:10:\"2023-12-09\";i:26;s:10:\"2023-12-10\";i:70;s:10:\"2023-12-11\";i:185;s:10:\"2023-12-12\";i:73;s:10:\"2023-12-13\";i:184;s:10:\"2023-12-14\";i:216;s:10:\"2023-12-15\";i:41;s:10:\"2023-12-16\";i:22;s:10:\"2023-12-17\";i:179;s:10:\"2023-12-18\";i:182;s:10:\"2023-12-19\";i:83;s:10:\"2023-12-20\";i:46;s:10:\"2023-12-21\";i:68;s:10:\"2023-12-22\";i:36;s:10:\"2023-12-23\";i:86;s:10:\"2023-12-24\";i:53;s:10:\"2023-12-25\";i:49;s:10:\"2023-12-26\";i:105;s:10:\"2023-12-27\";i:72;s:10:\"2023-12-28\";i:27;s:10:\"2023-12-29\";i:44;s:10:\"2023-12-30\";i:244;s:10:\"2023-12-31\";i:292;s:10:\"2024-01-01\";i:101;s:10:\"2024-01-02\";i:230;s:10:\"2024-01-03\";i:445;s:10:\"2024-01-04\";i:455;s:10:\"2024-01-05\";i:289;s:10:\"2024-01-06\";i:602;s:10:\"2024-01-07\";i:682;s:10:\"2024-01-08\";i:1578;s:10:\"2024-01-09\";i:73;s:10:\"2024-01-10\";i:48;s:10:\"2024-01-11\";i:634;s:10:\"2024-01-12\";i:52;s:10:\"2024-01-13\";i:76;s:10:\"2024-01-14\";i:1695;s:10:\"2024-01-15\";i:118;s:10:\"2024-01-16\";i:117;s:10:\"2024-01-17\";i:39;s:10:\"2024-01-18\";i:68;s:10:\"2024-01-19\";i:520;s:10:\"2024-01-20\";i:1045;s:10:\"2024-01-21\";i:464;s:10:\"2024-01-22\";i:32;s:10:\"2024-01-23\";i:652;s:10:\"2024-01-24\";i:12;s:10:\"2024-01-25\";i:130;s:10:\"2024-01-26\";i:32;s:10:\"2024-01-27\";i:171;s:10:\"2024-01-28\";i:42;s:10:\"2024-01-29\";i:29;s:10:\"2024-01-30\";i:601;s:10:\"2024-01-31\";i:36;s:10:\"2024-02-01\";i:566;s:10:\"2024-02-02\";i:56;s:10:\"2024-02-03\";i:500;s:10:\"2024-02-04\";i:47;s:10:\"2024-02-05\";i:496;s:10:\"2024-02-06\";i:1018;s:10:\"2024-02-07\";i:34;s:10:\"2024-02-08\";i:489;s:10:\"2024-02-09\";i:63;s:10:\"2024-02-10\";i:875;s:10:\"2024-02-11\";i:943;s:10:\"2024-02-12\";i:218;s:10:\"2024-02-13\";i:922;s:10:\"2024-02-14\";i:1232;s:10:\"2024-02-15\";i:55;s:10:\"2024-02-16\";i:28;s:10:\"2024-02-17\";i:27;s:10:\"2024-02-18\";i:38;s:10:\"2024-02-19\";i:62;s:10:\"2024-02-20\";i:123;s:10:\"2024-02-21\";i:1526;s:10:\"2024-02-22\";i:75;s:10:\"2024-02-23\";i:248;s:10:\"2024-02-24\";i:838;s:10:\"2024-02-25\";i:834;s:10:\"2024-02-26\";i:78;s:10:\"2024-02-27\";i:1762;s:10:\"2024-02-28\";i:116;s:10:\"2024-02-29\";i:203;s:10:\"2024-03-01\";i:134;s:10:\"2024-03-02\";i:61;s:10:\"2024-03-03\";i:82;s:10:\"2024-03-04\";i:119;s:10:\"2024-03-05\";i:36;s:10:\"2024-03-06\";i:52;s:10:\"2024-03-07\";i:23;s:10:\"2024-03-08\";i:166;s:10:\"2024-03-09\";i:318;s:10:\"2024-03-10\";i:195;s:10:\"2024-03-11\";i:389;s:10:\"2024-03-12\";i:337;s:10:\"2024-03-13\";i:26;s:10:\"2024-03-14\";i:91;s:10:\"2024-03-15\";i:28;s:10:\"2024-03-16\";i:759;s:10:\"2024-03-17\";i:1017;s:10:\"2024-03-18\";i:1193;s:10:\"2024-03-19\";i:1280;s:10:\"2024-03-20\";i:42;s:10:\"2024-03-21\";i:521;s:10:\"2024-03-22\";i:878;s:10:\"2024-03-23\";i:1488;s:10:\"2024-03-24\";i:264;s:10:\"2024-03-25\";i:599;s:10:\"2024-03-26\";i:146;s:10:\"2024-03-27\";i:536;s:10:\"2024-03-28\";i:44;s:10:\"2024-03-29\";i:169;s:10:\"2024-03-30\";i:177;s:10:\"2024-03-31\";i:97;s:10:\"2024-04-01\";i:489;s:10:\"2024-04-02\";i:71;s:10:\"2024-04-03\";i:436;s:10:\"2024-04-04\";i:140;s:10:\"2024-04-05\";i:554;s:10:\"2024-04-06\";i:228;s:10:\"2024-04-07\";i:1;}}","yes"),
("1016","widget_block","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("1022","auto_core_update_notified","a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:19:\"gen@pmoadvisory.com\";s:7:\"version\";s:3:\"6.5\";s:9:\"timestamp\";i:1712132670;}","no"),
("4873","wp_force_deactivated_plugins","a:0:{}","yes"),
("4874","db_upgraded","","yes"),
("8410","user_count","1","no"),
("19964","wp_attachment_pages_enabled","1","yes"),
("24359","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:57:\"https://downloads.wordpress.org/release/wordpress-6.5.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:57:\"https://downloads.wordpress.org/release/wordpress-6.5.zip\";s:10:\"no_content\";s:68:\"https://downloads.wordpress.org/release/wordpress-6.5-no-content.zip\";s:11:\"new_bundled\";s:69:\"https://downloads.wordpress.org/release/wordpress-6.5-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:3:\"6.5\";s:7:\"version\";s:3:\"6.5\";s:11:\"php_version\";s:5:\"7.0.0\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.4\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1712448708;s:15:\"version_checked\";s:3:\"6.5\";s:12:\"translations\";a:0:{}}","no"),
("24449","_site_transient_update_themes","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1712448709;s:7:\"checked\";a:5:{s:4:\"Divi\";s:5:\"4.9.7\";s:16:\"twentytwentyfour\";s:3:\"1.0\";s:15:\"twentytwentyone\";s:3:\"1.3\";s:17:\"twentytwentythree\";s:3:\"1.0\";s:15:\"twentytwentytwo\";s:3:\"1.0\";}s:8:\"response\";a:5:{s:16:\"twentytwentyfour\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfour\";s:11:\"new_version\";s:3:\"1.1\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfour/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfour.1.1.zip\";s:8:\"requires\";s:3:\"6.4\";s:12:\"requires_php\";s:3:\"7.0\";}s:15:\"twentytwentyone\";a:6:{s:5:\"theme\";s:15:\"twentytwentyone\";s:11:\"new_version\";s:3:\"2.2\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentyone/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentyone.2.2.zip\";s:8:\"requires\";s:3:\"5.3\";s:12:\"requires_php\";s:3:\"5.6\";}s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.4\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.4.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}s:15:\"twentytwentytwo\";a:6:{s:5:\"theme\";s:15:\"twentytwentytwo\";s:11:\"new_version\";s:3:\"1.7\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentytwo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentytwo.1.7.zip\";s:8:\"requires\";s:3:\"5.9\";s:12:\"requires_php\";s:3:\"5.6\";}s:4:\"Divi\";a:4:{s:11:\"new_version\";s:6:\"4.24.3\";s:5:\"theme\";s:4:\"Divi\";s:3:\"url\";s:52:\"https://www.elegantthemes.com/api/changelog/divi.txt\";s:7:\"package\";s:145:\"https://www.elegantthemes.com/api/api_downloads.php?api_update=1&theme=Divi&api_key=71e3498732a9076747f8403ee4b8ba109c00b790&username=pmoadvisory\";}}s:9:\"no_update\";a:0:{}s:12:\"translations\";a:0:{}}","no"),
("24450","_site_transient_et_update_themes","O:8:\"stdClass\":3:{s:7:\"checked\";a:5:{s:4:\"Divi\";s:5:\"4.9.7\";s:16:\"twentytwentyfour\";s:3:\"1.0\";s:15:\"twentytwentyone\";s:3:\"1.3\";s:17:\"twentytwentythree\";s:3:\"1.0\";s:15:\"twentytwentytwo\";s:3:\"1.0\";}s:8:\"response\";a:1:{s:4:\"Divi\";a:4:{s:11:\"new_version\";s:6:\"4.24.3\";s:5:\"theme\";s:4:\"Divi\";s:3:\"url\";s:52:\"https://www.elegantthemes.com/api/changelog/divi.txt\";s:7:\"package\";s:145:\"https://www.elegantthemes.com/api/api_downloads.php?api_update=1&theme=Divi&api_key=71e3498732a9076747f8403ee4b8ba109c00b790&username=pmoadvisory\";}}s:12:\"last_checked\";i:1712448707;}","no"),
("24461","_site_transient_timeout_browser_5e705226acd7a97aa6ee95ab188632d6","1713043880","no"),
("24462","_site_transient_browser_5e705226acd7a97aa6ee95ab188632d6","a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"123.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","no"),
("24463","_site_transient_timeout_php_check_990bfacb848fa087bcfc06850f5e4447","1713043880","no"),
("24464","_site_transient_php_check_990bfacb848fa087bcfc06850f5e4447","a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:3:\"7.0\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}","no"),
("24465","_site_transient_timeout_community-events-89f921ee2a4b64a5d09fffe0217394bc","1712482282","no"),
("24466","_site_transient_community-events-89f921ee2a4b64a5d09fffe0217394bc","a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:11:\"186.84.22.0\";}s:6:\"events\";a:1:{i:0;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:49:\"¿De qué tamaño subo mis imágenes a WordPress?\";s:3:\"url\";s:63:\"https://www.meetup.com/bogota-wordpress-meetup/events/300012455\";s:6:\"meetup\";s:24:\"Bogotá WordPress Meetup\";s:10:\"meetup_url\";s:47:\"https://www.meetup.com/Bogota-WordPress-Meetup/\";s:4:\"date\";s:19:\"2024-05-02 18:00:00\";s:8:\"end_date\";s:19:\"2024-05-02 20:00:00\";s:20:\"start_unix_timestamp\";i:1714690800;s:18:\"end_unix_timestamp\";i:1714698000;s:8:\"location\";a:4:{s:8:\"location\";s:17:\"Bogotá, Colombia\";s:7:\"country\";s:2:\"co\";s:8:\"latitude\";d:4.6761239999999997252189132268540561199188232421875;s:9:\"longitude\";d:-74.049890000000004874891601502895355224609375;}}}}","no"),
("24467","_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3","1712482283","no"),
("24468","_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"The latest news about WordPress and the WordPress community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Apr 2024 20:18:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.6-alpha-57934\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:61:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WP Briefing: Episode 76: A WordPress 6.5 Sneak Peek\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wordpress.org/news/2024/04/episode-76-a-wordpress-6-5-sneak-peek/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Apr 2024 20:18:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=17158\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:276:\"Join WordPress Executive Director, Josepha Haden Chomphosy, as she offers an exclusive preview of the upcoming WordPress 6.5 release, accompanied by special guest Dave Smith, one of the Editor Tech leads for this release. Don’t miss this opportunity for an insider’s look!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:51:\"https://wordpress.org/news/files/2024/04/WPB076.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:40466:\"\n<p>Join WordPress Executive Director, Josepha Haden Chomphosy, as she offers an exclusive preview of the upcoming WordPress 6.5 release, accompanied by special guest Dave Smith, one of the Editor Tech leads for this release. Don&#8217;t miss this opportunity for an insider&#8217;s look!</p>\n\n\n\n<h2 class=\"wp-block-heading\">Credits</h2>\n\n\n\n<p>Host:&nbsp;<a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden Chomphosy</a><br>Guest:&nbsp;<a href=\"https://profiles.wordpress.org/mikachan/\">Dave Smith</a><br>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a><br>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a><br>Production:&nbsp;<a href=\"https://profiles.wordpress.org/bjmcsherry/\">Brett McSherry</a> and <a href=\"https://profiles.wordpress.org/eidolonnight/\">Nicholas Garofalo</a><br>Song: Fearless First by Kevin MacLeod</p>\n\n\n\n<h2 class=\"wp-block-heading\">Show Notes</h2>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.org/download/\">WordPress Download</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/6-5/#:~:text=To%20get%20involved%20in%20WordPress,leave%20feedback%20on%20the%20ticket.\">WordPress 6.5 Development Cycle</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/03/07/unblocking-wp6-5-font-library-and-synced-pattern-overrides/\">Unblocking WP6.5 – Font Library and Synced Pattern Overrides</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/block-editor/reference-guides/packages/packages-dataviews/\">Data Views</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/07/12/admin-design/\">WP-Admin Redesign</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/ticket/59166\">Font Library</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2024/02/29/an-introduction-to-block-based-mega-menus/\">An Introduction to Block-Based Mega Menus</a></li>\n\n\n\n<li><a href=\"https://www.youtube.com/daveonwp\">Dave on WP</a>\n<ul>\n<li><a href=\"https://www.youtube.com/watch?v=ySyJRYAbU_M\">These TINY Link Editing CHANGES Just Made WORDPRESS 6.5 So Much Better</a></li>\n</ul>\n</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/03/04/interactivity-api-dev-note/\">Interactivity API in 6.5</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2024/01/13/early-opportunities-to-test-wordpress-6-5/\">Opportunities to Test WordPress 6.5</a></li>\n\n\n\n<li><strong>Small List of Big Things</strong>\n<ul>\n<li><a href=\"https://make.wordpress.org/community/2024/03/08/asia-meetup-revival-project-2024/\" target=\"_blank\" rel=\"noreferrer noopener\">Asia Meetup Revival Project 2024</a> </li>\n\n\n\n<li><a href=\"https://make.wordpress.org/meetings/\" target=\"_blank\" rel=\"noreferrer noopener\">Upcoming WordPress Meetings</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/marketing/2024/03/20/making-a-wordpress-media-corps/\" target=\"_blank\" rel=\"noreferrer noopener\">Making a WordPress Media Corps</a></li>\n</ul>\n</li>\n\n\n\n<li>Have a question you’d like answered? Submit them to <a href=\"mailto:wpbriefing@WordPress.org\">WPBriefing@WordPress.org</a>.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Transcript</h2>\n\n\n\n<span id=\"more-17158\"></span>\n\n\n\n<p>[00:00:00] <strong>Josepha:</strong> Hello, everyone, and welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks.</p>\n\n\n\n<p>I&#8217;m your host, Josepha Haden Chomphosy. Here we go!&nbsp;</p>\n\n\n\n<p>[00:00:28] (Intro Music)&nbsp;</p>\n\n\n\n<p>[00:00:39] <strong>Josepha:</strong> Dave, I&#8217;m so excited to have you here with us today. Welcome.</p>\n\n\n\n<p>[00:00:42] <strong>Dave:</strong> Thank you. I&#8217;m really excited to be here. Thank you so much for inviting me on.</p>\n\n\n\n<p>[00:00:46] <strong>Josepha:</strong> Yeah. So before we get much further, how about you tell us a little bit about what you do on the WordPress project? And if I recall correctly, that you have a role on the release squad. So just let us know a bit about what that role is and what that looks like.</p>\n\n\n\n<p>[00:01:00] <strong>Dave:</strong> Sure. Absolutely. Well, obviously said I&#8217;m Dave Smith. I&#8217;m from England in the United Kingdom, and I am full-time contributor to WordPress. I&#8217;ve focused primarily on the Block Editor during that time. And I&#8217;ve been doing it for about three years now. And fortunately for me, I am sponsored by Automattic, so that allows me to contribute full-time to the project, which is fantastic.</p>\n\n\n\n<p>But my history of WordPress goes back a fair way longer than that, and I used to work in agency land, and so I used WordPress for making things for a living before I worked in WordPress if you see what I mean.&nbsp;</p>\n\n\n\n<p>[00:01:35] <strong>Josepha:</strong> I, no, I definitely understand. I also was agency before WordPress.&nbsp;</p>\n\n\n\n<p>[00:01:40] <strong>Dave:</strong> I think it&#8217;s a common origin story, if you see what I mean. And yes, you&#8217;re absolutely right. I&#8217;ve been fortunate enough in this release, WordPress 6.5, to be the Co-editor Tech Lead. Obviously alongside my colleague which is Riad Benguella. Some of you may know him. He is the lead architect of Gutenberg. So yeah, it&#8217;s been fantastic to work alongside him.</p>\n\n\n\n<p>[00:02:00] <strong>Josepha:</strong> Yeah, excellent. One of these days, I&#8217;m going to get Riad on here. I think I&#8217;ve never had him on.</p>\n\n\n\n<p>[00:02:05] <strong>Dave:</strong> Oh, you should definitely.&nbsp;</p>\n\n\n\n<p>[00:02:06] <strong>Josepha:</strong> He&#8217;s so kind and reasonable. And I was just gonna tell a personal anecdote about Riad, and I don&#8217;t know that it makes any sense, but I&#8217;m gonna do it anyway. I&#8217;m gonna do it anyway. I saw him at an event like right after he came back from his most recent sabbatical, and he was like, it was great being away, but also like, I had forgotten what kind of energy events like this really bring in.</p>\n\n\n\n<p>And he has always struck me as an introvert, but I think maybe he&#8217;s like an outgoing introvert or something. Cause normally, like, introvert introverts are not like, this gives me so much energy. They&#8217;re like, I know that this is important work, and I&#8217;m here. And so that&#8217;s my personal anecdote about Riad, I am, gonna get him on here someday, but be that as it may, we&#8217;re delighted to have you.</p>\n\n\n\n<p>So, 6.5 is coming out are you excited, number one?</p>\n\n\n\n<p>[00:02:54] <strong>Dave:</strong> I am very excited. Yeah, it&#8217;s been a long road into this release. As you may know, well, as you do know, it&#8217;s, it was delayed by one week. That was actually, I think was, was a good decision. We&#8217;ve had a lot of work needing to go into the Font Library feature. I&#8217;ve seen a few posts saying there were bugs.</p>\n\n\n\n<p>[00:03:09] <strong>Dave:</strong> I think mainly it was a decision about where to upload fonts to, which seems quite amazing when you think about it. I was talking to my wife about it the other day, and she said, really, you&#8217;re delaying a release because of where to upload things. But, yeah, this is software that runs a considerable part of the web.</p>\n\n\n\n<p>So when we make these decisions about where things uploaded, we&#8217;ve got to be really confident that they are the right decisions. And so, yeah, that decision to delay the release has been good. And we&#8217;ve had an opportunity to make sure the release is fully robust and ready to go out. So yeah, I&#8217;m super excited to see it land.</p>\n\n\n\n<p>[00:03:40] <strong>Josepha:</strong> Yeah. I have some follow up questions about just like, how doing all of that work in public feels. But probably, we should get through the bulk of the sorts of things that people tune into this episode for, so like, let&#8217;s talk about some of the big features that are going into 6.5 so that folks have a sense for that.</p>\n\n\n\n<p>And then we&#8217;ll take a look at just like things that you&#8217;re excited to get in, things that I&#8217;m excited to get in. And maybe like if there&#8217;s a hidden surprise for users, things that will be really beneficial to users, but they don&#8217;t quite see it yet. We can maybe cover that too, but like, what are the big things going into this release from your perspective?</p>\n\n\n\n<p>[00:04:17] <strong>Dave:</strong> Sure. There&#8217;s some highlights, I think that the key highlights, and we should probably cover them. So the first one we&#8217;ve already touched on it is the Fonts Library. And this has been brewing for a while now, and it&#8217;s finally come to fruition. And it basically allows you to manage, install, and upload custom fonts for use on your website. And it&#8217;s really, really powerful. It&#8217;s, I think it&#8217;s going to really change the way people create themes and create their websites. It is unlocking a lot of power for users.</p>\n\n\n\n<p>[00:04:46] <strong>Josepha:</strong> And for folks who&#8217;ve been listening to this podcast for a long time, you have heard me say for, I think, like a year, basically every release podcast where we&#8217;re looking at what&#8217;s coming up. I&#8217;m like, and this time it&#8217;s fonts. I&#8217;m so excited. And so I&#8217;m saying it again this time, &#8217;cause it&#8217;s really happening this time.</p>\n\n\n\n<p>[00:05:03] <strong>Dave:</strong> It&#8217;s finally here. Yeah, it&#8217;s a great feature. There&#8217;s a lot of work gone into it. It&#8217;s really, really good.</p>\n\n\n\n<p>[00:05:07] <strong>Josepha:</strong> So much work. We&#8217;ve been working on it for like two or three years. And it&#8217;s at the point where like getting it out in front of people is the only way to figure out where the remaining problems will be. And it is the most scary part of any software release, I assume, the things where you&#8217;re like, this is time for people to tell us how it&#8217;s broken. Please look at it and break it for a while.</p>\n\n\n\n<p>[00:05:29] <strong>Dave:</strong> Yeah, absolutely. We&#8217;ve been working on resolving any bugs that we could find, but there&#8217;s always going to be things we haven&#8217;t noticed. So yeah, we can&#8217;t wait for users to get their hands on it. Exactly. Other than fonts, we&#8217;ve also got revisions that are now in place in the Site Editor. And this is more than just undo, redo that people may be already familiar with in the editor.</p>\n\n\n\n<p>It actually gives you the ability to fully revert your site back to any state that you previously had it. So you could make some changes in the editor. You could completely close down your computer, go away for a week, come back. And you&#8217;ve still got the opportunity to say, &#8220;Ah, do you know what? I don&#8217;t like the way that looks. I&#8217;m just gonna; I&#8217;m gonna roll that back.&#8221; And there&#8217;s a nice UI that shows you what it will affect. And you can even roll back styles, you know, like style changes. So it&#8217;s, it&#8217;s super, super powerful. And it&#8217;s just something we&#8217;ve been waiting for for such a long time. Just, it&#8217;s fantastic to see it land.</p>\n\n\n\n<p>[00:06:17] <strong>Josepha:</strong> I&#8217;m really excited about this one personally because I have been to so many meetup events with like new users being taught how to do things with WordPress. And invariably, in the last two or three years, the people who are presenting to new users are saying consistently like, &#8220;You can do any experimental thing that you feel like you need to do with your sites because there&#8217;s an undo button. WordPress wouldn&#8217;t let you do things that fully break your site.&#8221;</p>\n\n\n\n<p>Like there is a lot of trust in our kind of like time machine, roll-it-back kind of implementations. And so I&#8217;m really excited about this one. I think that for all of our new and mid-level users. Who like, have a little bit of fear, but mostly joy around it. Like, this will only increase that and so I&#8217;m super excited for this one to go in there.</p>\n\n\n\n<p>[00:07:09] <strong>Dave:</strong> Yeah, it&#8217;s really nice. Other than that, the two things I wanted to touch on as well, which is we&#8217;ve got these new views now for key objects in WordPress. So things like pages, patterns, templates, and template parts in the Site Editor. You can now view these in a sort of a table layout or in a grid layout. So it gives you a much easier way to sort them, find them, filter them. And I think it points us forward to the possibilities we&#8217;ve got in the future for the editor sort of taking some parts of WP Admin and making them more accessible without having to leave the Site Editor. And it&#8217;s extremely powerful; you can search in real-time, find things very, very quickly, do all the things you&#8217;re used to from the post listing screen, but all within the Site Editor. And it&#8217;s for these key objects that you use quite a lot of the time. So I think it&#8217;s going to be really, a really great thing for users to get hold of.</p>\n\n\n\n<p>[00:07:55] <strong>Josepha:</strong> Is this related to the Data Views work that we&#8217;ve been doing in the first part of the year here?</p>\n\n\n\n<p>[00:08:00] <strong>Dave:</strong> Exactly that exactly. The Data Views work has been a major feed into this, and this is where we see the fruits of all that work coming to the fore for the first time. And I expect to see more of that in future releases as well.</p>\n\n\n\n<p>[00:08:12] <strong>Josepha:</strong> Yeah. For folks who are really, really watching, like, our administrative side of things, you probably are aware that we, I don&#8217;t know, I wouldn&#8217;t say that we paused the phase three roadmap for this, but I do think that we made a clear choice to get this Data Views work done first so that we could, in parallel with phase three, do a bit of work on the WP Admin redesign, the dashboard redesign, which we all know, like, we love this dashboard, but also this dashboard, it needs a sprucing up, it needs a little bit of, of polish and a little bit of 2024 style I was going to say design. I don&#8217;t know if the design folks would love if I just was like, it needs to be modernized that way, but also like it, it does, right?</p>\n\n\n\n<p>[00:09:00] <strong>Dave:</strong> Yeah, and I mean, you know, we all know that the Site Editor is being used more and more. If you&#8217;ve got a Block theme, you&#8217;re using the Site Editor increasingly, and you&#8217;re spending less and less time sort of going between screens in WP Admin. So it makes sense that, you know, these things are accessible within that one interface of the Site Editor. So, yeah, it&#8217;s only going to be a good thing for users going forward.</p>\n\n\n\n<p>[00:09:20] <strong>Josepha:</strong> Yeah, absolutely. I probably should have like a whole episode about Data Views and what it&#8217;s intending to do, what it&#8217;s actually doing, what it&#8217;s going to look like as it goes because that&#8217;s such a big project. And so many things rely on it. And so, note to self and all listeners, that&#8217;s the thing that you should keep an eye out for. We&#8217;re going to get it done. But you said you had a final thing also.</p>\n\n\n\n<p>[00:09:40] <strong>Dave:</strong> Yeah, I&#8217;ve got one more which is this is for our users of classic themes. We haven&#8217;t forgotten about you. Basically, we now have support for appearance tools. So in prior releases, the Block themes have got these really cool design tools like ability to set border colors, border radius, link colors, you name it. We&#8217;ve got all these tools, but they haven&#8217;t been always available to classic themes. And classic themes can use the Block Editor; they may not be using the Site Editor in the same way, but they can use the Block Editor. And we&#8217;ve not made those things available in the same way, but there&#8217;s been work going into this release to allow that to happen.</p>\n\n\n\n<p>[00:10:11] <strong>Dave:</strong> So now you can opt into those if you so wish. And it is an opt-in basis. So none your themes will break out of the box if you&#8217;ve got classic theme or classic site. But it is a powerful tool to those people who are using classic themes, and that&#8217;s completely legitimate.</p>\n\n\n\n<p>[00:10:26] <strong>Josepha:</strong> And so is the opt in like something that you can do for yourself or something that your developer needs to do?</p>\n\n\n\n<p>[00:10:32] <strong>Dave:</strong> You would need to do it in your theme code. So you&#8217;d need to do that with PHP. So, your theme developer, if they choose to update their theme and provide support for these things. Then, they would obviously need to test their theme works with those new tools, make sure it&#8217;s ready, and then they would ship that update.</p>\n\n\n\n<p>And so maybe after 6.5 is released, you may see some themes incrementally adding support. My understanding at the moment is that the core themes, the Block themes, will not automatically add those straight away. I think they need more time to allow them to bed in and more time to get them ready for prime time if you see what I mean, but you know the fact that they&#8217;re there and ready means that the wider theme audience and theme developers can start taking advantage of them.</p>\n\n\n\n<p>[00:11:15] <strong>Josepha:</strong> Nice, nice. I have been wondering lately, this is only marginally related, but I&#8217;m gonna wonder it out loud anyway. I&#8217;ve been wondering lately if like, our classic themes, our most favorite, our most loved classic themes do need a little bit of help moving into a Block theme future. And I think that this will help. I think, on the one hand this will help, and on the other hand, like, what would it take for us to just say, and you&#8217;re not the theme person I know, but like, what would it take for us to just say, &#8220;These are our top five most favorite, most used, classic themes that we&#8217;ve got in WordPress. Let&#8217;s rebuild it in blocks and just ship the block version of it and help the classic themes users that love the design, love the look, love the features get introduced to this new block territory so that they can see that not only do they have the look, the feel, the features, but also the flexibility that comes with that and a little bit more feeling of safety as they wander around modifying themes.&#8221;</p>\n\n\n\n<p>[00:12:18] <strong>Josepha:</strong> I have no fear of any code changes and didn&#8217;t when I started working with WordPress, as opposed to working in WordPress, but I think that that&#8217;s not the way that that works right now. Like there&#8217;s a whole lot of like, I need to get it right-ish with folks who are using our software. And so I just wonder if that will help everybody feel a little more confident in what they&#8217;re doing, knowing they&#8217;re not going to break things because we&#8217;ve built it so you can&#8217;t.</p>\n\n\n\n<p>[00:12:45] <strong>Dave:</strong> It could do, it could do. And I was just thinking as you were talking, like, do we have any themes that already do that? And, of course, we do have 2021. If you can think back that far into the mists of time, we had 2021 classic, which is that it&#8217;s called 2021, but we also 2021 blocks, which is doing very much what you&#8217;ve just described.</p>\n\n\n\n<p>[00:13:03] <strong>Dave:</strong> So we haven&#8217;t pursued that for the new default themes or block themes, but, you know, it might be something to look at for onboarding if there are any of classic themes from the more distant past, you know, maybe some of those could do with a block theme equivalent just to let people on board to that experience and just feel comfortable. Yeah, interesting, interesting. You should definitely talk to the theme people about that.</p>\n\n\n\n<p>[00:13:23] <strong>Josepha:</strong> I&#8217;m going to. They&#8217;re going to love it. They&#8217;re going to be like, Yay! Of course! Of course! I don&#8217;t know, actually. I don&#8217;t know if anyone ever loves the things that I suggest, but that doesn&#8217;t mean that they&#8217;re not going to get suggested. I have all these ideas, and they got to come out somewhere. Okay. So do you have something that you worked on that&#8217;s not in this big list of features or that you helped people to really shepherd into the release that you think is really cool? Like, maybe it&#8217;s not going to be super visible or something, but like that you&#8217;ve personally felt was like a cool feature, excited for it to get into the release.</p>\n\n\n\n<p>[00:13:53] <strong>Dave:</strong> Yeah, there are a couple of things, a couple of things at the top of mind. One of them is user-facing and one of them is more developer-facing features. So, I&#8217;ll start with the developer feature first. And this one is a change to an API. Now, that API is always a slightly intimidating word, I think, but it just means a set of tools, a standardized set of tools that developers can use to do something. And in this case, it&#8217;s the allowed blocks API. </p>\n\n\n\n<p>[00:14:20] <strong>Josepha:</strong> Sounds so fun.&nbsp;</p>\n\n\n\n<p>[00:14:21] <strong>Dave:</strong> Yeah, I know it&#8217;s riveting, isn&#8217;t it? But trust me, it does come with some benefits. So the Navigation block is a good example. It&#8217;s a block that acts as a container and it&#8217;s got child blocks. Okay. But you can only insert certain blocks. You can insert links, you can insert social icons, you can insert search. But if you want to insert, I don&#8217;t know, an Icon block, for example. You can&#8217;t do that, but you can with WordPress 6.5 because of the change to the allow box API. And what it allows you to do is say, &#8220;I want to additionally allow the following blocks to be inserted as well.&#8221;</p>\n\n\n\n<p>So as a developer, you can hook into this filter and change those blocks. Now, okay, so far, so good. &#8220;What&#8217;s the big deal?&#8221; you might say, well, it&#8217;s open the door, is open the door to some very, very interesting explorations. Some of which I&#8217;ve no doubt that you and your listeners would have already encountered. And one is by a colleague of mine called Nick Diego. And I think it&#8217;s on the WordPress Developer blog right now. I think he&#8217;s done a fantastic inspiration into mega menus in the navigation block. I&#8217;m someone who&#8217;s worked on the Navigation block extensively in the past, and I&#8217;m very aware of how much users want mega menus to be a part of the Navigation block.</p>\n\n\n\n<p>[00:15:30] <strong>Dave:</strong> I was never convinced it was going to be something we were going to do in core, because it requires so many different things. But Nick has actually managed with this allow blocks API and some other tweaks as well to build a mega menu as a plugin for WordPress using the standard Navigation block.</p>\n\n\n\n<p>And I think that&#8217;s just one example of the utility of this API. But for example, I mentioned that you could add icons to your Navigation block and you can&#8217;t really do that at the moment. It&#8217;s pretty powerful. It&#8217;s kind of hidden away. It&#8217;s in the release notes, but it&#8217;s not massively clear, but it does open some pretty big doors. And I think if you&#8217;re a developer or a theme author, indeed, you should you should definitely be looking into that and see what it enables for you.</p>\n\n\n\n<p>[00:16:06] <strong>Josepha:</strong> Yeah, we&#8217;ll put a link to Nick&#8217;s post in the show notes, and we&#8217;ll share it around the social spaces. So like, I hear you saying it&#8217;s buried, it&#8217;s hard to see, it won&#8217;t necessarily be exciting now, but will be exciting later, but like mega menus and sliders, those are the most contested things that people want to put on sites all the time. Like from my agency days, like when I was thinking in the mindset of a strategist, a data person, that&#8217;s what I was doing. Like, I never wanted sliders. I never wanted mega menus because it just implied that we didn&#8217;t have a decision about the sites we were making, like we had not decided the primary purpose, and also it was just hard to track, but it was always literally every single time people are like well if Amazon has it why can&#8217;t we have it? You&#8217;re like, yeah, I know, but they&#8217;re Amazon. They&#8217;re not the same like mega menus sliders. I know that from a project perspective that we&#8217;re like, that should be a theme thing. That should be in theme territory. But I think it makes sense to have in core because so many people want to be able to do it.</p>\n\n\n\n<p>[00:17:14] <strong>Josepha:</strong> And just because like someone like me feels like it&#8217;s not the right call for your business doesn&#8217;t mean that you shouldn&#8217;t be able to make that decision for yourself, you know, I think that&#8217;s a, I think that&#8217;s a great, a great feature to call out.</p>\n\n\n\n<p>[00:17:28] <strong>Dave:</strong> Yeah, absolutely. I completely agree. I can look for my agency days. I can exactly imagine that sort of thing. We have a lot of people, a problem that a lot of people are facing. So it&#8217;s really important that we provide the tools to allow people to do that now. And we can always look at if it&#8217;s valid to include it in core later, then we can look at that as well.</p>\n\n\n\n<p>Yeah. So that&#8217;s, that&#8217;s the first one I had. The second one is a little bit more user-facing. I would say it&#8217;s hidden away. But I&#8217;m not 100 percent sure it is. I mean, Josepha, how often do you create links when you&#8217;re working with WordPress?</p>\n\n\n\n<p>[00:17:58] <strong>Josepha:</strong> Like every time that I&#8217;m in WordPress.</p>\n\n\n\n<p>[00:18:00] <strong>Dave:</strong> Yeah, exactly. Same here. I do it all the time, right? And a lot of people do. And for a long while, contributors to the editor have been sort of collecting and collating the feedback that&#8217;s come in from people about their frustrations with the built in link interface in the Block Editor. So if you&#8217;re creating a hyperlink to, you know, hyperlink to another page or, you know, you&#8217;re going to link to Nick&#8217;s mega menu article, you&#8217;re going to be doing that a lot, right?</p>\n\n\n\n<p>That&#8217;s something that people do when they&#8217;re creating content in WordPress. And so we worked a lot to refine that with a contributor who, who you may know, Rich Tabor. Who&#8217;s also, I think, on the release squad as well. An influencer in the WordPress space as well. He spent a lot of time looking at the UX and myself and a number of other contributors have spent a lot of time in this release refining that. And I think it&#8217;s surprisingly difficult to get right, but I think we&#8217;ve, I think we&#8217;ve made some nice improvements to that will be nice quality of life for people who, to do this sort of content creation quite a lot.</p>\n\n\n\n<p>So there&#8217;s things like now when you create the link for the first time, it remains open on the initial creation of the link. So that means you can quickly then easily adjust the link. I mean, it seems obvious, doesn&#8217;t it? Yeah, but it&#8217;s not happening. It just used to just automatically close, and the people are like, &#8220;Hey, I wanted to make more adjustments. &#8220;</p>\n\n\n\n<p>[00:19:08] <strong>Josepha:</strong> I wasn&#8217;t done yet.&nbsp;</p>\n\n\n\n<p>[00:19:10] <strong>Dave:</strong> Exactly. Yeah, exactly. We&#8217;ve, we&#8217;ve streamlined the UI. We&#8217;ve removed a lot of clutter, but we&#8217;ve also added some useful tools, like ability to copy a link and remove the link directly from the control itself. And lastly along with lots of other accessibility changes in this release. We have worked a lot on refining the implementation.</p>\n\n\n\n<p>So that is discoverable for, for users of assistive tech because we spent a lot of time talking to core accessibility team and other people, and they were finding it very hard to perceive that the UI was there because of the way that keyboard interactions work and you&#8217;ve got the block toolbar in the way and things like that.</p>\n\n\n\n<p>We think we&#8217;ve nailed on a really good solution now that works for, not only uses assistive tech, but actually provides benefits for sighted users as well. It&#8217;s kind of difficult to talk about. I mean, I have got a video covering this on my YouTube channel, which kind of shows it in a bit more detail, but we&#8217;re happy it&#8217;s in a much better place.</p>\n\n\n\n<p>[00:20:02] <strong>Dave:</strong> And yeah if people have got feedback about it, and when, when 6.5 comes out, we&#8217;re always happy to hear that. And you can go to the WordPress GitHub repository and raise an issue. And one of us will jump on it and see what we can do.</p>\n\n\n\n<p>[00:20:13] <strong>Josepha:</strong> And we can include a link to that video also. So like, for folks where this sounded intriguing, but they don&#8217;t quite get the concept, like video content all day, let&#8217;s pop it into our show notes. And everybody can take a look at it there. I think that&#8217;s a great idea.</p>\n\n\n\n<p>[00:20:28] <strong>Dave:</strong> Great. Yeah, I appreciate that.</p>\n\n\n\n<p>[00:20:30] <strong>Josepha:</strong> So final question, maybe, maybe final question, final planned question. Is there anything from a user-facing perspective again that you feel has not really gotten the airtime that it needs so far?&nbsp;</p>\n\n\n\n<p>[00:20:44] <strong>Dave:</strong> I think there&#8217;s a lot of technical changes that have happened in this release. So it&#8217;s easy to look at those. I mean, we&#8217;ve covered quite a lot of the key ones that will be user-facing in terms of Font Library and Revisions. We&#8217;ve got things that are going to this release that enable things a lot for people to experience in the future, I think, so underlying changes like the Interactivity API becoming public. Now that&#8217;s public, plugin developers can start to make sites much more interactive on the front of the site rather than just in the editor. So I think that once 6.5 has gone in, and people have started to explore the Interactivity API in more detail, we might see more plugins offering sort of interactivity on the fronts of their sites. An example is obviously the lightbox you&#8217;ve got with images in core, but I can; there&#8217;s way more stuff that you can do with that. So we&#8217;re going to see more of that. </p>\n\n\n\n<p>[00:21:28] <strong>Dave:</strong> We&#8217;ve got Block Hooks that have landed in 6.5, and this is going to open for things like ecommerce plugins and to be able to add, you know, cart blocks or log in, log out blocks to things like navigation, for example, or you might want a ability to like all your comments, and you can do that with Block Hooks and then a plugin developer can just, you know, when the plugin is enabled, they can just make it so that those things just appear on your site, but you still got control over the design.</p>\n\n\n\n<p>So there&#8217;s a lot of like hidden things I think are going to uncover new features for users over time as a result of the community getting involved and changing their plugins and themes to do these take advantage of these new tools.&nbsp;</p>\n\n\n\n<p>[00:22:07] <strong>Josepha:</strong> Yeah, so the Interactivity API, obviously it has &#8220;API&#8221; on it. And so no one&#8217;s thinking, well, this is a user-facing thing. And while the API is not a user facing thing, like, I think that you&#8217;re right. That what it enables absolutely is going to be really useful and hopefully really engaging for like end-to-end users, like the users that are not listening to this podcast and they don&#8217;t know we exist, like they don&#8217;t know that WordPress has a community building it, they&#8217;re just like, it exists, there&#8217;s a software that came out of nowhere, like, I&#8217;m really excited to see how our developers in the community start to use that in their plugins and themes and get that out to end users. I&#8217;m really, really excited to see how creative they get with it.</p>\n\n\n\n<p>Did you have a final thing?</p>\n\n\n\n<p>[00:22:51] <strong>Dave:</strong> There&#8217;s a lot of design changes, I think. I mean, we can&#8217;t cover them all, obviously, in verbal form in this podcast, but some things that are just standing out to me if we look at the source of truth for, for WordPress 6.5, it is, it is big. There&#8217;s a lot in this release. But there&#8217;s some very cool things for, I don&#8217;t know, quality. I like to see them as like quality of life design design changes. Things like, if you drop an image, as a background image of a cover block, it automatically sets the overlay color for that cover block to match the most prominent color of the background image. Like things like that, they seem small, but over time, they just, you just drop that thing, and it just does it. And it&#8217;s like, this is nice. And it feels like a nice tool to use that just is intuitive. And I think there&#8217;s, we&#8217;ll see a lot of those things landing in this release that can just make the experience of working with WordPress and working in the Site Editor much, much nicer.</p>\n\n\n\n<p>[00:23:41] <strong>Josepha:</strong> Yeah. I remember when I first ran into that particular thing, it was on the Showcase, our most recent redesign of it. We&#8217;re using that functionality in there before it was available in core. Obviously, I know, but it was really fascinating. I&#8217;m not great with color combinations. Like, I don&#8217;t have a sense for, like, oh, that&#8217;s the primary thing. That&#8217;s not. And so having that being done kind of automatically so that my stuff looks good anyway, despite what my color sense said to do or not. I thought it was great. Makes you look good as somebody who&#8217;s running a business. You don&#8217;t have to know how things work in order to have excellently functional, really beautiful things.</p>\n\n\n\n<p>[00:24:21] <strong>Josepha:</strong> And I think that&#8217;s a great thing about all of our releases. Obviously, everything is supposed to work that way, but like this one has a lot of really cool things like that available. I think those are really the questions that I had. Is there anything you want to make sure to share before we kind of give last thoughts and head out?</p>\n\n\n\n<p>[00:24:39] <strong>Dave:</strong> Yeah, I was, I was thinking a lot about, you know, the community we&#8217;ve got with WordPress, and I think that people outside of WordPress may not really understand that how amazing this community is that we&#8217;ve got here, but I wanted to say to people like don&#8217;t shy away from contributing to WordPress. I get that, you know, people like myself are fortunate enough to be sponsored to do it. But there&#8217;s always something that people can do, even if that&#8217;s just spending like 30 minutes testing a release or donating some of your time to run one of the meetings. It can really make a difference overall. Even just filing a bug report for something you see in WordPress 6.5 or testing 6.5 before it goes out, those little things do make a big difference. And if you&#8217;re not sure where to go, then we can signpost you with links, no doubt in this, in the podcast description with where where&#8217;s to go. But yeah, I just want to encourage people to get involved, basically.</p>\n\n\n\n<p>[00:25:27] <strong>Josepha:</strong> Yeah. And it&#8217;s all working out in public, like we&#8217;ve got developers, designers, marketing folks, community folks like all doing this work out where everybody can see it. And so that, I know, can look really kind of overwhelming. But I want to just highlight, like, you don&#8217;t have to know everything about what&#8217;s happening in the project in order to get involved in the project. Like every small bit of contribution toward like finding a new bug or confirming that a bug happens across other devices, other setups, things like that, like those all help make things better and keep things moving as quickly as we are able to make them move. And so, yeah, I&#8217;ll second that every little thing that you think like that won&#8217;t make a difference. It does. We can&#8217;t tell that things are broken or things are working or things are in need of some care unless you highlight those for us. And this is the best way to do it is to show up and give 30 minutes to send out a group testing invite to your meetup group or whatever it is that you all have been thinking you should do, like, this is your sign. You can do it.</p>\n\n\n\n<p>[00:26:34] <strong>Dave:</strong> Everyone should get involved if they can.</p>\n\n\n\n<p>[00:26:37] <strong>Josepha:</strong> I agree. I agree. Dave, this has been such an excellent conversation. Thank you so much for joining me today.</p>\n\n\n\n<p>[00:26:42] <strong>Dave:</strong> Oh, thank you very much. It&#8217;s a pleasure.</p>\n\n\n\n<p>[00:26:43] (Music interlude)&nbsp;</p>\n\n\n\n<p>[00:26:49] <strong>Josepha:</strong> What an interesting release we&#8217;ve got coming out this week. I&#8217;m so glad you all made it this far in the pod, and now it&#8217;s time for our small list of big things.</p>\n\n\n\n<p>[00:27:00] <strong>Josepha:</strong> First up, following up on the WordPress meetup reactivation project that we had in 2022, we aim to revive some meetup groups in big cities that are inactive or help the local WordPress community that are not yet part of our meetup chapter program to join our program. There is a post out on the community P2 on the community site. That is titled Asia Meetup Revival Project 2024. I&#8217;ll leave a link to that in the show notes if you want to read more about that and figure out how to get involved.</p>\n\n\n\n<p>And speaking of getting involved, we have roughly a million meetings. Because it&#8217;s a new month, we&#8217;re in April now. New month, new opportunities. There are a lot of things happening in April. We will be coming out of a major release, obviously, and so there will be some minor release follow up to do. There will be a lot of discussion about what&#8217;s coming next, what&#8217;s in trunk, what&#8217;s not in trunk. But also a lot of work being done around our next big major events, our next big major training initiatives. There&#8217;s just so much happening. Spring is a time when we are looking at stuff that&#8217;s new, what we want to invest in, what we want to grow. And so if you have not attended one in a while or even at all if you&#8217;ve never attended a meeting in the community, then this is a great time to start and join your fellow community members trying to make WordPress better every day.</p>\n\n\n\n<p>[00:28:23] <strong>Josepha:</strong> And then the final thing on our small list of big things is I am looking at helping to shift the focus of our WordPress marketing community. We&#8217;ve had a bit of a struggle over the years to figure out what our primary focus and our primary impact can be. So there&#8217;s a post up called &#8216;Making a WordPress Media Corps&#8217;. It&#8217;s gotten quite a bit of attention, and I do really think that it has a lot of potential for solving some of the issues that we have and kind of getting some quick wins into our recent history of that team so that we can move forward confidently together. So pop on over, give it a read, share your thoughts. And if you are one of these qualified media partners, also let us know.&nbsp;</p>\n\n\n\n<p>[00:29:08] <strong>Josepha:</strong> That, my friends, is your small list of big things.</p>\n\n\n\n<p>Don&#8217;t forget to follow us on your favorite podcast app or subscribe directly on WordPress.org/news. You&#8217;ll get a friendly reminder whenever there&#8217;s a new episode. And if you liked what you heard today, share it with a fellow WordPresser, or if you had questions about what you heard, you can share those with me at WPBriefing@WordPress.org. I&#8217;m your host, Josepha Haden Chomphosy. Thank you for tuning in today for the WordPress Briefing, and I&#8217;ll see you again in a couple of weeks.&nbsp;</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"17158\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:66:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"WordPress 6.5 “Regina”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://wordpress.org/news/2024/04/regina/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Apr 2024 18:42:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=17132\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:202:\"WordPress 6.5 \"Regina\" is here! Named in honor of Regina Carter, renowned jazz violinist and educator, this release was made possible by over 700 contributors. Download WordPress 6.5 “Regina” today.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:70187:\"\n<figure class=\"wp-block-image size-large\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/04/Release-Edition-Inline-Image.png?resize=1024%2C683&#038;ssl=1\" alt=\"WordPress 6.5 &quot;Regina&quot;\" class=\"wp-image-17178\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/04/Release-Edition-Inline-Image.png?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/04/Release-Edition-Inline-Image.png?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/04/Release-Edition-Inline-Image.png?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/04/Release-Edition-Inline-Image.png?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/04/Release-Edition-Inline-Image.png?resize=2048%2C1365&amp;ssl=1 2048w, https://i0.wp.com/wordpress.org/news/files/2024/04/Release-Edition-Inline-Image.png?w=3000&amp;ssl=1 3000w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>Say hello to WordPress 6.5 “Regina,” inspired by the dynamic versatility of renowned jazz violinist <a href=\"https://en.wikipedia.org/wiki/Regina_Carter\">Regina Carter</a>. An award-winning artist and storied jazz educator known for transcending genre, Regina’s technical foundations in classical music and deep understanding of jazz have earned her the reputation of boldly going beyond what’s possible with the violin.&nbsp;</p>\n\n\n\n<p>Let the stunning twists and subtle turns of <a href=\"https://open.spotify.com/playlist/37i9dQZF1DZ06evO1WEiVo?si=534335c984804713\" data-type=\"link\" data-id=\"https://open.spotify.com/playlist/37i9dQZF1DZ06evO1WEiVo?si=534335c984804713\">Regina’s genre-bending sound</a> surprise you as you explore everything 6.5 offers.</p>\n\n\n\n<p>This latest version of WordPress puts more power into the details. It offers new and improved ways to fine-tune and enhance your site-building experience, letting you take control in ways that make it your own. You’ll find new ways to manage your site’s typography, more comprehensive revisions available in more places, and a collection of Site Editor updates paired with impressive performance gains to help you get things done smoother and faster.</p>\n\n\n\n<p>&#8220;Regina&#8221; also marks the introduction of some breakthrough developer tools that will start transforming how you use and extend blocks to craft engaging experiences. The Interactivity API opens up a world of creative front-end possibilities, while the Block Bindings API makes dynamic connections between blocks and data seamless. These, among other developer-focused improvements and updates, are ready to help you evolve how you build with WordPress.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wordpress.org/download/\">Download WordPress 6.5 &#8220;Regina&#8221;</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s inside 6.5</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Add and manage fonts across your site</h3>\n\n\n\n<p>The new Font Library puts you in control of an essential piece of your site’s design—typography—without coding or extra steps. Effortlessly install, remove, and activate local and Google Fonts across your site for any Block theme. The ability to include custom typography collections gives site creators and publishers more options when it comes to styling content.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" width=\"1024\" height=\"656\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/04/Font-Manager-2.png?resize=1024%2C656&#038;ssl=1\" alt=\"\" class=\"wp-image-17167\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/04/Font-Manager-2.png?resize=1024%2C656&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/04/Font-Manager-2.png?resize=300%2C192&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/04/Font-Manager-2.png?resize=768%2C492&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/04/Font-Manager-2.png?w=1320&amp;ssl=1 1320w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Get more from your revisions—including revisions for templates and template parts</h3>\n\n\n\n<p>Work through creative projects with a more comprehensive picture of what’s been done—and what you can fall back on. Get details like time stamps, quick summaries, and a paginated list of all revisions. View revisions from the Style Book to see how changes impact every block. Revisions are also now available for templates and template parts.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" width=\"1024\" height=\"656\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/04/Revisions-1.png?resize=1024%2C656&#038;ssl=1\" alt=\"\" class=\"wp-image-17168\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/04/Revisions-1.png?resize=1024%2C656&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/04/Revisions-1.png?resize=300%2C192&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/04/Revisions-1.png?resize=768%2C492&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/04/Revisions-1.png?w=1320&amp;ssl=1 1320w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Play with enhanced background and shadow tools</h3>\n\n\n\n<ul>\n<li>Control the size, repeat, and focal point options for background images in Group blocks so you can explore subtle or splashy ways to add visual interest to layouts.&nbsp;</li>\n\n\n\n<li>Set aspect ratios for Cover block images and easily add color overlays that automatically source color from your chosen image.&nbsp;</li>\n\n\n\n<li>Add box shadow support to more block types and create layouts with visual depth, or throw a little personality into your design.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"656\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/04/design-tools-1.png?resize=1024%2C656&#038;ssl=1\" alt=\"\" class=\"wp-image-17169\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/04/design-tools-1.png?resize=1024%2C656&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/04/design-tools-1.png?resize=300%2C192&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/04/design-tools-1.png?resize=768%2C492&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/04/design-tools-1.png?w=1320&amp;ssl=1 1320w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Discover new Data Views</h3>\n\n\n\n<p>Every piece of your site comes with a library of information and data—now, you can find what you need quickly and organize it however you like. Data views for pages, templates, patterns, and template parts let you see data in a table or grid view, with the option to toggle fields and make bulk changes.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"656\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/04/Data-Views-1.png?resize=1024%2C656&#038;ssl=1\" alt=\"\" class=\"wp-image-17165\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/04/Data-Views-1.png?resize=1024%2C656&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/04/Data-Views-1.png?resize=300%2C192&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/04/Data-Views-1.png?resize=768%2C492&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/04/Data-Views-1.png?w=1320&amp;ssl=1 1320w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Smoother drag-and-drop</h3>\n\n\n\n<p>Feel the difference when you move things around, with helpful visual cues like displaced items in List View or frictionless dragging to anywhere in your workspace—from beginning to end.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"656\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/04/drag-and-drop-1.png?resize=1024%2C656&#038;ssl=1\" alt=\"\" class=\"wp-image-17170\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/04/drag-and-drop-1.png?resize=1024%2C656&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/04/drag-and-drop-1.png?resize=300%2C192&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/04/drag-and-drop-1.png?resize=768%2C492&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/04/drag-and-drop-1.png?w=1320&amp;ssl=1 1320w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Improved link controls</h3>\n\n\n\n<p>Create and manage links easily with a more intuitive link-building experience, like a streamlined UI and a shortcut for copying links.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"656\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/04/link-controls-1.png?resize=1024%2C656&#038;ssl=1\" alt=\"\" class=\"wp-image-17171\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/04/link-controls-1.png?resize=1024%2C656&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/04/link-controls-1.png?resize=300%2C192&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/04/link-controls-1.png?resize=768%2C492&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/04/link-controls-1.png?w=1320&amp;ssl=1 1320w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s fresh for developers in 6.5</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Bring interactions to blocks with the Interactivity API</h3>\n\n\n\n<p>The <a href=\"https://make.wordpress.org/core/2024/03/04/interactivity-api-dev-note/\">Interactivity API</a> offers developers a standardized method for building interactive front-end experiences with blocks. It simplifies the process, with fewer dependencies on external tooling, while maintaining optimal performance. Use it to create memorable user experiences, like fetching search results instantly or letting visitors interact with content in real time.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Connect blocks to custom fields or other dynamic content</h3>\n\n\n\n<p>Link core block attributes to custom fields and use the value of custom fields without creating custom blocks. Powered by the <a href=\"https://make.wordpress.org/core/2024/03/06/new-feature-the-block-bindings-api/\">Block Bindings API</a>, developers can extend this capability further to connect blocks to any dynamic content—even beyond custom fields. If there’s data stored elsewhere, easily point blocks to that new source with only a few lines of code.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Add appearance tools to Classic themes</h3>\n\n\n\n<p>Give designers and creators using Classic themes access to an upgraded design experience. Opt in to support for spacing, border, typography, and color options, even without using theme.json. Once support is enabled, more tools will be automatically added as they become available.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Explore improvements to the plugin experience</h3>\n\n\n\n<p>There&#8217;s now an <a href=\"https://make.wordpress.org/core/2024/03/05/introducing-plugin-dependencies-in-wordpress-6-5/\">easier way to manage plugin dependencies</a>. Plugin authors can supply a new <code>Requires Plugins</code> header with a comma-separated list of required plugin slugs, presenting users with links to install and activate those plugins first.</p>\n\n\n\n<h2 class=\"wp-block-heading\">From fast to faster: Performance updates</h2>\n\n\n\n<p>This release includes 110+ performance updates, resulting in an impressive increase in speed and efficiency across the Post Editor and Site Editor. Loading is over two times faster than in 6.4, with input processing speed up to five times faster than the previous release.</p>\n\n\n\n<p>&nbsp;Translated sites see up to 25% improvement in load time for this release courtesy of <a href=\"https://make.wordpress.org/core/2024/02/27/i18n-improvements-6-5-performant-translations/\">Performant Translations</a>. Additional performance highlights include <a href=\"https://make.wordpress.org/core/2024/02/23/wordpress-6-5-adds-avif-support/\">AVIF image support</a> and improvements for <a href=\"https://make.wordpress.org/core/2024/02/29/performance-improvements-for-registering-block-variations-with-callbacks/\">registering block variations with callbacks</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A tradition of inclusion</h2>\n\n\n\n<p>This release includes more than 65 accessibility improvements across the platform, making it more accessible than ever. It contains an important fix that unblocks access to the admin submenus for screen reader users and others who navigate by keyboard. This release also adds fixes to color contrast in admin focus states, positioning of elements, and cursor focus, among many others, that help improve the WordPress experience for everyone.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Learn more about WordPress 6.5</h2>\n\n\n\n<p>Check out the new&nbsp;<a href=\"https://wordpress.org/download/releases/6-5/\">WordPress 6.5 page</a>&nbsp;to learn more about the numerous enhancements and features of this release—including short demos of some of the highlighted features. </p>\n\n\n\n<p>Explore <a href=\"https://learn.wordpress.org/\">Learn WordPress</a> for quick how-to videos, <a href=\"https://learn.wordpress.org/social-learning/\">online workshops</a>, and other free resources to level up your WordPress knowledge and skills.</p>\n\n\n\n<p>Check out the <a href=\"https://make.wordpress.org/core/2024/03/15/wordpress-6-5-field-guide/\">WordPress 6.5 Field Guide</a> for detailed technical information and <a href=\"https://make.wordpress.org/core/tag/dev-notes-6-5/\">developer notes</a> to help you build with WordPress and get the most out of this release. Don’t forget to subscribe to the <a href=\"https://developer.wordpress.org/news/\">Developer Blog</a> for developer updates, feature tutorials, and other helpful WordPress content from a developer perspective.</p>\n\n\n\n<p>For more information about installation, file changes, fixes, and other updates, read the <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-5/\">6.5 release notes</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The 6.5 release squad</h2>\n\n\n\n<p>Every release has many moving parts with its own triumphs and challenges. It takes a dedicated team of enthusiastic contributors to help keep things on track and moving smoothly. 6.5 is made possible by a cross-functional group of contributors, always ready to champion ideas, remove blockers, and resolve issues.</p>\n\n\n\n<ul>\n<li>Release Lead: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Release Coordinators: <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a>, <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a>, <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a></li>\n\n\n\n<li>Core Tech Leads: <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a></li>\n\n\n\n<li>Editor Tech Leads: <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>, <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a></li>\n\n\n\n<li>Core Triage Leads: <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a></li>\n\n\n\n<li>Editor Triage Leads: <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a>, <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a></li>\n\n\n\n<li>Design Leads: <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a>, <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a></li>\n\n\n\n<li>Marketing and Communication Leads: <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a>, <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a></li>\n\n\n\n<li>Documentation Leads: <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a>, <a href=\"https://profiles.wordpress.org/leonnugraha/\">Leonardus Nugraha</a>, <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a></li>\n\n\n\n<li>Performance Leads: <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a></li>\n\n\n\n<li>Test Leads: <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>, <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a>, <a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a></li>\n\n\n\n<li>Default Themes Leads: <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you, contributors</h2>\n\n\n\n<p>WordPress believes in democratizing publishing and the <a href=\"https://opensource.org/osd-annotated\">freedoms that come with open source</a>. Supporting this idea is a global and diverse community of people collaborating to strengthen the software.&nbsp;</p>\n\n\n\n<p>WordPress 6.5 reflects the countless efforts and passion of around 700 contributors in at least 57 countries. This release also welcomed over 150 first-time contributors!</p>\n\n\n\n<p>Their collaboration delivered more than 2,500 enhancements and fixes, ensuring a stable release for all—a testament to the power and capability of the WordPress open source community.</p>\n\n\n<p class=\"is-style-wporg-props-long alignfull\"><a href=\"https://profiles.wordpress.org/benniledl/\">!Benni</a> · <a href=\"https://profiles.wordpress.org/_ck_/\">_ck_</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/abletec/\">abletec</a> · <a href=\"https://profiles.wordpress.org/acosmin/\">acosmin</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/adarshposimyth/\">Adarsh Akshat</a> · <a href=\"https://profiles.wordpress.org/ajmcfadyen/\">admcfajn</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/skyakash12/\">Akash Muchandikar</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akmelias/\">akmelias</a> · <a href=\"https://profiles.wordpress.org/wpfy/\">Akramul Hasan</a> · <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a> · <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a> · <a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a> · <a href=\"https://profiles.wordpress.org/ahoereth/\">Alex</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/alexkingorg/\">Alex King</a> · <a href=\"https://profiles.wordpress.org/akirk/\">Alex Kirk</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/viper007bond/\">Alex Mills</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alexanderkoledov/\">AlexKole</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/sabreuse/\">Amy Hendrix (sabreuse)</a> · <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a> · <a href=\"https://profiles.wordpress.org/anandau14/\">Anand Upadhyay</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Nor&#233;n</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/l1nuxjedi/\">Andrew Hutchings</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/norcross/\">Andrew Norcross</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/andrewleap/\">andrewleap</a> · <a href=\"https://profiles.wordpress.org/andbalashov/\">Andrii Balashov</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/apeatling/\">Andy Peatling</a> · <a href=\"https://profiles.wordpress.org/aneeshd16/\">Aneesh Devasthale</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> · <a href=\"https://profiles.wordpress.org/antonlukin/\">Anton Lukin</a> · <a href=\"https://profiles.wordpress.org/atimmer/\">Anton Timmermans</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/lighthouse79/\">Antonella</a> · <a href=\"https://profiles.wordpress.org/colomet/\">Antonio D.</a> · <a href=\"https://profiles.wordpress.org/antonisme/\">Antonis Lilis</a> · <a href=\"https://profiles.wordpress.org/arena94/\">arena94</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/passoniate/\">Arslan Kalwar</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/iamarunchaitanyajami/\">Arun Chaitanya Jami</a> · <a href=\"https://profiles.wordpress.org/dextorlobo/\">Arun Sharma</a> · <a href=\"https://profiles.wordpress.org/ideag/\">Arunas Liuiza</a> · <a href=\"https://profiles.wordpress.org/iamasadpolash/\">Asad Polash</a> · <a href=\"https://profiles.wordpress.org/ashfame/\">Ashish Kumar (Ashfame)</a> · <a href=\"https://profiles.wordpress.org/mohonchandra/\">Asish Chandra Mohon</a> · <a href=\"https://profiles.wordpress.org/audunmb/\">audunmb</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/filosofo/\">Austin Matzko</a> · <a href=\"https://profiles.wordpress.org/axwax/\">axwax</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">B&#233;ryl de La Grandi&#232;re</a> · <a href=\"https://profiles.wordpress.org/bahia0019/\">bahia0019</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/bangank36/\">bangank36</a> · <a href=\"https://profiles.wordpress.org/barry/\">Barry</a> · <a href=\"https://profiles.wordpress.org/barryhughes-1/\">Barry</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a> · <a href=\"https://profiles.wordpress.org/bartkleinreesink/\">bartkleinreesink</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/beaulebens/\">Beau Lebens</a> · <a href=\"https://profiles.wordpress.org/bedas/\">Beda</a> · <a href=\"https://profiles.wordpress.org/benharri/\">ben</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/ubernaut/\">Ben Hansen</a> · <a href=\"https://profiles.wordpress.org/husobj/\">Ben Huson</a> · <a href=\"https://profiles.wordpress.org/blobaugh/\">Ben Lobaugh (blobaugh)</a> · <a href=\"https://profiles.wordpress.org/britner/\">Ben Ritner - Kadence WP</a> · <a href=\"https://profiles.wordpress.org/retlehs/\">Ben Word</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benjaminknox/\">benjaminknox</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/billseymour/\">billseymour</a> · <a href=\"https://profiles.wordpress.org/bplv/\">Biplav</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/bobbingwide/\">bobbingwide</a> · <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a> · <a href=\"https://profiles.wordpress.org/born2webdesign/\">born2webdesign</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradparbs/\">Brad Parbs</a> · <a href=\"https://profiles.wordpress.org/williamsba1/\">Brad Williams</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/drrobotnik/\">Brandon Lavigne</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/fischfood/\">Brian Fischer</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a> · <a href=\"https://profiles.wordpress.org/brookemk/\">Brooke</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/ecc/\">camya</a> · <a href=\"https://profiles.wordpress.org/karl94/\">Carlo Cannas</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cenkdemir/\">cenkdemir</a> · <a href=\"https://profiles.wordpress.org/cfinnberg/\">cfinnberg</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/chasedsiedu/\">chased@si.edu</a> · <a href=\"https://profiles.wordpress.org/mel_cha/\">chiilog (Chiaki Okamoto)</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/chrisdavidmiles/\">Chris David Miles</a> · <a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/itschristiandale/\">christian-dale</a> · <a href=\"https://profiles.wordpress.org/christopherplus/\">Christopher</a> · <a href=\"https://profiles.wordpress.org/chrystl/\">Chrystl</a> · <a href=\"https://profiles.wordpress.org/codepo8/\">codepo8</a> · <a href=\"https://profiles.wordpress.org/cdevroe/\">Colin Devroe</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">Cory Birdsong</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/creativeslice/\">Creative Slice</a> · <a href=\"https://profiles.wordpress.org/crstauf/\">crstauf</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/cvorko/\">cvorko</a> · <a href=\"https://profiles.wordpress.org/didierjm/\">cybeardjm</a> · <a href=\"https://profiles.wordpress.org/cyberchicken/\">Cyberchicken</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/mzaweb/\">Daniel Dvorkin</a> · <a href=\"https://profiles.wordpress.org/mapumba/\">Daniel K&#228;fer</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/schutzsmith/\">Daniel Schutzsmith</a> · <a href=\"https://profiles.wordpress.org/danieldudzic/\">danieldudzic</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/danieltj/\">danieltj</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/darssen/\">darssen</a> · <a href=\"https://profiles.wordpress.org/dartiss/\">David Artiss</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/dglingren/\">David Lingren</a> · <a href=\"https://profiles.wordpress.org/davidperez/\">David Perez</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/denis-de-bernardy/\">Denis de Bernardy</a> · <a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a> · <a href=\"https://profiles.wordpress.org/dionysous/\">Dennis Hipp</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dennysdionigi/\">Dennys Dionigi</a> · <a href=\"https://profiles.wordpress.org/derekblank/\">Derek Blank</a> · <a href=\"https://profiles.wordpress.org/valendesigns/\">Derek Herman</a> · <a href=\"https://profiles.wordpress.org/derekspringer/\">Derek Springer</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/desrosjbot/\">Desrosj Bot</a> · <a href=\"https://profiles.wordpress.org/dernin/\">Devin Curtis</a> · <a href=\"https://profiles.wordpress.org/dlocc/\">Devin Walker</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruvishah2203/\">Dhruvi Shah</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/dougal/\">Dougal Campbell</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/lots0logs/\">Dustin Falgout</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham Siddiqui</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emirpprime/\">emirpprime</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/endymion00/\">Endymion00</a> · <a href=\"https://profiles.wordpress.org/ericlewis/\">Eric Andrew Lewis</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisalahmed29/\">Faisal Ahmed</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fanly/\">Fanly</a> · <a href=\"https://profiles.wordpress.org/feastdesignco/\">Feast Design Co.</a> · <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/fgiannar/\">fgiannar</a> · <a href=\"https://profiles.wordpress.org/flhz/\">Florent Hernandez</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/francescocarlucci/\">FrancescoCarlucci</a> · <a href=\"https://profiles.wordpress.org/fotodrachen/\">Frank J&#228;ger</a> · <a href=\"https://profiles.wordpress.org/nexflaszlo/\">Frank Laszlo</a> · <a href=\"https://profiles.wordpress.org/wazeter/\">Frank Wazeter</a> · <a href=\"https://profiles.wordpress.org/fushar/\">fushar</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garibiza/\">Garbi&#241;e</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/gavande1/\">gavande1</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/gerardreches/\">Gerard Reches</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/girishpanchal/\">Girish Panchal</a> · <a href=\"https://profiles.wordpress.org/giuseppemazzapica-1/\">Giuseppe Mazzapica</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/goldenapples/\">goldenapples</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregbenz/\">gregbenz</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">gvgvgvijayan</a> · <a href=\"https://profiles.wordpress.org/poran766/\">H.M. Mushfiqur Rahman</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hardik2221/\">Hardik Raval</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harsh175/\">Harsh Patel</a> · <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman Shamim</a> · <a href=\"https://profiles.wordpress.org/halounsbury/\">Heather Lounsbury</a> · <a href=\"https://profiles.wordpress.org/muhme/\">Heiko L&#252;bbe</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/tejwanihemant/\">Hemant Tejwani</a> · <a href=\"https://profiles.wordpress.org/kurudrive/\">Hidekazu Ishikawa</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hiteshtalpada/\">Hitesh Talpada</a> · <a href=\"https://profiles.wordpress.org/h71/\">Hossein</a> · <a href=\"https://profiles.wordpress.org/howdy_mcgee/\">Howdy_McGee</a> · <a href=\"https://profiles.wordpress.org/hrrarya/\">Hridoy Mozumder</a> · <a href=\"https://profiles.wordpress.org/hrithikd/\">Hrithik Dalal</a> · <a href=\"https://profiles.wordpress.org/hlashbrooke/\">Hugh Lashbrooke</a> · <a href=\"https://profiles.wordpress.org/ganon/\">Hugo Chinchilla</a> · <a href=\"https://profiles.wordpress.org/hugod/\">hugod</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/idad5/\">idad5</a> · <a href=\"https://profiles.wordpress.org/igmoweb/\">Ignacio Cruz Moreno</a> · <a href=\"https://profiles.wordpress.org/ignatiusjeroe/\">ignatiusjeroe</a> · <a href=\"https://profiles.wordpress.org/shaampk1/\">Ihtisham Zahoor</a> · <a href=\"https://profiles.wordpress.org/fnpen/\">Ilya Zolotov</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/iseulde/\">iseulde</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/itecrs/\">itecrs</a> · <a href=\"https://profiles.wordpress.org/ivanzhuck/\">Ivan Zhuck</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/jadpm/\">jadpm</a> · <a href=\"https://profiles.wordpress.org/jamescollins/\">James Collins</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/james roberts/\">James Roberts</a> · <a href=\"https://profiles.wordpress.org/jamieblomerus/\">Jamie Blomerus</a> · <a href=\"https://profiles.wordpress.org/perrelet/\">Jamie Perrelet</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">Jan Thiel</a> · <a href=\"https://profiles.wordpress.org/jane/\">jane</a> · <a href=\"https://profiles.wordpress.org/whiteshadow/\">Janis Elsts</a> · <a href=\"https://profiles.wordpress.org/jsandtro/\">jansan</a> · <a href=\"https://profiles.wordpress.org/japh/\">Japh</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarednova/\">jarednova</a> · <a href=\"https://profiles.wordpress.org/jason_the_adams/\">Jason Adams</a> · <a href=\"https://profiles.wordpress.org/pbking/\">Jason Crist</a> · <a href=\"https://profiles.wordpress.org/coolmann/\">Jason Crouse</a> · <a href=\"https://profiles.wordpress.org/jsnjohnston/\">Jason Johnston</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/jayadevankbh/\">Jayadevan k</a> · <a href=\"https://profiles.wordpress.org/jbobich/\">jbobich</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/amieiro/\">Jes&#250;s Amieiro</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jghazally/\">jghazally</a> · <a href=\"https://profiles.wordpress.org/jipmoors/\">Jip Moors</a> · <a href=\"https://profiles.wordpress.org/jivygraphics/\">jivygraphics</a> · <a href=\"https://profiles.wordpress.org/jltallon/\">jltallon</a> · <a href=\"https://profiles.wordpress.org/joanrodas/\">Joan</a> · <a href=\"https://profiles.wordpress.org/morehawes/\">Joe</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joelcj91/\">Joel James</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen A.</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnciacia/\">johnciacia</a> · <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a> · <a href=\"https://profiles.wordpress.org/duck_/\">Jon Cave</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/jbrinley/\">Jonathan Brinley</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/joppuyo/\">joppuyo</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/jorgevilchez/\">Jorge Vilchez</a> · <a href=\"https://profiles.wordpress.org/jornp/\">jornp</a> · <a href=\"https://profiles.wordpress.org/joefusco/\">Joseph Fusco</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/joshcanhelp/\">joshcanhelp</a> · <a href=\"https://profiles.wordpress.org/joshuatf/\">joshuatf</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/jrtashjian/\">JR Tashjian</a> · <a href=\"https://profiles.wordpress.org/jsmoriss/\">JS Morisset</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juhise/\">Juhi Saxena</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/ashikur698/\">K M Ashikur Rahman</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/bosskhj/\">Kamrul Hasan</a> · <a href=\"https://profiles.wordpress.org/karinclimber/\">Kari Anderson</a> · <a href=\"https://profiles.wordpress.org/karlijnbk/\">Karlijn Bok</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/tadamarketing/\">Katka</a> · <a href=\"https://profiles.wordpress.org/kawsaralameven/\">kawsaralameven</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kbat82/\">Kevin Batdorf</a> · <a href=\"https://profiles.wordpress.org/kevincoleman/\">Kevin Coleman</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kitchin/\">kitchin</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/koen12344/\">Koen Reus</a> · <a href=\"https://profiles.wordpress.org/koesper/\">Koesper</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a> · <a href=\"https://profiles.wordpress.org/kdowns/\">Kylen Downs</a> · <a href=\"https://profiles.wordpress.org/laumindproductscomau/\">lau@mindproducts.com.au</a> · <a href=\"https://profiles.wordpress.org/lada7042/\">Laura Adamonis</a> · <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">Laurent MILLET</a> · <a href=\"https://profiles.wordpress.org/lakshmananphp/\">Lax Mariappan</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/munizleo/\">Leo Muniz</a> · <a href=\"https://profiles.wordpress.org/leonnugraha/\">Leonardus Nugraha</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/liammcarthur/\">LiamMcArthur</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/lkraav/\">lkraav</a> · <a href=\"https://profiles.wordpress.org/logikal16/\">logikal16</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/luboslives/\">luboslives</a> · <a href=\"https://profiles.wordpress.org/lucasbustamante/\">lucasbustamante</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">Luis Herranz</a> · <a href=\"https://profiles.wordpress.org/lpawlik/\">Lukas Pawlik</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukefiretoss/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/maartenbelmans/\">Maarten</a> · <a href=\"https://profiles.wordpress.org/mrdollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mhimon/\">Mahbub Hasan Imon</a> · <a href=\"https://profiles.wordpress.org/mahnewr/\">mahnewr</a> · <a href=\"https://profiles.wordpress.org/maahrokh/\">Mahrokh</a> · <a href=\"https://profiles.wordpress.org/malae/\">Malae</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manyourisms/\">manyourisms</a> · <a href=\"https://profiles.wordpress.org/marc_j/\">Marc_J</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/marcoevich/\">Marcoevich</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/chaton666/\">Marie Comet</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a> · <a href=\"https://profiles.wordpress.org/markoheijnen/\">Marko Heijnen</a> · <a href=\"https://profiles.wordpress.org/flootr/\">Markus</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/mathewemoore/\">mathewemoore</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matiasrecondo77/\">matiasrecondo77</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/cadic/\">Max Lyuchin</a> · <a href=\"https://profiles.wordpress.org/maxpertici/\">Maxime Pertici</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/mhshohel/\">Md Hossain Shohel</a> · <a href=\"https://profiles.wordpress.org/hrshahin/\">Md HR Shahin</a> · <a href=\"https://profiles.wordpress.org/megphillips91/\">Meg Phillips</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/melcarthus/\">melcarthus</a> · <a href=\"https://profiles.wordpress.org/meta4/\">meta4</a> · <a href=\"https://profiles.wordpress.org/metropolis_john/\">metropolis_john</a> · <a href=\"https://profiles.wordpress.org/254volkan/\">mevolkan</a> · <a href=\"https://profiles.wordpress.org/wpscholar/\">Micah Wood</a> · <a href=\"https://profiles.wordpress.org/mshowes/\">Michael Showes</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michalooki/\">Michalooki</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/miguelsansegundo/\">miguelsansegundo</a> · <a href=\"https://profiles.wordpress.org/miikkamakela/\">Miikka</a> · <a href=\"https://profiles.wordpress.org/mbijon/\">Mike Bijon</a> · <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley (a11n)</a> · <a href=\"https://profiles.wordpress.org/mikeschinkel/\">Mike Schinkel</a> · <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/gonzomir/\">Milen Petrinski - Gonzo</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/mkismy/\">mkismy</a> · <a href=\"https://profiles.wordpress.org/mnydigital/\">mnydigital</a> · <a href=\"https://profiles.wordpress.org/batmoo/\">Mohammad Jangda</a> · <a href=\"https://profiles.wordpress.org/boemedia/\">Monique Dubbelman</a> · <a href=\"https://profiles.wordpress.org/monzuralam/\">Monzur Alam</a> · <a href=\"https://profiles.wordpress.org/man4toman/\">Morteza Geransayeh</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/seusmaniqbal/\">Muhammad Usman Iqbal</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/tanjimtc71/\">Musarrat Anjum Chowdhury</a> · <a href=\"https://profiles.wordpress.org/naoki0h/\">Naoki Ohashi</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/nateallen/\">Nate Allen</a> · <a href=\"https://profiles.wordpress.org/navjotjsingh/\">Navjot Singh</a> · <a href=\"https://profiles.wordpress.org/neffff/\">neffff</a> · <a href=\"https://profiles.wordpress.org/neilorangepeel/\">Neil Hainsworth</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/nerdpressteam/\">NerdPress</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/sessioncookiemonster/\">Nick Martianov</a> · <a href=\"https://profiles.wordpress.org/nickpagz/\">nickpagz</a> · <a href=\"https://profiles.wordpress.org/nico23/\">Nico</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/bgnicolepaschen/\">Nicole Paschen Caylor</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nko/\">Nikita</a> · <a href=\"https://profiles.wordpress.org/nikmeyer/\">nikmeyer</a> · <a href=\"https://profiles.wordpress.org/rabmalin/\">Nilambar Sharma</a> · <a href=\"https://profiles.wordpress.org/nilovelez/\">Nilo Velez</a> · <a href=\"https://profiles.wordpress.org/dhrupo/\">Niluthpal Purkayastha</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">Nirav Sherasiya</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/nvwd/\">Nowell VanHoesen</a> · <a href=\"https://profiles.wordpress.org/nudge/\">Nudge Themes</a> · <a href=\"https://profiles.wordpress.org/nwjames/\">nwjames</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/ockham/\">ockham</a> · <a href=\"https://profiles.wordpress.org/oguzkocer/\">oguzkocer</a> · <a href=\"https://profiles.wordpress.org/okat/\">okat</a> · <a href=\"https://profiles.wordpress.org/dargus/\">Old account</a> · <a href=\"https://profiles.wordpress.org/olegfuture/\">olegfuture</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pacicio/\">Pacicio</a> · <a href=\"https://profiles.wordpress.org/pannelars/\">pannelars</a> · <a href=\"https://profiles.wordpress.org/partyfrikadelle/\">partyfrikadelle</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/pauldewouters/\">Paul de Wouters</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/djpaul/\">Paul Wong-Gibbs</a> · <a href=\"https://profiles.wordpress.org/pavelevap/\">pavelevap</a> · <a href=\"https://profiles.wordpress.org/pbaylies/\">Peter Baylies</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/philipp15b/\">Philipp15b</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/mordauk/\">Pippin Williamson</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pmeenan/\">pmeenan</a> · <a href=\"https://profiles.wordpress.org/webtechpooja/\">Pooja Derashri</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/pouicpouic/\">pouicpouic</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/pratikthink/\">Pratik Kumar</a> · <a href=\"https://profiles.wordpress.org/freewebmentor/\">Prem Tiwari</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">presstoke</a> · <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiq</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/rashiguptaa/\">Rashi Gupta</a> · <a href=\"https://profiles.wordpress.org/rawrly/\">rawrly</a> · <a href=\"https://profiles.wordpress.org/rcain/\">rcain</a> · <a href=\"https://profiles.wordpress.org/rebasaurus/\">rebasaurus</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/renehermi/\">Rene Hermenau</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/rdcoll/\">Rich Collier</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/ravanh/\">Rolf Allard van Hagen</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/pogidude/\">Ryann Micua</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sereedmedia/\">S&#233; Reed</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">S&#233;bastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sabbirshouvo/\">Sabbir Hasan</a> · <a href=\"https://profiles.wordpress.org/sachyya-sachet/\">Sachyya</a> · <a href=\"https://profiles.wordpress.org/sadizaman/\">Sadi Mohammad Zaman</a> · <a href=\"https://profiles.wordpress.org/sadpencil/\">sadpencil</a> · <a href=\"https://profiles.wordpress.org/introvertedbot/\">Sahil</a> · <a href=\"https://profiles.wordpress.org/tohincoderex/\">Saiduzzaman Tohin</a> · <a href=\"https://profiles.wordpress.org/sakibsnaz/\">Sakib MD Nazmush</a> · <a href=\"https://profiles.wordpress.org/salcode/\">Sal Ferrarello</a> · <a href=\"https://profiles.wordpress.org/samba45/\">samba45</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/kim88/\">Samuel R&#252;egger</a> · <a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sacerro/\">Santiago Cerro L&#243;pez</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/hellosatya/\">Satyam Vishwakarma (Satya)</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/sayful/\">Sayful Islam</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sgr33n/\">Sergio de Falco</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shahariaazam/\">Shaharia Azam</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/shanef/\">ShaneF</a> · <a href=\"https://profiles.wordpress.org/cafenoirdesign/\">Shannon Smith</a> · <a href=\"https://profiles.wordpress.org/shaunandrews/\">shaunandrews</a> · <a href=\"https://profiles.wordpress.org/shooper/\">Shawn Hooper</a> · <a href=\"https://profiles.wordpress.org/shidouhikari/\">shidouhikari</a> · <a href=\"https://profiles.wordpress.org/shiponkarmakar/\">Shipon Karmakar</a> · <a href=\"https://profiles.wordpress.org/shreyash3087/\">Shreyash Srivastava</a> · <a href=\"https://profiles.wordpress.org/shubhamsedani/\">Shubham Sedani</a> · <a href=\"https://profiles.wordpress.org/rsiddharth/\">siddharth ravikumar</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/sirajummahdi/\">Sirajum Mahdi</a> · <a href=\"https://profiles.wordpress.org/sjregan/\">sjregan</a> · <a href=\"https://profiles.wordpress.org/soean/\">Soren Wrede</a> · <a href=\"https://profiles.wordpress.org/virtality-marketing-solutions/\">SourceView</a> · <a href=\"https://profiles.wordpress.org/sruthi89/\">sruthi89</a> · <a href=\"https://profiles.wordpress.org/stacimc/\">stacimc</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stephencronin/\">Stephen Cronin</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/stephenh1988/\">Stephen Harris</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sumisubedi/\">Sumi Subedi</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/svitlana41319/\">Svitlana Sukhoveiko</a> · <a href=\"https://profiles.wordpress.org/syamraj24/\">syamraj24</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/smub/\">Syed Balkhi</a> · <a href=\"https://profiles.wordpress.org/nuhel/\">Syed Nuhel</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/sparklingrobots/\">Tara King</a> · <a href=\"https://profiles.wordpress.org/buley/\">Taylor</a> · <a href=\"https://profiles.wordpress.org/taylorde/\">Taylor Dewey</a> · <a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a> · <a href=\"https://profiles.wordpress.org/tazotodua/\">tazotodua</a> · <a href=\"https://profiles.wordpress.org/tykoted/\">Teddy Patriarca</a> · <a href=\"https://profiles.wordpress.org/tellyworth/\">Tellyworth</a> · <a href=\"https://profiles.wordpress.org/thakordarshil/\">Thakor Darshil</a> · <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a> · <a href=\"https://profiles.wordpress.org/thinkluke/\">thinkluke</a> · <a href=\"https://profiles.wordpress.org/griffinjt/\">Thomas Griffin</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kr&#228;ftner</a> · <a href=\"https://profiles.wordpress.org/threadi/\">threadi</a> · <a href=\"https://profiles.wordpress.org/tnolte/\">Tim Nolte</a> · <a href=\"https://profiles.wordpress.org/timbroddin/\">timbroddin</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timoth&#233;e Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tmatsuur/\">tmatsuur</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomybyte/\">Tom</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/hifidesign/\">Tom Finley</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomluckies/\">tomluckies</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/tomsommer/\">tomsommer</a> · <a href=\"https://profiles.wordpress.org/tomxygen/\">tomxygen</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemer&#246;</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/torres126/\">torres126</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/toru/\">Toru Miki</a> · <a href=\"https://profiles.wordpress.org/toscho/\">toscho</a> · <a href=\"https://profiles.wordpress.org/wpsmith/\">Travis Smith</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">Utsav Patel</a> · <a href=\"https://profiles.wordpress.org/utsav72640/\">Utsav tilava</a> · <a href=\"https://profiles.wordpress.org/ukdrahul/\">Uttam Kumar Dash</a> · <a href=\"https://profiles.wordpress.org/valerogarte/\">valerogarte</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/vikram6/\">vikram6</a> · <a href=\"https://profiles.wordpress.org/viliamkopecky/\">viliamkopecky</a> · <a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a> · <a href=\"https://profiles.wordpress.org/vladimiraus/\">vladimiraus</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/wasiur195/\">Wasiur Rahman</a> · <a href=\"https://profiles.wordpress.org/welaunchio/\">welaunchio</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whsajid/\">WHSajid</a> · <a href=\"https://profiles.wordpress.org/wpcorner/\">WP Corner</a> · <a href=\"https://profiles.wordpress.org/xlthlx/\">xlthlx</a> · <a href=\"https://profiles.wordpress.org/yansern/\">Yan Sern</a> · <a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a> · <a href=\"https://profiles.wordpress.org/tollmanz/\">Zack Tollman</a> · <a href=\"https://profiles.wordpress.org/zanematthew/\">Zane Matthew</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">zieladam</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/chesio/\">Česlav Przywara</a></p>\n\n\n\n<p>Over <a href=\"https://translate.wordpress.org/stats/\">70 locales have translated 90 percent</a> or more of WordPress 6.5 into their language. Community translators are working hard to ensure more translations are on their way. Thank you to everyone who helps make WordPress available in 200 languages.</p>\n\n\n\n<p>Last but not least, thanks to the volunteers who contribute to the <a href=\"https://wordpress.org/support/\">support forums</a> by answering questions from WordPress users worldwide.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get involved and contribute</h3>\n\n\n\n<p>Participation in WordPress is not limited to coding. If contributing appeals to you, learning more and getting involved is easy. Discover the teams that come together to <a href=\"https://make.wordpress.org/\">Make WordPress</a>, and use <a href=\"https://make.wordpress.org/contribute/\">this interactive tool</a> to help you decide which is right for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">One more haiku</h2>\n\n\n\n<p>6.5 is here!<br>Play, interact, build better,<br>Stronger and faster.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"17132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:72:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.5 Release Candidate 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2024/03/wordpress-6-5-release-candidate-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 16:34:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:3:\"6.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=17136\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:214:\"WordPress 6.5 RC4 is ready for download and testing. Reaching this phase of the release cycle is an important milestone. Check out what\'s coming in this release and how to get involved with the open source project.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Lauren Stein\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6752:\"\n<p>The latest release candidate (RC4) for WordPress 6.5 is ready!&nbsp;</p>\n\n\n\n<p>This release candidate is an addition to the existing WordPress 6.5 release cycle. It allows more time for testing to ensure every feature and improvement is in the best shape possible.&nbsp;</p>\n\n\n\n<p>The updated target for the WordPress 6.5 release is <strong>April 2, 2024</strong>. Get an overview of the <a href=\"https://make.wordpress.org/core/6-5/\">6.5 release cycle</a>, and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-5/\">6.5-related posts</a> for further details.&nbsp;If you’re looking for more detailed technical notes on new features and improvements, the <a href=\"https://make.wordpress.org/core/2024/03/15/wordpress-6-5-field-guide/\">WordPress 6.5 Field Guide</a> is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What to expect in WordPress 6.5 RC4</h2>\n\n\n\n<p>There’s been a lot of helpful feedback regarding one of this release’s highlighted features: the Font Library. This has resulted in some <a href=\"https://make.wordpress.org/core/2024/03/25/wordpress-6-5-release-delayed-1-week/\">additional improvements needed</a> to make sure the greatest number of sites possible can benefit from this anticipated new feature.&nbsp;</p>\n\n\n\n<p>This release also includes six<strong> </strong>bug fixes for the Editor and 10+ <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=03%2F13%2F2024..03%2F19%2F2024&amp;resolution=fixed&amp;milestone=6.5&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">tickets for WordPress Core</a>. For more technical information related to issues addressed since RC3, you can browse the following links: </p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.5?since=2024-03-20&amp;until=2024-03-28\">GitHub commits for 6.5</a>&nbsp;</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=03%2F20%2F2024..03%2F28%2F2024&amp;resolution=fixed&amp;milestone=6.5&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Closed </a><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=03%2F13%2F2024..03%2F19%2F2024&amp;resolution=fixed&amp;milestone=6.5&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Trac</a><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=03%2F20%2F2024..03%2F28%2F2024&amp;resolution=fixed&amp;milestone=6.5&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\"> tickets</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">How to test</h2>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>.<strong> Please do not install, run, or test this version of WordPress on production or mission-critical websites.</strong> Instead, it’s recommended that you evaluate RC4 on a test server and site.</p>\n\n\n\n<p>While release candidates are considered ready for release, testing remains crucial to ensure that everything in WordPress 6.5 is the best it can be.</p>\n\n\n\n<p>You can test WordPress 6.5 RC4 in four ways:</p>\n\n\n\n<figure class=\"wp-block-table\"><table><tbody><tr><th>Plugin</th><td>Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream).</td></tr><tr><th>Direct Download</th><td>Download the <a href=\"https://wordpress.org/wordpress-6.5-RC4.zip\">RC4 version (zip)</a> and install it on a WordPress website.</td></tr><tr><th>Command Line</th><td>Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command:<br><code>wp core update --version=6.5-RC</code>4</td></tr><tr><th>WordPress Playground</th><td>Use the <a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20[%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20]%20%7D\">6.5 RC4 WordPress Playground instance</a> (available within 35 minutes after the release is ready) to test the software directly in your browser without the need for a separate site or setup.</td></tr></tbody></table></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Here comes the haiku</h2>\n\n\n\n<p>With some extra time<br>Test, rinse, repeat, and refresh<br>WordPress will really shine</p>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post: <a href=\'https://profiles.wordpress.org/dansoschin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>dansoschin</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"17136\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.5 Release Candidate 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2024/03/wordpress-6-5-release-candidate-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 19 Mar 2024 16:19:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=17110\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:214:\"WordPress 6.5 RC3 is ready for download and testing. Reaching this phase of the release cycle is an important milestone. Check out what\'s coming in this release and how to get involved with the open source project.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Lauren Stein\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9078:\"\n<p>The third release candidate (RC3) for WordPress 6.5 is ready!&nbsp;</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>.<strong> Please do not install, run, or test this version of WordPress on production or mission-critical websites.</strong> Instead, it’s recommended that you evaluate RC3 on a test server and site.</p>\n\n\n\n<p>While release candidates are considered ready for release, testing remains crucial to ensure that everything in WordPress 6.5 is the best it can be.</p>\n\n\n\n<p>You can test WordPress 6.5 RC3 in four ways:</p>\n\n\n\n<figure class=\"wp-block-table\"><table><tbody><tr><th>Plugin</th><td>Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream).</td></tr><tr><th>Direct Download</th><td>Download the <a href=\"https://wordpress.org/wordpress-6.5-RC3.zip\">RC3 version (zip)</a> and install it on a WordPress website.</td></tr><tr><th>Command Line</th><td>Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command:<br><code>wp core update --version=6.5-RC</code>3</td></tr><tr><th>WordPress Playground</th><td>Use the <a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20[%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20]%20%7D\">6.5 RC3 WordPress Playground instance</a> (available within 35 minutes after the release is ready) to test the software directly in your browser without the need for a separate site or setup.</td></tr></tbody></table></figure>\n\n\n\n<p>The current target for the WordPress 6.5 release is <strong>March 26, 2024</strong>. Get an overview of the <a href=\"https://make.wordpress.org/core/6-5/\">6.5 release cycle</a>, and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-5/\">6.5-related posts</a> in the coming weeks for further details. </p>\n\n\n\n<p>If you’re looking for more detailed technical notes on new features and improvements, the <a href=\"https://make.wordpress.org/core/2024/03/15/wordpress-6-5-field-guide/\">WordPress 6.5 Field Guide</a> is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What to expect in WordPress 6.5 RC3</h2>\n\n\n\n<p>Thanks to the many contributors testing up to this point, this release includes 10+ bug fixes for the Editor and around 15 <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=03%2F13%2F2024..03%2F19%2F2024&amp;resolution=fixed&amp;milestone=6.5&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">tickets for WordPress Core</a>. For more technical information related to issues addressed since RC2, you can browse the following links:&nbsp;</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.5?since=2024-03-13&amp;until=2024-03-19\">GitHub commits for 6.5</a> </li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=03%2F13%2F2024..03%2F19%2F2024&amp;resolution=fixed&amp;milestone=6.5&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Closed Trac tickets</a> </li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute to this release</h2>\n\n\n\n<p>WordPress is open source software made possible by a passionate community of people collaborating on and contributing to its development. The resources below outline various ways you can help the world’s most popular open source web platform, regardless of your technical expertise.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Get involved in testing</h2>\n\n\n\n<p>Testing for issues is critical to ensuring WordPress is performant and stable. It’s also a meaningful way for anyone to contribute. <a href=\"https://make.wordpress.org/test/2024/02/28/help-test-wordpress-beta-3/\">This detailed guide</a> will walk you through testing features in WordPress 6.5. For those new to testing, follow <a href=\"https://make.wordpress.org/test/2024/02/15/help-test-wordpress-6-5-beta-1\">this general testing guide</a> for more details on getting set up.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Search for vulnerabilities</h3>\n\n\n\n<p>During the release candidate phase of WordPress 6.5, the <a href=\"https://make.wordpress.org/security/2024/02/12/welcoming-2024-with-wordpress-6-5-beta-1/\">monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled. Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the <a href=\"https://hackerone.com/wordpress\">HackerOne page</a> and in the <a href=\"https://wordpress.org/about/security/\">security white paper</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Update your theme or plugin</h3>\n\n\n\n<p>For plugin and theme authors, your products play an integral role in extending the functionality and value of WordPress for all users.&nbsp;</p>\n\n\n\n<p>Thanks for continuing to test your themes and plugins with the WordPress 6.5 beta releases. With RC3, you’ll want to conclude your testing and update the <em>“Tested up to”</em> version in your <a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\">plugin’s readme file</a> to 6.5.</p>\n\n\n\n<p>If you find compatibility issues, please post detailed information to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forum</a>.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">Help translate WordPress</h3>\n\n\n\n<p>Do you speak a language other than English? ¿Español? Français? Русский? 日本? हिन्दी? বাংলা? You can <a href=\"https://translate.wordpress.org/projects/wp/dev/\">help translate WordPress into more than 100 languages</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Release the haiku</h2>\n\n\n\n<p>Another RC<br>We are getting really close<br>Have you tested yet?</p>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post: <a href=\'https://profiles.wordpress.org/dansoschin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>dansoschin</a></em>, <em><a href=\'https://profiles.wordpress.org/audrasjb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>audrasjb</a></em>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"17110\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:61:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WP Briefing: Episode 75: WordCamp Asia 2024 Unwrapped\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/news/2024/03/episode-75-wordcamp-asia-2024-unwrapped/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 18 Mar 2024 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=17107\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:485:\"WordCamp Asia 2024 was a dynamic three-day celebration of collaboration, diversity, and innovation in the WordPress project. This week, Executive Director Josepha Haden Chomphosy shares her insights and experiences from the event, which featured one of the largest Contributor Days in the region, a variety of speakers, engaging panel discussions, and workshops. Josepha offers her thoughts on the latest topics being discussed within the community and forming the future of WordPress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:51:\"https://wordpress.org/news/files/2024/03/WPB075.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:12163:\"\n<p>WordCamp Asia 2024 was a dynamic three-day celebration of collaboration, diversity, and innovation in the WordPress project. This week, Executive Director Josepha Haden Chomphosy shares her insights and experiences from the event, which featured one of the largest Contributor Days in the region, a variety of speakers, engaging panel discussions, and workshops. Josepha offers her thoughts on the latest topics being discussed within the community and forming the future of WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Credits</h2>\n\n\n\n<p>Host:&nbsp;<a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden Chomphosy</a><br>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a><br>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a><br>Production:&nbsp;<a href=\"https://profiles.wordpress.org/bjmcsherry/\">Brett McSherry</a><br>Song: Fearless First by Kevin MacLeod</p>\n\n\n\n<h2 class=\"wp-block-heading\">Show Notes</h2>\n\n\n\n<ul>\n<li><a href=\"https://asia.wordcamp.org/2024/\">WordCamp Asia 2024</a>\n<ul>\n<li><a href=\"https://asia.wordcamp.org/2024/contributor-day/\">Contributor Day</a></li>\n\n\n\n<li><a href=\"https://www.youtube.com/playlist?list=PL1pJFUVKQ7ETpYuALlCQPikuKEuihFsvU\">WordCamp Asia Playlist</a></li>\n</ul>\n</li>\n\n\n\n<li><strong>Small List of Big Things</strong>\n<ul>\n<li><a href=\"https://wordpress.org/news/category/releases/\" target=\"_blank\" rel=\"noreferrer noopener\">WordPress 6.5</a> is on target for release on&nbsp;March 26, 2024.</li>\n\n\n\n<li>Get involved with WordPress events:\n<ul>\n<li>Find events near you on <a href=\"https://events.wordpress.org/\">events.WordPress.org</a> and <a href=\"https://central.wordcamp.org/\">WordCamp Central</a></li>\n\n\n\n<li>Learn more about <a href=\"https://events.wordpress.org/organize-an-event/\">organizing your own local event</a></li>\n</ul>\n</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/community/2024/03/06/proposal-non-editable-footer-for-all-event-website-pages/\" target=\"_blank\" rel=\"noreferrer noopener\">Proposal: Non-editable Footer for all Event Website Pages</a></li>\n</ul>\n</li>\n\n\n\n<li>Have a question you&#8217;d like answered? Submit them to <a href=\"mailto:wpbriefing@WordPress.org\">WPBriefing@WordPress.org</a>.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Transcript</h2>\n\n\n\n<span id=\"more-17107\"></span>\n\n\n\n<p>[00:00:00]&nbsp;<strong>Josepha:</strong>&nbsp;Hello, everyone, and welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks. I’m your host, Josepha Haden Chomphosy. Here we go.&nbsp;</p>\n\n\n\n<p>[00:00:29] (Intro music)&nbsp;</p>\n\n\n\n<p>[00:00:40]&nbsp;<strong>Josepha:</strong> I have returned from WordCamp Asia and struggled my way through some truly aggressive jet lag, so that means it&#8217;s time for a little WordCamp wrap-up. I spoke with a couple hundred people at the event, and I came away with a few topics that seemed to be on everyone&#8217;s minds. Those topics are: making business in WordPress, the business of making WordPress, and how to communicate both sides a little better.</p>\n\n\n\n<p>[00:01:04] <strong>Josepha:</strong> So first, let&#8217;s start with making business in WordPress. This comes up at every event, and that honestly just makes sense. WordPress is a tool that people use to power their businesses across our global economy, and sometimes the businesses are closely related to WordPress itself. They are creating custom themes or plugins, building WordPress powered commerce sites for clients, or offering any number of agency services. But there are also businesses that are a little less close: restaurants, museums, local governments, schools. But it was clear that they all rely on the software just as much as the other.</p>\n\n\n\n<p>So, it was nice to see some sessions that focused specifically on business matters in WordPress. And I heard so many people tell me about a conversation they had had earlier in the day with someone who helped them figure out their pricing or advised them on early errors they made in their business journey and generally helped them feel a little less lost.</p>\n\n\n\n<p>I always love seeing this. Hearing how people are accomplishing their goals because of connections they made at one of our events, it&#8217;s enough to keep me coming back for years.</p>\n\n\n\n<p>[00:02:10] <strong>Josepha:</strong> The next thing that came up a lot was the business of making WordPress. I don&#8217;t know if that came up a lot because of the sorts of conversations that people are willing to bring to me these days or because there was overwhelming interest in knowing how we keep all these trains on their tracks. But either way, it was refreshing to be able to have so many conversations about the invisible work that goes into a project like this. There was a Contributor Day that hosted over 600 people, if I recall correctly, which makes it the largest Contributor Day in the area to date. 35 percent of those people had never attended a Contributor Day before, so there were a lot of people who were discovering the WordPress community for the first time.</p>\n\n\n\n<p>And for folks who&#8217;ve been here for a long time, it&#8217;s so easy for us to forget how much there is to learn at first. Even if you happen to show up with a skill set that fits a contributor team&#8217;s needs exactly, you still have to learn where we collaborate, how distributed contribution works, and all these rules and guidelines about open source freedoms and copyleft.</p>\n\n\n\n<p>[00:03:10] <strong><strong>Josepha</strong>:</strong> And then also you have to come to terms with the fact that we define and design all of our spaces and programs with belonging in mind. I mean, for every one question that you get answered, there are going to be six new ones that you didn&#8217;t know you had yet. So I came away from a lot of these conversations with the reminder that it&#8217;s important in so many ways for us to talk about the work that we do, even when it&#8217;s boring, even when we think it doesn&#8217;t really matter, because a lot of people have questions about how this works, how it runs, and how they can be part of making sure that it&#8217;s around for the long-term.</p>\n\n\n\n<p>And the final thing that came up all over the place last week was how to communicate these things better. It&#8217;s easy to forget that folks who listen to this podcast don&#8217;t actually make up like a hundred percent of the people using WordPress; that&#8217;s on me. So just cause I&#8217;ve said here that, you know, enterprise is our next big space for biz dev or that, our primary growth markets are APAC, or that events are our best tool for brand expression.</p>\n\n\n\n<p>[00:04:08] <strong><strong>Josepha</strong>:</strong> Like, just because I said it doesn&#8217;t mean that everyone heard it. And we absolutely have to get those messages to more people, more frequently, and with more certainty. You&#8217;ll hear often from WordPress pundits that rising tides lift all boats, and the bigger the pie, the more the slices. We believe fully in the spirit of coopetition here, that we are all better together.</p>\n\n\n\n<p>But I can&#8217;t shake the feeling that we&#8217;re mostly just talking to ourselves about it. It&#8217;s hard to get outside our own little bubble, but I believe completely that doing so is the best thing for our project in the long term. Not only so that we can continue to grow and provide access to the opportunities we know we offer but also so that we can do more to dignify our profession.</p>\n\n\n\n<p>WordPress developers are not taken seriously, and yet you all are some of the smartest and most compassionate people I&#8217;ve ever met in my career. And I&#8217;d like to see how we can fix that perception together. And so that&#8217;s it. Those are the big, big, giant, old topics that came up a lot in conversation last week.</p>\n\n\n\n<p>[00:05:14] <strong><strong>Josepha</strong>:</strong> Don&#8217;t forget that you can catch up on all the sessions via the live stream, or if you are feeling inspired to contribute, reach out to the community team and see what sorts of meetup events you can host.&nbsp;</p>\n\n\n\n<p>[00:05:24] (Music interlude)&nbsp;</p>\n\n\n\n<p>[00:05:32] <strong><strong>Josepha</strong>:</strong> Which brings us now to our small list of big things. I have two big things and one slightly less big thing, but they&#8217;re all fairly big.</p>\n\n\n\n<p>So, the first thing on the list is that the latest version of WordPress, WordPress 6.5, is on target for release on March 26th. That&#8217;s, I think, a couple weeks from now. So keep an eye out for that. In the event, I mean, we have auto-updates everywhere, and probably you are on a WordPress-specific host and, so you won&#8217;t necessarily need to do anything. But if you have any desire or concerns about seeing the software a little bit ahead of time, you can always go and download the beta, give it a quick test or the release candidate, give that a quick test. See if there&#8217;s anything that&#8217;s not functioning as you expected it to function, and let us know if it&#8217;s not. But yeah, there are auto-updates. You don&#8217;t have to go out and proactively do anything if you don&#8217;t want to, that&#8217;s just in case you do want to. That&#8217;s coming up March 26th.&nbsp;</p>\n\n\n\n<p>[00:06:27] <strong><strong>Josepha</strong>:</strong> The next thing is that I want to give everybody a general call-in for event contribution. So, WordPress events is where I entered the community. It is one of the most affirming and life-changing types of contribution I&#8217;ve ever done because you get to see a bunch of people succeed in their own goals because of something that you were able to tell them. It&#8217;s like teaching, but with people who elected to be there. So we have a lot of opportunities, for contribution by volunteering at events, either as volunteering at the event itself or to volunteer to organize it. We have small-scale, easy-to-do meetups, but we also have slightly larger WordCamps that can be done. If you have any hope for doing that or are just kind of interested. I&#8217;ll leave a link for you in the show notes.&nbsp;</p>\n\n\n\n<p>[00:07:19] <strong><strong>Josepha</strong>:</strong> And then the final thing on here is that we actually have a pretty substantial proposal out at the moment. It&#8217;s for non-editable footers on all event website pages. This might not sound interesting to you, but it actually is kind of interesting. So, it&#8217;s been proposed to add a non-editable footer to all of the event website pages moving forward. So that&#8217;s everything that would be displayed on a WordCamp or on any of the new formatted event sites that we have. This proposal intends to meet two goals. One, it fills any legal requirements a site or country might have about displaying the privacy policy and other items. And two, it brings visibility to the new events.WordPress.org website, where a community member can find more events in their area.&nbsp;The last day to respond to that proposal is March 20th, which I think is two days from now. I think it&#8217;s on Wednesday and this is airing on Monday. So, I&#8217;ll have a link to that in the show notes as well in case you have any thoughts about it.</p>\n\n\n\n<p>[00:08:15] <strong><strong>Josepha</strong>:</strong> And that, my friends, is your small list of big things. Don&#8217;t forget to follow us on your favorite podcast app or subscribe directly on WordPress.org/news. You&#8217;ll get a friendly reminder whenever there&#8217;s a new episode. And if you like what you heard today, share it with a fellow WordPresser. Or, if you ended up with questions about what you heard, you can share those with me at WPBriefing@WordPress.org. I&#8217;m your host, Josepha Haden Chomphosy. Thanks for tuning in today for the WordPress Briefing, and I&#8217;ll see you again in a couple of weeks. </p>\n\n\n\n<p>[00:08:43] (Music outro)&nbsp;</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"17107\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.5 Release Candidate 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2024/03/wordpress-6-5-release-candidate-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 12 Mar 2024 16:58:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=17053\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:185:\"WordPress 6.5 RC2 is ready for download and testing. Reaching this phase of the release cycle is an important milestone. Check out what\'s coming in this release and how to get involved.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Lauren Stein\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9625:\"\n<p>The second release candidate (RC2) for WordPress 6.5 is ready!&nbsp;</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>.<strong> Please do not install, run, or test this version of WordPress on production or mission-critical websites.</strong> Instead, it’s recommended that you evaluate RC2 on a test server and site.</p>\n\n\n\n<p>While release candidates are considered ready for release, testing remains crucial to ensure that everything in WordPress 6.5 is the best it can be.</p>\n\n\n\n<p>You can test WordPress 6.5 RC2 in four ways:</p>\n\n\n\n<figure class=\"wp-block-table\"><table><tbody><tr><th>Plugin</th><td>Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream).</td></tr><tr><th>Direct Download</th><td>Download the <a href=\"https://wordpress.org/wordpress-6.5-RC2.zip\">RC2 version (zip)</a> and install it on a WordPress website.</td></tr><tr><th>Command Line</th><td>Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command:<br><code>wp core update --version=6.5-RC</code>2</td></tr><tr><th>WordPress Playground</th><td>Use the <a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20[%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20]%20%7D\">6.5 RC2 WordPress Playground instance</a> (available within 35 minutes after the release is ready) to test the software directly in your browser without the need for a separate site or setup.</td></tr></tbody></table></figure>\n\n\n\n<p>The current target for the WordPress 6.5 release is <strong>March 26, 2024</strong>. That’s a mere two weeks away! Get an overview of the <a href=\"https://make.wordpress.org/core/6-5/\">6.5 release cycle</a>, and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-5/\">6.5-related posts</a> in the coming weeks for further details.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What to expect in WordPress 6.5 RC2</h2>\n\n\n\n<p>Thanks to the many contributors testing up to this point, this release includes approximately 20 bug fixes for the Editor and 30+ <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=03%2F05%2F2024..03%2F12%2F2024&amp;resolution=fixed&amp;milestone=6.5&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">tickets for WordPress Core</a>. For more technical information related to issues addressed since RC1, you can browse the following links:&nbsp;</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.5?since=2024-03-05&amp;until=2024-03-12\">GitHub commits for 6.5</a> since March 5</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=03%2F05%2F2024..03%2F12%2F2024&amp;resolution=fixed&amp;milestone=6.5&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Closed Trac tickets</a> since March 5</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Update on content overrides for synced patterns</h3>\n\n\n\n<p>As synced patterns evolve and improve, every enhancement must continue to provide the best experience possible. With this in mind, WordPress 6.5 <a href=\"https://make.wordpress.org/core/2024/03/07/unblocking-wp6-5-font-library-and-synced-pattern-overrides/\">will not include the ability to override content in synced patterns</a>. This allows more time for feedback and testing to ensure it can really shine. Expect this feature to debut in the next major release!</p>\n\n\n\n<h2 class=\"wp-block-heading\">Contribute to this release</h2>\n\n\n\n<p>WordPress is open source software made possible by a passionate community of people collaborating on and contributing to its development. The resources below outline various ways you can help the world’s most popular open source web platform, regardless of your technical expertise.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get involved in testing</h3>\n\n\n\n<p>Testing for issues is critical to ensuring WordPress is performant and stable. It’s also a meaningful way for anyone to contribute. <a href=\"https://make.wordpress.org/test/2024/02/28/help-test-wordpress-beta-3/\">This detailed guide</a> will walk you through testing features in WordPress 6.5. For those new to testing, follow <a href=\"https://make.wordpress.org/test/2024/02/15/help-test-wordpress-6-5-beta-1\">this general testing guide</a> for more details on getting set up.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Search for vulnerabilities</h3>\n\n\n\n<p>From now until the final release candidate of WordPress 6.5 (scheduled for March 19), the <a href=\"https://make.wordpress.org/security/2024/02/12/welcoming-2024-with-wordpress-6-5-beta-1/\">monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled. Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the <a href=\"https://hackerone.com/wordpress\">HackerOne page</a> and in the <a href=\"https://wordpress.org/about/security/\">security white paper</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Update your theme or plugin</h3>\n\n\n\n<p>For plugin and theme authors, your products play an integral role in extending the functionality and value of WordPress for all users.&nbsp;</p>\n\n\n\n<p>Thanks for continuing to test your themes and plugins with the WordPress 6.5 beta releases. With RC1, you’ll want to conclude your testing and update the <em>“Tested up to”</em> version in your <a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\">plugin’s readme file</a> to 6.5.</p>\n\n\n\n<p>If you find compatibility issues, please post detailed information to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forum</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Help translate WordPress</h3>\n\n\n\n<p>Do you speak a language other than English? ¿Español? Français? Русский? 日本? हिन्दी? বাংলা? You can <a href=\"https://translate.wordpress.org/projects/wp/dev/\">help translate WordPress into more than 100 languages</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Release the haiku</h2>\n\n\n\n<p>RC2, a bridge,<br>From development to launch,<br>One more step forward.<br>&#8211; <em>submitted by <a href=\'https://profiles.wordpress.org/huzaifaalmesbah/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>huzaifaalmesbah</a></em></p>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post: <a href=\"https://profiles.wordpress.org/dansoschin/\">@dansoschin</a></em>, <a href=\"https://profiles.wordpress.org/get_dave/\">@get_dave</a>, and <a href=\"https://profiles.wordpress.org/audrasjb/\">@audrasjb</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"17053\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"Highlights from WordCamp Asia 2024\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/news/2024/03/highlights-from-wordcamp-asia-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 09 Mar 2024 13:39:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=17064\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:268:\"Over 1,300 attendees gathered at the Taipei International Convention Center in Taiwan for WordCamp Asia 2024. The three-day event emerged as a vibrant celebration showcasing the collaboration, diversity, and innovation that drive the world\'s most popular web platform.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Reyes Martínez\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7233:\"\n<p>Over 1,300 attendees gathered at the Taipei International Convention Center in Taiwan for <a href=\"https://asia.wordcamp.org/2024/\">WordCamp Asia 2024</a>. This three-day event emerged as a vibrant celebration showcasing the collaboration, diversity, and innovation that drive the world&#8217;s most popular web platform.</p>\n\n\n\n<p>The Asian WordPress flagship event started with a dedicated Contributor Day, followed by two days of engaging talks, panels, hands-on workshops, and networking. Notable guests, including WordPress Cofounder <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> and Executive Director <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden Chomphosy</a>, joined the diverse lineup of <a href=\"https://asia.wordcamp.org/2024/speakers/\">speakers</a>. Popular topics featured cutting-edge web technologies and trends, use cases, open source dynamics, and more. WordPress enthusiasts seized the opportunity to gain insights from international and local industry experts and to learn about the project&#8217;s future.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Converting walled gardens into community gardens</h2>\n\n\n\n<p>On March 8, Josepha Haden Chomphosy <a href=\"https://www.youtube.com/live/UK7FnaEeTrU?si=0H6eEEijj4tDWm_t&amp;t=30830\">took the stage</a> for an insightful journey comparing and contrasting the “walled” and “community” gardens in software ecosystems, drawing an analogy between closed and open source platforms. After exploring both concepts, she posed an important question to the audience.</p>\n\n\n\n<div style=\"height:2px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>What would it take for someone to move from a walled garden to a community garden?</p>\n</blockquote>\n\n\n\n<div style=\"height:2px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p>Open source software, symbolized by community gardens, represents freedom from copyright restrictions and usage limitations. Unlike proprietary software (described as walled gardens), the core value lies in long-term empowerment, giving people control and ownership of their digital presence.</p>\n\n\n\n<p>Acknowledging the longstanding values held by WordPress and its open source community for two decades, Josepha focused on the importance of caring for foundations that make us strong, managing what distracts us, and nurturing growth by embracing new opportunities. She celebrated the strengths of the WordPress community and how its shared ethos furthers a thriving ecosystem.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/03/wcasia-slide.png?resize=1024%2C576&#038;ssl=1\" alt=\"Slide from Josepha Haden Chomphosy\'s presentation showing colorful flowers on a blue background and the quote, &quot;To plant a garden is to believe in tomorrow&quot; by Audrey Hepburn.\" class=\"wp-image-17066\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/03/wcasia-slide.png?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/03/wcasia-slide.png?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/03/wcasia-slide.png?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/03/wcasia-slide.png?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/03/wcasia-slide.png?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>Quoting artist and activist Audrey Hepburn, Josepha expressed that, much like a community garden, the power of contributions—whether through time, knowledge, or product use— sustains and maintains shared spaces like WordPress.</p>\n\n\n\n<p>In the <a href=\"https://www.youtube.com/live/UK7FnaEeTrU?si=pjg0nkwla-d7mP69&amp;t=32274\">Q&amp;A portion</a> of her presentation, Josepha addressed inquiries about community involvement and contributions. Highlighted resources included the <a href=\"https://jobs.wordpress.net/\">WordPress job board</a> for opportunities within the ecosystem and the <a href=\"https://wordpress.org/data-liberation/\">Data Liberation</a> project, emphasizing its role in fostering a more open web and helping the transition out of proprietary platforms.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Q&amp;A with Matt Mullenweg</h2>\n\n\n\n<p>WordCamp Asia concluded with a live audience Q&amp;A session featuring WordPress Cofounder Matt Mullenweg. Attendees gained insights into the future of WordPress, including ongoing projects like <a href=\"https://wordpress.org/data-liberation/\">Data Liberation</a>, <a href=\"https://make.wordpress.org/community/handbook/wordcamp-organizer/first-steps/inclusive-and-welcoming-events/community-inclusion-initiatives/\">community inclusion initiatives</a>, artificial intelligence (AI), and more.</p>\n\n\n\n<p>The atmosphere was filled with excitement when Matt revealed that this year’s State of the Word will take place in Tokyo, Japan, on December 16, 2024.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" class=\"youtube-player\" width=\"600\" height=\"338\" src=\"https://www.youtube.com/embed/EOF70YJLC5U?version=3&#038;rel=1&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;fs=1&#038;hl=en-US&#038;autohide=2&#038;wmode=transparent\" allowfullscreen=\"true\" style=\"border:0;\" sandbox=\"allow-scripts allow-same-origin allow-popups allow-presentation allow-popups-to-escape-sandbox\"></iframe>\n</div></figure>\n\n\n\n<p>Additional questions from this session will be addressed in an upcoming post on the <a href=\"https://make.wordpress.org/project/\">Make WordPress Project blog</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Stay connected</h2>\n\n\n\n<p><a href=\"https://events.wordpress.org/\">WordPress events</a> enable technologists, open source enthusiasts, and community members around the globe to meet, share ideas, and collaborate to drive WordPress and the open web forward.</p>\n\n\n\n<p>Don’t forget to mark your calendars for <a href=\"https://europe.wordcamp.org/2024/\">WordCamp Europe</a> (Torino, Italy), <a href=\"https://us.wordcamp.org/2024/\">WordCamp US</a> (Portland, Oregon, United States), and next year’s <a href=\"https://asia.wordcamp.org/2025/\">WordCamp Asia</a> in Manila, Philippines!</p>\n\n\n\n<p><em>Thank you to the <a href=\"https://asia.wordcamp.org/2024/\">WordCamp Asia</a> organizers, volunteers, and sponsors who made this event possible, and to <a href=\'https://profiles.wordpress.org/angelasjin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>angelasjin</a>, <a href=\'https://profiles.wordpress.org/dansoschin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>dansoschin</a>, <a href=\'https://profiles.wordpress.org/eidolonnight/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>eidolonnight</a>, <a href=\'https://profiles.wordpress.org/bjmcsherry/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>bjmcsherry</a> for collaborating on this post.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"17064\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"The Month in WordPress – February 2024\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wordpress.org/news/2024/03/the-month-in-wordpress-february-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Mar 2024 13:20:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:18:\"month in wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=17030\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:358:\"February saw significant progress towards the upcoming WordPress 6.5 release and final preparations for WordCamp Asia. The results of the annual WordPress survey were released, and discussions began on the next steps for the Data Liberation project. Read on for the latest happenings in the WordPress space. Get ready for WordCamp Asia The stage is [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Reyes Martínez\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:12384:\"\n<p>February saw significant progress towards the upcoming WordPress 6.5 release and final preparations for WordCamp Asia. The results of the annual WordPress survey were released, and discussions began on the next steps for the Data Liberation project. Read on for the latest happenings in the WordPress space.</p>\n\n\n\n<div style=\"height:3px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Get ready for WordCamp Asia</h2>\n\n\n\n<p>The stage is ready for the first WordPress flagship event of the year in Taipei, Taiwan. WordCamp Asia 2024 will kick off on March 7, promising three days of learning, networking, and inspiration.</p>\n\n\n\n<p><a href=\"https://asia.wordcamp.org/2024/schedule/\">This year’s schedule</a> features an extensive lineup of speakers, including guests <a href=\"https://asia.wordcamp.org/2024/speaker/josepha-haden-chomphosy/\">Josepha Haden Chomphosy</a>, <a href=\"https://asia.wordcamp.org/2024/speaker/ben-thompson/\">Ben Thompson</a>, <a href=\"https://asia.wordcamp.org/2024/speaker/noel-tock/\">Noel Tock</a>, and <a href=\"https://asia.wordcamp.org/2024/speaker/ju-chun-ko/\">JU-CHUN KO</a>. To conclude the summit, attendees can engage with WordPress co-founder <a href=\"https://asia.wordcamp.org/2024/speaker/matt-mullenweg/\">Matt Mullenweg</a> in a Q&amp;A session. <a href=\"https://wordpress.org/news/2024/03/wordcamp-asia-2024-qa-with-matt-mullenweg/\">Find out how to submit your questions</a>.</p>\n\n\n\n<p>Can’t make it to Taipei? Watch the event live stream on the <a href=\"https://www.youtube.com/wordpress\">WordPress YouTube channel</a>.</p>\n\n\n\n<div style=\"height:3px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<a class=\"wp-block-jetpack-podcast-player jetpack-podcast-player__direct-link\" href=\"https://wordpress.org/news/2023/10/episode-64-patterns-in-wordpress/\">https://wordpress.org/news/2023/10/episode-64-patterns-in-wordpress/</a>\n\n\n\n<div style=\"height:3px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Countdown to WordPress 6.5</h2>\n\n\n\n<p>WordPress 6.5 is on track for its much-anticipated release on March 26. Following last month’s beta releases, the <a href=\"https://wordpress.org/news/2024/03/wordpress-6-5-release-candidate-1/\">first release candidate (RC1)</a> is now available for testing—marking another milestone in the development cycle.</p>\n\n\n\n<p>This major release will add finesse and fine-tuning to how you control your site-building experience, with lots to explore specifically for developers. Get a detailed overview of highlighted features in the <a href=\"https://wordpress.org/news/2024/02/wordpress-6-5-beta-1/\">Beta 1 announcement</a>.</p>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Stay on top of the latest updates in WordPress development with <a href=\"https://developer.wordpress.org/news/2024/02/10/whats-new-for-developers-february-2024/\">February’s edition of What’s New for Developers?</a></p>\n</blockquote>\n\n\n\n<div style=\"height:3px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">New in the Gutenberg plugin</h2>\n\n\n\n<p>Two new versions of Gutenberg shipped in February:</p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2024/02/14/whats-new-in-gutenberg-17-7-14th-february/\"><strong>Gutenberg 17.7</strong></a> introduced multiple performance improvements, refinements to the link control UI, and shadow support for more blocks, among other notable highlights.</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/02/28/whats-new-in-gutenberg-17-8-28-february/\"><strong>Gutenberg 17.8</strong></a> focused on stability updates. New features included a grid layout variation for the Group block, bulk export of patterns, and the ability to browse and try alternative templates from the editor’s sidebar.</li>\n</ul>\n\n\n\n<div class=\"wp-block-media-text is-stacked-on-mobile has-off-white-2-background-color has-background\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;grid-template-columns:57% auto\"><figure class=\"wp-block-media-text__media\"><a href=\"https://make.wordpress.org/core/2024/02/10/core-editor-improvement-power-in-the-details/\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/03/Core-Editor-Improvement-Power-in-the-Details-Featured-Image.png?resize=1024%2C576&#038;ssl=1\" alt=\"Decorative blue background with text &quot;Core Editor Improvement: Power in the Details.&quot;\" class=\"wp-image-17031 size-full\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/03/Core-Editor-Improvement-Power-in-the-Details-Featured-Image.png?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/03/Core-Editor-Improvement-Power-in-the-Details-Featured-Image.png?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/03/Core-Editor-Improvement-Power-in-the-Details-Featured-Image.png?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/03/Core-Editor-Improvement-Power-in-the-Details-Featured-Image.png?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/03/Core-Editor-Improvement-Power-in-the-Details-Featured-Image.png?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></a></figure><div class=\"wp-block-media-text__content\">\n<p>Beyond major features, many small yet mighty updates are coming in WordPress 6.5 that will make a big difference in your WordPress experience. <a href=\"https://make.wordpress.org/core/2024/02/10/core-editor-improvement-power-in-the-details/\">Read more »</a></p>\n</div></div>\n\n\n\n<div style=\"height:3px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Team updates</h2>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.org/news/2024/02/2023-annual-survey-results-and-next-steps/\">Results of the 2023 annual WordPress survey</a> were announced last month.</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/02/19/data-liberation-next-steps/\">An update on the Data Liberation project</a> informs the next steps of this initiative and how to contribute to current conversations.</li>\n\n\n\n<li>The Community team shared <a href=\"https://make.wordpress.org/community/2024/02/09/2023-wordpress-meetup-survey-key-findings/\">key findings from the 2023 WordPress meetup survey</a>.</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/community/2024/02/16/contributor-mentorship-program-second-cohort-2024-q1/\">Meet the new cohort</a> of the Contributor Mentorship Program.</li>\n\n\n\n<li>The Photos team posted <a href=\"https://make.wordpress.org/photos/2024/02/02/alt-text-for-wordpress-photos/\">recommendations for improving alternative texts</a> when submitting images to the Photo Directory.</li>\n\n\n\n<li>Following discussions on the evolution of the Outreach Program, a <a href=\"https://make.wordpress.org/core/2024/02/27/connect-with-the-github-outreach-group-to-request-feedback-or-further-testing/\">new outreach group</a> has been created on GitHub. This group will provide expertise and feedback to those seeking additional testing or perspectives on a new feature or solution.</li>\n\n\n\n<li>Core team members introduced the <a href=\"https://make.wordpress.org/core/2024/02/22/introducing-the-wordpress-core-trac-sustainability-focus/\">WordPress Core Trac Sustainability Focus</a>, a part of the Sustainability team&#8217;s effort to enhance the sustainability of the WordPress codebase.</li>\n\n\n\n<li>A new release of WP-CLI is <a href=\"https://make.wordpress.org/cli/2024/02/08/wp-cli-v2-10-0-release-notes/\">now available</a>.</li>\n\n\n\n<li>Learn WordPress is regularly updated with new tutorials, online workshops, and more learning resources. <a href=\"https://learn.wordpress.org/learn-wordpress-newsletter-march-2024/\">Check out what’s new</a>.</li>\n\n\n\n<li>The latest edition of People of WordPress features <a href=\"https://wordpress.org/news/2024/02/people-of-wordpress-sunita-rai/\">Sunita Rai</a>, a content marketer and volunteer translator from Nepal.</li>\n</ul>\n\n\n\n<div style=\"height:3px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<a class=\"wp-block-jetpack-podcast-player jetpack-podcast-player__direct-link\" href=\"https://wordpress.org/news/2023/10/episode-64-patterns-in-wordpress/\">https://wordpress.org/news/2023/10/episode-64-patterns-in-wordpress/</a>\n\n\n\n<div style=\"height:3px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Requests for feedback and testing</h2>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.org/news/2024/03/wordpress-6-5-release-candidate-1/\">Your help testing WordPress 6.5</a> is key to ensuring everything in this release is the best it can be. New to testing? <a href=\"https://make.wordpress.org/test/2024/02/15/help-test-wordpress-6-5-beta-1/\">Read this post</a> for more details on getting set up.</li>\n\n\n\n<li>The Training team is discussing <a href=\"https://make.wordpress.org/training/2024/02/20/discussion-bringing-accessibility-first-approaches-into-content-development/\">how to bring accessibility-first approaches</a> into their content creation and processes. Feedback is open until March 9.</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2024/02/27/mobile-team-update-february-26th-2/\">Version 24.3</a> of the WordPress mobile app for iOS and Android is ready for testing.</li>\n</ul>\n\n\n\n<div style=\"height:3px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">WordPress events</h2>\n\n\n\n<ul>\n<li>WordCamp Europe 2024 is <a href=\"https://europe.wordcamp.org/2024/call-for-photographers-is-now-open/\">looking for photographers</a>.</li>\n\n\n\n<li>The WordPress Kerala Photo Festival wrapped up with great success. The event received over <a href=\"https://wordpress.org/photos/t/wpkeralaphotos/\">1,500 images</a> from 163 participants, contributing to the Photo Directory passing the 15,000 photo milestone. Winners were announced <a href=\"https://events.wordpress.org/kerala/2024/photo-festival/winners-of-the-kerala-wordpress-photo-festival/\">in this post</a>.</li>\n\n\n\n<li>Don’t miss these other WordPress events happening soon:\n<ul>\n<li><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f1e8-1f1f7.png\" alt=\"🇨🇷\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://events.wordpress.org/sanjose/2024/women-wordpress-day/\">Women WordPress Day</a>, Costa Rica, on March 8</li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f1e8-1f1ed.png\" alt=\"🇨🇭\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://events.wordpress.org/switzerland/2024/community-day/\">Switzerland Community Day</a> on March 23</li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f1ea-1f1f8.png\" alt=\"🇪🇸\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://torrelodones.wordcamp.org/2024/\">WordCamp Torrelodones</a>, Spain, on March 23-24</li>\n</ul>\n</li>\n\n\n\n<li>Find out more local events or apply to organize one on the <a href=\"https://events.wordpress.org/\">Events page</a>.</li>\n</ul>\n\n\n\n<div style=\"height:1px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p><em><strong>Have a story we should include in the next issue of The Month in WordPress? Fill out </strong></em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><strong><em>this quick form</em></strong></a><em><strong> to let us know.</strong></em></p>\n\n\n\n<div class=\"wp-block-group is-layout-constrained wp-block-group-is-layout-constrained\">\n<h3 class=\"wp-block-heading\">Subscribe to WordPress News</h3>\n\n\n\n<p>Join other subscribers and receive WordPress news directly in your inbox.</p>\n\n\n<div class=\"wp-block-jetpack-subscriptions__supports-newline is-style-split wp-block-jetpack-subscriptions\">\n		<div>\n			<div>\n				<div>\n					<p >\n						<a href=\"https://wordpress.org/news/?post_type=post&#038;p=17030\" style=\"font-size: 16px;padding: 15px 23px 15px 23px;margin: 0px; margin-left: 10px;border-radius: 0px;border-width: 1px; background-color: #113AF5; color: #FFFFFF; text-decoration: none; white-space: nowrap; margin-left: 0\">Subscribe</a>\n					</p>\n				</div>\n			</div>\n		</div>\n	</div></div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"17030\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.5 Release Candidate 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2024/03/wordpress-6-5-release-candidate-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 05 Mar 2024 16:26:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=17008\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:185:\"WordPress 6.5 RC1 is ready for download and testing. Reaching this phase of the release cycle is an important milestone. Check out what\'s coming in this release and how to get involved.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Lauren Stein\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11482:\"\n<p>The first release candidate (RC1) for WordPress 6.5 is ready for download and testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>.<strong> Please do not install, run, or test this version of WordPress on production or mission-critical websites.</strong> Instead, it’s recommended that you evaluate RC1 on a test server and site.</p>\n\n\n\n<p>Reaching this phase of the release cycle is an important milestone. While release candidates are considered ready for release, testing remains crucial to ensure that everything in WordPress 6.5 is the best it can be.</p>\n\n\n\n<p>You can test WordPress 6.5 RC1 in four ways:</p>\n\n\n\n<figure class=\"wp-block-table\"><table><tbody><tr><th>Plugin</th><td>Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream).</td></tr><tr><th>Direct Download</th><td>Download the <a href=\"https://wordpress.org/wordpress-6.5-RC1.zip\">RC1 version (zip)</a> and install it on a WordPress website.</td></tr><tr><th>Command Line</th><td>Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command:<br><code>wp core update --version=6.5-RC1</code></td></tr><tr><th>WordPress Playground</th><td>Use the <a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20[%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20]%20%7D\">6.5 RC1 WordPress Playground instance</a> (available within 35 minutes after the release is ready) to test the software directly in your browser without the need for a separate site or setup.</td></tr></tbody></table></figure>\n\n\n\n<p>The current target for the WordPress 6.5 release is <strong>March 26, 2024</strong>. Get an overview of the <a href=\"https://make.wordpress.org/core/6-5/\">6.5 release cycle</a>, and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-5/\">6.5-related posts</a> in the coming weeks for further details.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s in WordPress 6.5 RC1?</h2>\n\n\n\n<p>Thanks to the many contributors testing up to this point, this release includes more than 20 bug fixes for the Editor and more than 40 <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=02%2F27%2F2024..03%2F05%2F2024&amp;milestone=6.5&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">tickets for WordPress Core</a>.</p>\n\n\n\n<p>Get a recap of WordPress 6.5’s highlighted features in the <a href=\"https://wordpress.org/news/2024/02/wordpress-6-5-beta-1/\">Beta 1 announcement</a>. For more technical information related to issues addressed since Beta 3, you can browse the following links:</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.5?since=2024-02-27&amp;until=2024-03-05\">GitHub commits for 6.5</a> since February 27</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=02%2F27%2F2024..03%2F05%2F2024&amp;milestone=6.5&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Closed Trac tickets</a> since February 27</li>\n</ul>\n\n\n\n<p>Want to look deeper into the details and technical notes for this release? These recent posts cover some of the latest updates:</p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2024/03/05/introducing-plugin-dependencies-in-wordpress-6-5/\" data-type=\"link\" data-id=\"https://make.wordpress.org/core/2024/03/05/introducing-plugin-dependencies-in-wordpress-6-5/\">Introducing Plugin Dependencies in WordPress 6.5</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/03/05/unification-of-the-site-and-post-editors-in-6-5/\" data-type=\"link\" data-id=\"https://make.wordpress.org/core/2024/03/05/unification-of-the-site-and-post-editors-in-6-5/\">Unification of the Site and Post Editors in 6.5</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/03/04/updates-to-the-html-api-in-6-5/\" data-type=\"link\" data-id=\"https://make.wordpress.org/core/2024/03/04/updates-to-the-html-api-in-6-5/\">Updates to the HTML API in 6.5</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/03/04/interactivity-api-dev-note/\" data-type=\"link\" data-id=\"https://make.wordpress.org/core/2024/03/04/interactivity-api-dev-note/\">Interactivity API in 6.5</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/02/27/i18n-improvements-6-5-performant-translations/\">I18N Improvements in 6.5 (Performant Translations)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/02/23/wordpress-6-5-adds-avif-support/\">WordPress 6.5 adds AVIF support</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/02/10/core-editor-improvement-power-in-the-details/\">Core Editor Improvement: Power in the Details</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/01/22/core-editor-improvement-robust-revisions-in-the-site-editor/\">Core Editor Improvement: Robust Revisions in the Site Editor</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/tag/dev-notes-6-5/\">All 6.5-related developer notes</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">How you can contribute</h2>\n\n\n\n<p>WordPress is open source software made possible by a passionate community of people collaborating on and contributing to its development. The resources below outline various ways you can help the world’s most popular open source web platform, regardless of your technical expertise.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get involved in testing</h3>\n\n\n\n<p>Testing for issues is critical to ensuring WordPress is performant and stable. It’s also a meaningful way for anyone to contribute. <a href=\"https://make.wordpress.org/test/2024/02/28/help-test-wordpress-beta-3/\">This detailed guide</a> will walk you through testing features in WordPress 6.5. For those new to testing, follow <a href=\"https://make.wordpress.org/test/2024/02/15/help-test-wordpress-6-5-beta-1\">this general testing guide</a> for more details on getting set up.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Search for vulnerabilities</h3>\n\n\n\n<p>From now until the final release candidate of WordPress 6.5 (scheduled for March 19), the <a href=\"https://make.wordpress.org/security/2024/02/12/welcoming-2024-with-wordpress-6-5-beta-1/\">monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled. Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the <a href=\"https://hackerone.com/wordpress\">HackerOne page</a> and in the <a href=\"https://wordpress.org/about/security/\">security white paper</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Update your theme or plugin</h3>\n\n\n\n<p>For plugin and theme authors, your products play an integral role in extending the functionality and value of WordPress for all users.&nbsp;</p>\n\n\n\n<p>Thanks for continuing to test your themes and plugins with the WordPress 6.5 beta releases. With RC1, you’ll want to conclude your testing and update the <em>“Tested up to”</em> version in your <a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\">plugin’s readme file</a> to 6.5.</p>\n\n\n\n<p>If you find compatibility issues, please post detailed information to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forum</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Help translate WordPress</h3>\n\n\n\n<p>Do you speak a language other than English? ¿Español? Français? Русский? 日本? हिन्दी? বাংলা? You can <a href=\"https://translate.wordpress.org/projects/wp/dev/\">help translate WordPress into more than 100 languages</a>. This release milestone (RC1) also marks the <a href=\"https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze\">hard string freeze</a> point of the 6.5 release cycle.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Release the haiku</h2>\n\n\n\n<p>What’s this? RC1?<br>Three weeks left until it’s done.<br>Come and test. It’s fun!</p>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post: <a href=\'https://profiles.wordpress.org/dansoschin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>dansoschin</a>,</em> <em><a href=\'https://profiles.wordpress.org/courane01/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>courane01</a>, <a href=\'https://profiles.wordpress.org/hellosatya/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>hellosatya</a>, <a href=\'https://profiles.wordpress.org/huzaifaalmesbah/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>huzaifaalmesbah</a></em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"17008\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordCamp Asia 2024: Q&amp;A with Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://wordpress.org/news/2024/03/wordcamp-asia-2024-qa-with-matt-mullenweg/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 04 Mar 2024 15:50:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:6:\"WCAsia\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=17015\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:261:\"WordCamp Asia 2024 is just a few days away—starting on March 7 in Taipei, Taiwan. This three-day summit will feature a distinguished lineup of speakers, numerous networking opportunities, and a closing Q&#38;A session with WordPress co-founder Matt Mullenweg.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Dan Soschin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3072:\"\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"299\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/03/wcasia-logo.png?resize=1024%2C299&#038;ssl=1\" alt=\"WordCamp Asia 2024\" class=\"wp-image-17016\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/03/wcasia-logo.png?resize=1024%2C299&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/03/wcasia-logo.png?resize=300%2C87&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/03/wcasia-logo.png?resize=768%2C224&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/03/wcasia-logo.png?resize=1536%2C448&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/03/wcasia-logo.png?resize=2048%2C597&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>WordCamp Asia 2024 is just a few days away—starting on March 7 in Taipei, Taiwan. This unique three-day summit will feature a distinguished lineup of speakers, numerous networking opportunities, and a closing Q&amp;A experience with WordPress co-founder Matt Mullenweg. The live Q&amp;A session will be streamed for WordPress enthusiasts worldwide, beginning at 3:30 p.m. Taipei Standard Time (7:30 a.m. UTC) on Saturday, March 9, 2024.</p>\n\n\n\n<p>Watch the event live stream on the <a href=\"https://youtube.com/wordpress\">WordPress YouTube channel</a> or visit the <a href=\"https://asia.wordcamp.org/2024/\">event website</a> for more details.</p>\n\n\n\n<p><strong>What:</strong> Q&amp;A Session with Matt Mullenweg<br><strong>When: </strong>March 9, 2024 at 7:30 a.m. UTC (Start of live stream)<br><strong>Where: </strong><a href=\"https://asia.wordcamp.org/2024/location/\">Taipei International Convention Center<br></a><strong>Streaming: </strong><a href=\"https://youtube.com/wordpress\">Watch the live stream</a> on the WordPress YouTube channel.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Have a question for Matt?</h2>\n\n\n\n<p>If you want to participate, please submit your question via Slido from March 7 until about 6:00 a.m. UTC on Friday, March 8. <em>Slido is now closed.</em></p>\n\n\n\n<p>Given the expected volume of submitted questions, only some will be answered live, while others will be covered in a follow-up post published after the event on <a href=\"https://make.wordpress.org/project\">make.wordpress.org/project</a>.</p>\n\n\n\n<p>See you in-person and online on March 7!</p>\n\n\n\n<p>谢谢!</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p><em>Thank you to <a href=\'https://profiles.wordpress.org/rmartinezduque/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rmartinezduque</a>, <a href=\'https://profiles.wordpress.org/eidolonnight/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>eidolonnight</a>, <a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a>, and <a href=\'https://profiles.wordpress.org/bjmcsherry/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>bjmcsherry</a> for reviewing this post.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"17015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:12:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sat, 06 Apr 2024 21:31:23 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:25:\"strict-transport-security\";s:12:\"max-age=3600\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Tue, 02 Apr 2024 20:18:01 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";s:14:\"20220125223029\";}","no");

INSERT IGNORE INTO `wp13_options` VALUES 
("24469","_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3","1712482283","no"),
("24470","_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3","1712439083","no"),
("24471","_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9","1712482283","no"),
("24472","_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:120:\"Gutenberg Times: WordPress 6.5, register Font collections, working with templates, or playground — Weekend Edition 290\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=28091\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"https://gutenbergtimes.com/wordpress-6-5-register-font-collections-working-with-templates-or-playground-weekend-edition-290/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:13157:\"<p>Howdy, </p>\n\n\n\n<p>This week, WordPress 6.5 certainly dominated the WordPress news cycle. Articles, Videos, Threads on X, and workshops are plenty available for every type of WordPress user. <a href=\"https://gutenbergtimes.com/about-wordpress-6-5-all-in-one-list/\">I compiled a separate list for your perusal or to point people to wandering about</a>.</p>\n\n\n\n<p>As a reader of this newsletter, you have kept up with all the changes, for sure. &nbsp;😍 The newsletter is a little shorter today, so enjoy the rest of the weekend. </p>\n\n\n\n<p>Yours, 💕<br /><em>Birgit</em></p>\n\n\n\n<p><em>PS: I am experimenting with AI summaries, I slightly edited, mostly for brevity.  The two pieces are marked. Please reach out to me, how you think about it&#8230; </em></p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/wordpress-6-5-register-font-collections-working-with-templates-or-playground-weekend-edition-290/#0-word-press-release-information\">Developing Gutenberg and WordPress</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/wordpress-6-5-register-font-collections-working-with-templates-or-playground-weekend-edition-290/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/wordpress-6-5-register-font-collections-working-with-templates-or-playground-weekend-edition-290/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/wordpress-6-5-register-font-collections-working-with-templates-or-playground-weekend-edition-290/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </a></li></ol>\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p>With the release, core contributors are starting to work on WordPress 6.6. <strong>Anne McCarthy</strong> invites you to a <a href=\"https://make.wordpress.org/core/2024/04/04/hallway-hangout-lets-chat-about-whats-next-in-gutenberg/\"><strong>Hallway Hangout: Let’s chat about what’s next in Gutenberg</strong></a>. The discussion/demos will cover Dataviews, synced pattern overrides, Zoomed out view, Grid layout, Pattern styles and Style inheritance. The virtual meeting will take place on <strong>April 24 at 23:00 UTC</strong> / 7 pm EDT / 4pm PDT.</p>\n\n\n<div class=\"ngl-articles colored ngl-articles-full ngl-articles-frontend\">\n\n	\n	<div class=\"ngl-articles-wrap ngl-articles-webview\">\n	\n						\n			<div class=\"ngl-article-mobile\">\n				<div width=\"100%\" border=\"0\">\n					<div>\n						<div valign=\"top\">\n							<div class=\"ngl-article-mob-wrap\">\n							<div class=\"ngl-article-featured\"><a href=\"https://gutenbergtimes.com/about-wordpress-6-5-all-in-one-list/\" target=\"_self\" rel=\"\"><img src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/04/Features-WordPress-6.5-scaled.jpeg?w=652&ssl=1\" /></a></div><div class=\"ngl-article-title\"><a href=\"https://gutenbergtimes.com/about-wordpress-6-5-all-in-one-list/\" target=\"_self\" rel=\"\"><span>About WordPress 6.5 &#8211; all in one list on blocks and site editor</span></a></div><div class=\"ngl-article-excerpt\">This week, WordPress 6.5 certainly dominated the WordPress news cycle. Articles, Videos, Threads on X, and workshops are plenty available for every type of WordPress user. This list of resources&hellip; <a href=\"https://gutenbergtimes.com/about-wordpress-6-5-all-in-one-list/\" class=\"ngl-article-read-more\" target=\"_self\">Read more.</a></div>							</div>\n						</div>\n					</div>\n				</div>\n			</div>\n			\n			\n			\n\n		\n		\n		</div>\n\n</div>\n\n\n<p class=\"has-accent-color has-light-background-background-color has-text-color has-background has-link-color wp-elements-b6fe42ed62408b6fe464d62777dc0282\">🎙️ Latest episode: <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-98/\">Gutenberg Changelog #98 – WordPress 6.5, Gutenberg 18.0 Community Theme Project and the Contributor Mentorship Program</a> with special guest Maggie Cabrera</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p><strong>Wes Theron</strong>, contributor to the training team, published a series of videos on  <strong>how to work with templates </strong>on YouTube </p>\n\n\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<div class=\"toolbelt-video-wrapper\"></div>\n</div>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<div class=\"toolbelt-video-wrapper\"></div>\n</div>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<div class=\"toolbelt-video-wrapper\"></div>\n</div>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<div class=\"toolbelt-video-wrapper\"></div>\n</div>\n\n\n\n<p>In his video, <a href=\"https://www.youtube.com/watch?v=ICMir7dO9M4\"><strong>WordPress Block Themes in 250 seconds</strong></a>, <strong>Jamie Marsland</strong> provides a concise but comprehensive overview of Block Themes in WordPress. He covers the basics of how Block Themes work, demonstrates their flexibility and ease of use, and explains how they differ from traditional WordPress themes by enabling users to have more control over their site&#8217;s design without needing to write code. Jamie also gives a quick tour of the WordPress editor with a Block Theme enabled, highlighting its features and capabilities. <em>(AI, slightly edited) </em></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p>Now the Font Library is part of WordPress, Justin Tadlock&#8217;s latest tutorial is on <a href=\"https://developer.wordpress.org/news/2024/04/01/how-to-register-custom-font-collections-for-the-font-library/\"><strong>How to register custom font collections for the Font Library</strong></a> with the built-in API. &#8220;By default, WordPress ships with a single collection that lets you install fonts from the Google Fonts library. But as a developer, you can offer a more curated experience by building custom collections.&#8221; he wrote.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In <em>WP Jukebox</em> podcast episode titled <a href=\"https://wptavern.com/podcast/114-tammie-lister-on-the-journey-through-design-and-theming\"><strong>Tammie Lister on the Journey Through Design and Theming</strong></a>, Tammie Lister discusses with <strong>Nathan Wrigley</strong> her experiences and the evolution of her career in design and WordPress theming. The conversation sheds light on the changing landscape of WordPress design, the introduction of new technologies, and how these shifts have influenced the approach to creating engaging and effective themes. Throughout the episode, Lister offers insights into her process and reflections on the future of design in the WordPress ecosystem. <em>(AI summary slightly edited for brevity)</em> </p>\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2024&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The previous years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a>&nbsp;|&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong>&nbsp;|&nbsp;<strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong>&nbsp;|&nbsp;<strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </h2>\n\n\n\n<p><strong>Jeremy Holcombe</strong> wrote a tutorial on <a href=\"https://kinsta.com/blog/headless-wordpress-gutenberg/\"><strong>How to parse Gutenberg content for headless WordPress</strong></a> and explained how to parse Gutenberg content as&nbsp;HTML&nbsp;using the&nbsp;WordPress REST API&nbsp;in a&nbsp;Next.js&nbsp;static site. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Artur Piszek</strong> shared a quick tip:  <a href=\"https://piszek.com/2024/03/19/get_comment_delimited_block_content/\"><strong>Writing serialized Gutenberg blocks in PHP</strong></a> on using the <code>get_comment_delimited_block_content</code> function. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><a href=\"https://wordpress.github.io/wordpress-playground/\"><em>WordPress Playground</em></a> is so much bigger than Blocks. It&#8217;s a fascinating, if not mind blowing tool for developers and product companies. Ronny Shani wrote an <a href=\"https://developer.wordpress.org/news/2024/04/05/introduction-to-playground-running-wordpress-in-the-browser/\"><strong>Introduction to Playground: running WordPress in the browser</strong></a>. She covers the basic some built-in features and how to create a blueprint. She also has plenty of examples and links to learn more for you.</p>\n\n\n\n<p>You can use Playground to test the <a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Gutenberg Nightly</a>. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his live stream, <strong>Ryan Welcher</strong>  worked on a playground blueprint to for a live preview of his plugin Advanced Query Loop. He used various methods, to add content to a Playground site: <a href=\"https://www.youtube.com/watch?v=Bz2INc3_yAw\"><strong>Using Playground to preview plugins | Gutenberg 18.0 Review</strong></a></p>\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Featured Image:  Elephant-cement-blocks by Pooja Derashri, <a href=\"https://wordpress.org/photos/photo/32765c4d4c/\">found on WordPress Photos</a></p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 06 Apr 2024 11:30:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"Gutenberg Times: About WordPress 6.5 – all in one list on blocks and site editor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=28104\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://gutenbergtimes.com/about-wordpress-6-5-all-in-one-list/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:17381:\"<p>This week, WordPress 6.5 certainly dominated the WordPress news cycle. Articles, Videos, Threads on X, and workshops are plenty available for every type of WordPress user. </p>\n\n\n\n<p>This list of resources if for all who need to dive deeper into certain aspects or have to field questions about the new release. I didn&#8217;t aim for completeness, I might have missed past publications for sure. If I did, feel free to email a link to pauli@gutenbergtimes.com. If you are seeking information not posted here, Anne McCarthy has you covered:</p>\n\n\n\n<p>📗 <strong>Anne McCarthy</strong> published the ultimate&nbsp;<a href=\"https://nomad.blog/2024/03/13/wordpress-6-5-source-of-truth/\"><strong>WordPress 6.5 Source of&nbsp;Truth</strong></a>&nbsp;for you. In this over 10,000-word opus, you’ll find the updates tagged for each group of WordPress users. They would be relevant to end users, theme or plugin authors, developers, site admins, and enterprises. For selective reading, you could use your browser’s “Find on page” feature and search for these tags. McCarthy lists 15 priority items, with an array of 26 sub-items, and then another 23 additional items, and closes with information about items that didn’t make it into the release for one reason or another.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://make.wordpress.org/core/2024/03/15/wordpress-6-5-field-guide/\">WordPress 6.5 Field Guide</a></blockquote>\n</div>\n\n\n\n<p class=\"has-light-background-background-color has-background has-large-font-size\">🎥 <strong>Bud Kraus</strong>&nbsp;invites you to the Learn WordPress Online Workshop:&nbsp;<strong><a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/299175971/\">What’s New In WordPress 6.5</a></strong>? on&nbsp;<strong>April 9, 2024, at 19:00 UTC</strong>. He’ll cover, among other features</p>\n\n\n\n<p class=\"has-light-background-background-color has-background has-large-font-size\">🎥 Also,&nbsp;<strong>April 9, 2024, at 14:00 UTC</strong>,&nbsp;<strong>Nick Diego</strong>&nbsp;and&nbsp;<strong>Damon Cook</strong>&nbsp;invite you to the next&nbsp;<a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/300032710/\"><strong>Developer Hours: Building custom blocks with the Interactivity API</strong>.&nbsp;</a><strong>Damon Cook</strong>&nbsp;from WP Engine will demonstrate how he built a form submission block that leverages the API.</p>\n\n\n\n<p class=\"has-large-font-size\"><strong>Table of Contents</strong></p>\n\n\n\n<ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/about-wordpress-6-5-all-in-one-list/#general-information\">General Information</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/about-wordpress-6-5-all-in-one-list/#design-tools\">Design Tools</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/about-wordpress-6-5-all-in-one-list/#font-library\">Font Library</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/about-wordpress-6-5-all-in-one-list/#block-bindings-api\">Block Bindings API</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/about-wordpress-6-5-all-in-one-list/#block-hooks-api\">Block Hooks API</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/about-wordpress-6-5-all-in-one-list/#interactivity-api\">Interactivity API</a></li></ol>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"general-information\">General Information</h2>\n\n\n\n<p>🎉 <a href=\"https://wordpress.org/news/2024/04/regina/\"><strong>WordPress 6.5 “Regina”</strong></a> Official Release Post</p>\n\n\n\n<div class=\"wp-block-group has-accent-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<a href=\"https://wordpress.org/news/2024/04/regina/\"><img width=\"652\" height=\"435\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/04/image.png?resize=652%2C435&ssl=1\" alt=\"\" class=\"wp-image-28113\" /></a>\n</div></div>\n\n\n\n<p>🛬 <strong><a href=\"https://wordpress.org/download/releases/6-5/\">WordPress 6.5 Landing page</a></strong> Check out the new&nbsp;WordPress 6.5 page&nbsp;to learn more about the numerous enhancements and features of this release—including short demos of highlighted features.</p>\n\n\n\n<p>📗 <strong>Leonardo Nurugha</strong>, documentation co-lead of the release, posted: <a href=\"https://www.hostinger.com/blog/wordpress-6-5\"><strong>WordPress 6.5 “Regina” Is Here – Key Features and Changes</strong></a></p>\n\n\n\n<p>📗 <strong>Carlos Daniele</strong>&nbsp;took a deep dive into the most important features for the Kinsta Blog:&nbsp;<a href=\"https://www.therepository.email/?mailpoet_router&endpoint=track&action=click&data=WyI1NTYiLCIxam9oNGRrYjZ2Zm84dzRvb293ZzRvczg4Z2swNHM0dyIsIjEwMTgiLCJkYjkzYzgwOWZlZmIiLGZhbHNlXQ\"><strong>What’s new in WordPress 6.5: Font Library, DataViews, Block Bindings, Interactivity API, and much more!</strong></a></p>\n\n\n\n<p>📗 <strong>Courtney Robertson</strong>&nbsp;published a&nbsp;<a href=\"https://www.godaddy.com/resources/news/whats-new-in-wordpress-6-5\" target=\"_blank\" rel=\"noreferrer noopener\"><strong>What’s new in WordPress 6.5</strong></a>&nbsp;walk-through and separated the updates for site builders and users from those relevant for developers.</p>\n\n\n\n<p>🧵 <strong>Rich Tabor</strong> created an <a href=\"https://twitter.com/richard_tabor/status/1775477094031741249\"><strong>18-message Twitter thread</strong></a> listing the main highlights of the release together with mini-videos. <a href=\"https://rich.blog/wordpress-6-5/\">The list</a> is also available on his blog</p>\n\n\n\n<p>📘 <strong>Matt Medeiros</strong> has some sound advice for WordPress users around 6.5 in his video <a href=\"https://www.youtube.com/watch?v=U5aYK1MPbWA\"><strong>Watch BEFORE You Update to WordPress 6.5 &#8220;Regina&#8221;</strong></a></p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<div class=\"toolbelt-video-wrapper\"></div>\n</div>\n\n\n\n<p>📽️ Learn.WordPress contributor, Wes Theron, posted a <a href=\"https://www.youtube.com/watch?v=DtJwcJF9LM8\">walk -through the WordPress 6.5 version on YouTube</a>. He covered:</p>\n\n\n\n<ul>\n<li>Improvements to the Cover block</li>\n\n\n\n<li>Renaming blocks and improved drag and drop functionality </li>\n\n\n\n<li>Box shadow support</li>\n\n\n\n<li>New powerful views in the Site Editor</li>\n\n\n\n<li>Robust revisions  </li>\n\n\n\n<li>Using the Font Library </li>\n\n\n\n<li>General UX improvements</li>\n</ul>\n\n\n\n<p>&nbsp;📽️ <strong>Jamie Marsland</strong>&nbsp;<a href=\"https://www.youtube.com/watch?v=tf8w0xMNToY\"><strong>explains WordPress 6.5 in 250 seconds</strong></a>.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<div class=\"toolbelt-video-wrapper\"></div>\n</div>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://make.wordpress.org/core/2024/03/09/miscellaneous-editor-changes-in-wordpress-6-5/\">Miscellaneous Editor changes in WordPress 6.5</a></blockquote>\n</div>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://make.wordpress.org/core/2024/03/05/unification-of-the-site-and-post-editors-in-6-5/\">Unification of the site and post editors in 6.5</a></blockquote>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"design-tools\">Design Tools</h2>\n\n\n\n<p>📽️ <strong>Dave Smith</strong> published a video to show off <a href=\"https://www.youtube.com/watch?v=ySyJRYAbU_M\"><strong>these tiny link editing changes that just made WordPress 6.5 so much better</strong></a>.</p>\n\n\n\n<p>📙 <a href=\"https://developer.wordpress.org/news/2024/03/21/drop-shadow-updates-in-wordpress-6-5/\"><strong>Drop Shadow updates in WordPress 6.5</strong></a> &#8211; WordPress 6.5 brings drop shadow options to the end user. This post summarizes how to use the controls for various blocks, and how to remove core presets.</p>\n\n\n\n		\n			<div class=\"jetpack-videopress-player__wrapper\"> <div class=\"toolbelt-video-wrapper\"></div></div>\n			\n			\n		\n		\n\n\n		\n			<div class=\"jetpack-videopress-player__wrapper\"> <div class=\"toolbelt-video-wrapper\"></div></div>\n			\n			\n		\n		\n\n\n<h2 class=\"wp-block-heading\" id=\"font-library\">Font Library</h2>\n\n\n\n		\n			<div class=\"jetpack-videopress-player__wrapper\"> <div class=\"toolbelt-video-wrapper\"></div></div>\n			\n			\n		\n		\n\n\n<p>📙 <strong><a href=\"https://developer.wordpress.org/news/2024/04/01/how-to-register-custom-font-collections-for-the-font-library/\">How to register custom font collections for the Font Library</a> </strong>&#8211; WordPress 6.5 will ship with the Font Library. Learn how to use a built-in API for registering custom font collections. <em>(WordPress Developer Blog)</em></p>\n\n\n\n<p>📽️ <strong>Anne McCarthy</strong>&nbsp;posted a new video:&nbsp;<strong><a href=\"https://www.youtube.com/watch?v=Pnx_nkB-O2E\">No Code, All Fonts thanks to the Font Library in WordPress 6.5</a>.</strong>&nbsp;She wrote in the description:</p>\n\n\n\n<ul>\n<li>The Font Library operates globally, similar to the Media Library, allowing you to easily install, remove, and activate fonts across your entire site.</li>\n\n\n\n<li>Whether a font is installed by you or provided by your theme or plugin, the Font Library provides seamless selection across your editing experience.</li>\n\n\n\n<li>Google Fonts is integrated into the Font Library experience, offering various typography options and quick uploads.</li>\n\n\n\n<li>This new ability empowers you to control a foundational aspect of your site’s design without the need for coding.</li>\n\n\n\n<li>Extenders can provide their font collections and manage permissions, including turning the feature off.</li>\n</ul>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://make.wordpress.org/core/2024/03/14/new-feature-font-library/\">New Feature: Font Library</a></blockquote>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"block-bindings-api\">Block Bindings API</h2>\n\n\n<div class=\"ngl-articles colored ngl-articles-50_50 ngl-articles-frontend\">\n\n	\n	<div class=\"ngl-articles-wrap ngl-articles-webview\">\n	\n						\n			<div class=\"ngl-article-mobile\">\n				<div width=\"100%\" border=\"0\">\n					<div>\n						<div valign=\"top\">\n							<div class=\"ngl-article-mob-wrap\">\n							<div class=\"ngl-article-featured\"><a href=\"https://gutenbergtimes.com/block-bindings-and-custom-fields-an-almost-no-code-example/\" target=\"_self\" rel=\"\"><img src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/02/Screenshot-2024-02-21-at-11.06.40.png?w=652&ssl=1\" /></a></div><div class=\"ngl-article-title\"><a href=\"https://gutenbergtimes.com/block-bindings-and-custom-fields-an-almost-no-code-example/\" target=\"_self\" rel=\"\"><span>Block Bindings and Custom Fields &#8211;  an (almost) no-code example</span></a></div><div class=\"ngl-article-excerpt\">This article received two updates today, March 13, 2024: Link to second part of the Introducing Block Bindings article series. Screenshot of the visual indicator for single block With the&hellip;</div>							</div>\n						</div>\n					</div>\n				</div>\n			</div>\n			\n			\n			\n\n		\n		\n		</div>\n\n</div>\n\n\n<p>📙 <strong><a href=\"https://developer.wordpress.org/news/2024/02/20/introducing-block-bindings-part-1-connecting-custom-fields/\">Introducing Block Bindings, part 1: connecting custom fields</a> </strong>&#8211; The first tutorial in a two-part series that introduces the Block Bindings API in WordPress 6.5. Part 1 focuses on custom fields. <em>(WordPress Developer Blog)</em></p>\n\n\n\n<p>📙 <a href=\"https://developer.wordpress.org/news/2024/03/06/introducing-block-bindings-part-2-working-with-custom-binding-sources/\"><strong>Introducing Block Bindings, part 2: Working with custom binding sources</strong></a> &#8211; The second tutorial in a two-part series that introduces the Block Bindings API in WordPress 6.5. Part 2 focuses on registering and using custom binding sources.<em>(WordPress Developer Blog)</em></p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://make.wordpress.org/core/2024/03/06/new-feature-the-block-bindings-api/\">New Feature: The Block Bindings API</a></blockquote>\n</div>\n\n\n\n<p>🗞️ <strong>Brian Coords</strong>&nbsp;reported for the WPTavern on&nbsp;<a href=\"https://wptavern.com/the-block-bindings-api-brings-dynamic-data-to-blocks\"><strong>The Block Bindings API Brings Dynamic Data to Blocks</strong></a>. “As the block editor continues to evolve its content management capabilities, the lack of support for custom fields has been one of the key roadblocks for users and developers. While custom fields in WordPress are still widely used, in the block editor they’ve been relegated to a drawer at the bottom of the screen, and haven’t been as deeply integrated as many would like. With the coming&nbsp;Block Bindings API, things are about to change in a very good way.” he wrote.</p>\n\n\n\n<p>📽️ In his latest video on YouTube, <strong>Brian Coords</strong>&nbsp;shows you how he uses&nbsp;<a href=\"https://www.youtube.com/watch?v=qD5U7TNUKTQ\"><strong>Block Variations with the Block Bindings API</strong></a>&nbsp;and how you can offer a “no-code” experience for your users with Block Variations. Coords shared&nbsp;<a href=\"https://github.com/bacoords/example-block-variation\">his code via GitHub</a></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"block-hooks-api\">Block Hooks API</h2>\n\n\n\n<p>📽️ <strong>Bernie Reiter</strong>&nbsp;and&nbsp;<strong>Nick Diego</strong>&nbsp;took participants of the Developer Hours on the journey&nbsp;<a href=\"https://www.youtube.com/watch?v=ezPHiyhhaoQ\">exploring Block Hooks in WordPress 6.5</a>. In addition to covering the basics, they looked at practical examples that you can implement in your projects.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<div class=\"toolbelt-video-wrapper\"></div>\n</div>\n\n\n\n<p>📙 <a href=\"https://developer.wordpress.org/news/2024/03/25/exploring-the-block-hooks-api-in-wordpress-6-5/\"><strong>Exploring the Block Hooks API in WordPress 6.5</strong></a> &#8211; The Block Hooks API is an extensibility mechanism that allows you to dynamically insert blocks into block themes. Learn how to use the API in your projects in this comprehensive overview. <em>(WordPress Developer Blog)</em></p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://make.wordpress.org/core/2024/03/04/updates-to-block-hooks-in-6-5/\">Updates to Block Hooks in 6.5</a></blockquote>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"interactivity-api\">Interactivity API</h2>\n\n\n\n<p>🎙️ If you don’t have a lot of time, but are curious about the Interactivity API, you and listen to&nbsp;<strong>Mario Santos</strong>,&nbsp;<strong>Ryan Welcher</strong>&nbsp;and&nbsp;<strong>Josepha Haden Chomphosy</strong>&nbsp;on the 73rd episode of the<strong>&nbsp;<a href=\"https://wordpress.org/news/2024/02/episode-73-inside-the-interactivity-api\">WP Briefing discussing the Interactivity API</a></strong>. “a new foundational tool that helps developers create memorable interactive front-end experiences.” and the show notes lists a ton of resources.</p>\n\n\n\n<a href=\"https://wordpress.org/news/2024/02/episode-73-inside-the-interactivity-api\"><img width=\"652\" height=\"367\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/02/WPBriefingInteractivityAPI.jpeg?resize=652%2C367&ssl=1\" alt=\"Cover image of the podcast episode in Interactivity API\" class=\"wp-image-27606\" /></a>\n\n\n\n<p>🗞️ On the WPTavern site,&nbsp;<strong><a href=\"https://twitter.com/jamesgiroux\">James Giroux</a></strong>&nbsp;reported on&nbsp;<a href=\"https://wptavern.com/interactivity-api-prepares-for-its-official-debut-in-wordpress-6-5\"><strong>Interactivity API Prepares for its Official Debut in WordPress 6.5</strong></a>. “The Interactivity API and how it uses WordPress could be a pivotal moment in the Project’s history. It could create a new way of working with WordPress.&nbsp;” he wrote. And he might be right. It’s definitely exciting, and I am excited about all the tutorials and case studies that will be written in the upcoming months.</p>\n\n\n\n<p>📙 <a href=\"https://developer.wordpress.org/news/2024/02/29/an-introduction-to-block-based-mega-menus/\"><strong>An introduction to block-based mega menus</strong></a> &#8211; In this tutorial, we’ll explore how to build a Mega Menu block that integrates with the Core Navigation block using new features coming in WordPress 6.5. <em>(WordPress Developer Blog)</em></p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://make.wordpress.org/core/2024/03/04/interactivity-api-dev-note/\">Interactivity API in 6.5</a></blockquote>\n</div>\n\n\n\n<p>📗 <strong>Jonathan Bossenger</strong>&nbsp;experimented with the Interactivity API and used&nbsp;<a href=\"https://jonathanbossenger.com/2023/12/wordpress-as-a-game-development-platform/\"><strong>WordPress as a game development platform.</strong></a>&nbsp;It’s a fun game, where the logos of other web development platform chase after the WordPress logo. I lasted 25 seconds. How long did you last?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 05 Apr 2024 15:46:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"Do The Woo Community: Introducing Groundbreaker, Empowering Women in Tech in Uganda\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=80862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://dothewoo.io/introducing-groundbreaker-empowering-women-in-tech-in-uganda/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:168:\"During CloudFest 2024, BobWP met with Groundbreaker, a nonprofit empowering young women in Uganda for tech careers through scholarships. Find more on groundbreaker.org.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 05 Apr 2024 08:59:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"Do The Woo Community: Accessibility Comes to Do the Woo with Anne and Taeke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=80839\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://dothewoo.io/accessibility-comes-to-do-the-woo-with-anne-and-taeke/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:231:\"Anne and Taeke discuss the expansive realm of web accessibility, covering its intersection with profitability, society, and legal compliance. They invite listener engagement and promise a diverse range of topics in future episodes.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 04 Apr 2024 08:48:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: #114 – Tammie Lister on the Journey Through Design and Theming\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=155234\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://wptavern.com/podcast/114-tammie-lister-on-the-journey-through-design-and-theming\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:48061:\"Transcript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, design and the future of theming in WordPress.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice. Or by going to WP Tavern.com forward slash feed forward slash podcast. And you can copy that URL in to most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you, and hopefully get you, or your idea, featured on the show. Head to WP Tavern.com forward slash contact forward slash jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Tammie Lister. Tammie is a product creator focusing on WordPress. She has a hybrid background across product, design, psychology and development. She contributes to WordPress and is passionate about open source and the community. If you&#8217;ve been in the WordPress space for awhile, Tammie&#8217;s name is likely a familiar one. She&#8217;s an 18 year veteran of the project. A talented designer, developer and a key contributor to the project. Her journey has made her wear a variety of hats in both agency, life and product development.</p>\n\n\n\n<p>Today, Tammie shares insights that span from the practical, to the philosophical within the open source landscape. We get to hear Tammie&#8217;s perspective on this crucial experimentation phase in WordPress theme development. The balance she seeks between minimalist design and functional complexity, and active roles, including the default theme task force.</p>\n\n\n\n<p>Our discussion takes us into the evolving WordPress editor experience, user roles and interface design. We discussed the future of WordPress UI and UX, touching on visual configurations and how the Gutenberg site editor continues to shape our digital toolkit.</p>\n\n\n\n<p>For those inspired by themes, Tammie reveals her passion for them from preserving the essence of classic themes, to ways that the project might break new ground.</p>\n\n\n\n<p>She also introduces us to some of our own projects, such as Composition Themes and discusses her Classic to Block Themes project as well.</p>\n\n\n\n<p>Tammie shares some of the resources that she recommends for both beginners and seasoned developers alike, bringing to light the many pathways that you can now choose to learn about WordPress.</p>\n\n\n\n<p>Looking over the horizon of collaborative editing and design systems, Tammie&#8217;s excitement for what&#8217;s next is palpable.</p>\n\n\n\n<p>So, whether you&#8217;re a developer, a designer or a WordPress aficionado this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to WP Tavern.com forward slash podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>A quick note, before we begin, this episode was recorded live at WordCamp Asia. There was quite a lot of background noise to contend with, and I&#8217;ve done my best to make the audio as easy to listen to as possible.</p>\n\n\n\n<p>And so without further delay, I bring you Tammie Lister.</p>\n\n\n\n<p>I am joined on the podcast by Tammie Lister. Hello Tammie.</p>\n\n\n\n<p>[00:03:44] <strong>Tammie Lister:</strong> Hello. How are you?</p>\n\n\n\n<p>[00:03:45] <strong>Nathan Wrigley:</strong> Yeah, good. Thank you for joining me today. We are at WordCamp Asia. I actually don&#8217;t know the name of the venue, but we are at WordCamp Asia. And Tammie&#8217;s giving us a presentation during the event. But before she tells us about that, just give us a little bit of a background. Give us your potted biography. Tell us who you are, where you&#8217;ve been, whatever you like.</p>\n\n\n\n<p>[00:04:04] <strong>Tammie Lister:</strong> Ah, yeah. So my name is Tammie Lister. I have been involved in project, oh, I think 18 years or so now, a little while. I have been pretty much, designer, developer, worn most hats around the project. I&#8217;ve been a full-time contributor, I&#8217;ve worked on phase one of Gutenberg, and I&#8217;ve also worked in agencies. And currently, I am working a kind of hybrid function, working with products, and also doing some sponsored contribution.</p>\n\n\n\n<p>[00:04:32] <strong>Nathan Wrigley:</strong> You&#8217;ve been around the houses, haven&#8217;t you, basically? You&#8217;ve been there, done that. What&#8217;s your talk about? It&#8217;s called The Elements of WordPress, but I&#8217;ve got it written down in front of me, so I know what it&#8217;s about. But you want to, just for the sake of the audience, maybe somebody listening to this will be able to watch it on WordPress TV. Tell us what you&#8217;re intending to say.</p>\n\n\n\n<p>[00:04:48] <strong>Tammie Lister:</strong> Yeah. So my talk is specifically looking at the elements of WordPress, going up from blocks, to patterns, to template parts, to templates, and then styling. And looking at how they all come together. So everything on the front end of the site, but also the hidden design system as well.</p>\n\n\n\n<p>[00:05:03] <strong>Nathan Wrigley:</strong> So that&#8217;s the talk. You haven&#8217;t done it yet, have you?</p>\n\n\n\n<p>[00:05:06] <strong>Tammie Lister:</strong> Yes.</p>\n\n\n\n<p>[00:05:06] <strong>Nathan Wrigley:</strong> You have. And how did it go?</p>\n\n\n\n<p>[00:05:08] <strong>Tammie Lister:</strong> It went really well. I was really pleased to be able to deliver it and, as of all these talks, I think it&#8217;s a good idea to kind of deliver it. I always like writing blog posts, so I&#8217;m hoping to write a blog post about it, and then iterate on it. And some of the conversations are really interesting afterwards as well.</p>\n\n\n\n<p>[00:05:22] <strong>Nathan Wrigley:</strong> Yeah. A little bit off piste, but how do you manage the nerves for things like that?</p>\n\n\n\n<p>[00:05:26] <strong>Tammie Lister:</strong> I am atrocious with nerves. I am not one of those people that ever doesn&#8217;t have nerves. I would probably worry if I didn&#8217;t have nerves.</p>\n\n\n\n<p>[00:05:33] <strong>Nathan Wrigley:</strong> Well, it&#8217;s something that I couldn&#8217;t do, so bravo. Thank you for doing that. So I&#8217;ve got a list of questions here, and I&#8217;ll go through them, and we&#8217;ll tackle them one at a time. So my first question to you, and because I know of the history that you&#8217;ve had, this question seems like on message, but we&#8217;ll see.</p>\n\n\n\n<p>I&#8217;ve written down, over the last 10 years let&#8217;s say, WordPress, well, let&#8217;s maybe go for 5 years. WordPress has changed a lot. Tell us what you make of everything that&#8217;s happened since your involvement, you know, phase one, and all of that. What sticks out as the most important moments?</p>\n\n\n\n<p>[00:06:02] <strong>Tammie Lister:</strong> The word at the moment that I&#8217;m focusing on is patterns. I love patterns because they, and I kind of said this in my talk, because when people think of a site, they don&#8217;t think of blocks, they think of patterns. If you shut your eyes and you think of a site. So that, to me, is really significant because it&#8217;s starting to deal with the science and deal with the interface as people see it.</p>\n\n\n\n<p>A lot of the work that we&#8217;ve done, is dealing with it as people see it, because a lot of phase one, and a lot of all that work was foundational. I kind of use the term iceberg. And it was all that kind of groundwork, or that big foundational pieces. And you don&#8217;t see that, and you don&#8217;t recognise that.</p>\n\n\n\n<p>The work now is refinements on top of that, and it can seem bigger, but it&#8217;s making all of that hidden work visible. So I really like that. I like it when something that I made is changed, I get great delight in that. I like it when the language is firmed, both visually and also that we start having solid names for things, and the name stick, rather than the names changing.</p>\n\n\n\n<p>[00:07:03] <strong>Nathan Wrigley:</strong> We&#8217;ve had a a lot of changing of names, haven&#8217;t we?</p>\n\n\n\n<p>[00:07:05] <strong>Tammie Lister:</strong> Yeah. I really like that we are using proper things, so we&#8217;ll get examples, reusable blocks, and then patterns, and syncing, and all those kind of things. That we&#8217;re also making things in response to how they&#8217;re being used, is really important as well.</p>\n\n\n\n<p>Initially, you&#8217;re going to make the best bet that you can be. So phase one was very much a, well, we know we need the editor, we know we need this, the block kind of needs it, this is how an editor kind of should work, rough bet, you know, throw something.</p>\n\n\n\n<p>But then you only know when people are using it how to refine it. And then, even more so when site editor, the site editor and block editor are very different. So all of that kind of information refines and changes it as well.</p>\n\n\n\n<p>[00:07:44] <strong>Nathan Wrigley:</strong> You mentioned an iceberg, and whilst I don&#8217;t want to sort of open up Pandora&#8217;s box a little bit, how well do you feel the whole of the Gutenberg project, from phase one, was communicated? Because it feels, right now, 2024, it feels like a lot of things are beginning to land, and are beginning to be understood. I&#8217;ve got the intuition that, for the last five years or so there was, just maybe the communication wasn&#8217;t what it could have been, or something like that. So it was difficult for people to understand, and that leads to all sorts of interesting conversations.</p>\n\n\n\n<p>[00:08:13] <strong>Tammie Lister:</strong> I think communication is a conversation, and conversations need to happen between two, both ways. That&#8217;s where I come back to. I think everyone has learned in this, you know, we didn&#8217;t even really have a concept of developer relations. You know, we were asking the people who were building it to do developer relations, who weren&#8217;t doing developer relations, who didn&#8217;t know how to do developer relations, right? Or we were asking people to build it, whilst also advocating for it.</p>\n\n\n\n<p>You know, all these kind of different things. And we&#8217;ve learned over time, and how to do an awful lot in this project. And we&#8217;ve had to learn a lot of, we have things like hallway hangouts, now and we have all these amazing, like the developer blog, and we have all these amazing resources that we didn&#8217;t have in phase one.</p>\n\n\n\n<p>We had, just had some like user feedback sessions, and we didn&#8217;t have the FSE program, the outreach. That kind of didn&#8217;t happen, that started happening later. We didn&#8217;t have specific people who were specifically focused on things. That was the people who were building it as well.</p>\n\n\n\n<p>So I think we&#8217;ve learned from having those conversations and refining it. But also, it&#8217;s really hard to communicate what you don&#8217;t know yet, whilst you are learning how to do it. So if you&#8217;re like, I need to experiment and I need to explore this thing, but you need to give me time to experiment and explore this thing, that&#8217;s a completely different conversation.</p>\n\n\n\n<p>[00:09:31] <strong>Nathan Wrigley:</strong> Yeah, I was having, a chat with somebody yesterday, and sort of explaining that if WordPress was a, I don&#8217;t know, a blue chip company, and it was a for-profit entity, and you had a hierarchy with the CEO at the top, you could communicate everything down with just a memo. But the nature of the WordPress project, given that there&#8217;s loads of volunteer hours, and contributor hours, and people are in different time zones, I think that&#8217;s a really difficult thing to manage.</p>\n\n\n\n<p>[00:09:51] <strong>Tammie Lister:</strong> Well you couldn&#8217;t say like, hey, can everyone just go into experimentation mode for like four years, and just everyone not judge anything that&#8217;s going to be produced. That&#8217;s a whole different conversation. And then who&#8217;s going to get the memo that we&#8217;re actually all in experimentation. And then if Bob in the corner, and then Mary in the other corner doesn&#8217;t get that memo, they&#8217;re going to be judging something. Bob and Mary are super awesome people, but they&#8217;re not going to have that knowledge to make those judgements on different things.</p>\n\n\n\n<p>[00:10:15] <strong>Nathan Wrigley:</strong> Yeah. I have no intuition as to whether anything&#8217;s changed in the background, but it sounds, from everything that you&#8217;ve said and the messaging that I&#8217;m receiving, that that message has been understood, in the places where it needs to be understood. That getting the message out, getting buy-in from people who are using it, communicating it, setting up things like the FSE program as you mentioned, and the Learn WordPress, and the mentor sponsorship.</p>\n\n\n\n<p>[00:10:37] <strong>Tammie Lister:</strong> It&#8217;s maturing of the project as well, and maturing of concepts and learning, like we all learn. I think that&#8217;s one of the things in the open source projects, you learn by doing. And it&#8217;s as safe a place as you can have as any to learn from, and as gentle a place.</p>\n\n\n\n<p>But we all need to be very gentle with allowing that learning, and just give that consideration of, we&#8217;re all learning together, we&#8217;re all reflecting on what we do. That ability to experiment, if we can kind of replicate that and keep that, I think that&#8217;s going to serve us well in the future as well.</p>\n\n\n\n<p>[00:11:10] <strong>Nathan Wrigley:</strong> I haven&#8217;t been in the WordPress ecosystem since day one, probably more like 12 years or something like that. So long enough to know a bit, but not long enough to know everything. But it does feel like when phase one began, that was probably the moment where WordPress changed beyond all recognition, in a way that it had never done before. So there may was no need to communicate on such a deep level.</p>\n\n\n\n<p>[00:11:33] <strong>Tammie Lister:</strong> I think there&#8217;s always been pivotal changes. They&#8217;ve just sometimes not, if it&#8217;s not impacting your area, impacted so many areas, I think if it impacts your area, it may have impacted a smaller area, so it would&#8217;ve felt huge in that smaller area, to that group of people.</p>\n\n\n\n<p>Because it impacted so many people, it&#8217;s the editor, right? The editor is where you go to write things. You want to impact a big area of WordPress, impact the editor. It&#8217;s pretty much impacting the heart, right? In a beautiful way.</p>\n\n\n\n<p>It really is important to think about, there&#8217;s been, you know, from plugins, to themes, to different things. There&#8217;s been so many areas that have had pivotal changes from day one that, I&#8217;m sure different people would have this on this day, and this time. This was this change that shook me, right? And I can think of many little kerfuffles, that kind of people would&#8217;ve felt, or little blips that people felt.</p>\n\n\n\n<p>But we kind of have learned along the way to have those, and learn from those. And each one you learn from, and each one as a community. I think one of the big things to do is think, okay, how do we then progress? How do we then take those learnings? How do we then get better? And I do think we have some strong learnings from this project.</p>\n\n\n\n<p>[00:12:49] <strong>Nathan Wrigley:</strong> Yeah. I also feel the footprint is important, because back 12 years ago, let&#8217;s just use that number. I don&#8217;t know what the percentage was, but it wasn&#8217;t 43 that this number, this percentage of the internet&#8217;s being used. So obviously the impact.</p>\n\n\n\n<p>[00:13:00] <strong>Tammie Lister:</strong> The footprint and the businesses that are established on it, and the livelihoods, and the families, and the people that depend on it, you know? And the children, and the partners, and there&#8217;s passion, and there&#8217;s the depth and the roots, and the people that have been on it for decades, or whatever. That leaves a lot of change. You know, trying to change things when someone has been very used to something for 15, whatever years, is quite a change.</p>\n\n\n\n<p>[00:13:26] <strong>Nathan Wrigley:</strong> How confusing do you think the editing experience is at the moment? So I&#8217;m in WordPress all the time, I have this subset of things that I need to achieve. And so for me to do that is really straightforward, because I&#8217;ve spent the time to understand the things that I need to do.</p>\n\n\n\n<p>But if I was somebody brand new coming to WordPress, what&#8217;s your intuition about how finished it is as an editing experience? Do you think we&#8217;ve got a way to go? Are you happy? Of anybody that I&#8217;ve met, you&#8217;ve probably put as much thought into this as anybody. And so I&#8217;m just curious what you think.</p>\n\n\n\n<p>[00:13:57] <strong>Tammie Lister:</strong> So I don&#8217;t think it&#8217;s baked yet, seeing it as a cake, because I think it&#8217;s getting there. One of the things with core is it&#8217;s always going to be the middle ground. And I think we often forget that when we&#8217;re looking at the interface, or we&#8217;re looking at the product, that it&#8217;s the middle that it&#8217;s going for.</p>\n\n\n\n<p>And I would always encourage people to think about how, yes, you can use it out of the box, you can use the middle, but maybe, what do you want to turn on or off? There are options that you can turn, settings as well. I would like to have more configurations to be able to be done, so that you can have less or more, depending on that.</p>\n\n\n\n<p>One of the big things from an agency perspective, is more control from user locking, and user roles, and user capacities. I&#8217;m also probably a big critic as well. I think those people that have been involved in the project, are probably way more critical than those who are outside.</p>\n\n\n\n<p>I always find that interesting. Like, you&#8217;re always going to be more critical of the things that you&#8217;ve ever touched, than anyone else&#8217;s going to be critical. If you know how the cake&#8217;s made, you&#8217;re going to be more critical about the cake.</p>\n\n\n\n<p>I think, for me, I have a personal taste, and then I have a work taste. And so I can share both of those. My personal taste is super minimal, so I would actually like to see, how less distilled can it be. But I also know, for most jobs to be done, that&#8217;s also not going to be the case at all. So I don&#8217;t want to see that to be the default of the interface.</p>\n\n\n\n<p>What I maybe want from a design perspective is absolutely not what should be the default case. And that is always the challenge as a creator of interfaces. But I would definitely like to see different types. I would like to see more visual configuration of that. And I would like to see the ability to, just be able to change the experience a lot more, and style it.</p>\n\n\n\n<p>[00:15:37] <strong>Nathan Wrigley:</strong> Do you feel that the project is heading in the right direction with the UI, the UX that we&#8217;ve got at the moment? Where patterns seem to be taking a bit more of a leading role, and also we&#8217;ve got FSE. I mean, goodness me, we could spend, honestly we could do two hours on FSE. But, is this the direction you want to see it go in? Some like really visual way of just, okay, I want to put that little pattern in that row.</p>\n\n\n\n<p>[00:15:57] <strong>Tammie Lister:</strong> So I love using the site editor&#8217;s Dreamweaver. And I go back, like super dates me. But it is right. Like, for me, that&#8217;s how I make themes now. I love Figma, but Figma, I really use, I don&#8217;t know if you know the concept of style tiles, which is basically just like, you pick your colors, you pick your fonts, and then you just make a little tile basically.</p>\n\n\n\n<p>That&#8217;s kind of what I do. And then I put that into a theme json, and then I load it up, using create block theme, the plugin. I always get those words muddled round. And then I go straight into the editor, and then I start mixing stuff around, and I make my patterns, and I do export. So I&#8217;m basically using it like Dreamweaver, that&#8217;s what I&#8217;m doing, because I find it incredibly effective.</p>\n\n\n\n<p>I strongly recommend people do that, because you are then in it and, would you release it like that? No, probably not, because then you don&#8217;t get translatable, all of those things. But I find it a really effective tool, and it&#8217;s become not just a way to do it, it&#8217;s a way to create. It&#8217;s almost like a coding tool that way.</p>\n\n\n\n<p>Patterns being central, I think is way more important. We do put too much emphasis on blocks, because patterns to me are way more important. One of the things I want with patterns is, I want pattern variations. I really would love to see that.</p>\n\n\n\n<p>[00:17:08] <strong>Nathan Wrigley:</strong> Just tell us more about that, because I think that could easily get missed.</p>\n\n\n\n<p>[00:17:11] <strong>Tammie Lister:</strong> Yeah, so as we have, you know, we have block styles or pattern styles, maybe we call it. Being able to attach different styling to different patterns that you can change. I don&#8217;t know how that happens, but I think that that would be really nice, to be able to switch that in the interface somehow. No idea how that happens.</p>\n\n\n\n<p>The other thing I would love is easier sharing styling. In fact, I&#8217;ve had a couple of conversations at this WordCamp of people just being like, I just want to port. People are going back to CSS Zen Garden. It&#8217;s got a place in everyone&#8217;s heart, right? And what if, bear with me, I&#8217;ve had more than one person say this to me in the past couple of days. What if you could go on the site, and you could grab a load of code, and no matter what theme you had, you could put it in, and then your site would look like that.</p>\n\n\n\n<p>[00:17:56] <strong>Nathan Wrigley:</strong> Neat. Neat. Really neat.</p>\n\n\n\n<p>[00:17:59] <strong>Tammie Lister:</strong> That is kind of what we want. And if it&#8217;s just styling, I mean, it&#8217;s going to be more or less, right? Because of the patterns and everything. But if you are grabbing that and getting the styles, that&#8217;s kind of where we probably should be heading, I think, personally. Very opinions on my own.</p>\n\n\n\n<p>But for me, that&#8217;s true independence of styling. And that&#8217;s what I really want, because I love ephemeral styling. That creative freedom. I think it opens up, not just to developers. It allows front end developers to really polish their fine art. They can boost their skills. They can do even more CSS on top of it, if they want to.</p>\n\n\n\n<p>And they can do even more amazing animation. It opens all these things up to more designers to be able to do it without having to know to code. So at both ends, more capable as well. So it doesn&#8217;t limit anyone.</p>\n\n\n\n<p>[00:18:48] <strong>Nathan Wrigley:</strong> Some of the steps that you mentioned, I don&#8217;t exactly know the level of every listener to this podcast, but some of them will be very technical, and would&#8217;ve understood everything that you&#8217;ve said. But then you may have said something like theme json, and then some people are glazing over and thinking, what? What&#8217;s your intuition as to where being able to create themes and patterns, what level of expertise would you ideally like to see that? Would it be ideal to allow anybody?</p>\n\n\n\n<p>[00:19:12] <strong>Tammie Lister:</strong> I would literally love you to be able to, you know, the Pattern Directory, or the Museum of Block Art. Maybe we can literal just go, pattern directory. I would love a style directory. Where you could literally go and grab a style, grab it, and then you can put it.</p>\n\n\n\n<p>[00:19:23] <strong>Nathan Wrigley:</strong> So no knowledge required, you just need to be able to just go through the directory, copy and paste.</p>\n\n\n\n<p>[00:19:27] <strong>Tammie Lister:</strong> I would love that. WordPress Zen Garden.</p>\n\n\n\n<p>[00:19:30] <strong>Nathan Wrigley:</strong> Yeah, Zen Garden takes me right back.</p>\n\n\n\n<p>[00:19:32] <strong>Tammie Lister:</strong> WordPress Zengarden. How amazing would that be, right?</p>\n\n\n\n<p>[00:19:34] <strong>Nathan Wrigley:</strong> But I guess even that step for some people, I know it seems almost ridiculous on a WordPress podcast, to say even that step might be a of a leap.</p>\n\n\n\n<p>[00:19:41] <strong>Tammie Lister:</strong> But if you had it in the interface.</p>\n\n\n\n<p>[00:19:43] <strong>Nathan Wrigley:</strong> In the interface. Okay, so it&#8217;s not like a separate Zen Garden site.</p>\n\n\n\n<p>[00:19:46] <strong>Tammie Lister:</strong> The pattern directory is in the interface. So if you had the style interface in there somehow, and you could browse it, and you could be like, I want a whatever. I have this rather peculiar analogy I&#8217;m going to share for theming, which is, at the moment, themeing should be super easy to change. But at the moment, changing a theme is like removing your head, rather than changing your clothes. Changing your jumpers should be easy, right?</p>\n\n\n\n<p>And it should just be super simple to change styling. And themes are great and amazing, but they&#8217;re a package, that&#8217;s what they are. And we need to just go back to having that beautiful freedom. And then we can have these creative freedoms.</p>\n\n\n\n<p>Themes to me are, we talk about design. Design and art are very, very different. But art is where meets WordPress in theming, to me. And art is part of my background. And there is potential for us to have some beautiful art in themes again. If we just have that freedom, and we stop themes having to have all this weight in them as well, and be tied down.</p>\n\n\n\n<p>[00:20:47] <strong>Nathan Wrigley:</strong> I get the feeling that an ideal place for you to land with this would be that, most people can do most of what they need to do when they want to style their own website. But there&#8217;s always still going to be an area for a professional.</p>\n\n\n\n<p>[00:20:59] <strong>Tammie Lister:</strong> If you think of it like fashion, is good example. So you can go and have custom fashion, you can go and have high-end, haute couture. You can always go and have custom tailoring. You can go and have all of that. Or you can go to high street, and go get something off the rack. And I think that&#8217;s a really good model for us to kind of think of it as well, right?</p>\n\n\n\n<p>[00:21:16] <strong>Nathan Wrigley:</strong> Nobody&#8217;s used that on me before. That actually sums it up perfectly. That&#8217;s nice, yeah.</p>\n\n\n\n<p>[00:21:20] <strong>Tammie Lister:</strong> Yeah. And that isn&#8217;t belittling anything. That&#8217;s totally fine, you know. And that still allows us to have theme shops, fashion shops, right? That still allows us to have very functional, you know, we have very functional clothing, we have functional themes as well.</p>\n\n\n\n<p>And I think it&#8217;s really important to think about the site works, the site has to do something. Some fashion is very frivolous. Some themes are going to be incredibly frivolous as well. And I actually adore frivolous themes. I don&#8217;t think we have enough of them.</p>\n\n\n\n<p>But some are going to have to just be functional, and jobs to be done as well, because absolutely. And some are going to be frameworks, and some are going to be whatevers, you know. But it&#8217;s having those options. You know, you&#8217;re looking at high street, you have the options to be able to wear different clothing as well.</p>\n\n\n\n<p>And some people are going to be super dependent on a brand, and super passionate about only wearing that brand as well, you know, all those kind of things.</p>\n\n\n\n<p>[00:22:13] <strong>Nathan Wrigley:</strong> So you can peel back the curtain a little bit on this, because of your experience inside the project, trying to drive this change. How does it happen? Are there certain people that we should be, you know, if we&#8217;re strongly into themes, and we&#8217;re opinionated about that, and we want to make the change, where do we go? Do we start talking directly to people like you? Are there other people that we need to be banging on the door and saying, this is what we want?</p>\n\n\n\n<p>[00:22:36] <strong>Tammie Lister:</strong> So I&#8217;m not a full-time contributor, so I&#8217;m just like anybody else in that sense. I mean, I have the knowledge, I&#8217;ve been in the project, but there&#8217;s many people who&#8217;ve been in the project and have that knowledge.</p>\n\n\n\n<p>My biggest thing is use the things, start experimenting, start creating if you can. And I&#8217;m well aware, I&#8217;m suggesting that most people have a time machine to do that, because you are trying to do your job as well as you&#8217;re doing that. But if you can, in your projects, start using them. As you start using new things, you&#8217;re going to find bugs, because the universe.</p>\n\n\n\n<p>And then you can start reporting those issues, and then you can start saying, these things need to change, when you&#8217;re changing classic themes to block themes, that&#8217;s one of the big things at the moment. So you can help with those things.</p>\n\n\n\n<p>And just find the area that you want to help with. Reporting one issue, which is a few minutes, is an incredibly big help. Having one conversation is incredibly helpful. Watching one hallway hangout, which is an hour, is a big help. Watching a video, going to a talk. But then scaling it up, going to a triage session.</p>\n\n\n\n<p>It&#8217;s really finding where you are. Experiment, have a pattern in the Museum of Block Art. Have a pattern in the Pattern Directory. Find where you want to join in. But by using these things, you start to contribute, is the biggest thing, because you start then knowing how they fit.</p>\n\n\n\n<p>To dive in straight away and say, these things should be this way, without having used them in their current state, is a little bit, you might not be knowing how they are utilised. I would also always encourage people to search to see that something&#8217;s not coming up. So if you&#8217;re going to log something as an issue, just have a little quick search, and see whether it&#8217;s coming up to be fixed, before you log it in the GitHub repo. That&#8217;s always a really good kind of tip as well.</p>\n\n\n\n<p>There&#8217;s the channels in Slack, but Slack can also be quite a lot for a lot of people. So just, yeah, just using it, and just figure out where your happy is. But just start experimenting and using is the biggest one.</p>\n\n\n\n<p>[00:24:33] <strong>Nathan Wrigley:</strong> Yeah, joining in, we could probably sum it up, couldn&#8217;t we? That&#8217;s nice. Where would you go? There was a nice little segue there, because you were talking about ways to learn, and you mentioned a couple of things.</p>\n\n\n\n<p>But, where do you find to be the best places to send somebody who&#8217;s, well, let&#8217;s just say a novice? Let&#8217;s go with that. Where are the online resources, the places to hang out?</p>\n\n\n\n<p>[00:24:51] <strong>Tammie Lister:</strong> So there&#8217;s a couple of different ones. We are very lucky, we have a developer blog now, which is incredible good resources. But all the Hallway Hangouts, amazing to watch back. Learn WordPress is also a really good resource. And between all of those, you&#8217;ve just got your good start then.</p>\n\n\n\n<p>And then there&#8217;s quite a few people in between those that start doing. So Ryan has been doing some through develop blog, has also been doing some live streams. So just doing things like that.</p>\n\n\n\n<p>The problem with a lot of these things are, maybe a live stream is like an hour watching. That might be quite a lot of time for you. So that&#8217;s why maybe following like a quick little tutorial, that maybe has a GitHub repo that you can do quickly. Again it&#8217;s, how much time have you got?</p>\n\n\n\n<p>I find pointing people to the Museum of Block Art&#8217;s quite good, because they can just go there, they can see the code, they can drop it in. And then they can learn, oh, this is what a pattern is. And some of those are quite fun. Or go to the Pattern Directory, and then they can be like, oh okay, well, this is what a pattern is, and this is how it forms. Yeah, so those kind of things as well.</p>\n\n\n\n<p>WordPress.tv is also really, really good, because, if you&#8217;ve got some time, type in whatever you want to follow, and just start learning that way. You can learn some really diverse things that way. Following along some State of the Words, the kind of pivotal points, you are going to find out the points of the project that way as well, is a good milestone as well.</p>\n\n\n\n<p>[00:26:11] <strong>Nathan Wrigley:</strong> I will make sure that there is a link to everything that Tammie just said. So if you go to wptavern.com/podcast, and you search for Tammie&#8217;s episode and you find it, there will be all of the links in there.</p>\n\n\n\n<p>Lets pivot a little bit. It&#8217;s not apropos of themes at all but, what do you think about this current phase that we&#8217;re in of Gutenberg? Which is called phase three. But the highlight item for me, I mean there&#8217;s absolutely loads to be honest, but I&#8217;m just going to talk about collaborative editing. What do you make about that? And especially related to themes and sites more generally, not just the content, but editing collaboratively, just the way the whole site looks, so the theme.</p>\n\n\n\n<p>[00:26:47] <strong>Tammie Lister:</strong> I think it hasn&#8217;t been worked out yet, how it&#8217;s going to work on the theme. I don&#8217;t know if it means you are creating the theme collaboratively.</p>\n\n\n\n<p>[00:26:54] <strong>Nathan Wrigley:</strong> It&#8217;s to imagine actually.</p>\n\n\n\n<p>[00:26:56] <strong>Tammie Lister:</strong> Well, it definitely means you&#8217;re creating, so if you think of the site editor as the builder of the theme, which it kind of is, then technically, if you are creating content, which is the theme, you are creating that collaboratively, so yes. Collaborative editing at enterprise scale is something that happens quite often anyway.</p>\n\n\n\n<p>[00:27:17] <strong>Nathan Wrigley:</strong> So tools like Figma, you can do all of that collaborative editing is my understanding.</p>\n\n\n\n<p>[00:27:20] <strong>Tammie Lister:</strong> Yeah. So I&#8217;m very, if I put my design hat on, very used to, in Figma, like comments and, or even like in Google Docs, people are very used to like leaving messages and whatever. So I just think being very aware of those kind of workflows, is kind of interesting.</p>\n\n\n\n<p>One of the things we might find is, someone would just set up a template, and it&#8217;d be like, add something here, and something here later. So adding comments to your templates, might be curious and interesting.</p>\n\n\n\n<p>A different aspect might be people using different themes in the backend. That kind of comes to mind, from accessibility reasons. That is also something that I&#8217;ve always thought about is, could people want to have different editor experiences depending on their accessibility. Which you might do as well. So collaborative editor experiences, or different editor experiences. Which is slightly a sidetrack of this, but it&#8217;s something to consider.</p>\n\n\n\n<p>But phase three is collaborative editing, and plus, plus, plus. Which also the design system, finally, kind of flow. And that kind of, to me, is more Lego pieces to play with. And that&#8217;s the bit that I am incredibly excited about. Because a lot of the stuff that&#8217;s been hidden, we&#8217;ve had a design system all along. It&#8217;s really good.</p>\n\n\n\n<p>People, when they talk about the work that&#8217;s recently done, they&#8217;re pointing just to like the editor. Yes, but it&#8217;s not going to just be the editor. It&#8217;s going to be coming into the settings, into the admin, and to everything, because it needs to. There&#8217;s areas of WordPress that haven&#8217;t been touched for a very long time. And by bringing these components, and being this unification through, it&#8217;s better user experience. But it&#8217;s one user experience.</p>\n\n\n\n<p>Again, that point of, it&#8217;s a middle road. If it&#8217;s, the way that it&#8217;s being done, means you then will be able to have the same level of customisation, the same level of extensibility, the same level of styling on top of it. So you&#8217;ll be able to then, for your end users, customise it how you want to. So you have that flexibility still, yeah.</p>\n\n\n\n<p>[00:29:17] <strong>Nathan Wrigley:</strong> I think it&#8217;s fabulous that somebody who&#8217;s been around in the projects as long as you have, and I&#8217;m sure you&#8217;ve had your ups and downs, I&#8217;m sure that, you know, some days it&#8217;s like, oh, WordPress. It sounds like you are very, very, genuinely excited about what&#8217;s coming. That&#8217;s amazing.</p>\n\n\n\n<p>[00:29:30] <strong>Tammie Lister:</strong> And I&#8217;m excited about who&#8217;s doing it.</p>\n\n\n\n<p>[00:29:32] <strong>Nathan Wrigley:</strong> Oh, okay. Yeah.</p>\n\n\n\n<p>[00:29:33] <strong>Tammie Lister:</strong> It&#8217;s exciting the new, I love when you have fresher people have fresher eyes on it. I love when older people have fresh eyes on it as well, and different energy. I love when, as I&#8217;ve mentioned previously, when someone re-does work that I&#8217;ve done, I&#8217;m so excited. I&#8217;m like, yes, that&#8217;s gone.</p>\n\n\n\n<p>But it&#8217;s exciting to see areas that haven&#8217;t been touched for such a long time. We shouldn&#8217;t have areas that haven&#8217;t been for 10 years, because that&#8217;s how many years. That&#8217;s like dog years.</p>\n\n\n\n<p>[00:30:02] <strong>Nathan Wrigley:</strong> Tell us a little bit about your stuff. We&#8217;ve heard about your relationship with WordPress. Let&#8217;s just get into what you are doing at the minute. I think you said you had four hats or something. Is it four hats?</p>\n\n\n\n<p>[00:30:11] <strong>Tammie Lister:</strong> Yeah, I go with lots of hats.</p>\n\n\n\n<p>[00:30:12] <strong>Nathan Wrigley:</strong> What are the four hats? What&#8217;s keeping Tammie busy at the minute?</p>\n\n\n\n<p>[00:30:14] <strong>Tammie Lister:</strong> So I&#8217;m working on a project called Gildenberg. I&#8217;m working with Luke and Jonathan. What we&#8217;re doing is, we&#8217;re working on a guild of product creators, and we&#8217;re working to support them through that as well. That&#8217;s really exciting. So I&#8217;m doing that a little bit.</p>\n\n\n\n<p>I&#8217;m also creating my own, looking to create my own products. I&#8217;m working out what that means. Spoilers, going to start with theming. I&#8217;m also collaborating with some, doing some agency work as well. And I&#8217;ve been collab&#8217;ing some awesome plugins, doing some classic block based work. Which I actually really enjoy.</p>\n\n\n\n<p>There&#8217;s something about converting classic themes to block. One, because I&#8217;m learning where the friction points are. I&#8217;m also really lucky to be sponsored by Automattic, to be doing two days a week on the default theme task force.</p>\n\n\n\n<p>[00:30:59] <strong>Nathan Wrigley:</strong> Go on, tell us more about that. That sounds fun.</p>\n\n\n\n<p>[00:31:00] <strong>Tammie Lister:</strong> Yeah, I am really excited about that. It&#8217;s 400 odd tickets on the default themes. So the idea is, eventually, it came from the community summit. There&#8217;s actually a post up by Jonathan Desrosiers. Rather than scorch earthing, and removing all the default themes, it&#8217;s what if we actually fixed them? Which is a beautiful and wonderful concept.</p>\n\n\n\n<p>So what we&#8217;re doing is, we&#8217;re going through each ticket, and we are going to analyse, does it need fixing? Some of those tickets have been sat there for four, five years. They haven&#8217;t had attention.</p>\n\n\n\n<p>So we&#8217;re going to look at it, we&#8217;re going to see if it even stands in this time. If it does, great, let&#8217;s ship it, let&#8217;s get that patch in. If it doesn&#8217;t, it&#8217;s got a new patch. If it needs closing, let&#8217;s close it. And then we&#8217;ll able to see the lay of the land, once we don&#8217;t have this amount of tickets. Then we can decide where we go from this, on block based theme.</p>\n\n\n\n<p>[00:31:48] <strong>Nathan Wrigley:</strong> Kind of a nice project, that you can see that 400 dropping.</p>\n\n\n\n<p>[00:31:51] <strong>Tammie Lister:</strong> Oh goodness, yeah. We&#8217;ve already done some at contribution day.</p>\n\n\n\n<p>[00:31:53] <strong>Nathan Wrigley:</strong> Oh nice. Lovely.</p>\n\n\n\n<p>[00:31:55] <strong>Tammie Lister:</strong> And it is. I got to be part of some of the default themes. You know, one of my first roles within WordPress, you know, I kind of came in through theming. Theming has been a theme throughout my whole history of WordPress, throughout everything. And my heart is strongly there.</p>\n\n\n\n<p>And default themes, yes, some of them are classic, and we could be like, oh, just forget it. I don&#8217;t believe that. I think it&#8217;s history. It&#8217;s like denying that we have a history, right? And I love block themes. I think they&#8217;re amazing and they&#8217;re fantastic, but that doesn&#8217;t mean that we should forget that we have these themes.</p>\n\n\n\n<p>I think we should look at how we can bring the essence of those, if we want to bring them. Or we should look at how can we support the people that are still using them and how can we have that respect. So, if someone&#8217;s using 2011, how can we still respect that they&#8217;re using 2011?</p>\n\n\n\n<p>[00:32:50] <strong>Nathan Wrigley:</strong> Yeah. Yeah.</p>\n\n\n\n<p>[00:32:51] <strong>Tammie Lister:</strong> As well.</p>\n\n\n\n<p>[00:32:52] <strong>Nathan Wrigley:</strong> Yeah, that&#8217;s a lovely project. You very quickly glossed over, there was one there where you are going to be looking at doing your own projects, but you didn&#8217;t dive into that. Maybe it&#8217;s because you haven&#8217;t distilled it quite yet.</p>\n\n\n\n<p>[00:33:03] <strong>Tammie Lister:</strong> I haven&#8217;t yet fully.</p>\n\n\n\n<p>[00:33:04] <strong>Nathan Wrigley:</strong> What&#8217;s, the kind of intuition that that you&#8217;re going to tackle.</p>\n\n\n\n<p>[00:33:08] <strong>Tammie Lister:</strong> I really want to start creating my own themes again, that&#8217;s one of the things. And I also want to start exploring maybe some plugins as well. I don&#8217;t have an idea yet, but the idea that I can start. I&#8217;m going to use the word playing, but playing to an end. I have so many ideas, and that&#8217;s awesome, but I need to work out which idea I&#8217;m going to work on.</p>\n\n\n\n<p>[00:33:30] <strong>Nathan Wrigley:</strong> Okay, so maybe we should do this conversation again in 2025, and see where you are?</p>\n\n\n\n<p>[00:33:34] <strong>Tammie Lister:</strong> I have a theme site, Composition Themes, and I want to, I want to start making themes that have one purpose and, both that are beautiful, but also that have one purpose for types as well. That&#8217;s where I want to be themeing. But I also really like the idea of doing similar for plugins.</p>\n\n\n\n<p>Maybe it&#8217;s blocks, but maybe it&#8217;s also companion experience plugins. Going back to that idea of experience. I love the idea of maybe making the experience lesser for the editor or maybe exploring different things around that.</p>\n\n\n\n<p>[00:34:04] <strong>Nathan Wrigley:</strong> Yeah. Okay. 2025 is the date. We&#8217;ll have you back and we&#8217;ll see. What was it again?</p>\n\n\n\n<p>[00:34:08] <strong>Tammie Lister:</strong> Composition Themes.</p>\n\n\n\n<p>[00:34:10] <strong>Nathan Wrigley:</strong> Composition Themes.</p>\n\n\n\n<p>[00:34:10] <strong>Tammie Lister:</strong> Yeah. I also have Classic to Block Themes as well.</p>\n\n\n\n<p>[00:34:13] <strong>Nathan Wrigley:</strong> Oh, nice. Okay, we&#8217;ll put both of those in the show notes. Great. Well, Tammie Lister, thank you so much for joining me on the podcast today. I really appreciate it.</p>\n\n\n\n<p>[00:34:21] <strong>Tammie Lister:</strong> Thank you.</p>\n\n\n\n<p>[00:34:21] <strong>Nathan Wrigley:</strong> You are very welcome.</p>\n</div>\n\n\n\n<p>On the podcast today we have <a href=\"https://tammielister.com/\">Tammie Lister</a>.</p>\n\n\n\n<p>Tammie is a product creator focusing on WordPress. She has a hybrid background across product, design, psychology and development. She contributes to WordPress and is passionate about open source, and the community.</p>\n\n\n\n<p>If you’ve been in the WordPress space for a while, Tammie&#8217;s name is likely a familiar one. She&#8217;s an 18-year veteran of the project, a talented designer, developer, and a key contributor to the project. Her journey has made her wear a variety of hats in both agency life and product development.</p>\n\n\n\n<p>Today, Tammie shares insights that span from the practical to the philosophical within the open-source landscape. We get to hear Tammie&#8217;s perspective on this crucial experimentation phase in WordPress theme development, the balance she seeks between minimalist design and functional complexity, and her active roles, including the default theme task force.</p>\n\n\n\n<p>Our discussion takes us into the evolving WordPress editor experience, user roles, and interface design. We discuss the future of WordPress UI / UX, touching on visual configurations and how the Gutenberg site editor continues to shape our digital toolkit.</p>\n\n\n\n<p>For those inspired by themes, Tammie reveals her passion for them. From preserving the essence of classic themes to ways that the project might break new ground.</p>\n\n\n\n<p>She also introduces us to some of her own projects, such as Composition Themes, and discusses her Classic to Block Themes project as well.</p>\n\n\n\n<p>Tammie shares some of the resources that she recommends for both beginners and seasoned developers alike, bringing to light the many pathways that you can now choose to learn about WordPress.</p>\n\n\n\n<p>Looking over the horizon of collaborative editing and design systems, Tammie&#8217;s excitement for what&#8217;s next is palpable. So, whether you&#8217;re a developer, a designer, or a WordPress aficionado, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://asia.wordcamp.org/2024/\">WordCamp Asia</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/create-block-theme/\">Create Block Theme plugin</a></p>\n\n\n\n<p><a href=\"https://www.csszengarden.com/\">CSS Zen Garden</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/patterns/\">Pattern Directory</a></p>\n\n\n\n<p><a href=\"https://block-museum.com/\">Museum of Block Art</a></p>\n\n\n\n<p><a href=\"https://developer.wordpress.org/news/\">Developer blog</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/tag/hallwayhangout/\">Hallway Hangouts</a></p>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\">Learn WordPress</a></p>\n\n\n\n<p><a href=\"https://wordpress.tv/\">WordPress.tv</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/state-of-the-word/\">State of the Word from 2024</a></p>\n\n\n\n<p><a href=\"https://guildenberg.com/\">Gildenberg</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2023/12/05/proposal-default-theme-task-force-for-2024/\">Jonathan Desrosiers&#8217; post &#8220;Proposal: Default Theme Task Force for 2024&#8221;</a></p>\n\n\n\n<p><a href=\"https://compositionthemes.com/\">Composition Themes</a></p>\n\n\n\n<p><a href=\"https://classictoblock.com/\">Classic to Block Themes</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 03 Apr 2024 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Do The Woo Community: You Don’t Need to be a Developer to Join a Hackathon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=80797\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://dothewoo.io/you-dont-need-to-a-developer-to-join-a-hackathon/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"Patricia, a non-developer and WordPress contributor, shares her experience and the value of having diverse skills at CloudFest Hackathon.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 03 Apr 2024 09:02:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"HeroPress: The Time I Left My Island – Quella volta che sono uscito dalla mia isola\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=6656\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:214:\"https://heropress.com/essays/the-time-i-left-my-island-quella-volta-che-sono-uscito-dalla-mia-isola/#utm_source=rss&utm_medium=rss&utm_campaign=the-time-i-left-my-island-quella-volta-che-sono-uscito-dalla-mia-isola\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:21363:\"<img width=\"1024\" height=\"512\" src=\"https://heropress.com/wp-content/uploads/2024/04/040224-min.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: The sea has never been a limit, now that I know the way, I can cross it whenever I want. - Il mare non è mai stato un limite, ora che conosco la strada, posso attraversarlo tutte le volte che voglio.\" /><p><a href=\"https://heropress.com/feed/#italian\">Questo saggio è disponibile anche in italiano.</a></p>\n\n\n\n<p>Perfect, I have my blank sheet, notes on what I need to express, and I&#8217;m ready to write this essay. I have my hot coffee on the desk and my compilation of Bob Dylan playing in my ears, but we&#8217;re on the tenth song and I haven&#8217;t written a word yet, in fact, I&#8217;ve written and then deleted many. Do you know what happens? I&#8217;m not a writer, I spend my life in PHP, why should I completely detach from what is my daily routine? Okay, here we go! I&#8217;ll open my code editor, coffee, and Dylan at this hour are constants, let&#8217;s see if the words flow now.</p>\n\n\n\n<h2 class=\"kt-adv-heading6656_ed8ffe-24 wp-block-kadence-advancedheading\">My Island</h2>\n\n\n\n<p>I&#8217;m Sardinian, I come from an island in the Mediterranean envied for its sea, climate, food, and the warmth of its people. Let&#8217;s talk about an island, and sometimes the sea is a boundary, it&#8217;s a beautiful blue wall that separates you from the rest of the world, often it&#8217;s difficult to feel Italian, let alone European.</p>\n\n\n\n<p>My story begins here, with a strong introversion orchestrating my life, a passion for computer science, PHP which had been accompanying me for about 5 years, and some small attempts to overcome my shyness. Not to mention the years of studying English at school, which remained theoretical and never put into practice. To help me overcome shyness, I had started speaking at small events about Free Software, and there had been some small improvements. Meanwhile, I was beginning to get to know a CMS called WordPress, required by several companies; at that time, I didn&#8217;t know what it would give me.</p>\n\n\n\n<p>I had left my small town and moved to Cagliari, the city, on my island and facing the sea. Imagine, in 10 minutes with public transport, I was at the nearest beach, and in 30 minutes, I was at those beaches you see in screensavers. I felt in my place, at least geographically. But sometimes an island doesn&#8217;t offer you much from a work perspective, and remote work wasn&#8217;t yet so widespread. But my move to Cagliari was just a first step, like when you dip your foot in the water to see if it&#8217;s cold, before taking a run and diving in.</p>\n\n\n\n<h2 class=\"kt-adv-heading6656_06671b-01 wp-block-kadence-advancedheading\">Let&#8217;s change the song, but also the city and life.</h2>\n\n\n\n<p>I packed my bags, took a flight, and changed regions to pursue a job. I was leaving the place that De Andrè, a famous Italian singer-songwriter, described: &#8220;Life in Sardinia is perhaps the best a man can wish for: twenty-four thousand kilometers of forests, countryside, coasts immersed in a miraculous sea should coincide with what I would recommend to God to give us as Paradise.&#8221; And I arrived in what another famous Italian singer, Ligabue, describes as &#8220;This city is a hell disguised as paradise, where every dream is at risk of burning.&#8221;</p>\n\n\n\n<p>The city called me, and now I&#8217;m here. There are proposals, there are opportunities, there are hopes, and there are dreams, all within reach, my reach. The city is ready to give me everything but it needs me, my time, and my hard work. I just had to change, the island had to become a city, shyness must disappear here and change pace. Walking following that frenetic rhythm, which I didn&#8217;t understand, but which was ready to give me more and more.</p>\n\n\n\n<p>If you walk fast, in a place you don&#8217;t know, you risk coming across a street you don&#8217;t know and you could find yourself in a situation you never want to relive. You could walk on asphalt, on the sidewalk, or on a lawn, and if you&#8217;re not careful, it&#8217;s easy to stumble upon something, and from a panic attack, it&#8217;s not always easy to get back up, from two, worse.</p>\n\n\n\n<p>During the same period, I found myself on a fairly intense WordPress-based project, and between one check and another, my eye fell on a type of event I didn&#8217;t know, called WordCamp Torino, just over an hour by train from where I was.</p>\n\n\n\n<p>Early wake-up call, coffee, and off to the station, the train departs and slowly the city fades away. I participate in a contributor day and a day of talks. A nice event, I took thousands of notes but experienced only as much as my shyness allowed me to.</p>\n\n\n\n<p>I knew that this event was much more beautiful than what I had experienced, so I started paying more and more attention to that part of the site until I found two tickets, Zurich and Verona. I bought the ticket to Verona immediately, but Zurich was two weeks earlier and the choice wasn&#8217;t so easy.</p>\n\n\n\n<p>Zurich is part of German-speaking Switzerland, okay that the WordCamp was organized in two languages, but my English had been stagnant for almost 12 years, plus it was a trip to be done alone.</p>\n\n\n\n<p>Verona was a great WordCamp, I began to understand how these events work and to meet some members of the city&#8217;s MeetUp.</p>\n\n\n\n<p>Honestly, I remember Zurich less and less, it was a beautiful WordCamp, but I learned more things about myself there than about WordPress. I just wonder if there are Swiss people who believe that my surname is &#8220;sorry my English is terrible&#8221;, because when I&#8217;m a bit nervous, I speak faster and to introduce myself I would say &#8220;My name is Matteo sorry my English is terrible, nice to meet you&#8221;. The thing I remember best is that I filled out the application to be a speaker and volunteer during the return trip. Let&#8217;s talk about WordCamp Milano.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-but-it-s-just-a-tool-how-can-it-do-all-this\">But it&#8217;s just a tool, how can it do all this?</h2>\n\n\n\n<p>I was preparing my slides, comparing WordPress development with another CMS, starting from the latter. After finishing the first section where I had to talk about WordPress, I had to create a separation slide. Somewhat sarcastically, I wrote &#8220;But we&#8217;re at a WordCamp so let&#8217;s go home!&#8221; Ajo is a word widely used in Sardinia, taking it away from a Sardinian is like preventing a Roman from saying daje, it&#8217;s the equivalent of an English &#8220;let’s go&#8221;.</p>\n\n\n\n<p>It wasn&#8217;t my first time in front of an audience, but I was used to a maximum of 20/30 people. I found myself facing a university class with a lot of people, I was extremely excited and super tense. But at my &#8220;ajo&#8221; moment, amidst some laughter and some smiles, I felt at home again, in my island but at the same time in Milan, what a strange feeling.</p>\n\n\n\n<p>But it&#8217;s just a CMS, a work tool, how can it do all this? A stupid question if the person asking it has books like &#8220;Just for Fun&#8221; by Linus Torvalds, &#8220;The Cathedral and the Bazaar&#8221; by Eric Steven Raymond, and &#8220;Free Software, Free Society&#8221; by Richard Stallman in their library. So the term &#8220;community&#8221; in those texts was true and WordPress was the best example I could come across.</p>\n\n\n\n<p>In the span of a few months, I also attended events in Dublin and volunteered in Glasgow, English wasn&#8217;t a limitation for me, just something I had to work on.</p>\n\n\n\n<p>Glasgow was at the beginning of 2020, the last memory of a WordCamp before a year of closure, a year where there were online events, but the energy was different. A period in which I changed two jobs.</p>\n\n\n\n<p>It was a period halfway between the city and the island until the end of 2021, when I saw &#8220;WordCamp Geneva&#8221;, I proposed to tell my story at WordCamps, how they helped me, but they still do, both with language confidence and shyness. It was accepted and that became both my first talk in English, but also the non-technical one. A talk that involved a higher intimacy never experienced before, which will always remain a source of pride for me.</p>\n\n\n\n<p>From that moment on, WordCamp after WordCamp, each stop began to give me more and more emotions and more and more lessons, especially about myself, but not about who I am, but about what I could and wanted to be.</p>\n\n\n\n<p>From WordCamp Italy where I first became an organizer to Turin and Verona as a speaker.</p>\n\n\n\n<p>In all three, I decided to participate both days, also attending contribution days and gladly joining the polyglots team, a group I have never abandoned.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-to-infinity-and-beyond\">To infinity and beyond</h2>\n\n\n\n<p>Then they announced WordCamp Europe in Turin, the city where it all started, I applied as an organizer, which was accepted. Now I find myself talking to many new people in English almost twice a week. Every time is a challenge to my shyness, but by now I&#8217;ve learned to accept them.</p>\n\n\n\n<p>Sometimes I find myself comparing my first and last WordCamp. From a silent Contribution Day to one where I shared my experience, from being an attendee to a speaker with many listeners, from a day in silence to being someone trying to integrate the newcomers, from a person who leaves early to the last person leaving the after-party.</p>\n\n\n\n<p>But WordPress is just a tool, the end goal is always something else, in my story it&#8217;s not a website but understanding a part of myself and stopping suffocating my true identity and starting to behave in my own way. Making me understand that my island side shouldn&#8217;t be suppressed but valued, it was always me. Like in the code, with oneself too, there are best practices, they are needed to look back and live in harmony with oneself. In my case, WordCamp after WordCamp, I added one more brick to my self-esteem and I understood something more about my shyness.</p>\n\n\n\n<p>In the end, living the WordPress community, getting to know many different people guided me towards rediscovering myself until I realized that I had never left my island, maybe it was the city&#8217;s fog that made me perceive it as farther away, it had always been here. The sea has never been a limit, now that I know the way, I can cross it whenever I want. My island was me and now I&#8217;ve learned to accept it.</p>\n\n\n\n<p>Yes, I&#8217;d say I did well to use the dark editor! Let&#8217;s contribute!</p>\n\n\n\n<h1 class=\"wp-block-heading\" id=\"italian\">Quella volta che sono uscito dalla mia isola</h1>\n\n\n\n<p>Perfetto, ho il mio foglio bianco, gli appunti su quello che devo esprimere e sono pronto a scrivere questo saggio. Ho il mio caffè caldo sulla scrivania e la mia compilation di Bob Dylan alle orecchie, ma siamo alla decima canzone e non ho ancora scritto una parola, anzi, ne ho scritte e poi cancellate tante. Sai che succede? Non sono uno scrittore, passo la mia vita in PHP, perché dovrei estraniarmi completamente da ciò che è la mia quotidianità? Ok, ci sono! Apro il mio editor di codice, il caffè e Dylan a quest&#8217;ora sono una costante, vediamo se ora le parole escono.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-la-mia-isola\">La mia isola</h2>\n\n\n\n<p>Sono sardo, vengo da un’isola del mediterraneo invidiata per il mare, il clima, il cibo ed il cuore delle persone. Parliamo di un isola, e il mare a volte è un limite, è un bellissimo muro blu che ti separa dal resto del mondo, spesso si ha la difficoltà di sentirsi italiani, figurati europei.</p>\n\n\n\n<p>La mia storia inizia qua, con una forte introversione che orchestrava la mia vita, la passione per l&#8217;informatica, il PHP che da circa 5 anni mi accompagnava e qualche piccolo tentativo di superare la mia timidezza. Senza dimenticare gli anni di studio dell&#8217;inglese a scuola, che sono rimasti teorici e mai messi in pratica. Per aiutarmi a sconfiggere la timidezza avevo iniziato a fare lo speaker in piccoli eventi sul Software Libero e qualche piccolo miglioramento c&#8217;era stato. Intanto iniziavo a conoscere un CMS chiamato WordPress richiesto da diverse aziende, in quel periodo non sapevo quello che mi avrebbe dato.</p>\n\n\n\n<p>Avevo lasciato il mio paesino e trasferito a Cagliari, la città, nella mia isola e davanti al mare. Pensate, in 10 minuti con i mezzi cittadini ero nella spiaggia più vicina e in 30 minuti ero in quelle spiagge che si vedono nei screensaver. Mi sentivo nel mio posto, almeno geograficamente. Ma un&#8217;isola a volte, non ti offre tantissimo da un punto di vista lavorativo e il lavoro da remoto non era ancora così diffuso. Ma il mio trasferimento a Cagliari era solo un primo passo, come quando metti il piede in acqua per sapere se è fredda, prima di prendere la rincorsa e tuffarsi.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-cambiamo-canzone-ma-anche-citta-e-vita\">Cambiamo canzone, ma anche città e vita</h2>\n\n\n\n<p>Avevo riempito le valigie, preso un volo e cambiato regione per seguire un lavoro. Lasciavo il luogo che De Andrè, un famoso cantautore italiano, descriveva: “La vita in Sardegna è forse la migliore che un uomo possa augurarsi: ventiquattromila chilometri di foreste, di campagne, di coste immerse in un mare miracoloso dovrebbero coincidere con quello che io consiglierei al buon Dio di regalarci come Paradiso” e arrivavo in quella che un altro famoso cantante italiano, Ligabue, descrive come “Questa città è un inferno travestito da paradiso, dove ogni sogno è a rischio di bruciarsi&#8221;.</p>\n\n\n\n<p>La città mi ha chiamato, ed ora sono qua. Ci sono proposte, ci sono occasioni, ci sono speranze e ci sono sogni e tutte a portata di mano, la mia mano. La città è pronta a darmi tutto ma ha bisogno di me, del mio tempo e del mio duro lavoro. Dovevo solo cambiare, l’isola doveva diventare città, la timidezza deve sparire qua e cambiare passo. Camminare seguendo quel ritmo frenetico, che non capivo, ma che era pronto a darmi sempre di più.</p>\n\n\n\n<p>Se cammini veloce, in un posto che non conosci, rischi di imbatterti in una strada che non conosci e potresti trovarti in una situazione che mai vorresti rivivere. Potresti camminare sull’asfalto, sul marciapiede o su un prato, e se non si sta attenti è facile inciampare su qualcosa e da un attacco di panico non sempre è facile rialzarsi, da due peggio.</p>\n\n\n\n<p>Nello stesso periodo mi sono ritrovato su un progetto basato su WordPress abbastanza intenso e tra un controllo e l&#8217;altro mi è caduto l’occhio su una tipologia di evento, che non conoscevo, chiamato WordCamp Torino a poco più di un ora di treno da dove stavo.&nbsp;</p>\n\n\n\n<p>Sveglia presto, caffè e di corsa in stazione, il treno parte e pian piano la città si allontana. Partecipo ad un giorno di contributor day e ad una giornata di talk. Un bel evento, preso migliaia di appunti ma vissuto come solo la mia timidezza mi permetteva di essere.&nbsp;</p>\n\n\n\n<p>Sapevo che questo evento era molto più bello di quello che avevo vissuto, quindi inizio a prestare sempre più attenzione a quella parte del sito sino a che non trovai due biglietti, Zurigo e Verona. Il biglietto di Verona lo presi subito, ma Zurigo era due settimane prima e la scelta non era così facile.&nbsp;</p>\n\n\n\n<p>Zurigo fa parte della Svizzera tedesca, ok che il WordCamp era organizzato in due lingue, ma il mio inglese era rimasto fermo da quasi 12 anni, in più era un viaggio da fare da solo.</p>\n\n\n\n<p>Verona fu un ottimo WordCamp, iniziai a capire il funzionamento di questi eventi e conoscere alcuni componenti dei MeetUp della città.</p>\n\n\n\n<p>Zurigo sinceramente lo ricordo sempre meno, è stato un bellissimo WordCamp, ma ho imparato lì più cose su me stesso che su WordPress. Mi chiedo solamente se ci sono svizzeri che credono che il mio cognome sia “sorry my English is terrible”, perchè quando sono un po’ nervoso, parlo più veloce e per presentarmi dicevo “My name is Matteo sorry my English is terrible, nice to meet you”. La cosa che ricordo meglio è che ho compilato la domanda per fare da speaker e volontario durante il viaggio di ritorno.&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-parliamo-di-wordcamp-milano\">Parliamo di WordCamp Milano.</h2>\n\n\n\n<p>Ma è solo uno strumento, come può fare tutto questo?</p>\n\n\n\n<p>Preparo le mie slide, confrontavo lo sviluppo su WordPress con un altro CMS, partendo da quest’ultimo. Finito il primo pezzo dovevo parlare di WordPress, dovevo creare una slide di separazione, un po’ sarcasticamente scrissi “Ma siamo in un WordCamp quindi ajo a casa!”. Ajo è una parola molto usata in Sardegna, toglierla a un sardo è come impedire ad un romano di dire daje, è l&#8217;equivalente di un “let’s go” inglese.&nbsp;</p>\n\n\n\n<p>Non era la prima volta davanti ad un pubblico, ma ero abituato a un massimo di 20/30 persone, mi trovai davanti una classe universitaria con tantissime persone, ero emozionatissimo e super teso. Ma al mio momento del “ajo”, tra qualche risata e qualche sorriso mi sentii nuovamente a casa, nella mia isola ma allo stesso tempo a Milano, che strana emozione.&nbsp;</p>\n\n\n\n<p>Ma si tratta di un CMS, uno strumento di lavoro, come può fare tutto questo? Una domanda stupida se chi la fa ha nella sua libreria libri come “Rivoluzionario per caso” di Linus Torvald, “La cattedrale e il bazaar” di Eric Steven Raymond e “software libero, pensiero libero” di Richard Stallman. Quindi il termine “comunità” in quei testi era vero e WordPress era il miglior esempio in cui potevo capitare.</p>\n\n\n\n<p>Nel giro di pochi mesi, partecipai anche a Dublino e feci da volontario a Glasgow, l’inglese non era un mio limite, ma solo qualcosa su cui dovevo lavorare.&nbsp;</p>\n\n\n\n<p>Glasgow fu ad inizio 2020, l’ultimo ricordo di un WordCamp prima di un anno di chiusura, un anno in cui c&#8217;erano gli eventi online, ma l’energia era diversa. Un periodo in cui cambia due lavori.<br />Fu un periodo a metà tra la città e l’isola fino alla fine del 2021, quando vidi “WordCamp Ginevra”, proposi di raccontare la mia storia nei WordCamp, come mi aiutarono, ma lo fanno tutt’ora, sia con la sicurezza nella lingua che con la timidezza. Fu accettato e quello per me diventò sia il mio primo talk in inglese, ma anche quello non tecnico. Un talk che prevedeva un&#8217;intimità più alta mai sperimentata, che rimarrà per sempre un mio orgoglio.</p>\n\n\n\n<p>Da quel momento in poi, WordCamp dopo WordCamp, ogni tappa iniziò a regalarmi sempre più emozioni e sempre più lezioni, soprattutto su me stesso, ma non su come sono, ma su quello che potevo e volevo essere.&nbsp;</p>\n\n\n\n<p>Da WordCamp Italia in cui feci per la prima volta l’organizer a Torino e Verona da speaker.</p>\n\n\n\n<p>In tutti e tre decisi di partecipare entrambi i giorni, partecipando anche alle giornate di contribuzione e portandomi con piacere nel team polyglots, gruppo che non ho mai più abbandonato.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-verso-l-infinito-ed-oltre\">Verso l’infinito ed oltre</h2>\n\n\n\n<p>Poi annunciarono WordCamp Europe a Torino, la città dove tutto è iniziato, feci domanda come organizer, che fu accettata. Ora mi ritrovo a parlare con tantissime persone nuove in inglese quasi due volte alla settimana. Ogni volta è una sfida alla mia timidezza, ma ormai ho imparato ad accettarle.</p>\n\n\n\n<p>A volte mi capita di confrontare il mio primo ed ultimo WordCamp. Da un Contribution Day silenzioso ad uno in cui raccontavo la mia esperienza, solo attendee a speaker con tantissimi ascoltatori, da una giornata in silenzio a persona che cercava di far integrare i nuovi, da persona che rientra presto all’ultima persona che esce dall&#8217;after party.</p>\n\n\n\n<p>Ma WordPress è solo uno strumento, il fine è sempre un altro, nella mia storia non è un sito internet ma riuscire a capire una parte di me e smettere di soffocare la mia vera identità ed iniziare a comportarsi a modo mio. Facendomi capire che la mia parte isola non andava soffocata ma valorizzata, ero sempre io. Come nel codice, anche con se stessi, ci sono delle best practice, servono per riguardarsi e vivere in armonia con se stessi. Nel mio caso, WordCamp dopo WordCamp ho messo un mattoncino in più alla mia autostima e ho capito qualcosa in più sulla mia timidezza.</p>\n\n\n\n<p>Alla fine vivere la community di WordPress, conoscere tante persone diverse mi ha guidato verso la riscoperta di me stesso sino ad accorgermi che non avevo mai lasciato la mia isola, forse era la nebbia della città che me la faceva percepire più lontana, era sempre stata qui. Il mare non è mai stato un limite, ora che conosco la strada, posso attraversarlo tutte le volte che voglio. La mia isola ero io e ora ho imparato ad accettarlo.</p>\n\n\n\n<p>Si, direi che ho fatto bene ad usare l’editor scuro! Ajo a contribuire!</p>\n<p>The post <a href=\"https://heropress.com/essays/the-time-i-left-my-island-quella-volta-che-sono-uscito-dalla-mia-isola/\">The Time I Left My Island &#8211; Quella volta che sono uscito dalla mia isola</a> appeared first on <a href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 03 Apr 2024 07:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Matteo Enna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"WordPress.org blog: WP Briefing: Episode 76: A WordPress 6.5 Sneak Peek\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=17158\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wordpress.org/news/2024/04/episode-76-a-wordpress-6-5-sneak-peek/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:40474:\"<p>Join WordPress Executive Director, Josepha Haden Chomphosy, as she offers an exclusive preview of the upcoming WordPress 6.5 release, accompanied by special guest Dave Smith, one of the Editor Tech leads for this release. Don&#8217;t miss this opportunity for an insider&#8217;s look!</p>\n\n\n\n<h2 class=\"wp-block-heading\">Credits</h2>\n\n\n\n<p>Host:&nbsp;<a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden Chomphosy</a><br />Guest:&nbsp;<a href=\"https://profiles.wordpress.org/mikachan/\">Dave Smith</a><br />Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a><br />Logo:&nbsp;<a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a><br />Production:&nbsp;<a href=\"https://profiles.wordpress.org/bjmcsherry/\">Brett McSherry</a> and <a href=\"https://profiles.wordpress.org/eidolonnight/\">Nicholas Garofalo</a><br />Song: Fearless First by Kevin MacLeod</p>\n\n\n\n<h2 class=\"wp-block-heading\">Show Notes</h2>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.org/download/\">WordPress Download</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/6-5/#:~:text=To%20get%20involved%20in%20WordPress,leave%20feedback%20on%20the%20ticket.\">WordPress 6.5 Development Cycle</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/03/07/unblocking-wp6-5-font-library-and-synced-pattern-overrides/\">Unblocking WP6.5 – Font Library and Synced Pattern Overrides</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/block-editor/reference-guides/packages/packages-dataviews/\">Data Views</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/07/12/admin-design/\">WP-Admin Redesign</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/ticket/59166\">Font Library</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2024/02/29/an-introduction-to-block-based-mega-menus/\">An Introduction to Block-Based Mega Menus</a></li>\n\n\n\n<li><a href=\"https://www.youtube.com/daveonwp\">Dave on WP</a>\n<ul>\n<li><a href=\"https://www.youtube.com/watch?v=ySyJRYAbU_M\">These TINY Link Editing CHANGES Just Made WORDPRESS 6.5 So Much Better</a></li>\n</ul>\n</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/03/04/interactivity-api-dev-note/\">Interactivity API in 6.5</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2024/01/13/early-opportunities-to-test-wordpress-6-5/\">Opportunities to Test WordPress 6.5</a></li>\n\n\n\n<li><strong>Small List of Big Things</strong>\n<ul>\n<li><a href=\"https://make.wordpress.org/community/2024/03/08/asia-meetup-revival-project-2024/\" target=\"_blank\" rel=\"noreferrer noopener\">Asia Meetup Revival Project 2024</a> </li>\n\n\n\n<li><a href=\"https://make.wordpress.org/meetings/\" target=\"_blank\" rel=\"noreferrer noopener\">Upcoming WordPress Meetings</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/marketing/2024/03/20/making-a-wordpress-media-corps/\" target=\"_blank\" rel=\"noreferrer noopener\">Making a WordPress Media Corps</a></li>\n</ul>\n</li>\n\n\n\n<li>Have a question you’d like answered? Submit them to <a href=\"mailto:wpbriefing@WordPress.org\">WPBriefing@WordPress.org</a>.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Transcript</h2>\n\n\n\n<span id=\"more-17158\"></span>\n\n\n\n<p>[00:00:00] <strong>Josepha:</strong> Hello, everyone, and welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks.</p>\n\n\n\n<p>I&#8217;m your host, Josepha Haden Chomphosy. Here we go!&nbsp;</p>\n\n\n\n<p>[00:00:28] (Intro Music)&nbsp;</p>\n\n\n\n<p>[00:00:39] <strong>Josepha:</strong> Dave, I&#8217;m so excited to have you here with us today. Welcome.</p>\n\n\n\n<p>[00:00:42] <strong>Dave:</strong> Thank you. I&#8217;m really excited to be here. Thank you so much for inviting me on.</p>\n\n\n\n<p>[00:00:46] <strong>Josepha:</strong> Yeah. So before we get much further, how about you tell us a little bit about what you do on the WordPress project? And if I recall correctly, that you have a role on the release squad. So just let us know a bit about what that role is and what that looks like.</p>\n\n\n\n<p>[00:01:00] <strong>Dave:</strong> Sure. Absolutely. Well, obviously said I&#8217;m Dave Smith. I&#8217;m from England in the United Kingdom, and I am full-time contributor to WordPress. I&#8217;ve focused primarily on the Block Editor during that time. And I&#8217;ve been doing it for about three years now. And fortunately for me, I am sponsored by Automattic, so that allows me to contribute full-time to the project, which is fantastic.</p>\n\n\n\n<p>But my history of WordPress goes back a fair way longer than that, and I used to work in agency land, and so I used WordPress for making things for a living before I worked in WordPress if you see what I mean.&nbsp;</p>\n\n\n\n<p>[00:01:35] <strong>Josepha:</strong> I, no, I definitely understand. I also was agency before WordPress.&nbsp;</p>\n\n\n\n<p>[00:01:40] <strong>Dave:</strong> I think it&#8217;s a common origin story, if you see what I mean. And yes, you&#8217;re absolutely right. I&#8217;ve been fortunate enough in this release, WordPress 6.5, to be the Co-editor Tech Lead. Obviously alongside my colleague which is Riad Benguella. Some of you may know him. He is the lead architect of Gutenberg. So yeah, it&#8217;s been fantastic to work alongside him.</p>\n\n\n\n<p>[00:02:00] <strong>Josepha:</strong> Yeah, excellent. One of these days, I&#8217;m going to get Riad on here. I think I&#8217;ve never had him on.</p>\n\n\n\n<p>[00:02:05] <strong>Dave:</strong> Oh, you should definitely.&nbsp;</p>\n\n\n\n<p>[00:02:06] <strong>Josepha:</strong> He&#8217;s so kind and reasonable. And I was just gonna tell a personal anecdote about Riad, and I don&#8217;t know that it makes any sense, but I&#8217;m gonna do it anyway. I&#8217;m gonna do it anyway. I saw him at an event like right after he came back from his most recent sabbatical, and he was like, it was great being away, but also like, I had forgotten what kind of energy events like this really bring in.</p>\n\n\n\n<p>And he has always struck me as an introvert, but I think maybe he&#8217;s like an outgoing introvert or something. Cause normally, like, introvert introverts are not like, this gives me so much energy. They&#8217;re like, I know that this is important work, and I&#8217;m here. And so that&#8217;s my personal anecdote about Riad, I am, gonna get him on here someday, but be that as it may, we&#8217;re delighted to have you.</p>\n\n\n\n<p>So, 6.5 is coming out are you excited, number one?</p>\n\n\n\n<p>[00:02:54] <strong>Dave:</strong> I am very excited. Yeah, it&#8217;s been a long road into this release. As you may know, well, as you do know, it&#8217;s, it was delayed by one week. That was actually, I think was, was a good decision. We&#8217;ve had a lot of work needing to go into the Font Library feature. I&#8217;ve seen a few posts saying there were bugs.</p>\n\n\n\n<p>[00:03:09] <strong>Dave:</strong> I think mainly it was a decision about where to upload fonts to, which seems quite amazing when you think about it. I was talking to my wife about it the other day, and she said, really, you&#8217;re delaying a release because of where to upload things. But, yeah, this is software that runs a considerable part of the web.</p>\n\n\n\n<p>So when we make these decisions about where things uploaded, we&#8217;ve got to be really confident that they are the right decisions. And so, yeah, that decision to delay the release has been good. And we&#8217;ve had an opportunity to make sure the release is fully robust and ready to go out. So yeah, I&#8217;m super excited to see it land.</p>\n\n\n\n<p>[00:03:40] <strong>Josepha:</strong> Yeah. I have some follow up questions about just like, how doing all of that work in public feels. But probably, we should get through the bulk of the sorts of things that people tune into this episode for, so like, let&#8217;s talk about some of the big features that are going into 6.5 so that folks have a sense for that.</p>\n\n\n\n<p>And then we&#8217;ll take a look at just like things that you&#8217;re excited to get in, things that I&#8217;m excited to get in. And maybe like if there&#8217;s a hidden surprise for users, things that will be really beneficial to users, but they don&#8217;t quite see it yet. We can maybe cover that too, but like, what are the big things going into this release from your perspective?</p>\n\n\n\n<p>[00:04:17] <strong>Dave:</strong> Sure. There&#8217;s some highlights, I think that the key highlights, and we should probably cover them. So the first one we&#8217;ve already touched on it is the Fonts Library. And this has been brewing for a while now, and it&#8217;s finally come to fruition. And it basically allows you to manage, install, and upload custom fonts for use on your website. And it&#8217;s really, really powerful. It&#8217;s, I think it&#8217;s going to really change the way people create themes and create their websites. It is unlocking a lot of power for users.</p>\n\n\n\n<p>[00:04:46] <strong>Josepha:</strong> And for folks who&#8217;ve been listening to this podcast for a long time, you have heard me say for, I think, like a year, basically every release podcast where we&#8217;re looking at what&#8217;s coming up. I&#8217;m like, and this time it&#8217;s fonts. I&#8217;m so excited. And so I&#8217;m saying it again this time, &#8217;cause it&#8217;s really happening this time.</p>\n\n\n\n<p>[00:05:03] <strong>Dave:</strong> It&#8217;s finally here. Yeah, it&#8217;s a great feature. There&#8217;s a lot of work gone into it. It&#8217;s really, really good.</p>\n\n\n\n<p>[00:05:07] <strong>Josepha:</strong> So much work. We&#8217;ve been working on it for like two or three years. And it&#8217;s at the point where like getting it out in front of people is the only way to figure out where the remaining problems will be. And it is the most scary part of any software release, I assume, the things where you&#8217;re like, this is time for people to tell us how it&#8217;s broken. Please look at it and break it for a while.</p>\n\n\n\n<p>[00:05:29] <strong>Dave:</strong> Yeah, absolutely. We&#8217;ve been working on resolving any bugs that we could find, but there&#8217;s always going to be things we haven&#8217;t noticed. So yeah, we can&#8217;t wait for users to get their hands on it. Exactly. Other than fonts, we&#8217;ve also got revisions that are now in place in the Site Editor. And this is more than just undo, redo that people may be already familiar with in the editor.</p>\n\n\n\n<p>It actually gives you the ability to fully revert your site back to any state that you previously had it. So you could make some changes in the editor. You could completely close down your computer, go away for a week, come back. And you&#8217;ve still got the opportunity to say, &#8220;Ah, do you know what? I don&#8217;t like the way that looks. I&#8217;m just gonna; I&#8217;m gonna roll that back.&#8221; And there&#8217;s a nice UI that shows you what it will affect. And you can even roll back styles, you know, like style changes. So it&#8217;s, it&#8217;s super, super powerful. And it&#8217;s just something we&#8217;ve been waiting for for such a long time. Just, it&#8217;s fantastic to see it land.</p>\n\n\n\n<p>[00:06:17] <strong>Josepha:</strong> I&#8217;m really excited about this one personally because I have been to so many meetup events with like new users being taught how to do things with WordPress. And invariably, in the last two or three years, the people who are presenting to new users are saying consistently like, &#8220;You can do any experimental thing that you feel like you need to do with your sites because there&#8217;s an undo button. WordPress wouldn&#8217;t let you do things that fully break your site.&#8221;</p>\n\n\n\n<p>Like there is a lot of trust in our kind of like time machine, roll-it-back kind of implementations. And so I&#8217;m really excited about this one. I think that for all of our new and mid-level users. Who like, have a little bit of fear, but mostly joy around it. Like, this will only increase that and so I&#8217;m super excited for this one to go in there.</p>\n\n\n\n<p>[00:07:09] <strong>Dave:</strong> Yeah, it&#8217;s really nice. Other than that, the two things I wanted to touch on as well, which is we&#8217;ve got these new views now for key objects in WordPress. So things like pages, patterns, templates, and template parts in the Site Editor. You can now view these in a sort of a table layout or in a grid layout. So it gives you a much easier way to sort them, find them, filter them. And I think it points us forward to the possibilities we&#8217;ve got in the future for the editor sort of taking some parts of WP Admin and making them more accessible without having to leave the Site Editor. And it&#8217;s extremely powerful; you can search in real-time, find things very, very quickly, do all the things you&#8217;re used to from the post listing screen, but all within the Site Editor. And it&#8217;s for these key objects that you use quite a lot of the time. So I think it&#8217;s going to be really, a really great thing for users to get hold of.</p>\n\n\n\n<p>[00:07:55] <strong>Josepha:</strong> Is this related to the Data Views work that we&#8217;ve been doing in the first part of the year here?</p>\n\n\n\n<p>[00:08:00] <strong>Dave:</strong> Exactly that exactly. The Data Views work has been a major feed into this, and this is where we see the fruits of all that work coming to the fore for the first time. And I expect to see more of that in future releases as well.</p>\n\n\n\n<p>[00:08:12] <strong>Josepha:</strong> Yeah. For folks who are really, really watching, like, our administrative side of things, you probably are aware that we, I don&#8217;t know, I wouldn&#8217;t say that we paused the phase three roadmap for this, but I do think that we made a clear choice to get this Data Views work done first so that we could, in parallel with phase three, do a bit of work on the WP Admin redesign, the dashboard redesign, which we all know, like, we love this dashboard, but also this dashboard, it needs a sprucing up, it needs a little bit of, of polish and a little bit of 2024 style I was going to say design. I don&#8217;t know if the design folks would love if I just was like, it needs to be modernized that way, but also like it, it does, right?</p>\n\n\n\n<p>[00:09:00] <strong>Dave:</strong> Yeah, and I mean, you know, we all know that the Site Editor is being used more and more. If you&#8217;ve got a Block theme, you&#8217;re using the Site Editor increasingly, and you&#8217;re spending less and less time sort of going between screens in WP Admin. So it makes sense that, you know, these things are accessible within that one interface of the Site Editor. So, yeah, it&#8217;s only going to be a good thing for users going forward.</p>\n\n\n\n<p>[00:09:20] <strong>Josepha:</strong> Yeah, absolutely. I probably should have like a whole episode about Data Views and what it&#8217;s intending to do, what it&#8217;s actually doing, what it&#8217;s going to look like as it goes because that&#8217;s such a big project. And so many things rely on it. And so, note to self and all listeners, that&#8217;s the thing that you should keep an eye out for. We&#8217;re going to get it done. But you said you had a final thing also.</p>\n\n\n\n<p>[00:09:40] <strong>Dave:</strong> Yeah, I&#8217;ve got one more which is this is for our users of classic themes. We haven&#8217;t forgotten about you. Basically, we now have support for appearance tools. So in prior releases, the Block themes have got these really cool design tools like ability to set border colors, border radius, link colors, you name it. We&#8217;ve got all these tools, but they haven&#8217;t been always available to classic themes. And classic themes can use the Block Editor; they may not be using the Site Editor in the same way, but they can use the Block Editor. And we&#8217;ve not made those things available in the same way, but there&#8217;s been work going into this release to allow that to happen.</p>\n\n\n\n<p>[00:10:11] <strong>Dave:</strong> So now you can opt into those if you so wish. And it is an opt-in basis. So none your themes will break out of the box if you&#8217;ve got classic theme or classic site. But it is a powerful tool to those people who are using classic themes, and that&#8217;s completely legitimate.</p>\n\n\n\n<p>[00:10:26] <strong>Josepha:</strong> And so is the opt in like something that you can do for yourself or something that your developer needs to do?</p>\n\n\n\n<p>[00:10:32] <strong>Dave:</strong> You would need to do it in your theme code. So you&#8217;d need to do that with PHP. So, your theme developer, if they choose to update their theme and provide support for these things. Then, they would obviously need to test their theme works with those new tools, make sure it&#8217;s ready, and then they would ship that update.</p>\n\n\n\n<p>And so maybe after 6.5 is released, you may see some themes incrementally adding support. My understanding at the moment is that the core themes, the Block themes, will not automatically add those straight away. I think they need more time to allow them to bed in and more time to get them ready for prime time if you see what I mean, but you know the fact that they&#8217;re there and ready means that the wider theme audience and theme developers can start taking advantage of them.</p>\n\n\n\n<p>[00:11:15] <strong>Josepha:</strong> Nice, nice. I have been wondering lately, this is only marginally related, but I&#8217;m gonna wonder it out loud anyway. I&#8217;ve been wondering lately if like, our classic themes, our most favorite, our most loved classic themes do need a little bit of help moving into a Block theme future. And I think that this will help. I think, on the one hand this will help, and on the other hand, like, what would it take for us to just say, and you&#8217;re not the theme person I know, but like, what would it take for us to just say, &#8220;These are our top five most favorite, most used, classic themes that we&#8217;ve got in WordPress. Let&#8217;s rebuild it in blocks and just ship the block version of it and help the classic themes users that love the design, love the look, love the features get introduced to this new block territory so that they can see that not only do they have the look, the feel, the features, but also the flexibility that comes with that and a little bit more feeling of safety as they wander around modifying themes.&#8221;</p>\n\n\n\n<p>[00:12:18] <strong>Josepha:</strong> I have no fear of any code changes and didn&#8217;t when I started working with WordPress, as opposed to working in WordPress, but I think that that&#8217;s not the way that that works right now. Like there&#8217;s a whole lot of like, I need to get it right-ish with folks who are using our software. And so I just wonder if that will help everybody feel a little more confident in what they&#8217;re doing, knowing they&#8217;re not going to break things because we&#8217;ve built it so you can&#8217;t.</p>\n\n\n\n<p>[00:12:45] <strong>Dave:</strong> It could do, it could do. And I was just thinking as you were talking, like, do we have any themes that already do that? And, of course, we do have 2021. If you can think back that far into the mists of time, we had 2021 classic, which is that it&#8217;s called 2021, but we also 2021 blocks, which is doing very much what you&#8217;ve just described.</p>\n\n\n\n<p>[00:13:03] <strong>Dave:</strong> So we haven&#8217;t pursued that for the new default themes or block themes, but, you know, it might be something to look at for onboarding if there are any of classic themes from the more distant past, you know, maybe some of those could do with a block theme equivalent just to let people on board to that experience and just feel comfortable. Yeah, interesting, interesting. You should definitely talk to the theme people about that.</p>\n\n\n\n<p>[00:13:23] <strong>Josepha:</strong> I&#8217;m going to. They&#8217;re going to love it. They&#8217;re going to be like, Yay! Of course! Of course! I don&#8217;t know, actually. I don&#8217;t know if anyone ever loves the things that I suggest, but that doesn&#8217;t mean that they&#8217;re not going to get suggested. I have all these ideas, and they got to come out somewhere. Okay. So do you have something that you worked on that&#8217;s not in this big list of features or that you helped people to really shepherd into the release that you think is really cool? Like, maybe it&#8217;s not going to be super visible or something, but like that you&#8217;ve personally felt was like a cool feature, excited for it to get into the release.</p>\n\n\n\n<p>[00:13:53] <strong>Dave:</strong> Yeah, there are a couple of things, a couple of things at the top of mind. One of them is user-facing and one of them is more developer-facing features. So, I&#8217;ll start with the developer feature first. And this one is a change to an API. Now, that API is always a slightly intimidating word, I think, but it just means a set of tools, a standardized set of tools that developers can use to do something. And in this case, it&#8217;s the allowed blocks API. </p>\n\n\n\n<p>[00:14:20] <strong>Josepha:</strong> Sounds so fun.&nbsp;</p>\n\n\n\n<p>[00:14:21] <strong>Dave:</strong> Yeah, I know it&#8217;s riveting, isn&#8217;t it? But trust me, it does come with some benefits. So the Navigation block is a good example. It&#8217;s a block that acts as a container and it&#8217;s got child blocks. Okay. But you can only insert certain blocks. You can insert links, you can insert social icons, you can insert search. But if you want to insert, I don&#8217;t know, an Icon block, for example. You can&#8217;t do that, but you can with WordPress 6.5 because of the change to the allow box API. And what it allows you to do is say, &#8220;I want to additionally allow the following blocks to be inserted as well.&#8221;</p>\n\n\n\n<p>So as a developer, you can hook into this filter and change those blocks. Now, okay, so far, so good. &#8220;What&#8217;s the big deal?&#8221; you might say, well, it&#8217;s open the door, is open the door to some very, very interesting explorations. Some of which I&#8217;ve no doubt that you and your listeners would have already encountered. And one is by a colleague of mine called Nick Diego. And I think it&#8217;s on the WordPress Developer blog right now. I think he&#8217;s done a fantastic inspiration into mega menus in the navigation block. I&#8217;m someone who&#8217;s worked on the Navigation block extensively in the past, and I&#8217;m very aware of how much users want mega menus to be a part of the Navigation block.</p>\n\n\n\n<p>[00:15:30] <strong>Dave:</strong> I was never convinced it was going to be something we were going to do in core, because it requires so many different things. But Nick has actually managed with this allow blocks API and some other tweaks as well to build a mega menu as a plugin for WordPress using the standard Navigation block.</p>\n\n\n\n<p>And I think that&#8217;s just one example of the utility of this API. But for example, I mentioned that you could add icons to your Navigation block and you can&#8217;t really do that at the moment. It&#8217;s pretty powerful. It&#8217;s kind of hidden away. It&#8217;s in the release notes, but it&#8217;s not massively clear, but it does open some pretty big doors. And I think if you&#8217;re a developer or a theme author, indeed, you should you should definitely be looking into that and see what it enables for you.</p>\n\n\n\n<p>[00:16:06] <strong>Josepha:</strong> Yeah, we&#8217;ll put a link to Nick&#8217;s post in the show notes, and we&#8217;ll share it around the social spaces. So like, I hear you saying it&#8217;s buried, it&#8217;s hard to see, it won&#8217;t necessarily be exciting now, but will be exciting later, but like mega menus and sliders, those are the most contested things that people want to put on sites all the time. Like from my agency days, like when I was thinking in the mindset of a strategist, a data person, that&#8217;s what I was doing. Like, I never wanted sliders. I never wanted mega menus because it just implied that we didn&#8217;t have a decision about the sites we were making, like we had not decided the primary purpose, and also it was just hard to track, but it was always literally every single time people are like well if Amazon has it why can&#8217;t we have it? You&#8217;re like, yeah, I know, but they&#8217;re Amazon. They&#8217;re not the same like mega menus sliders. I know that from a project perspective that we&#8217;re like, that should be a theme thing. That should be in theme territory. But I think it makes sense to have in core because so many people want to be able to do it.</p>\n\n\n\n<p>[00:17:14] <strong>Josepha:</strong> And just because like someone like me feels like it&#8217;s not the right call for your business doesn&#8217;t mean that you shouldn&#8217;t be able to make that decision for yourself, you know, I think that&#8217;s a, I think that&#8217;s a great, a great feature to call out.</p>\n\n\n\n<p>[00:17:28] <strong>Dave:</strong> Yeah, absolutely. I completely agree. I can look for my agency days. I can exactly imagine that sort of thing. We have a lot of people, a problem that a lot of people are facing. So it&#8217;s really important that we provide the tools to allow people to do that now. And we can always look at if it&#8217;s valid to include it in core later, then we can look at that as well.</p>\n\n\n\n<p>Yeah. So that&#8217;s, that&#8217;s the first one I had. The second one is a little bit more user-facing. I would say it&#8217;s hidden away. But I&#8217;m not 100 percent sure it is. I mean, Josepha, how often do you create links when you&#8217;re working with WordPress?</p>\n\n\n\n<p>[00:17:58] <strong>Josepha:</strong> Like every time that I&#8217;m in WordPress.</p>\n\n\n\n<p>[00:18:00] <strong>Dave:</strong> Yeah, exactly. Same here. I do it all the time, right? And a lot of people do. And for a long while, contributors to the editor have been sort of collecting and collating the feedback that&#8217;s come in from people about their frustrations with the built in link interface in the Block Editor. So if you&#8217;re creating a hyperlink to, you know, hyperlink to another page or, you know, you&#8217;re going to link to Nick&#8217;s mega menu article, you&#8217;re going to be doing that a lot, right?</p>\n\n\n\n<p>That&#8217;s something that people do when they&#8217;re creating content in WordPress. And so we worked a lot to refine that with a contributor who, who you may know, Rich Tabor. Who&#8217;s also, I think, on the release squad as well. An influencer in the WordPress space as well. He spent a lot of time looking at the UX and myself and a number of other contributors have spent a lot of time in this release refining that. And I think it&#8217;s surprisingly difficult to get right, but I think we&#8217;ve, I think we&#8217;ve made some nice improvements to that will be nice quality of life for people who, to do this sort of content creation quite a lot.</p>\n\n\n\n<p>So there&#8217;s things like now when you create the link for the first time, it remains open on the initial creation of the link. So that means you can quickly then easily adjust the link. I mean, it seems obvious, doesn&#8217;t it? Yeah, but it&#8217;s not happening. It just used to just automatically close, and the people are like, &#8220;Hey, I wanted to make more adjustments. &#8220;</p>\n\n\n\n<p>[00:19:08] <strong>Josepha:</strong> I wasn&#8217;t done yet.&nbsp;</p>\n\n\n\n<p>[00:19:10] <strong>Dave:</strong> Exactly. Yeah, exactly. We&#8217;ve, we&#8217;ve streamlined the UI. We&#8217;ve removed a lot of clutter, but we&#8217;ve also added some useful tools, like ability to copy a link and remove the link directly from the control itself. And lastly along with lots of other accessibility changes in this release. We have worked a lot on refining the implementation.</p>\n\n\n\n<p>So that is discoverable for, for users of assistive tech because we spent a lot of time talking to core accessibility team and other people, and they were finding it very hard to perceive that the UI was there because of the way that keyboard interactions work and you&#8217;ve got the block toolbar in the way and things like that.</p>\n\n\n\n<p>We think we&#8217;ve nailed on a really good solution now that works for, not only uses assistive tech, but actually provides benefits for sighted users as well. It&#8217;s kind of difficult to talk about. I mean, I have got a video covering this on my YouTube channel, which kind of shows it in a bit more detail, but we&#8217;re happy it&#8217;s in a much better place.</p>\n\n\n\n<p>[00:20:02] <strong>Dave:</strong> And yeah if people have got feedback about it, and when, when 6.5 comes out, we&#8217;re always happy to hear that. And you can go to the WordPress GitHub repository and raise an issue. And one of us will jump on it and see what we can do.</p>\n\n\n\n<p>[00:20:13] <strong>Josepha:</strong> And we can include a link to that video also. So like, for folks where this sounded intriguing, but they don&#8217;t quite get the concept, like video content all day, let&#8217;s pop it into our show notes. And everybody can take a look at it there. I think that&#8217;s a great idea.</p>\n\n\n\n<p>[00:20:28] <strong>Dave:</strong> Great. Yeah, I appreciate that.</p>\n\n\n\n<p>[00:20:30] <strong>Josepha:</strong> So final question, maybe, maybe final question, final planned question. Is there anything from a user-facing perspective again that you feel has not really gotten the airtime that it needs so far?&nbsp;</p>\n\n\n\n<p>[00:20:44] <strong>Dave:</strong> I think there&#8217;s a lot of technical changes that have happened in this release. So it&#8217;s easy to look at those. I mean, we&#8217;ve covered quite a lot of the key ones that will be user-facing in terms of Font Library and Revisions. We&#8217;ve got things that are going to this release that enable things a lot for people to experience in the future, I think, so underlying changes like the Interactivity API becoming public. Now that&#8217;s public, plugin developers can start to make sites much more interactive on the front of the site rather than just in the editor. So I think that once 6.5 has gone in, and people have started to explore the Interactivity API in more detail, we might see more plugins offering sort of interactivity on the fronts of their sites. An example is obviously the lightbox you&#8217;ve got with images in core, but I can; there&#8217;s way more stuff that you can do with that. So we&#8217;re going to see more of that. </p>\n\n\n\n<p>[00:21:28] <strong>Dave:</strong> We&#8217;ve got Block Hooks that have landed in 6.5, and this is going to open for things like ecommerce plugins and to be able to add, you know, cart blocks or log in, log out blocks to things like navigation, for example, or you might want a ability to like all your comments, and you can do that with Block Hooks and then a plugin developer can just, you know, when the plugin is enabled, they can just make it so that those things just appear on your site, but you still got control over the design.</p>\n\n\n\n<p>So there&#8217;s a lot of like hidden things I think are going to uncover new features for users over time as a result of the community getting involved and changing their plugins and themes to do these take advantage of these new tools.&nbsp;</p>\n\n\n\n<p>[00:22:07] <strong>Josepha:</strong> Yeah, so the Interactivity API, obviously it has &#8220;API&#8221; on it. And so no one&#8217;s thinking, well, this is a user-facing thing. And while the API is not a user facing thing, like, I think that you&#8217;re right. That what it enables absolutely is going to be really useful and hopefully really engaging for like end-to-end users, like the users that are not listening to this podcast and they don&#8217;t know we exist, like they don&#8217;t know that WordPress has a community building it, they&#8217;re just like, it exists, there&#8217;s a software that came out of nowhere, like, I&#8217;m really excited to see how our developers in the community start to use that in their plugins and themes and get that out to end users. I&#8217;m really, really excited to see how creative they get with it.</p>\n\n\n\n<p>Did you have a final thing?</p>\n\n\n\n<p>[00:22:51] <strong>Dave:</strong> There&#8217;s a lot of design changes, I think. I mean, we can&#8217;t cover them all, obviously, in verbal form in this podcast, but some things that are just standing out to me if we look at the source of truth for, for WordPress 6.5, it is, it is big. There&#8217;s a lot in this release. But there&#8217;s some very cool things for, I don&#8217;t know, quality. I like to see them as like quality of life design design changes. Things like, if you drop an image, as a background image of a cover block, it automatically sets the overlay color for that cover block to match the most prominent color of the background image. Like things like that, they seem small, but over time, they just, you just drop that thing, and it just does it. And it&#8217;s like, this is nice. And it feels like a nice tool to use that just is intuitive. And I think there&#8217;s, we&#8217;ll see a lot of those things landing in this release that can just make the experience of working with WordPress and working in the Site Editor much, much nicer.</p>\n\n\n\n<p>[00:23:41] <strong>Josepha:</strong> Yeah. I remember when I first ran into that particular thing, it was on the Showcase, our most recent redesign of it. We&#8217;re using that functionality in there before it was available in core. Obviously, I know, but it was really fascinating. I&#8217;m not great with color combinations. Like, I don&#8217;t have a sense for, like, oh, that&#8217;s the primary thing. That&#8217;s not. And so having that being done kind of automatically so that my stuff looks good anyway, despite what my color sense said to do or not. I thought it was great. Makes you look good as somebody who&#8217;s running a business. You don&#8217;t have to know how things work in order to have excellently functional, really beautiful things.</p>\n\n\n\n<p>[00:24:21] <strong>Josepha:</strong> And I think that&#8217;s a great thing about all of our releases. Obviously, everything is supposed to work that way, but like this one has a lot of really cool things like that available. I think those are really the questions that I had. Is there anything you want to make sure to share before we kind of give last thoughts and head out?</p>\n\n\n\n<p>[00:24:39] <strong>Dave:</strong> Yeah, I was, I was thinking a lot about, you know, the community we&#8217;ve got with WordPress, and I think that people outside of WordPress may not really understand that how amazing this community is that we&#8217;ve got here, but I wanted to say to people like don&#8217;t shy away from contributing to WordPress. I get that, you know, people like myself are fortunate enough to be sponsored to do it. But there&#8217;s always something that people can do, even if that&#8217;s just spending like 30 minutes testing a release or donating some of your time to run one of the meetings. It can really make a difference overall. Even just filing a bug report for something you see in WordPress 6.5 or testing 6.5 before it goes out, those little things do make a big difference. And if you&#8217;re not sure where to go, then we can signpost you with links, no doubt in this, in the podcast description with where where&#8217;s to go. But yeah, I just want to encourage people to get involved, basically.</p>\n\n\n\n<p>[00:25:27] <strong>Josepha:</strong> Yeah. And it&#8217;s all working out in public, like we&#8217;ve got developers, designers, marketing folks, community folks like all doing this work out where everybody can see it. And so that, I know, can look really kind of overwhelming. But I want to just highlight, like, you don&#8217;t have to know everything about what&#8217;s happening in the project in order to get involved in the project. Like every small bit of contribution toward like finding a new bug or confirming that a bug happens across other devices, other setups, things like that, like those all help make things better and keep things moving as quickly as we are able to make them move. And so, yeah, I&#8217;ll second that every little thing that you think like that won&#8217;t make a difference. It does. We can&#8217;t tell that things are broken or things are working or things are in need of some care unless you highlight those for us. And this is the best way to do it is to show up and give 30 minutes to send out a group testing invite to your meetup group or whatever it is that you all have been thinking you should do, like, this is your sign. You can do it.</p>\n\n\n\n<p>[00:26:34] <strong>Dave:</strong> Everyone should get involved if they can.</p>\n\n\n\n<p>[00:26:37] <strong>Josepha:</strong> I agree. I agree. Dave, this has been such an excellent conversation. Thank you so much for joining me today.</p>\n\n\n\n<p>[00:26:42] <strong>Dave:</strong> Oh, thank you very much. It&#8217;s a pleasure.</p>\n\n\n\n<p>[00:26:43] (Music interlude)&nbsp;</p>\n\n\n\n<p>[00:26:49] <strong>Josepha:</strong> What an interesting release we&#8217;ve got coming out this week. I&#8217;m so glad you all made it this far in the pod, and now it&#8217;s time for our small list of big things.</p>\n\n\n\n<p>[00:27:00] <strong>Josepha:</strong> First up, following up on the WordPress meetup reactivation project that we had in 2022, we aim to revive some meetup groups in big cities that are inactive or help the local WordPress community that are not yet part of our meetup chapter program to join our program. There is a post out on the community P2 on the community site. That is titled Asia Meetup Revival Project 2024. I&#8217;ll leave a link to that in the show notes if you want to read more about that and figure out how to get involved.</p>\n\n\n\n<p>And speaking of getting involved, we have roughly a million meetings. Because it&#8217;s a new month, we&#8217;re in April now. New month, new opportunities. There are a lot of things happening in April. We will be coming out of a major release, obviously, and so there will be some minor release follow up to do. There will be a lot of discussion about what&#8217;s coming next, what&#8217;s in trunk, what&#8217;s not in trunk. But also a lot of work being done around our next big major events, our next big major training initiatives. There&#8217;s just so much happening. Spring is a time when we are looking at stuff that&#8217;s new, what we want to invest in, what we want to grow. And so if you have not attended one in a while or even at all if you&#8217;ve never attended a meeting in the community, then this is a great time to start and join your fellow community members trying to make WordPress better every day.</p>\n\n\n\n<p>[00:28:23] <strong>Josepha:</strong> And then the final thing on our small list of big things is I am looking at helping to shift the focus of our WordPress marketing community. We&#8217;ve had a bit of a struggle over the years to figure out what our primary focus and our primary impact can be. So there&#8217;s a post up called &#8216;Making a WordPress Media Corps&#8217;. It&#8217;s gotten quite a bit of attention, and I do really think that it has a lot of potential for solving some of the issues that we have and kind of getting some quick wins into our recent history of that team so that we can move forward confidently together. So pop on over, give it a read, share your thoughts. And if you are one of these qualified media partners, also let us know.&nbsp;</p>\n\n\n\n<p>[00:29:08] <strong>Josepha:</strong> That, my friends, is your small list of big things.</p>\n\n\n\n<p>Don&#8217;t forget to follow us on your favorite podcast app or subscribe directly on WordPress.org/news. You&#8217;ll get a friendly reminder whenever there&#8217;s a new episode. And if you liked what you heard today, share it with a fellow WordPresser, or if you had questions about what you heard, you can share those with me at WPBriefing@WordPress.org. I&#8217;m your host, Josepha Haden Chomphosy. Thank you for tuning in today for the WordPress Briefing, and I&#8217;ll see you again in a couple of weeks.&nbsp;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Apr 2024 20:18:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"WordPress.org blog: WordPress 6.5 “Regina”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=17132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://wordpress.org/news/2024/04/regina/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:65839:\"<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/04/Release-Edition-Inline-Image.png?resize=1024%2C683&ssl=1\" alt=\"WordPress 6.5 \" />\n\n\n\n<p>Say hello to WordPress 6.5 “Regina,” inspired by the dynamic versatility of renowned jazz violinist <a href=\"https://en.wikipedia.org/wiki/Regina_Carter\">Regina Carter</a>. An award-winning artist and storied jazz educator known for transcending genre, Regina’s technical foundations in classical music and deep understanding of jazz have earned her the reputation of boldly going beyond what’s possible with the violin.&nbsp;</p>\n\n\n\n<p>Let the stunning twists and subtle turns of <a href=\"https://open.spotify.com/playlist/37i9dQZF1DZ06evO1WEiVo?si=534335c984804713\">Regina’s genre-bending sound</a> surprise you as you explore everything 6.5 offers.</p>\n\n\n\n<p>This latest version of WordPress puts more power into the details. It offers new and improved ways to fine-tune and enhance your site-building experience, letting you take control in ways that make it your own. You’ll find new ways to manage your site’s typography, more comprehensive revisions available in more places, and a collection of Site Editor updates paired with impressive performance gains to help you get things done smoother and faster.</p>\n\n\n\n<p>&#8220;Regina&#8221; also marks the introduction of some breakthrough developer tools that will start transforming how you use and extend blocks to craft engaging experiences. The Interactivity API opens up a world of creative front-end possibilities, while the Block Bindings API makes dynamic connections between blocks and data seamless. These, among other developer-focused improvements and updates, are ready to help you evolve how you build with WordPress.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wordpress.org/download/\">Download WordPress 6.5 &#8220;Regina&#8221;</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s inside 6.5</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Add and manage fonts across your site</h3>\n\n\n\n<p>The new Font Library puts you in control of an essential piece of your site’s design—typography—without coding or extra steps. Effortlessly install, remove, and activate local and Google Fonts across your site for any Block theme. The ability to include custom typography collections gives site creators and publishers more options when it comes to styling content.</p>\n\n\n\n<img width=\"1024\" height=\"656\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/04/Font-Manager-2.png?resize=1024%2C656&ssl=1\" alt=\"\" class=\"wp-image-17167\" />\n\n\n\n<h3 class=\"wp-block-heading\">Get more from your revisions—including revisions for templates and template parts</h3>\n\n\n\n<p>Work through creative projects with a more comprehensive picture of what’s been done—and what you can fall back on. Get details like time stamps, quick summaries, and a paginated list of all revisions. View revisions from the Style Book to see how changes impact every block. Revisions are also now available for templates and template parts.</p>\n\n\n\n<img width=\"1024\" height=\"656\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/04/Revisions-1.png?resize=1024%2C656&ssl=1\" alt=\"\" class=\"wp-image-17168\" />\n\n\n\n<h3 class=\"wp-block-heading\">Play with enhanced background and shadow tools</h3>\n\n\n\n<ul>\n<li>Control the size, repeat, and focal point options for background images in Group blocks so you can explore subtle or splashy ways to add visual interest to layouts.&nbsp;</li>\n\n\n\n<li>Set aspect ratios for Cover block images and easily add color overlays that automatically source color from your chosen image.&nbsp;</li>\n\n\n\n<li>Add box shadow support to more block types and create layouts with visual depth, or throw a little personality into your design.</li>\n</ul>\n\n\n\n<img width=\"1024\" height=\"656\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/04/design-tools-1.png?resize=1024%2C656&ssl=1\" alt=\"\" class=\"wp-image-17169\" />\n\n\n\n<h3 class=\"wp-block-heading\">Discover new Data Views</h3>\n\n\n\n<p>Every piece of your site comes with a library of information and data—now, you can find what you need quickly and organize it however you like. Data views for pages, templates, patterns, and template parts let you see data in a table or grid view, with the option to toggle fields and make bulk changes.</p>\n\n\n\n<img width=\"1024\" height=\"656\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/04/Data-Views-1.png?resize=1024%2C656&ssl=1\" alt=\"\" class=\"wp-image-17165\" />\n\n\n\n<h3 class=\"wp-block-heading\">Smoother drag-and-drop</h3>\n\n\n\n<p>Feel the difference when you move things around, with helpful visual cues like displaced items in List View or frictionless dragging to anywhere in your workspace—from beginning to end.</p>\n\n\n\n<img width=\"1024\" height=\"656\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/04/drag-and-drop-1.png?resize=1024%2C656&ssl=1\" alt=\"\" class=\"wp-image-17170\" />\n\n\n\n<h3 class=\"wp-block-heading\">Improved link controls</h3>\n\n\n\n<p>Create and manage links easily with a more intuitive link-building experience, like a streamlined UI and a shortcut for copying links.</p>\n\n\n\n<img width=\"1024\" height=\"656\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/04/link-controls-1.png?resize=1024%2C656&ssl=1\" alt=\"\" class=\"wp-image-17171\" />\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s fresh for developers in 6.5</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Bring interactions to blocks with the Interactivity API</h3>\n\n\n\n<p>The <a href=\"https://make.wordpress.org/core/2024/03/04/interactivity-api-dev-note/\">Interactivity API</a> offers developers a standardized method for building interactive front-end experiences with blocks. It simplifies the process, with fewer dependencies on external tooling, while maintaining optimal performance. Use it to create memorable user experiences, like fetching search results instantly or letting visitors interact with content in real time.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Connect blocks to custom fields or other dynamic content</h3>\n\n\n\n<p>Link core block attributes to custom fields and use the value of custom fields without creating custom blocks. Powered by the <a href=\"https://make.wordpress.org/core/2024/03/06/new-feature-the-block-bindings-api/\">Block Bindings API</a>, developers can extend this capability further to connect blocks to any dynamic content—even beyond custom fields. If there’s data stored elsewhere, easily point blocks to that new source with only a few lines of code.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Add appearance tools to Classic themes</h3>\n\n\n\n<p>Give designers and creators using Classic themes access to an upgraded design experience. Opt in to support for spacing, border, typography, and color options, even without using theme.json. Once support is enabled, more tools will be automatically added as they become available.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Explore improvements to the plugin experience</h3>\n\n\n\n<p>There&#8217;s now an <a href=\"https://make.wordpress.org/core/2024/03/05/introducing-plugin-dependencies-in-wordpress-6-5/\">easier way to manage plugin dependencies</a>. Plugin authors can supply a new <code>Requires Plugins</code> header with a comma-separated list of required plugin slugs, presenting users with links to install and activate those plugins first.</p>\n\n\n\n<h2 class=\"wp-block-heading\">From fast to faster: Performance updates</h2>\n\n\n\n<p>This release includes 110+ performance updates, resulting in an impressive increase in speed and efficiency across the Post Editor and Site Editor. Loading is over two times faster than in 6.4, with input processing speed up to five times faster than the previous release.</p>\n\n\n\n<p>&nbsp;Translated sites see up to 25% improvement in load time for this release courtesy of <a href=\"https://make.wordpress.org/core/2024/02/27/i18n-improvements-6-5-performant-translations/\">Performant Translations</a>. Additional performance highlights include <a href=\"https://make.wordpress.org/core/2024/02/23/wordpress-6-5-adds-avif-support/\">AVIF image support</a> and improvements for <a href=\"https://make.wordpress.org/core/2024/02/29/performance-improvements-for-registering-block-variations-with-callbacks/\">registering block variations with callbacks</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A tradition of inclusion</h2>\n\n\n\n<p>This release includes more than 65 accessibility improvements across the platform, making it more accessible than ever. It contains an important fix that unblocks access to the admin submenus for screen reader users and others who navigate by keyboard. This release also adds fixes to color contrast in admin focus states, positioning of elements, and cursor focus, among many others, that help improve the WordPress experience for everyone.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Learn more about WordPress 6.5</h2>\n\n\n\n<p>Check out the new&nbsp;<a href=\"https://wordpress.org/download/releases/6-5/\">WordPress 6.5 page</a>&nbsp;to learn more about the numerous enhancements and features of this release—including short demos of some of the highlighted features. </p>\n\n\n\n<p>Explore <a href=\"https://learn.wordpress.org/\">Learn WordPress</a> for quick how-to videos, <a href=\"https://learn.wordpress.org/social-learning/\">online workshops</a>, and other free resources to level up your WordPress knowledge and skills.</p>\n\n\n\n<p>Check out the <a href=\"https://make.wordpress.org/core/2024/03/15/wordpress-6-5-field-guide/\">WordPress 6.5 Field Guide</a> for detailed technical information and <a href=\"https://make.wordpress.org/core/tag/dev-notes-6-5/\">developer notes</a> to help you build with WordPress and get the most out of this release. Don’t forget to subscribe to the <a href=\"https://developer.wordpress.org/news/\">Developer Blog</a> for developer updates, feature tutorials, and other helpful WordPress content from a developer perspective.</p>\n\n\n\n<p>For more information about installation, file changes, fixes, and other updates, read the <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-5/\">6.5 release notes</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The 6.5 release squad</h2>\n\n\n\n<p>Every release has many moving parts with its own triumphs and challenges. It takes a dedicated team of enthusiastic contributors to help keep things on track and moving smoothly. 6.5 is made possible by a cross-functional group of contributors, always ready to champion ideas, remove blockers, and resolve issues.</p>\n\n\n\n<ul>\n<li>Release Lead: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Release Coordinators: <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a>, <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a>, <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a></li>\n\n\n\n<li>Core Tech Leads: <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a></li>\n\n\n\n<li>Editor Tech Leads: <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>, <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a></li>\n\n\n\n<li>Core Triage Leads: <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a></li>\n\n\n\n<li>Editor Triage Leads: <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a>, <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a></li>\n\n\n\n<li>Design Leads: <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a>, <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a></li>\n\n\n\n<li>Marketing and Communication Leads: <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a>, <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a></li>\n\n\n\n<li>Documentation Leads: <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a>, <a href=\"https://profiles.wordpress.org/leonnugraha/\">Leonardus Nugraha</a>, <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a></li>\n\n\n\n<li>Performance Leads: <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a></li>\n\n\n\n<li>Test Leads: <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>, <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a>, <a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a></li>\n\n\n\n<li>Default Themes Leads: <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you, contributors</h2>\n\n\n\n<p>WordPress believes in democratizing publishing and the <a href=\"https://opensource.org/osd-annotated\">freedoms that come with open source</a>. Supporting this idea is a global and diverse community of people collaborating to strengthen the software.&nbsp;</p>\n\n\n\n<p>WordPress 6.5 reflects the countless efforts and passion of around 700 contributors in at least 57 countries. This release also welcomed over 150 first-time contributors!</p>\n\n\n\n<p>Their collaboration delivered more than 2,500 enhancements and fixes, ensuring a stable release for all—a testament to the power and capability of the WordPress open source community.</p>\n\n\n<p class=\"is-style-wporg-props-long alignfull\"><a href=\"https://profiles.wordpress.org/benniledl/\">!Benni</a> · <a href=\"https://profiles.wordpress.org/_ck_/\">_ck_</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/abletec/\">abletec</a> · <a href=\"https://profiles.wordpress.org/acosmin/\">acosmin</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/adarshposimyth/\">Adarsh Akshat</a> · <a href=\"https://profiles.wordpress.org/ajmcfadyen/\">admcfajn</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/skyakash12/\">Akash Muchandikar</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akmelias/\">akmelias</a> · <a href=\"https://profiles.wordpress.org/wpfy/\">Akramul Hasan</a> · <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a> · <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a> · <a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a> · <a href=\"https://profiles.wordpress.org/ahoereth/\">Alex</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/alexkingorg/\">Alex King</a> · <a href=\"https://profiles.wordpress.org/akirk/\">Alex Kirk</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/viper007bond/\">Alex Mills</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alexanderkoledov/\">Alexander</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/sabreuse/\">Amy Hendrix (sabreuse)</a> · <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a> · <a href=\"https://profiles.wordpress.org/anandau14/\">Anand Upadhyay</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Nor&#233;n</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/l1nuxjedi/\">Andrew Hutchings</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/norcross/\">Andrew Norcross</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/andrewleap/\">andrewleap</a> · <a href=\"https://profiles.wordpress.org/andbalashov/\">Andrii Balashov</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/apeatling/\">Andy Peatling</a> · <a href=\"https://profiles.wordpress.org/aneeshd16/\">Aneesh Devasthale</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> · <a href=\"https://profiles.wordpress.org/antonlukin/\">Anton Lukin</a> · <a href=\"https://profiles.wordpress.org/atimmer/\">Anton Timmermans</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/lighthouse79/\">Antonella</a> · <a href=\"https://profiles.wordpress.org/colomet/\">Antonio D.</a> · <a href=\"https://profiles.wordpress.org/antonisme/\">Antonis Lilis</a> · <a href=\"https://profiles.wordpress.org/arena94/\">arena94</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/passoniate/\">Arslan Kalwar</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/iamarunchaitanyajami/\">Arun Chaitanya Jami</a> · <a href=\"https://profiles.wordpress.org/dextorlobo/\">Arun Sharma</a> · <a href=\"https://profiles.wordpress.org/ideag/\">Arunas Liuiza</a> · <a href=\"https://profiles.wordpress.org/iamasadpolash/\">Asad Polash</a> · <a href=\"https://profiles.wordpress.org/ashfame/\">Ashish Kumar (Ashfame)</a> · <a href=\"https://profiles.wordpress.org/mohonchandra/\">Asish Chandra Mohon</a> · <a href=\"https://profiles.wordpress.org/audunmb/\">audunmb</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/filosofo/\">Austin Matzko</a> · <a href=\"https://profiles.wordpress.org/axwax/\">axwax</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">B&#233;ryl de La Grandi&#232;re</a> · <a href=\"https://profiles.wordpress.org/bahia0019/\">bahia0019</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/bangank36/\">bangank36</a> · <a href=\"https://profiles.wordpress.org/barryhughes-1/\">Barry</a> · <a href=\"https://profiles.wordpress.org/barry/\">Barry</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a> · <a href=\"https://profiles.wordpress.org/bartkleinreesink/\">bartkleinreesink</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/beaulebens/\">Beau Lebens</a> · <a href=\"https://profiles.wordpress.org/bedas/\">Beda</a> · <a href=\"https://profiles.wordpress.org/benharri/\">ben</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/ubernaut/\">Ben Hansen</a> · <a href=\"https://profiles.wordpress.org/husobj/\">Ben Huson</a> · <a href=\"https://profiles.wordpress.org/blobaugh/\">Ben Lobaugh (blobaugh)</a> · <a href=\"https://profiles.wordpress.org/britner/\">Ben Ritner - Kadence WP</a> · <a href=\"https://profiles.wordpress.org/retlehs/\">Ben Word</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benjaminknox/\">benjaminknox</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/billseymour/\">billseymour</a> · <a href=\"https://profiles.wordpress.org/bplv/\">Biplav</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/bobbingwide/\">bobbingwide</a> · <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a> · <a href=\"https://profiles.wordpress.org/born2webdesign/\">born2webdesign</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradparbs/\">Brad Parbs</a> · <a href=\"https://profiles.wordpress.org/williamsba1/\">Brad Williams</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/drrobotnik/\">Brandon Lavigne</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/fischfood/\">Brian Fischer</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a> · <a href=\"https://profiles.wordpress.org/brookemk/\">Brooke</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/ecc/\">camya</a> · <a href=\"https://profiles.wordpress.org/karl94/\">Carlo Cannas</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cenkdemir/\">cenkdemir</a> · <a href=\"https://profiles.wordpress.org/cfinnberg/\">cfinnberg</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/chasedsiedu/\">chased@si.edu</a> · <a href=\"https://profiles.wordpress.org/mel_cha/\">chiilog (Chiaki Okamoto)</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/chrisdavidmiles/\">Chris David Miles</a> · <a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/itschristiandale/\">christian-dale</a> · <a href=\"https://profiles.wordpress.org/christopherplus/\">Christopher</a> · <a href=\"https://profiles.wordpress.org/chrystl/\">Chrystl</a> · <a href=\"https://profiles.wordpress.org/codepo8/\">codepo8</a> · <a href=\"https://profiles.wordpress.org/cdevroe/\">Colin Devroe</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">Cory Birdsong</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/creativeslice/\">Creative Slice</a> · <a href=\"https://profiles.wordpress.org/crstauf/\">crstauf</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/cvorko/\">cvorko</a> · <a href=\"https://profiles.wordpress.org/didierjm/\">cybeardjm</a> · <a href=\"https://profiles.wordpress.org/cyberchicken/\">Cyberchicken</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/mzaweb/\">Daniel Dvorkin</a> · <a href=\"https://profiles.wordpress.org/mapumba/\">Daniel K&#228;fer</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/schutzsmith/\">Daniel Schutzsmith</a> · <a href=\"https://profiles.wordpress.org/danieldudzic/\">danieldudzic</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/danieltj/\">danieltj</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/darssen/\">darssen</a> · <a href=\"https://profiles.wordpress.org/dartiss/\">David Artiss</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/dglingren/\">David Lingren</a> · <a href=\"https://profiles.wordpress.org/davidperez/\">David Perez</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/denis-de-bernardy/\">Denis de Bernardy</a> · <a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a> · <a href=\"https://profiles.wordpress.org/dionysous/\">Dennis Hipp</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dennysdionigi/\">Dennys Dionigi</a> · <a href=\"https://profiles.wordpress.org/derekblank/\">Derek Blank</a> · <a href=\"https://profiles.wordpress.org/valendesigns/\">Derek Herman</a> · <a href=\"https://profiles.wordpress.org/derekspringer/\">Derek Springer</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/desrosjbot/\">Desrosj Bot</a> · <a href=\"https://profiles.wordpress.org/dernin/\">Devin Curtis</a> · <a href=\"https://profiles.wordpress.org/dlocc/\">Devin Walker</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruvishah2203/\">Dhruvi Shah</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/dougal/\">Dougal Campbell</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/lots0logs/\">Dustin Falgout</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham Siddiqui</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emirpprime/\">emirpprime</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/endymion00/\">Endymion00</a> · <a href=\"https://profiles.wordpress.org/ericlewis/\">Eric Andrew Lewis</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisalahmed29/\">Faisal Ahmed</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fanly/\">Fanly</a> · <a href=\"https://profiles.wordpress.org/feastdesignco/\">Feast Design Co.</a> · <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/fgiannar/\">fgiannar</a> · <a href=\"https://profiles.wordpress.org/flhz/\">Florent Hernandez</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/francescocarlucci/\">FrancescoCarlucci</a> · <a href=\"https://profiles.wordpress.org/fotodrachen/\">Frank J&#228;ger</a> · <a href=\"https://profiles.wordpress.org/nexflaszlo/\">Frank Laszlo</a> · <a href=\"https://profiles.wordpress.org/wazeter/\">Frank Wazeter</a> · <a href=\"https://profiles.wordpress.org/fushar/\">fushar</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garibiza/\">Garbi&#241;e</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/gavande1/\">gavande1</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/gerardreches/\">Gerard Reches</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/girishpanchal/\">Girish Panchal</a> · <a href=\"https://profiles.wordpress.org/giuseppemazzapica-1/\">Giuseppe Mazzapica</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/goldenapples/\">goldenapples</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregbenz/\">gregbenz</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">gvgvgvijayan</a> · <a href=\"https://profiles.wordpress.org/poran766/\">H.M. Mushfiqur Rahman</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hardik2221/\">Hardik Raval</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harsh175/\">Harsh Patel</a> · <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman Shamim</a> · <a href=\"https://profiles.wordpress.org/halounsbury/\">Heather Lounsbury</a> · <a href=\"https://profiles.wordpress.org/muhme/\">Heiko L&#252;bbe</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/tejwanihemant/\">Hemant Tejwani</a> · <a href=\"https://profiles.wordpress.org/kurudrive/\">Hidekazu Ishikawa</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hiteshtalpada/\">Hitesh Talpada</a> · <a href=\"https://profiles.wordpress.org/h71/\">Hossein</a> · <a href=\"https://profiles.wordpress.org/howdy_mcgee/\">Howdy_McGee</a> · <a href=\"https://profiles.wordpress.org/hrrarya/\">Hridoy Mozumder</a> · <a href=\"https://profiles.wordpress.org/hrithikd/\">Hrithik Dalal</a> · <a href=\"https://profiles.wordpress.org/hlashbrooke/\">Hugh Lashbrooke</a> · <a href=\"https://profiles.wordpress.org/ganon/\">Hugo Chinchilla</a> · <a href=\"https://profiles.wordpress.org/hugod/\">hugod</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/idad5/\">idad5</a> · <a href=\"https://profiles.wordpress.org/igmoweb/\">Ignacio Cruz Moreno</a> · <a href=\"https://profiles.wordpress.org/ignatiusjeroe/\">ignatiusjeroe</a> · <a href=\"https://profiles.wordpress.org/shaampk1/\">Ihtisham Zahoor</a> · <a href=\"https://profiles.wordpress.org/fnpen/\">Ilya Zolotov</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">ironprogrammer</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/iseulde/\">iseulde</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/itecrs/\">itecrs</a> · <a href=\"https://profiles.wordpress.org/ivanzhuck/\">Ivan Zhuck</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/jadpm/\">jadpm</a> · <a href=\"https://profiles.wordpress.org/jamescollins/\">James Collins</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/james roberts/\">James Roberts</a> · <a href=\"https://profiles.wordpress.org/jamieblomerus/\">Jamie Blomerus</a> · <a href=\"https://profiles.wordpress.org/perrelet/\">Jamie Perrelet</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">Jan Thiel</a> · <a href=\"https://profiles.wordpress.org/jane/\">jane</a> · <a href=\"https://profiles.wordpress.org/whiteshadow/\">Janis Elsts</a> · <a href=\"https://profiles.wordpress.org/jsandtro/\">jansan</a> · <a href=\"https://profiles.wordpress.org/japh/\">Japh</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarednova/\">jarednova</a> · <a href=\"https://profiles.wordpress.org/jason_the_adams/\">Jason Adams</a> · <a href=\"https://profiles.wordpress.org/pbking/\">Jason Crist</a> · <a href=\"https://profiles.wordpress.org/coolmann/\">Jason Crouse</a> · <a href=\"https://profiles.wordpress.org/jsnjohnston/\">Jason Johnston</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/jayadevankbh/\">Jayadevan k</a> · <a href=\"https://profiles.wordpress.org/jbobich/\">jbobich</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/amieiro/\">Jes&#250;s Amieiro</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jghazally/\">jghazally</a> · <a href=\"https://profiles.wordpress.org/jipmoors/\">Jip Moors</a> · <a href=\"https://profiles.wordpress.org/jivygraphics/\">jivygraphics</a> · <a href=\"https://profiles.wordpress.org/jltallon/\">jltallon</a> · <a href=\"https://profiles.wordpress.org/joanrodas/\">Joan</a> · <a href=\"https://profiles.wordpress.org/morehawes/\">Joe</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joelcj91/\">Joel James</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen A.</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnciacia/\">johnciacia</a> · <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a> · <a href=\"https://profiles.wordpress.org/duck_/\">Jon Cave</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/jbrinley/\">Jonathan Brinley</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/joppuyo/\">joppuyo</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/jorgevilchez/\">Jorge Vilchez</a> · <a href=\"https://profiles.wordpress.org/jornp/\">jornp</a> · <a href=\"https://profiles.wordpress.org/joefusco/\">Joseph Fusco</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/joshcanhelp/\">joshcanhelp</a> · <a href=\"https://profiles.wordpress.org/joshuatf/\">joshuatf</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/jrtashjian/\">JR Tashjian</a> · <a href=\"https://profiles.wordpress.org/jsmoriss/\">JS Morisset</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juhise/\">Juhi Saxena</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/ashikur698/\">K M Ashikur Rahman</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/bosskhj/\">Kamrul Hasan</a> · <a href=\"https://profiles.wordpress.org/karinclimber/\">Kari Anderson</a> · <a href=\"https://profiles.wordpress.org/karlijnbk/\">Karlijn Bok</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/tadamarketing/\">Katka</a> · <a href=\"https://profiles.wordpress.org/kawsaralameven/\">kawsaralameven</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kbat82/\">Kevin Batdorf</a> · <a href=\"https://profiles.wordpress.org/kevincoleman/\">Kevin Coleman</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kitchin/\">kitchin</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/koen12344/\">Koen Reus</a> · <a href=\"https://profiles.wordpress.org/koesper/\">Koesper</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a> · <a href=\"https://profiles.wordpress.org/kdowns/\">Kylen Downs</a> · <a href=\"https://profiles.wordpress.org/laumindproductscomau/\">lau@mindproducts.com.au</a> · <a href=\"https://profiles.wordpress.org/lada7042/\">Laura Adamonis</a> · <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">Laurent MILLET</a> · <a href=\"https://profiles.wordpress.org/lakshmananphp/\">Lax Mariappan</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/munizleo/\">Leo Muniz</a> · <a href=\"https://profiles.wordpress.org/leonnugraha/\">Leonardus Nugraha</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/liammcarthur/\">LiamMcArthur</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/lkraav/\">lkraav</a> · <a href=\"https://profiles.wordpress.org/logikal16/\">logikal16</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/luboslives/\">luboslives</a> · <a href=\"https://profiles.wordpress.org/lucasbustamante/\">lucasbustamante</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">Luis Herranz</a> · <a href=\"https://profiles.wordpress.org/lpawlik/\">Lukas Pawlik</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukefiretoss/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/maartenbelmans/\">Maarten</a> · <a href=\"https://profiles.wordpress.org/mrdollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mhimon/\">Mahbub Hasan Imon</a> · <a href=\"https://profiles.wordpress.org/mahnewr/\">mahnewr</a> · <a href=\"https://profiles.wordpress.org/maahrokh/\">Mahrokh</a> · <a href=\"https://profiles.wordpress.org/malae/\">Malae</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manyourisms/\">manyourisms</a> · <a href=\"https://profiles.wordpress.org/marc_j/\">Marc_J</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/marcoevich/\">Marcoevich</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/chaton666/\">Marie Comet</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a> · <a href=\"https://profiles.wordpress.org/markoheijnen/\">Marko Heijnen</a> · <a href=\"https://profiles.wordpress.org/flootr/\">Markus</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/mathewemoore/\">mathewemoore</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matiasrecondo77/\">matiasrecondo77</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/cadic/\">Max Lyuchin</a> · <a href=\"https://profiles.wordpress.org/maxpertici/\">Maxime Pertici</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/mhshohel/\">Md Hossain Shohel</a> · <a href=\"https://profiles.wordpress.org/hrshahin/\">Md HR Shahin</a> · <a href=\"https://profiles.wordpress.org/megphillips91/\">Meg Phillips</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/melcarthus/\">melcarthus</a> · <a href=\"https://profiles.wordpress.org/meta4/\">meta4</a> · <a href=\"https://profiles.wordpress.org/metropolis_john/\">metropolis_john</a> · <a href=\"https://profiles.wordpress.org/254volkan/\">mevolkan</a> · <a href=\"https://profiles.wordpress.org/wpscholar/\">Micah Wood</a> · <a href=\"https://profiles.wordpress.org/mshowes/\">Michael Showes</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michalooki/\">Michalooki</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/miguelsansegundo/\">miguelsansegundo</a> · <a href=\"https://profiles.wordpress.org/miikkamakela/\">Miikka</a> · <a href=\"https://profiles.wordpress.org/mbijon/\">Mike Bijon</a> · <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley (a11n)</a> · <a href=\"https://profiles.wordpress.org/mikeschinkel/\">Mike Schinkel</a> · <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/gonzomir/\">Milen Petrinski - Gonzo</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/mkismy/\">mkismy</a> · <a href=\"https://profiles.wordpress.org/mnydigital/\">mnydigital</a> · <a href=\"https://profiles.wordpress.org/batmoo/\">Mohammad Jangda</a> · <a href=\"https://profiles.wordpress.org/boemedia/\">Monique Dubbelman</a> · <a href=\"https://profiles.wordpress.org/monzuralam/\">Monzur Alam</a> · <a href=\"https://profiles.wordpress.org/man4toman/\">Morteza Geransayeh</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/seusmaniqbal/\">Muhammad Usman Iqbal</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/tanjimtc71/\">Musarrat Anjum Chowdhury</a> · <a href=\"https://profiles.wordpress.org/naoki0h/\">Naoki Ohashi</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/nateallen/\">Nate Allen</a> · <a href=\"https://profiles.wordpress.org/navjotjsingh/\">Navjot Singh</a> · <a href=\"https://profiles.wordpress.org/neffff/\">neffff</a> · <a href=\"https://profiles.wordpress.org/neilorangepeel/\">Neil Hainsworth</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/nerdpressteam/\">NerdPress</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/sessioncookiemonster/\">Nick Martianov</a> · <a href=\"https://profiles.wordpress.org/nickpagz/\">nickpagz</a> · <a href=\"https://profiles.wordpress.org/nico23/\">Nico</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/bgnicolepaschen/\">Nicole Paschen Caylor</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nko/\">Nikita</a> · <a href=\"https://profiles.wordpress.org/nikmeyer/\">nikmeyer</a> · <a href=\"https://profiles.wordpress.org/rabmalin/\">Nilambar Sharma</a> · <a href=\"https://profiles.wordpress.org/nilovelez/\">Nilo Velez</a> · <a href=\"https://profiles.wordpress.org/dhrupo/\">Niluthpal Purkayastha</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">niravsherasiya7707</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/nvwd/\">Nowell VanHoesen</a> · <a href=\"https://profiles.wordpress.org/nudge/\">Nudge Themes</a> · <a href=\"https://profiles.wordpress.org/nwjames/\">nwjames</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/ockham/\">ockham</a> · <a href=\"https://profiles.wordpress.org/oguzkocer/\">oguzkocer</a> · <a href=\"https://profiles.wordpress.org/okat/\">okat</a> · <a href=\"https://profiles.wordpress.org/dargus/\">Old account</a> · <a href=\"https://profiles.wordpress.org/olegfuture/\">olegfuture</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pacicio/\">Pacicio</a> · <a href=\"https://profiles.wordpress.org/pannelars/\">pannelars</a> · <a href=\"https://profiles.wordpress.org/partyfrikadelle/\">partyfrikadelle</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/pauldewouters/\">Paul de Wouters</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/djpaul/\">Paul Wong-Gibbs</a> · <a href=\"https://profiles.wordpress.org/pavelevap/\">pavelevap</a> · <a href=\"https://profiles.wordpress.org/pbaylies/\">Peter Baylies</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/philipp15b/\">Philipp15b</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/mordauk/\">Pippin Williamson</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pmeenan/\">pmeenan</a> · <a href=\"https://profiles.wordpress.org/webtechpooja/\">Pooja Derashri</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/pouicpouic/\">pouicpouic</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/pratikthink/\">Pratik Kumar</a> · <a href=\"https://profiles.wordpress.org/freewebmentor/\">Prem Tiwari</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">presstoke</a> · <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiq</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/rashiguptaa/\">Rashi Gupta</a> · <a href=\"https://profiles.wordpress.org/rawrly/\">rawrly</a> · <a href=\"https://profiles.wordpress.org/rcain/\">rcain</a> · <a href=\"https://profiles.wordpress.org/rebasaurus/\">rebasaurus</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/renehermi/\">Rene Hermenau</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/rdcoll/\">Rich Collier</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/ravanh/\">Rolf Allard van Hagen</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/pogidude/\">Ryann Micua</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sereedmedia/\">S&#233; Reed</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">S&#233;bastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sabbirshouvo/\">Sabbir Hasan</a> · <a href=\"https://profiles.wordpress.org/sachyya-sachet/\">Sachyya</a> · <a href=\"https://profiles.wordpress.org/sadizaman/\">Sadi Mohammad Zaman</a> · <a href=\"https://profiles.wordpress.org/sadpencil/\">sadpencil</a> · <a href=\"https://profiles.wordpress.org/introvertedbot/\">Sahil</a> · <a href=\"https://profiles.wordpress.org/tohincoderex/\">Saiduzzaman Tohin</a> · <a href=\"https://profiles.wordpress.org/sakibsnaz/\">Sakib MD Nazmush</a> · <a href=\"https://profiles.wordpress.org/salcode/\">Sal Ferrarello</a> · <a href=\"https://profiles.wordpress.org/samba45/\">samba45</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/kim88/\">Samuel R&#252;egger</a> · <a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sacerro/\">Santiago Cerro L&#243;pez</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/hellosatya/\">Satyam Vishwakarma (Satya)</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/sayful/\">Sayful Islam</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sgr33n/\">Sergio de Falco</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shahariaazam/\">Shaharia Azam</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/shanef/\">ShaneF</a> · <a href=\"https://profiles.wordpress.org/cafenoirdesign/\">Shannon Smith</a> · <a href=\"https://profiles.wordpress.org/shaunandrews/\">shaunandrews</a> · <a href=\"https://profiles.wordpress.org/shooper/\">Shawn Hooper</a> · <a href=\"https://profiles.wordpress.org/shidouhikari/\">shidouhikari</a> · <a href=\"https://profiles.wordpress.org/shiponkarmakar/\">Shipon Karmakar</a> · <a href=\"https://profiles.wordpress.org/shreyash3087/\">Shreyash Srivastava</a> · <a href=\"https://profiles.wordpress.org/shubhamsedani/\">Shubham Sedani</a> · <a href=\"https://profiles.wordpress.org/rsiddharth/\">siddharth ravikumar</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/sirajummahdi/\">Sirajum Mahdi</a> · <a href=\"https://profiles.wordpress.org/sjregan/\">sjregan</a> · <a href=\"https://profiles.wordpress.org/soean/\">Soren Wrede</a> · <a href=\"https://profiles.wordpress.org/virtality-marketing-solutions/\">SourceView</a> · <a href=\"https://profiles.wordpress.org/sruthi89/\">sruthi89</a> · <a href=\"https://profiles.wordpress.org/stacimc/\">stacimc</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stephencronin/\">Stephen Cronin</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/stephenh1988/\">Stephen Harris</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sumisubedi/\">Sumi Subedi</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/svitlana41319/\">Svitlana Sukhoveiko</a> · <a href=\"https://profiles.wordpress.org/syamraj24/\">syamraj24</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/smub/\">Syed Balkhi</a> · <a href=\"https://profiles.wordpress.org/nuhel/\">Syed Nuhel</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/sparklingrobots/\">Tara King</a> · <a href=\"https://profiles.wordpress.org/buley/\">Taylor</a> · <a href=\"https://profiles.wordpress.org/taylorde/\">Taylor Dewey</a> · <a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a> · <a href=\"https://profiles.wordpress.org/tazotodua/\">tazotodua</a> · <a href=\"https://profiles.wordpress.org/tykoted/\">Teddy Patriarca</a> · <a href=\"https://profiles.wordpress.org/tellyworth/\">Tellyworth</a> · <a href=\"https://profiles.wordpress.org/thakordarshil/\">Thakor Darshil</a> · <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a> · <a href=\"https://profiles.wordpress.org/thinkluke/\">thinkluke</a> · <a href=\"https://profiles.wordpress.org/griffinjt/\">Thomas Griffin</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kr&#228;ftner</a> · <a href=\"https://profiles.wordpress.org/threadi/\">threadi</a> · <a href=\"https://profiles.wordpress.org/tnolte/\">Tim Nolte</a> · <a href=\"https://profiles.wordpress.org/timbroddin/\">timbroddin</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timoth&#233;e Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tmatsuur/\">tmatsuur</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomybyte/\">Tom</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/hifidesign/\">Tom Finley</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomluckies/\">tomluckies</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/tomsommer/\">tomsommer</a> · <a href=\"https://profiles.wordpress.org/tomxygen/\">tomxygen</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemer&#246;</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/torres126/\">torres126</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/toru/\">Toru Miki</a> · <a href=\"https://profiles.wordpress.org/toscho/\">toscho</a> · <a href=\"https://profiles.wordpress.org/wpsmith/\">Travis Smith</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">Utsav Patel</a> · <a href=\"https://profiles.wordpress.org/utsav72640/\">Utsav tilava</a> · <a href=\"https://profiles.wordpress.org/ukdrahul/\">Uttam Kumar Dash</a> · <a href=\"https://profiles.wordpress.org/valerogarte/\">valerogarte</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/vikram6/\">vikram6</a> · <a href=\"https://profiles.wordpress.org/viliamkopecky/\">viliamkopecky</a> · <a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a> · <a href=\"https://profiles.wordpress.org/vladimiraus/\">vladimiraus</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/wasiur195/\">Wasiur Rahman</a> · <a href=\"https://profiles.wordpress.org/welaunchio/\">welaunchio</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whsajid/\">WHSajid</a> · <a href=\"https://profiles.wordpress.org/wpcorner/\">WP Corner</a> · <a href=\"https://profiles.wordpress.org/xlthlx/\">xlthlx</a> · <a href=\"https://profiles.wordpress.org/yansern/\">Yan Sern</a> · <a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a> · <a href=\"https://profiles.wordpress.org/tollmanz/\">Zack Tollman</a> · <a href=\"https://profiles.wordpress.org/zanematthew/\">Zane Matthew</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">zieladam</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/chesio/\">Česlav Przywara</a></p>\n\n\n\n<p>Over <a href=\"https://translate.wordpress.org/stats/\">70 locales have translated 90 percent</a> or more of WordPress 6.5 into their language. Community translators are working hard to ensure more translations are on their way. Thank you to everyone who helps make WordPress available in 200 languages.</p>\n\n\n\n<p>Last but not least, thanks to the volunteers who contribute to the <a href=\"https://wordpress.org/support/\">support forums</a> by answering questions from WordPress users worldwide.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get involved and contribute</h3>\n\n\n\n<p>Participation in WordPress is not limited to coding. If contributing appeals to you, learning more and getting involved is easy. Discover the teams that come together to <a href=\"https://make.wordpress.org/\">Make WordPress</a>, and use <a href=\"https://make.wordpress.org/contribute/\">this interactive tool</a> to help you decide which is right for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">One more haiku</h2>\n\n\n\n<p>6.5 is here!<br />Play, interact, build better,<br />Stronger and faster.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Apr 2024 18:42:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Do The Woo Community: Day Two Updates from the CloudFest Hackathon 2024\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=80779\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://dothewoo.io/day-two-updates-from-the-cloudfest-hackathon-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:166:\"A diverse group at the CloudFest Hackathon worked on innovative projects, from database integration to accessibility plugins, showcasing dedication and collaboration.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Apr 2024 09:25:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"Gutenberg Times: Gutenberg Changelog #98 – WordPress 6.5, Gutenberg 18.0 Community Theme Project and the Contributor Mentorship Program\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://gutenbergtimes.com/?post_type=podcast&p=28067\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://gutenbergtimes.com/podcast/gutenberg-changelog-98/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:44696:\"<p>In this episode, Maggie Cabrera and Birgit Pauli-Haack discuss WordPress 6.5, Gutenberg 18.0, Community Theme Project and the Contributor Mentorship Program.</p>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-98/#shownotes\">Show Notes</a> / <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-98/#transcript\">Transcript</a></p>\n\n\n\n<ul>\n<li>Music:&nbsp;<a href=\"https://soundcloud.com/xirclebox\">Homer Gaines</a></li>\n\n\n\n<li>Editor:&nbsp;<a href=\"https://www.linkedin.com/in/sandy-reed/\">Sandy Reed</a></li>\n\n\n\n<li>Logo:&nbsp;<a href=\"https://markuraine.com/\">Mark Uraine</a></li>\n\n\n\n<li>Production:&nbsp;<a href=\"https://icodeforapurpose.com\">Birgit Pauli-Haack</a></li>\n</ul>\n\n\n\n<p class=\"has-larger-font-size\" id=\"shownotes\"><strong>Show Notes</strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">Maggie Cabrera</h2>\n\n\n\n<ul>\n<li><a href=\"https://profiles.wordpress.org/onemaggie/\">WordPress profile</a></li>\n\n\n\n<li><a href=\"https://twitter.com/one_maggie\">Twitter @one_maggie</a></li>\n\n\n\n<li>GitHub <a href=\"https://github.com/MaggieCabrera\">MaggieCabrera</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Announcements</h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2024/03/25/wordpress-6-5-release-delayed-1-week/\">WordPress 6.5 release delayed 1 week</a></li>\n\n\n\n<li><a href=\"https://wordpress.org/news/2024/03/wordpress-6-5-release-candidate-4/\">WordPress 6.5 Release Candidate 4&nbsp;</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/community/2024/02/16/contributor-mentorship-program-second-cohort-2024-q1/\">Announcing the Second Cohort (2024 Q1) of the WordPress Contributor Mentorship Program</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/03/26/hallway-hangout-data-liberation-discussion-and-brainstorm/\">Hallway Hangout: Data Liberation Discussion and Brainstorm</a></li>\n\n\n\n<li>Recording: <a href=\"https://www.youtube.com/watch?v=ezPHiyhhaoQ\">Developer Hours: Exploring Block Hooks in WordPress 6.5</a></li>\n\n\n\n<li><strong>April 9, 2024, at 14:00 UTC</strong>: <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/300032710/\"><strong>Developer Hours: Building custom blocks with the Interactivity API</strong>.</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/community-themes\">Community Theme Project</a></li>\n</ul>\n\n\n\n<p><strong>Developer Blog updates</strong></p>\n\n\n\n<ul>\n<li><a href=\"https://developer.wordpress.org/news/2024/03/14/how-to-register-block-variations-with-php/\">How to register block variations with PHP</a>&nbsp;</li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2024/03/19/pattern-design-tips-and-tricks-for-developers/\">Pattern design tips and tricks for developers</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2024/03/21/drop-shadow-updates-in-wordpress-6-5/\">Drop Shadow updates in WordPress 6.5</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2024/03/25/exploring-the-block-hooks-api-in-wordpress-6-5/\">Exploring the Block Hooks API in WordPress 6.5</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2024/03/26/how-to-use-wordpress-react-components-for-plugin-pages/\">How to use WordPress React components for plugin pages</a></li>\n</ul>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2024/03/27/whats-new-in-gutenberg-18-0-27-march/\">What’s new in Gutenberg 18.0? (27 March)</a>.</p>\n\n\n\n<p><a href=\"https://wordpress.github.io/gutenberg/?path=/story/dataviews-dataviews--default\">Story Dataviews Component</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/design/2024/03/25/design-share-mar-11-mar-22/\">Design Share: Mar 11-Mar 22</a></p>\n\n\n\n<p class=\"has-large-font-size\">Stay in Touch</p>\n\n\n\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<ul>\n<li>Did you like this episode? <a href=\"https://lovethepodcast.com/gutenbergchangelog\"><strong>Please write us a review </strong></a></li>\n\n\n\n<li>Ping us on Twitter or send DMs with questions. <a href=\"https://twitter.com/gutenbergtimes\">@gutenbergtimes </a>and <a href=\"https://twitter.com/bph\">@bph</a>.</li>\n\n\n\n<li><em>If you have questions or suggestions, or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. </em></li>\n\n\n\n<li><em>Please write us a review on iTunes! <a href=\"https://gutenbergtimes.com/itunes/\">(Click here to learn how)</a></em></li>\n</ul>\n</div></div>\n\n\n\n<p class=\"has-large-font-size\" id=\"transcript\"><strong>Transcript</strong></p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Hello, and welcome to our 98th episode of the Gutenberg Changelog Podcast. In today&#8217;s episode, we will talk about WordPress 6.5 briefly, Gutenberg 18.0, the community mentorship program, and some other things that are in the works. And I&#8217;m your host, Birgit Pauli-Haack, curator at the Gutenberg Times and full-time Core contributor for the WordPress open-source project sponsored by Automattic&#8217;s Five for the Future Program. That is a mouthful, and we&#8217;re going to repeat it again. I am thrilled to have with me Maggie Cabrera, also Core contributor, also sponsored by Automattic. She was also the co-lead for the Twenty Twenty Four theme development, and she does so much more in the community as well, and we will talk about those things. Thank you for joining me on the show, Maggie. Welcome. How are you today?</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Hi. Thanks for having me. I&#8217;m doing really good. How are you?</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> I&#8217;m good, I&#8217;m good. I&#8217;m excited. Yeah, it&#8217;s kind of Easter weekend, and we get a few additional days.</p>\n\n\n\n<p><em>Maggie Cabrera</em>: Yeah, short week. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. Short week, yes.</p>\n\n\n\n<p><em>Maggie Cabrera</em>: I&#8217;m really excited to be here with you.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Announcements</h3>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. So we have a couple of announcements that we want to kind of let our listeners know, and so one is, although contributors work really hard, the release team decided to delay the release of WordPress 6.5 for a week to get some more bugs fixed that are gravely impacting the user experience, and make the change to the default fonts directory. There was a discussion back and forth, and there was in Core, on the Core blog, you can certainly read up about it. I think the most important information is that it releases on April 2nd, just after the Easter holidays in Europe, so&#8230;</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah. Yeah, I think it wouldn&#8217;t have, the holidays here, it would&#8217;ve been just a two-day release delay, or something like that, but I think it makes sense to take it out a little longer, and make sure that everything&#8217;s ironed out, and the change with the forms directory, it&#8217;s been a constant discussion, but it feels like there&#8217;s a solid decision now, so that it feels like it&#8217;s,&nbsp;</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> It&#8217;s a solid decision to get a release out, yes.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah, it wasn&#8217;t easy, apparently. Yeah, yeah, it wasn&#8217;t a clear solution there.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. No, and it&#8217;s kind of architectural versus practical, and all those kinds of different aspects of it, yeah. Would host work with it? How plugin devices work with it, and how users will find it. So I think it&#8217;s a decision, and we will see how it works out when WordPress 6.5 kind of hits your WordPress instance next week.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">Community Contributions</h3>\n\n\n\n<p>There are a few community contributions that I wanted to point out. The developer blog, we had a great publishing two weeks on the developer blog. Sometimes, we barely get one post out a week, but this time, we had two posts per week, so that is really cool, and in a very broad spectrum. So the first one was how to register block variations of PHP, and I think it was one of the most-read posts on that, and what we saw on Twitter was also the comments was, &#8220;Oh, finally, something for PHP developers who are not that comfortable with JavaScript,&#8221; and I&#8217;m glad we kind of, yeah, picked them up as well. Yeah, and another one that was well-received was the pattern design tips and tricks for developers and designers.</p>\n\n\n\n<p><em>Maggie Cabrera</em>: Oh, yes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, by Beatriz Fialho.</p>\n\n\n\n<p><em>Maggie Cabrera: </em>Yes, I love that one.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. She did an awesome job with the dos and don&#8217;ts, and kind of make it also visually very attractive.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yes. I need to link that one to the Community Themes project, because it&#8217;s really relevant, so that&#8217;s really good that I have the link there for me.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. So the Meta team asked me if we could add some of the dos and don&#8217;ts to the pattern directory guidelines as well, because that would probably also change a little bit how people kind of approach it. Well, you mentioned the Community Theme project. Do you want to tell me about it, or our listeners about it?</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Oh, yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah?</p>\n\n\n\n<h3 class=\"wp-block-heading\">Community Theme Project</h3>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah, sure. Absolutely. Yeah, the Community Themes project is this really small thing that it&#8217;s&#8230; I hope it will attract more new contributors to the WordPress project. So, basically, it started after contributing to some of the previous default themes, I think it was Twenty Twenty One or Twenty Twenty Two. It was such a good experience for me to work with the community, and all the contributors, all together on a default thing, that it felt really sad that it only lasted a few months, and after that development was done, everyone went their own ways, and that was it. So I felt shouldn&#8217;t we just keep making blog themes together, and keep this momentum going? And so yeah, we just opened a repo, and started building some community themes that, they are block themes. It&#8217;s like this space where you can get with other contributors with different degrees of experience that can help you build block themes following the best code practices, and learn how to do that together. Now, we are using that project to also onboard new contributors via the mentorship program, which I think you&#8217;re going to talk about in a bit. So the new contributors will join that repo and help build the themes with some other more-seasoned contributors helping them out.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, so was it Twenty Twenty Two that had the call for style variations?</p>\n\n\n\n<p><em>Maggie Cabrera:</em> I think it was Twenty Twenty Three.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Twenty Twenty Three? Oh, yeah.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> And that was the community project that you are kind of working on, where you had about 38 people submitting style variations, and made it into the default theme. So that was really cool, and it was also interesting to see how different designers approach it, yeah, and was it one or two themes that the Community Theme project released?&nbsp;</p>\n\n\n\n<p><em>Maggie Cabrera:</em> So, right now, there&#8217;s two that are already finished, but we&#8217;re working on four more. They&#8217;re still in different degrees of done, but we&#8217;re not in a rush, which is the nice thing, because a default theme has a deadline, but community themes don&#8217;t really, so we just go at the pace of the contributors, and hopefully there will be, like those four, will make it sometime in the future in the directory. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. So where can people read up about it? Is a GitHub repo, or a GitHub space, or is a channel?</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah, it is a GitHub repo under the WordPress namespace. I think there&#8217;s an old post on the Make blog on the themes team, and it&#8217;s also part of the mentorship program. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. Yeah, we definitely need to bring this out more, and amplify some of that work that you&#8217;re doing.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah, whenever I go to WordCamps, and during contributor day, we usually work on that, on the themes table. So if you&#8217;re around in WordCamp EU, I will probably do more of that. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Excellent. Excellent. So yeah, there are some more developer blog posts that I wanted to point out. The next one was drop shadow updates for WordPress 6.5. That kind of covers that drop shadows were only available for buttons, and only through the theme JSON file, so now, they&#8217;re available with a user interface under the Border and Shadows section in the styles, and come with five presets from Core. And you can add through the theme JSON additional ones, and they&#8217;re now available for images and column both, and the button block. Yeah, so those four blocks can now have drop shadows, have support for drop shadows. Yeah, it&#8217;s quite interesting to see how drop shadows make a revival design-wise, because they add a little bit of a dimension to a site, especially. Oh, and well, we talk about it when we cover Gutenberg 18.0 is, it now also came to featured image, but it will not be in 6.5. Yeah, and then Nick Diego published an Exploring the Block Hooks API in WordPress 6.5. You need, really, a big cup of coffee for it when you want to read it. It&#8217;s about 5,000 words, but it has 4 examples, how you can use this API to add blocks to various actions, and various other blocks, and also change content.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> More PHP for the PHP lovers.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Say it again?</p>\n\n\n\n<p><em>Maggie Cabrera:</em> More PHP for the PHP-lovers.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, it&#8217;s both, actually.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah, true.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. Yeah, you need to tell the block what to do. So that&#8217;s probably in JavaScript some more. Yeah. But yeah, that definitely, yeah, and then the last one was just published yesterday is how to use the WordPress React components for plugin pages, and so you can use the components that are pre-configured, pre-designed. You don&#8217;t have to make those decisions, but you can use them to also create your settings pages, your additional pages on the plugins, and it kind of goes into the next phase of things, when admin changes over to a few additional pages and all that, so&#8230;&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">Mentorship Program</h3>\n\n\n\n<p>Well, you mentioned it before, the second cohort of the mentorship program is almost finished. It has really taken off. Almost 50 contributors were paired with mentors, and the program ran for six weeks. Mentees came from a lot of different countries, from Spain, from Egypt, from India, from Brazil, Italy. That&#8217;s just what I can kind of, at a first glance, see. So you have been part of it as a mentor, Maggie. So thank you for raising your hand and stepping up to that plate, and so what was your experience in working with a mentee in the whole program?</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah, it&#8217;s been really good. Our particular project has nine people working on building the community themes that I mentioned before. Of those mentees, they all have varying degrees of experience in blog theme development, and I was really happy to see that some of them were designers, which is something that slowly, we&#8217;re moving towards, which I&#8217;m really excited about.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: That&#8217;s cool. That designers are going to now do themes. Yeah, absolutely.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah. Before, it was just developers, and then we&#8217;re getting more and more designers, because they don&#8217;t really need to actually know any kind of coding skills to do this. So I encourage any designers to join us, if they want to. I had the privilege to meet a few of them during WordCamp Contributor Day on the themes table. We were working on some community themes, along with other contributors that just joined our org, and I think this is the second instance of the mentorship program, which was successful, they did the first time around, and there&#8217;s been way more people this time, all over other teams of the project. I&#8217;m only talking about teams because it&#8217;s the one that I&#8217;m working on, but there&#8217;s a community, there&#8217;s Core, there&#8217;s tests, there&#8217;s documentation. All of the teams, I think, are represented. So everyone&#8217;s welcome. So yeah, I encourage, from here, anyone who&#8217;s interested in being a contributor to join it for the next one, and keep an eye on that. I think it&#8217;s the community Make blog where they are announcing when this mentorship is taking place, and it&#8217;s really nice.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. That will be <a href=\"http://make.wordpress.org/community\">make.wordpress.org/community</a>. So the program managers are Hari Shanker and Naoko Takano?</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> And they&#8217;re both very experienced community members.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yes, they are.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, and yes, the first cohort was in July last year. It started in July last year. It&#8217;s an experiment, yeah, and, obviously, the feedback was really great in how it all went, both from mentees and mentors. So they were able to expand this. I think they had 75 applicants. So there is an application embedding process for both mentees and mentors.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah. There&#8217;s also been, this time around, there&#8217;s been a grant for LGBTQ+ people, so some of them are actually sponsored to join the mentorship program, which I hope will happen again. So yeah, I&#8217;m really excited about that, too.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, that&#8217;s one of the many, actually, efforts to bring underrepresented minorities also to the contributor team, and I really love that there is a sponsorship there, because many women, I say, were non-binaries, have so much requests on their times, that apart from having a profession, or a job to do, they&#8217;re also caretakers of their families, their kids, their elderly, and so they are not as free, most of the time, in our society, not as free to take on extra time, and we can&#8217;t change that, but we can help offset some of the financial burdens that are there. All right, so yeah, I&#8217;m glad we talked about the mentorship program there. Thank you so much.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">Data Liberation</h3>\n\n\n\n<p>So there&#8217;s another initiative out there since the State of the Word in 2023. That was in Madrid. Matt Mullenweg talked about the data liberation, that anybody should be able to take their data and move either into WordPress, from WordPress to another WordPress, or from a third-party system, and the Data Liberation Project Initiative has invited developers and product owners to a hallway hangout, which is an informal discussion, to discuss and brainstorm around that project, and it&#8217;s on April 3rd at 7:00 PM, 1900 UTC, which is 1500 Europe or Germany, and 1900 is 1700. Well, time zones. Yeah, it&#8217;s 1900 UTC. Let&#8217;s do it that way.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> We&#8217;re close to daylight savings, so you just let those people figure it out.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. It&#8217;s going to change on Sunday. So today is the 10th, and it will be on April 3rd. So yeah.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> For some people.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> For some people.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> For some people.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> That&#8217;s okay. Only for some people.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. Well, if you miss it, because either time zones or daylight savings time, there, likely, will be a recording, and the topics that will become discussions is kind of the challenging of migrating from third-party platforms to WordPress, the good, the bad, and the ugly of exporting WordPress content. So the potential interoperability between block libraries, and page builders, and what work will make data liberation, and who should work on it. So that&#8217;s quite an interesting discussion to have with those people that are interested in the project on April 3rd. Okay, yeah, every time when I was working in an agency, it was always a little bit hard to move people away from hosting that is bad, or from page-builder that was bad, and all of that. So I&#8217;m glad that there is a project now where all the community can put together their scripts, and their ideas, and their work that they have already done, and share it with the rest of the community.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah. I know more and more people who want to move out of those walled gardens, and own their own content, so I think that&#8217;s going to be a great initiative, for sure.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, the flexibility.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> To keep an eye on it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. The interoperability is just unmatched there that WordPress has with other systems, and the more a website grows up, the more needs there are, for sure.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">Developer Hours</h3>\n\n\n\n<p>Speaking of events, this week was a developer hour covering the block hooks API, and Nick Diego, and Ryan, or, no, Justin, went through four examples, Justin Tadlock, four examples of adding a like block to a page, and moving it from the comments to the top, or something like that, and then the Getting Started Guide in the Block Editor Handbook has a example of a copyright block. This developer API event kind of took that, and see what you could do with the block hooks, and get it into a footer, or get it into a template. And then the third example is to add a Back to Top link to a paragraph, or to the next heading, before the next heading, or something like that. Yeah, and then, last, but not least, how to add a login/logout block automatically to the navigation of a site in the template. So, right now, you can&#8217;t use the block hooks API, all the blocks. We should get rid of the name blocks, and just call it hooks.</p>\n\n\n\n<p>Right now, it&#8217;s only for templates; you cannot do it for pages or posts, but that certainly is the next iteration of it. The recording will be linked in the show notes, so you can catch up on it, and they use the developer blog post on the block hooks API as a guide, and how they talked about it. Yeah. The next Developer Block Hour&#8230; God. There&#8217;s an erroneous block added to it, the Developer Block hours. No, it&#8217;s the Developer Hours, and it will take place on April 9th with Damon Cook and Nick Diego, and they will showcase examples on how to use the interactivity API and enhance your block-building experience for you and your users. So save the date, April 9th at 1400 UTC. You&#8217;ll figure out when that is for you, but I will link to register in the show notes, and it&#8217;s a link to meet up, and they do a good job in translating the times to the local times of your browser. All right, that&#8217;s about that, and I think it&#8217;s time that we start with the Gutenberg 18.0 release. Maggie, do you want to be honest and get us into the groove of things?</p>\n\n\n\n<h3 class=\"wp-block-heading\">What’s Released &#8211; Gutenberg 18.0</h3>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah. The 18.0 Gutenberg plugin release has 206 closed PRs by 59 contributors. It has a record setting of 17 first-time contributors, which is amazing.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, amazing. Yeah. The last time, I think, was Gutenberg 13 point-something. Yeah, it was 13, but, normally, we have 4 or 5 first-time contributors.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, I&#8217;m thinking that the successful Contributor Day in WordCamp Asia had something to do with it, but it&#8217;s just a theory.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah, or the mentorship. Maybe the mentorship, too.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, mentorship, too, yeah.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> I don&#8217;t know.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah. Everything counts, yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Everything counts. Yes, of course. Yeah, every contribution is worth it.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah. If you look, you&#8217;ll find, in the release, the result of additional data view works, improvements on feature image in all the blocks, and a ton of bug fixes, and about 35 PRs just for the contribution updates.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, it&#8217;s amazing.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> So let&#8217;s have a look at some of them.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Enhancements</h3>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. So DataViews is the prototype for the new admin design. Not a lot of people realize that, but if you&#8217;re in the blog edit and the site editor, the list views that you see there, the list of templates, and the list of pages, and the list of template parts, they&#8217;re all powered by the new data views, and this release brings with the multiple selection of filters. So if you were in a template view, you can say, &#8220;Okay, I want to combine the filter from the author with a theme,&#8221; or something like that. Yeah, or, &#8220;In a page, I want the ones that are published and pending for review, but not the draft ones,&#8221; or, &#8220;I want the ones published by a certain author.&#8221; So these, in the list here, I don&#8217;t think that&#8217;s actually available in the admin section now. I&#8217;m not quite sure. Yeah.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Not as complex as this filter looks like in this PR. It feels like it&#8217;s going a step ahead, and what I think is very powerful is how this can be used, not just where it&#8217;s being used right now, but in any other place that a plugin author may want to implement it, or in the future, we&#8217;re going to see it in other places in the admin panel. So yeah, I think it&#8217;s really powerful, and they&#8217;re working really hard on making this something that can be used in many ways. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, and in the pages state of view, they added some quick actions. The quick bulk actions. I think bulk actions is the one from the admin where you can say, &#8220;Okay, I want this page, and this page, and this page,&#8221; and then delete them all, or change something, or something like that. Yeah, and now, that&#8217;s also in the new ones. And the last one from the data view, there are tons of changes in the data views. Some were incremental changes, but one is that the updates…</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah, the story.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, so I wanted to talk about the index page for the templates, because it now shows three different views of it. So you could have a table. So the templates are your archive pages, your single post template, and all that, and you can see them all in a list, or you use the toggle for the layout, and you can see a grid view, and the grid view gives you a little small preview of the template, so you know exactly what it will show with a featured image with where the content is, and all that, or you can have a list, but then, there&#8217;s another pane that gives you a preview of the full page, full template, where you can also edit it, so that, from table, to grid view, to list view, those are the different prototypes for the admin designs, and it&#8217;s really smooth how they move, and with all the animations, yeah.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah. I&#8217;ve been looking at the PRs, and the contributors take a lot of care into the performance aspect of the changes. They are keeping close tabs into what the performance looks like. So these improvements, they&#8217;re going to be very important when this goes all over the admin. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. So the next item on my list was in the site editor, the featured image is now, or in the site editor that we can look at, the post editor, the featured image section is now moved up to the top of the inspector control, which is….</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah, I&#8217;m very excited about that. It feels like it&#8217;s such a small change, but it&#8217;s something that you want to be up top there, so I&#8217;m really excited that that finally made it. That&#8217;s the kind of thing that it&#8217;s like, &#8220;Why is it that hidden?&#8221; And it&#8217;s also something that it&#8217;s toggled, so you need to click it before you see it. So now, it&#8217;s up there, right where you need all the info for your photos.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah.</p>\n\n\n\n<p><em>Maggie Cabrera: </em>Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, yeah. Yeah, the web pages become more and more just also visually, need to be visually attractive. You need to have a featured image for the social posts. Yeah, so it&#8217;s such a strong piece of your design that it should be more in the forefront, as it is now. Yeah. Yeah, speaking of featured image, you can now use the featured image in a media and text block, which I find exciting, because you don&#8217;t need to use complicated columns. Yeah, you can just use a media and text block for your featured image, and the title of your post, and then it kind of shows up in a great way, and you don&#8217;t have it as a background, or as a cover, or something like that; it&#8217;s just the picture has its own right, actually, in your header of your post, or in your archive pages. Yeah, so I really like it. Have you seen any designs for that yet?</p>\n\n\n\n<p><em>Maggie Cabrera: </em>No. You&#8217;ve seen that particular block, but I can think of a few things that I&#8217;ve worked on that try to replicate the same thing with columns, and I&#8217;m glad that now, we can do it with the media and text block, which is probably simpler than those solutions that we built. So yeah, I&#8217;m excited to have another tool for the theme developers to get those featured images in your posts. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, media and text block is actually quite versatile in how you can use it, and also, the expanding of the picture when the text goes bigger, and yeah, it&#8217;s all some automation in there. That was very intriguing.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> And the responsive controls, yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> It was very intriguing to me, yeah, when I first kind of encountered it, and we mentioned it before, for the featured image, now, you can attach a box shadow or a drop shadow around it. It has support for that now. So you could have borders that are rounded plus a drop shadow on your featured image in the single post. It&#8217;s really cool. Yeah, I like it.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yep.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: So the layout changes are part of the grid layout experiments? Have you experimented with those grid layouts that are coming to WordPress, or to the Gutenberg Times?</p>\n\n\n\n<p><em>Maggie Cabrera:</em> I have tested some of the PRs. This is not yet on Core, right?&nbsp;</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> No, it&#8217;s on 18.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Okay. Yeah, so that&#8217;s the reason why I haven&#8217;t used it in a production-ready theme, but I&#8217;m really excited. I&#8217;m following it, because I think it&#8217;s great. It&#8217;s the future of layout in WordPress. So I&#8217;m super stoked about how fast it&#8217;s moving, because grid is so complicated, and thinking about a UI for grid, that it&#8217;s both complex enough to give you all the tools that you need for those complicated layouts, while are still being friendly for users who don&#8217;t know how grid works in CSS, it&#8217;s an incredible difficult accomplishment. So I&#8217;m really excited to see it advance, and it&#8217;s looking really, really promising. I really think it&#8217;s the future for theme layout. So I&#8217;m really looking really closely into those features.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. So right now, you can only experience it when you enable the grid layouts in the experiments section of the Gutenberg plugin, but it&#8217;s really eye-opening how it all works, and there are two new features in there, that one is to have start row, and column start and row start controls in the grid so inside the grid, so you can drag and drop around blocks, and use the drag and drop, which is, visually, much easier to accomplish than trying to figure out which column to put where, something wherever, and another one is that you can group blocks in a grid, so you have six paragraphs, and then you highlight them all, and you click the grid button, and then it arranges them in whatever grid you say, three by three, three by two, four by two, kind of&#8230; Yeah, it&#8217;s actually really magic. Yeah.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> It&#8217;s magic. It&#8217;s magic, yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, yeah, and it&#8217;s just so amazing that this is possible in WordPress, where you never had any layout tools before. Yeah, so yeah, we are really happy about that. The next thing is that, also, in the site editor, when you look at styles, up until now, you have just the style variations, but now, you also have access to the color and the typography presets in the same page or same column. So you can say, &#8220;Okay, I want this style variation, but I want it in a different color, and I want a different font for that.&#8221; So that informs your whole site as well. You don&#8217;t have to do it for every block, and every template, or something like that. Yeah, so this is really powerful to kind of bring the global styles, not only to the style variations, but also to color and typography presets. Yeah.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah, sometimes you really like everything about a style variation, but the colors or the typography, and now, you can mix and match however you like, which is nice having the extra option, and I think it&#8217;s also a stepping stone for more changes, in that vein, that will come. So yeah, I&#8217;m excited about that, too.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, and it&#8217;s also visually pleasing. So if you try that out, then when you use the Gutenberg plugin, you have some great visual representation of what the presets would be like, and also, when you click on it, you have a preview on the right-hand side, so you know what you get yourself into. So it&#8217;s really good.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">APIs</h3>\n\n\n\n<p>There&#8217;s a new API for developers, and that is the plugin document settings panel. So in the document settings, you can have, now, a slot fill, where you, as a plugin developer, you can have put additional fields in there, additional information, and additional controls, and it&#8217;s now available, also, for the site editor. You could do this on the post editor, but now, it&#8217;s also available for the site editor. So there&#8217;s this matching-up with post editor and site editor kind of becoming the same.</p>\n\n\n\n<p><em>Maggie Cabrera</em>: Yes. Yeah, that&#8217;s important.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Bug Fixes</h3>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Oh yeah. There&#8217;s one bug fix that I really love, and that&#8217;s the code bug. Finally. So yeah, especially for the developer blog, yeah, we had a few code examples.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> I see why you highlighted it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> &#8230; where we had to kind of spend hours, no, not hours, but at least a half an hour, very tedious work, to remove the breaks, and kind of have new lines in there in code view. So, now, that&#8217;s finally solved, and yeah, we can now start writing again.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Focus your time on what&#8217;s important, yes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, it&#8217;s actually very soothing. It&#8217;s almost meditative doing that, but you need to be in the mindset for that.</p>\n\n\n\n<p><em>Maggie Cabrera: </em>Oh, yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, yeah.</p>\n\n\n\n<p><em>Maggie Cabrera</em>: Put on some music.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, put on some music. Yeah.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah, I get it.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Documentation</h3>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> I think I wanted to highlight one of the documentation things. So, if you, as plugin developer, or agency developer, are interested in the data views, there is a&#8230; Well, all the components are in a storybook kind of site that gives you a representation outside of context of a component, and you can see all the attributes for it, and you can try it out, and they just updated the story for the data views component, and so it&#8217;s easier for if you want to kind of experiment with it, or, in your research, you can definitely use it now, and get a better handle on how the data views would maybe work for you in your plugin, and give us your more complicated custom post types that you might have. I will link the story to this DataViews component into the show notes so you don&#8217;t have to hunt it down.</p>\n\n\n\n<p>I think that was it. That&#8217;s all from the Gutenberg plugin 18.0. Of course, if you&#8217;re interested in any of the other 209 PRs, the release post will be on makeblog/core later, after we&#8217;ve finished recording, but way before this podcast is published, so we&#8217;ll have it there for you in the show notes.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">What’s in Active Development or Discussed</h3>\n\n\n\n<p>Now, we&#8217;re at the section of what&#8217;s in active development or discussed, and I wanted to point out for you, dear listeners, what&#8217;s coming with the admin design. We know we see a few things already in the site editor, and as kind of a prototype of Saxon Fletcher from the design team showed in the video how the next version of DataViews, the admin pages, could work, and it&#8217;s an insightful 18-minute video shared in the design channel, and he summarizes the most recent thinking, particularly about layout and transitions in and out of the editor, and walks us through some of the Figma views and prototypes. It also goes into details about some of the Core paradigms, and if you&#8217;re not part of the WP Slack, you can also watch it via the latest design share on the Make design blog. So, Maggie, did you watch it? What was the most intriguing for you, or what was it from it?</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah, we talked about the DataViews earlier, and I think it&#8217;s really exciting to see how it&#8217;s shaping up. I think one of the comments that he makes is probably what some of the people have mentioned, about how the drilldown on the sidebar looks like, and how you&#8217;ve got to kind of click too many times to get where you want, and if you want to go back, you got to get taken back again, and it&#8217;s nice that they&#8217;re looking into that, and see if they&#8217;re going to iterate on that design. I think it&#8217;s really important for extenders, and even just regular users, to look into those design explorations, and give them feedback, because there&#8217;s only so many things that the design team can take into account, even though they make a great job at trying to figure out all use cases, and all probable ways of using the WordPress admin, but if you have feedback, I think this is the key moment to give it. So go ahead and look at the video. It&#8217;s really exciting. I think it looks really good, and I&#8217;m super stoked to see it actually live, and maybe even work on it. I really enjoyed, particularly, the color stuff, so I&#8217;ll delve into that, if I can chime in on that, but yeah, absolutely 100% look into it and give feedback, because now is the moment. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, what struck me as really interesting to see was how the new layout, we talked about the layout being on the left-hand side, being the menu, and then you get a list view, and then a preview, that has also been explored to use with more complicated custom postings, like a product, for instance, that has a few additional settings that you need to enter it, and he showed, very nicely, how that can be done in that content area in the middle of it, and then you could either switch to settings of the product, and have additional tabs, and additional fields and forms, or you could go and edit the product in an editor view. So I think there&#8217;s some great explorations there, in terms of more complicated custom post types, and to see those in a more modern interface is, really, it&#8217;s quite exciting for me. Yeah, and I can see how, because the admin designs are all extensible right now, and that accessibility needs to come back. So yes, so&#8230;</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Yeah. WordPress needs plugins to live. Plugins are the soul of WordPress, so having them be more consistent with the general admin field is going to make WordPress, in general, a better experience for any users, whatever the plugins are. So that&#8217;s really good.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, in the Figma space section, it also showed some of the standard colors, and how the variables for primary, secondary, and tertiary could work out, but he also had a section in there where he changed a whole palette from light to dark, and then every screen would also follow suit, and how that is already thought through about it because admin themes are, I think on Core, we have six or seven admin themes, and plugins add additional ones there, so that needs to be taken care of as well. And with the Figma place, where all the standards are, it&#8217;s probably easier for the plugin developers to make decisions, and to come forward to going to production much faster than before, because they don&#8217;t have to invent the wheel over and over again. Yeah, so that&#8217;s an active discussion on the design team, and I have a link for you in the show notes, and, with that, we are at the end of the show.&nbsp;</p>\n\n\n\n<p>Maggie, it has been a great pleasure to chat with you, and I hope you&#8217;ll come back in a few months for another Gutenberg Changelog episode.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Absolutely. Yeah, I would be really happy to. It&#8217;s been a pleasure for me. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Thank you, Maggie.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Thank you so much for inviting me.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Absolutely, and the pleasure was all mine. So, before we end the show, I want to remind everyone, April 9th, next Developer Hours on the Interactivity API at 1400 UTC. I think it&#8217;s 8:00 AM Eastern, but don&#8217;t hold me to that.&nbsp;</p>\n\n\n\n<p>As always, the show notes will be published on gutenbergtimes.com/podcast. This is episode 98, and if you have questions, or suggestions, or news you want us to include, send them to <a href=\"mailto:Changelog@GutenbergTimes.com\">Changelog@GutenbergTimes.com</a>. That&#8217;s <a href=\"mailto:Changelog@GutenbergTimes.com\">Changelog@GutenbergTimes.com</a>, and if you want to write a review about our podcast, I think our last reviews were from 2021. I also have asked that much for it, and I have the experience that when you ask for it, people will step up to the plate and write a review. So if you want to do that, that would be really helpful, because it helps with discovery for new people. All right, that&#8217;s it. Thanks for listening. Goodbye.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> Goodbye.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Until the next time. See you.</p>\n\n\n\n<p><em>Maggie Cabrera:</em> See you.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 30 Mar 2024 19:57:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Gutenberg Changelog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Gutenberg Times: Gutenberg 18.0, Playground, Pattern, and Form plugins and so much more — Weekend Edition 289\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=28030\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:115:\"https://gutenbergtimes.com/gutenberg-18-0-playground-pattern-and-form-plugins-and-so-much-more-weekend-edition-289/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:24294:\"<p>Happy Easter if you celebrate it! 🐰 🐣&nbsp; The Easter weekend has a total different vibe in Munich as it had in Naples. In Naples, it was just a normal weekend, and you could get groceries over the weekend, and other shopping done.  Here it is a four-day weekend with Good Friday and Easter Monday as bank holidays and except for Saturday, almost all shops are closed. </p>\n\n\n\n<p>On Thursday, everyone was out grocery shopping for the long weekend. We went to our weekly neighborhood market and were surprised by the long queue in front of every stand. People weren&#8217;t deterred by the pouring rain. It took us twice as long to make our purchases then in a normal week. I bet the lines would have been even longer without the rain. </p>\n\n\n\n<p>We bought the first white asparagus already, some fish salad and graved lachsforelle from the local trout farmer, vegetable from the local farmers and butter and eggs from the local dairy farmers. At each stand, during the cash payment process you have a little chat with the merchant. I cherish these moments in the non-online, the analog world, that hasn&#8217;t changed for centuries. Interpersonal connections are so much richer than anything that can happen online,  writes she who has been building websites for 28 years. Anyway. What are your favorite offline every day interactions, you cherish?</p>\n\n\n\n<p>Now back to the world of blocks, themes, and plugins. </p>\n\n\n\n<p>Yours, 💕<br /><em>Birgit</em></p>\n\n\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/gutenberg-18-0-playground-pattern-and-form-plugins-and-so-much-more-weekend-edition-289/#0-word-press-release-information\">Developing Gutenberg and WordPress</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/gutenberg-18-0-playground-pattern-and-form-plugins-and-so-much-more-weekend-edition-289/#upcoming-events\">Upcoming events</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/gutenberg-18-0-playground-pattern-and-form-plugins-and-so-much-more-weekend-edition-289/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/gutenberg-18-0-playground-pattern-and-form-plugins-and-so-much-more-weekend-edition-289/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/gutenberg-18-0-playground-pattern-and-form-plugins-and-so-much-more-weekend-edition-289/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor.</a></li></ol>\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p>This week we expected WordPress 6.5 to land. After further deliberation evaluating late bug fixes, the release team <a href=\"https://make.wordpress.org/core/2024/03/25/wordpress-6-5-release-delayed-1-week/\">decided to move the release date</a> until after Easter and so committers have enough time to review the code and add some testing. The <a href=\"https://wordpress.org/news/2024/03/wordpress-6-5-release-candidate-4/\"><strong>WordPress 6.5 Release Candidate </strong></a>4 is now available for testing. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Gutenberg 18.0 plugin version was released. You can read everything about it in the release post <a href=\"https://make.wordpress.org/core/2024/03/27/whats-new-in-gutenberg-18-0-27-march/\"><strong>What’s new in Gutenberg 18.0? (27 March)</strong></a>. As highlight, I pointed out: the newly added sitewide color and typography presets you find in <strong>Site Editor &gt; Styles</strong> section, you can now use the feature image in a Media + Text block and features images now have support for drop shadows. Furthermore, the Grid layout experiments showed some great progress </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Core Contributor, <strong>Maggie Cabrera</strong> and I chatted about the updates in Gutenberg 18.0, the Community Theme project and the Contributor mentorship program in our recording of the 98th Gutenberg changelog episode. As always, it will arrive at your favorite podcast app over the weekend. </p>\n\n\n\n<a href=\"https://gutenbergtimes.com/podcast/\"><img width=\"652\" height=\"187\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/03/Screenshot-2024-03-29-at-15.25.06.png?resize=652%2C187&ssl=1\" alt=\"Maggie Cabrera and Birgit Pauli-Haack recording Gutenberg changelog episode 98. \" class=\"wp-image-28062\" /></a>\n\n\n\n<p class=\"has-accent-color has-light-background-background-color has-text-color has-background has-link-color wp-elements-b6fe42ed62408b6fe464d62777dc0282\">🎙️ Latest episode: <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-98/\">Gutenberg Changelog #98 – WordPress 6.5, Gutenberg 18.0 Community Theme Project and the Contributor Mentorship Program</a> with special guest Maggie Cabrera</p>\n\n\n\n<p>If you haven’t yet, you can subscribe to any of these services and apps:<br /><a href=\"https://podcasts.apple.com/us/podcast/gutenberg-changelog/id1469294475\" target=\"_blank\" rel=\"noreferrer noopener\">Apple Podcasts</a>&nbsp;|&nbsp;<a href=\"https://castbox.fm/channel/Gutenberg-Changelog-id2173375\" target=\"_blank\" rel=\"noreferrer noopener\">CastBox</a>&nbsp;|&nbsp;<a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9ndXRlbmJlcmd0aW1lcy5jb20vZmVlZC9wb2RjYXN0\" target=\"_blank\" rel=\"noreferrer noopener\">Google&nbsp;</a>|&nbsp;<a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9ndXRlbmJlcmd0aW1lcy5jb20vZmVlZC9wb2RjYXN0\" target=\"_blank\" rel=\"noreferrer noopener\">Podcasts</a>&nbsp;|&nbsp;<a href=\"https://pca.st/7O43\" target=\"_blank\" rel=\"noreferrer noopener\">PocketCasts</a>&nbsp;|&nbsp;&nbsp;<a href=\"https://www.podbean.com/podcast-detail/chi7j-9904a/Gutenberg-Changelog-Podcast\" target=\"_blank\" rel=\"noreferrer noopener\">Podbean</a>&nbsp;&nbsp;<br /><a href=\"https://www.podchaser.com/podcasts/gutenberg-changelog-878239/\" target=\"_blank\" rel=\"noreferrer noopener\">Podchaser</a>&nbsp;|&nbsp;<a href=\"https://gutenbergtimes.com/feed/podcast/\" target=\"_blank\" rel=\"noreferrer noopener\">RSS</a>&nbsp;|&nbsp;<a href=\"https://open.spotify.com/show/620NwVKQJGdTupy36zYxvg\">Spotify</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his latest, <a href=\"https://make.wordpress.org/design/2024/03/25/design-share-mar-11-mar-22/\"><strong>Design Share: Mar 11-Mar 22</strong></a>, <strong>Joen Asmussen</strong> lists the work of the WordPress Design Team. In this post, you  also find the links of design resources for WordPress Figma and GitHub spaces in one place. Asmussen shared about the progress of the Grid layout work, Template vs. page content refinements, Template part and proximity selection, color generation and an 18-minute video with Admin updates with Saxon Fletcher. </p>\n\n\n\n<p>In addition, </p>\n\n\n\n<ul>\n<li>progress on synced pattern overrides, a feature that didn&#8217;t make into WordPress 6.5, </li>\n\n\n\n<li>contentOnly improvements</li>\n\n\n\n<li>Top bar organization exploration</li>\n\n\n\n<li>Save &amp; publish</li>\n\n\n\n<li>Openverse dark mode</li>\n\n\n\n<li>Blocks page v2 (<a href=\"https://wordpress.org/blocks/\">https://wordpress.org/blocks</a>)</li>\n</ul>\n\n\n\n<img width=\"652\" height=\"348\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/03/Screenshot-2024-03-29-at-11.39.03.png?resize=652%2C348&ssl=1\" alt=\"Design explorations for Block page version 2\" class=\"wp-image-28041\" />\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Data-liberation</strong> initiative invites developers and product owners to a <a href=\"https://make.wordpress.org/core/2024/03/26/hallway-hangout-data-liberation-discussion-and-brainstorm/\">Hallway Hangout: Data Liberation Discussion and Brainstorm</a> on April 3 at 7 PM UTC don’t worry if you miss it, there will likely be a recording. The topics that might come up are around&nbsp;</p>\n\n\n\n<ul>\n<li>Challenges of migrating from third-party platforms to WordPress</li>\n\n\n\n<li>The good, bad, and ugly of exporting WordPress content</li>\n\n\n\n<li>The potential of interoperability between Block libraries and page builders</li>\n\n\n\n<li>What work will make data liberation, and who should work on it</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"upcoming-events\">Upcoming events</h3>\n\n\n\n<p>April 2, 2024 14:00 UTC <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/300076015/\"><strong>WordPress developer live stream: Testing WP Playground</strong></a> Jonathan Bossenger will  dive deeply into WordPress Playground and all its different permutations, to see what they are capable of, and whether he could replace his custom local development environment with a version of WordPress Playground.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Learn.WordPress and&nbsp;<strong>Bud Kraus</strong>&nbsp;will present “<a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/299175971/\"><strong>What’s New In WordPress 6.5?</strong></a>” via Zoom on&nbsp;<strong>Tuesday, April 9 at 19:00 UTC</strong>*. He will demonstrate the new features coming to WordPress 6.5, such as Font Management Revisions for Styles and templates, and the new data view screens coming to the Site Editor.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Also, <strong>April 9, 2024, at 14:00 UTC</strong>*<sup class=\"fn\"><a href=\"https://gutenbergtimes.com/feed/#77c4b891-cd4b-4ec6-a2cb-9c14f0b34849\" id=\"77c4b891-cd4b-4ec6-a2cb-9c14f0b34849-link\">1</a></sup>, <strong>Nick Diego</strong> and <strong>Damon Cook</strong> invite you to the next <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/300032710/\"><strong>Developer Hours: Building custom blocks with the Interactivity API</strong>. </a><strong>Damon Cook</strong> from WP Engine will demonstrate how he built a form submission block that leverages the API. This example will teach you how to kick-start a custom interactive block using the Create Block package, use directives to assign critical attributes to your HTML markup, create the store, and hook up the client-side JavaScript.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p>If you are looking for a block-based way to create form, <a href=\"https://twitter.com/MatzeKitt\"><strong>Matthias Kittsteiner</strong></a> has the solution as the <a href=\"https://wordpress.org/plugins/form-block/\"><strong>Form Block</strong></a> plugin. It comes with a Form creation Wizard, you can use unlimited fields and various field types, comes with honeypot implementation, client and server-side validation and built on consent check.  A pro-version is also available at <a href=\"https://formblock.pro/en/.\">Form Block Pro</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><b>Yay Commerce</b>, a long-time WooCommerce extender company,  just published a set of blocks as <strong><a href=\"https://wordpress.org/plugins/brandy-blocks/\">Brandy Blocks</a></strong> in the WordPress Repository, primarily a testimonial block and a 3-column pricing table block. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/RafalTomal\">Rafal Tomal</a></strong> reflected in his post <a href=\"https://rafaltomal.com/why-wordpress/\"><strong>Why I’m Excited About WordPress Again</strong></a> on his journey to Webflow as a site building tool and back and his experience with the Site editor and building the new premium block theme <a href=\"https://rockbase.co/get-rockbase/\">Rockbase.</a> &#8220;The full site editor aligns with the contemporary approach to web design, moving away from viewing websites as static, brochure-like pages. Instead, websites are envisioned as dynamic design systems, and the modern WordPress theme embodies this system.&#8221; Tomal wrote. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>David Artiss</strong>, customer success lead for WordPress VIP,  is using the new Footnotes block and migrated earlier content. And he shared how he did it:  <a href=\"https://artiss.blog/2024/03/adding-footnotes-in-the-wordpress-block-editor/\"><strong>Adding Footnotes in the WordPress block editor</strong></a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p>Theme shop <strong>Blockify </strong>released a <a href=\"https://wordpress.org/plugins/pattern-editor/\"><strong>Pattern Manager</strong></a> in the WordPress plugin repository. It helps &#8220;you create and edit patterns for WordPress block themes. It automatically exports patterns on save as PHP files to the active themes&nbsp;<code>patterns</code>&nbsp;directory.&#8221; </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In the <a href=\"https://wordpress.slack.com/archives/C015GUFFC00\">#outreach channel</a>, Anne McCarthy posted a question for theme developer and users: </p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p><strong><img src=\"https://i0.wp.com/a.slack-edge.com/production-standard-emoji-assets/14.0/apple-medium/1f914.png?w=652&ssl=1\" alt=\":thinking_face:\" />&nbsp;Share your thoughts on what the block theme tag should be in the theme repo&nbsp;<img src=\"https://i0.wp.com/a.slack-edge.com/production-standard-emoji-assets/14.0/apple-medium/1f914.png?w=652&ssl=1\" alt=\":thinking_face:\" /></strong></p>\n\n\n\n<p>In this trac issue&nbsp;<a href=\"https://meta.trac.wordpress.org/ticket/7524\" target=\"_blank\" rel=\"noreferrer noopener\">https://meta.trac.wordpress.org/ticket/7524</a>&nbsp;, it’s proposed to update the&nbsp;&nbsp;<code>full site editing</code>&nbsp;tag for block themes. What makes the most sense to you all to include? If folks can take some time to chime in, I’d appreciate it. I flagged twice now for&nbsp;<a href=\"https://wordpress.slack.com/archives/C02RP4VMP\" target=\"_blank\" rel=\"noreferrer noopener\">#core-themes</a>, and I am hoping to get more voices in the mix.</p>\n<cite>Anne McCarty #outreach </cite></blockquote>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Via the <a href=\"https://wordpress.slack.com/archives/C015GUFFC00\">WP Slack #outreach channel</a>, theme builders were invited to discuss their workflows and their challenges in a Hallway Hangout. Here the <a href=\"https://make.wordpress.org/core/2024/03/29/recap-hallway-hangout-using-site-editor-in-production-for-client-sites/\"><strong>Recap Hallway Hangout: Using Site editor in production for client sites</strong></a>. Hot topics, Navigation Block, Theme.json editor and the implementation of patterns, templates and Global styles between database and file system. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his blog post, <a href=\"https://rich.blog/composing-with-patterns/\"><strong>Composing with Patterns, </strong></a> Rich Tabor how <strong>patterns</strong> are pre-made designs that you can add to your website&#8217;s posts and pages. He explains that patterns make it quicker to build nice-looking pages. They also help keep the look of the website the same all over, which is good for people visiting your site. Rich thinks that as people use patterns more and tell WordPress what they like, patterns will get even better and make WordPress easier to use.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2024&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The previous years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a>&nbsp;|&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong>&nbsp;|&nbsp;<strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong>&nbsp;|&nbsp;<strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor.</h2>\n\n\n\n<p><strong>Bernie Reiter</strong> and <strong>Nick Diego</strong> took participants of the Developer Hours on the journey  <a href=\"https://www.youtube.com/watch?v=ezPHiyhhaoQ\"><strong>exploring Block Hooks in WordPress 6.5</strong></a>. In addition to covering the basics, they looked at practical examples that you can implement in your projects.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Brian Coords</strong> shows you in his latest video on YouTube how he uses <a href=\"https://www.youtube.com/watch?v=qD5U7TNUKTQ\"><strong>Block Variations with the Block Bindings API</strong></a> and how you can offer a &#8220;no-code&#8221; experience for your users with Block Variations. Coords share <a href=\"https://github.com/bacoords/example-block-variation\">his code via GitHub</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his latest live stream, <strong>Ryan Welcher</strong> explored <a href=\"https://www.youtube.com/watch?v=EZnZQa_wjME\"><strong>Using Playground to preview plugins</strong></a>, and building a blueprint to show off some features of his  <a href=\"https://wordpress.org/plugins/advanced-query-loop/\">Advanced Query Loop plugin.</a> He walks through the process of how to set up a blueprint for the WordPress plugin repository, and then how to create demo content and integrate them into a blueprint as well.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Jonathan Bossenger</strong> explains the difference between <strong><a href=\"https://wordpress.tv/2024/03/28/static-vs-dynamic-blocks/\">Static and Dynamic Blocks</a>,</strong> for the series of Introduction to Block development. In this video, Bossenger looks at what the difference is between static and dynamic blocks, how to determine which is right for your needs, and the different approaches for development. </p>\n\n\n\n<p>If you rather learn by reading than by watching, <strong>Joni Halabi</strong>, published an article covering a similar topic: <a href=\"https://developer.wordpress.org/news/2023/02/27/static-vs-dynamic-blocks-whats-the-difference/\"><strong>Static vs. dynamic blocks: What’s the difference?</strong></a> on the WordPress Developer Blog. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>🗞️ Speaking of Developer Blog: This week saw three new articles published; </p>\n\n\n\n<p><a href=\"https://developer.wordpress.org/news/2024/03/25/exploring-the-block-hooks-api-in-wordpress-6-5/\"><strong>Exploring the Block Hooks API in WordPress 6.5</strong></a> by <strong>Nick Diego.</strong> The Block Hooks API is an extensibility mechanism that allows you to dynamically insert blocks into block themes. Learn how to use the API in your projects in this comprehensive overview.</p>\n\n\n\n<p><a href=\"https://developer.wordpress.org/news/2024/03/26/how-to-use-wordpress-react-components-for-plugin-pages/\"><strong>How to use WordPress React components for plugin pages</strong></a> by <strong>Robert Mészáros</strong>. Learn how to create a settings page with multiple controls using WordPress React components for a plugin that displays an announcement bar on the front end.</p>\n\n\n\n<p><a href=\"https://developer.wordpress.org/news/2024/03/28/how-to-work-effectively-with-the-useselect-hook/\"><strong>How to work effectively with the useSelect hook</strong></a> by <strong>Jarda Snajdr</strong>. This article is about the useSelect React hook from the @wordpress/data library. It offers several tips and tricks on how to use it in the most efficient way possible, and answers many subtle questions about how it really works.</p>\n\n\n\n<p><em>If you don&#8217;t want to miss any new posts on the Developer blog, head on over there and <a href=\"https://developer.wordpress.org/news/subscribe/\">subscribe via email</a>. </em></p>\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review.</p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n\n\n\n<p><img src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" alt=\"GitHub all releases\" /></p>\n\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Featured Image: Scooters at the Festival of Lights, Taipei, Taiwan by Birgit Pauli-Haack</p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n<ol class=\"wp-block-footnotes\"><li id=\"77c4b891-cd4b-4ec6-a2cb-9c14f0b34849\"> <a href=\"https://gutenbergtimes.com/feed/#77c4b891-cd4b-4ec6-a2cb-9c14f0b34849-link\">↩︎</a></li></ol>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 30 Mar 2024 07:59:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"HeroPress: Jouralism, 5000 Theme Reviews, WordCamp Europe and more!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://heropress.com/?p=6624\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:173:\"https://heropress.com/jouralism-5000-theme-reviews-wordcamp-europe-and-more/#utm_source=rss&utm_medium=rss&utm_campaign=jouralism-5000-theme-reviews-wordcamp-europe-and-more\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14741:\"<img width=\"1024\" height=\"683\" src=\"https://heropress.com/wp-content/uploads/2024/03/5665f5e9afc734c8.12871696-1024x683.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Front view of a Boeing 737-8AS airplane taking off from an airport runway, viewed from the perspective of the airport with a fence in the foreground and a hilly landscape with buildings in the background.\" /><div class=\"kb-row-layout-wrap kb-row-layout-id6624_9229b7-a3 alignnone wp-block-kadence-rowlayout\"><div class=\"kt-row-column-wrap kt-has-1-columns kt-row-layout-equal kt-tab-layout-inherit kt-mobile-layout-row kt-row-valign-top\">\n\n<div class=\"wp-block-kadence-column kadence-column6624_1c0628-36\"><div class=\"kt-inside-inner-col\">\n<p>Once again some extra stuff outside the normal HeroPress fare!</p>\n</div></div>\n\n</div></div>\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-6624_231904-31\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n<div class=\"kb-row-layout-wrap kb-row-layout-id6624_b0f88b-90 alignnone kt-row-has-bg wp-block-kadence-rowlayout\"><div class=\"kt-row-column-wrap kt-has-1-columns kt-row-layout-equal kt-tab-layout-inherit kt-mobile-layout-row kt-row-valign-top kb-theme-content-width\">\n\n<div class=\"wp-block-kadence-column kadence-column6624_08fcd7-bc inner-column-1\"><div class=\"kt-inside-inner-col\">\n<h2 class=\"kt-adv-heading6624_b11492-92 wp-block-kadence-advancedheading\"><a href=\"https://heropress.com/\">HeroPress.com</a> &#8211; <a href=\"https://heropress.com/essays/words-to-wordpress-the-uncharted-path-of-syed-laden/\">Words to WordPress: The Uncharted Path of Syed Laden</a></h2>\n\n\n\n\n<div class=\"wp-block-image is-style-default\">\n<a href=\"https://heropress.com/essays/words-to-wordpress-the-uncharted-path-of-syed-laden/\"><img width=\"300\" height=\"300\" src=\"https://heropress.com/wp-content/uploads/2024/03/1052441B-31C7-4153-94F9-227FF564B1E1-Photoroom.png-Photoroom-300x300.webp\" alt=\"\" class=\"wp-image-6608\" /></a></div>\n\n\n<p>Syed Laden didn&#8217;t set out to be &#8220;into&#8221; technology, being a journalist. But when the right tool came along, he fell in love. </p>\n\n\n\n<p><em>My mission is simple: to bridge the gap between tech savviness and digital expression. WordPress is for everyone, and I’m here to prove it.</em></p>\n\n\n\n<p>Syed&#8217;s essay is <a href=\"https://heropress.com/essays/words-to-wordpress-the-uncharted-path-of-syed-laden/\">available</a> on <a href=\"https://heropress.com\">HeroPress.com</a>.</p>\n</div></div>\n\n</div></div>\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-6624_ae33f6-6d\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n<div class=\"kb-row-layout-wrap kb-row-layout-id6624_2a0ab9-e1 alignnone kt-row-has-bg wp-block-kadence-rowlayout\"><div class=\"kt-row-column-wrap kt-has-1-columns kt-row-layout-equal kt-tab-layout-inherit kt-mobile-layout-row kt-row-valign-top kb-theme-content-width\">\n\n<div class=\"wp-block-kadence-column kadence-column6624_e1f421-53 inner-column-1\"><div class=\"kt-inside-inner-col\">\n<img width=\"1024\" height=\"390\" src=\"https://heropress.com/wp-content/uploads/2024/03/Badge-Facebook-cover-We-are-Media-Partners-1024x390.png\" alt=\"We\'re Media Partners!\" class=\"kb-img wp-image-6631\" />\n\n\n\n<div class=\"wp-block-kadence-image kb-image6624_931128-a3\"><a href=\"https://heropress.com/wp-content/uploads/2024/03/Vespa-Piaggio-Wapuu.png\" class=\"kb-advanced-image-link\"><img width=\"300\" height=\"220\" src=\"https://heropress.com/wp-content/uploads/2024/03/Vespa-Piaggio-Wapuu-300x220.png\" alt=\"\" class=\"kb-img wp-image-6632\" /></a></div>\n\n\n\n<p>That&#8217;s right, HeroPress is once again a WordCamp Europe Media Partner AND I&#8217;m going to attend!</p>\n\n\n\n<p>I plan to interview people while I&#8217;m there, so please come say hi to me.  If you don&#8217;t want to be interviewed, please come say hi to me and I won&#8217;t ask you any questions.  :)</p>\n</div></div>\n\n</div></div>\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-6624_3c0336-b9\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n<div class=\"kb-row-layout-wrap kb-row-layout-id6624_885731-7c alignnone kt-row-has-bg wp-block-kadence-rowlayout\"><div class=\"kt-row-column-wrap kt-has-1-columns kt-row-layout-equal kt-tab-layout-inherit kt-mobile-layout-row kt-row-valign-top kb-theme-content-width\">\n\n<div class=\"wp-block-kadence-column kadence-column6624_d22a24-27 inner-column-1\"><div class=\"kt-inside-inner-col\">\n<a href=\"https://kafleg.com.np/5k-wordpress-themes-reviewed/\" class=\"kb-advanced-image-link\"><img width=\"834\" height=\"417\" src=\"https://heropress.com/wp-content/uploads/2024/03/theme_reviews_number.jpg\" alt=\"\" class=\"kb-img wp-image-6629\" /></a>\n\n\n\n<p>The other day HeroPresser Ganga Kafle wrote to me from Nepal to let me know he recently finished his 5000th theme review! He did a great <a href=\"https://kafleg.com.np/5k-wordpress-themes-reviewed/\">blog post</a> about how he got started and who mentored him.  Coincidentally, most of them were HeroPressers!</p>\n</div></div>\n\n</div></div>\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-6624_21c670-e7\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n<div class=\"kb-row-layout-wrap kb-row-layout-id6624_2fd581-cb alignnone kt-row-has-bg wp-block-kadence-rowlayout\"><div class=\"kt-row-column-wrap kt-has-1-columns kt-row-layout-equal kt-tab-layout-inherit kt-mobile-layout-row kt-row-valign-top kb-theme-content-width\">\n\n<div class=\"wp-block-kadence-column kadence-column6624_735a1d-7c inner-column-1\"><div class=\"kt-inside-inner-col\">\n<h2 class=\"kt-adv-heading6624_c246c6-42 wp-block-kadence-advancedheading\"><a href=\"https://hallwaychats.com\">WPPhotos.Info</a></h2>\n\n\n\n\n<div class=\"wp-block-image\">\n<a href=\"https://wpphotos.info/close-up-percussion-instruments/\"><img width=\"300\" height=\"200\" src=\"https://heropress.com/wp-content/uploads/2024/03/79965f5f3b9e5c6b3.44956242-scaled-1-300x200.jpg\" alt=\"A close-up of percussion instruments, prominently featuring a tambourine placed on top of a Deagan xylophone, with drumsticks resting on a music stand and a cymbal in the background.\" class=\"wp-image-6630\" /></a></div>\n\n\n<p>Nice close-up taken by <a href=\"https://wordpress.org/photos/author/roytanck/\">Roy Tanck</a>. Here a short story:</p>\n\n\n\n<p>“This picture was taken at the National Military Museum in Soesterberg, NL. I was actually there to photograph their collection of tanks and fighter jets. They have several jets, including an F16, suspended from the ceiling. But when I was there they were also hosting the “Night of the Military Music”, a two-day music event. These instruments were set up to be used later in the day.”</p>\n\n\n\n<p><a href=\"https://wpphotos.info/close-up-percussion-instruments/\">Read more of the story at WPPhotos.info!</a></p>\n</div></div>\n\n</div></div>\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-6624_333b50-2b\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n<div class=\"kb-row-layout-wrap kb-row-layout-id6624_4639ae-64 alignnone kt-row-has-bg wp-block-kadence-rowlayout\"><div class=\"kt-row-column-wrap kt-has-1-columns kt-row-layout-equal kt-tab-layout-inherit kt-mobile-layout-row kt-row-valign-top kb-theme-content-width\">\n\n<div class=\"wp-block-kadence-column kadence-column6624_bd0131-52 inner-column-1\"><div class=\"kt-inside-inner-col\">\n<h2 class=\"kt-adv-heading6624_aad73c-cc wp-block-kadence-advancedheading\"><a href=\"https://wppodcasts.com\">WP Podcasts</a></h2>\n\n\n\n\n\n<a href=\"https://wppodcasts.com\"><img src=\"https://heropressnetwork.com/wp-content/uploads/2024/01/pocket_casts_single_315.png\" alt=\"Pocket Casts image\" class=\"wp-image-4316\" /></a>\n\n\n\n<p>There were <em>twenty-two</em> WordPress podcast episodes released this week!</p>\n\n\n\n<ul>\n<li><a href=\"https://underrepresented-in-tech-1.castos.com/episodes/invisible-disabilities-feat-caylin-white#new_tab\">Invisible Disabilities (feat. Caylin White)</a> from <a href=\"https://wppodcasts.com/podcast/underrepresented-in-tech/\">Underrepresented in Tech</a></li>\n\n\n\n<li><a href=\"https://remkusdevries.com/podcast/elevating-wordpress-education-insights-from-jonathan-bossenger/#new_tab\">Elevating WordPress Education: Insights from Jonathan Bossenger</a> from <a href=\"https://wppodcasts.com/podcast/within-wordpress/\">Within WordPress</a></li>\n\n\n\n<li><a href=\"https://unbilleteachattanooga.com/episodio-255/#new_tab\">Episodio 255: Review de WordCamp Torrelodones 2024</a> from <a href=\"https://wppodcasts.com/podcast/un-billete-a-chattanooga/\">Un billete a Chattanooga</a></li>\n\n\n\n<li><a href=\"https://www.wppodcast.fr/podcast/wordpress-media-corps/#new_tab\">19. WordPress Media Corps</a> from <a href=\"https://wppodcasts.com/podcast/wordpress-podcast-francais/\">WordPress Podcast (français)</a></li>\n\n\n\n<li><a href=\"http://www.ivoox.com/arte-hacer-preguntas-para-vender-con-audios-mp3_rf_126432063_1.html#new_tab\">El Arte de hacer preguntas para vender. Con Jokin Fernández</a> from <a href=\"https://wppodcasts.com/podcast/club-wordpress-emprendedores-online/\">Club WordPress Emprendedores Online</a></li>\n</ul>\n\n\n\n<p>There are new episodes every single day, so be sure to stop by <a href=\"https://wppodcasts.com\">WPPodcasts.com</a> and search for things that interest you!</p>\n</div></div>\n\n</div></div>\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-6624_98fe15-27\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n<div class=\"kb-row-layout-wrap kb-row-layout-id6624_40f699-80 alignnone kt-row-has-bg wp-block-kadence-rowlayout\"><div class=\"kt-row-column-wrap kt-has-1-columns kt-row-layout-equal kt-tab-layout-inherit kt-mobile-layout-row kt-row-valign-top kb-theme-content-width\">\n\n<div class=\"wp-block-kadence-column kadence-column6624_bdd9ba-8a inner-column-1\"><div class=\"kt-inside-inner-col\">\n<h2 id=\"wpphotos\" class=\"kt-adv-heading6624_d578e6-b7 wp-block-kadence-advancedheading\"><a href=\"https://wordpress.org/photos\">WP Photos</a></h2>\n\n\n\n<p>Here are some of the great photos submitted to the <a href=\"https://wordpress.org/photos\">WPPhotos</a> project this week!</p>\n\n\n\n\n<a href=\"https://heropress.com/wp-content/uploads/2024/03/53165ff07eaf28c20.83046093-scaled.jpg\"><img width=\"683\" height=\"1024\" src=\"https://heropress.com/wp-content/uploads/2024/03/53165ff07eaf28c20.83046093-683x1024.jpg\" alt=\"Looking back through a side mirror of a car reveals a row of cherry blossom trees in bloom on a neighborhood street lined with cars. The camera taking the photo is barely in view in the side mirror.\" class=\"wp-image-6637\" /></a><a href=\"https://creativecommons.org/share-your-work/public-domain/cc0/\">CC0</a> licensed <a href=\"https://wordpress.org/photos/photo/53165ff07e/\">photo</a> by <a href=\"https://wordpress.org/photos/author/annezazu/\">annezazu</a> from the <a href=\"https://wordpress.org/photos/\">WordPress Photo Directory</a>.\n\n\n\n<a href=\"https://heropress.com/wp-content/uploads/2024/03/69565fa4461789ba5.31742062-scaled.jpg\"><img width=\"768\" height=\"1024\" src=\"https://heropress.com/wp-content/uploads/2024/03/69565fa4461789ba5.31742062-768x1024.jpg\" alt=\"a mayfly on a glass surface, reflected symmetrically.\" class=\"wp-image-6638\" /></a><a href=\"https://creativecommons.org/share-your-work/public-domain/cc0/\">CC0</a> licensed <a href=\"https://wordpress.org/photos/photo/69565fa446/\">photo</a> by <a href=\"https://wordpress.org/photos/author/ajithrn/\">Ajith R N</a> from the <a href=\"https://wordpress.org/photos/\">WordPress Photo Directory</a>.\n\n\n\n<a href=\"https://heropress.com/wp-content/uploads/2024/03/85665fee10fb74437.27225028-scaled.jpeg\"><img width=\"1024\" height=\"768\" src=\"https://heropress.com/wp-content/uploads/2024/03/85665fee10fb74437.27225028-1024x768.jpeg\" alt=\"A street dog is sleeping under the evening sun. From Pantheerankav, Kozhikode, Kerala.\" class=\"wp-image-6639\" /></a><a href=\"https://creativecommons.org/share-your-work/public-domain/cc0/\">CC0</a> licensed <a href=\"https://wordpress.org/photos/photo/85665fee10/\">photo</a> by <a href=\"https://wordpress.org/photos/author/mbigul/\">Bigul Malayi</a> from the <a href=\"https://wordpress.org/photos/\">WordPress Photo Directory</a>.\n\n\n\n<a href=\"https://heropress.com/wp-content/uploads/2024/03/90065fe1e37c05ab7.12425413-scaled.jpg\"><img width=\"1024\" height=\"683\" src=\"https://heropress.com/wp-content/uploads/2024/03/90065fe1e37c05ab7.12425413-1024x683.jpg\" alt=\"A brown rabbit sitting on gravel near a metal gate with plants visible in the background.\" class=\"wp-image-6640\" /></a><a href=\"https://creativecommons.org/share-your-work/public-domain/cc0/\">CC0</a> licensed <a href=\"https://wordpress.org/photos/photo/90065fe1e3/\">photo</a> by <a href=\"https://wordpress.org/photos/author/nilovelez/\">Nilo Velez</a> from the <a href=\"https://wordpress.org/photos/\">WordPress Photo Directory</a>.\n\n\n\n<a href=\"https://heropress.com/wp-content/uploads/2024/03/2516602bb29c08da0.74950620-scaled.jpg\"><img width=\"1024\" height=\"768\" src=\"https://heropress.com/wp-content/uploads/2024/03/2516602bb29c08da0.74950620-1024x768.jpg\" alt=\"A Bengal tiger lying on the grass. It has a rich orange fur coat with black stripes, and its front paws are extended forward.\" class=\"wp-image-6641\" /></a><a href=\"https://creativecommons.org/share-your-work/public-domain/cc0/\">CC0</a> licensed <a href=\"https://wordpress.org/photos/photo/2516602bb2/\">photo</a> by <a href=\"https://wordpress.org/photos/author/neusitas/\">neusitas</a> from the <a href=\"https://wordpress.org/photos/\">WordPress Photo Directory</a>.\n\n\n\n<a href=\"https://heropress.com/wp-content/uploads/2024/03/3746602d32f248af1.64336328-scaled.jpg\"><img width=\"1024\" height=\"684\" src=\"https://heropress.com/wp-content/uploads/2024/03/3746602d32f248af1.64336328-1024x684.jpg\" alt=\"Close-up of a forsythia leaf shoot. Light green leaves on a dark background.\" class=\"wp-image-6642\" /></a><a href=\"https://creativecommons.org/share-your-work/public-domain/cc0/\">CC0</a> licensed <a href=\"https://wordpress.org/photos/photo/3746602d32/\">photo</a> by <a href=\"https://wordpress.org/photos/author/werkform/\">werkform</a> from the <a href=\"https://wordpress.org/photos/\">WordPress Photo Directory</a>.\n\n\n\n\n<p>Be sure to check out the <a href=\"https://wordpress.org/photos/\">hundreds of other great photos</a>!</p>\n</div></div>\n\n</div></div><p>The post <a href=\"https://heropress.com/jouralism-5000-theme-reviews-wordcamp-europe-and-more/\">Jouralism, 5000 Theme Reviews, WordCamp Europe and more!</a> appeared first on <a href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 29 Mar 2024 08:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WordPress.org blog: WordPress 6.5 Release Candidate 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=17136\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2024/03/wordpress-6-5-release-candidate-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6552:\"<p>The latest release candidate (RC4) for WordPress 6.5 is ready!&nbsp;</p>\n\n\n\n<p>This release candidate is an addition to the existing WordPress 6.5 release cycle. It allows more time for testing to ensure every feature and improvement is in the best shape possible.&nbsp;</p>\n\n\n\n<p>The updated target for the WordPress 6.5 release is <strong>April 2, 2024</strong>. Get an overview of the <a href=\"https://make.wordpress.org/core/6-5/\">6.5 release cycle</a>, and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-5/\">6.5-related posts</a> for further details.&nbsp;If you’re looking for more detailed technical notes on new features and improvements, the <a href=\"https://make.wordpress.org/core/2024/03/15/wordpress-6-5-field-guide/\">WordPress 6.5 Field Guide</a> is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What to expect in WordPress 6.5 RC4</h2>\n\n\n\n<p>There’s been a lot of helpful feedback regarding one of this release’s highlighted features: the Font Library. This has resulted in some <a href=\"https://make.wordpress.org/core/2024/03/25/wordpress-6-5-release-delayed-1-week/\">additional improvements needed</a> to make sure the greatest number of sites possible can benefit from this anticipated new feature.&nbsp;</p>\n\n\n\n<p>This release also includes six<strong> </strong>bug fixes for the Editor and 10+ <a href=\"https://core.trac.wordpress.org/query?status=closed&changetime=03%2F13%2F2024..03%2F19%2F2024&resolution=fixed&milestone=6.5&col=id&col=summary&col=milestone&col=owner&col=type&col=priority&order=id\">tickets for WordPress Core</a>. For more technical information related to issues addressed since RC3, you can browse the following links: </p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.5?since=2024-03-20&until=2024-03-28\">GitHub commits for 6.5</a>&nbsp;</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&changetime=03%2F20%2F2024..03%2F28%2F2024&resolution=fixed&milestone=6.5&col=id&col=summary&col=milestone&col=owner&col=type&col=priority&order=id\">Closed </a><a href=\"https://core.trac.wordpress.org/query?status=closed&changetime=03%2F13%2F2024..03%2F19%2F2024&resolution=fixed&milestone=6.5&col=id&col=summary&col=milestone&col=owner&col=type&col=priority&order=id\">Trac</a><a href=\"https://core.trac.wordpress.org/query?status=closed&changetime=03%2F20%2F2024..03%2F28%2F2024&resolution=fixed&milestone=6.5&col=id&col=summary&col=milestone&col=owner&col=type&col=priority&order=id\"> tickets</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">How to test</h2>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>.<strong> Please do not install, run, or test this version of WordPress on production or mission-critical websites.</strong> Instead, it’s recommended that you evaluate RC4 on a test server and site.</p>\n\n\n\n<p>While release candidates are considered ready for release, testing remains crucial to ensure that everything in WordPress 6.5 is the best it can be.</p>\n\n\n\n<p>You can test WordPress 6.5 RC4 in four ways:</p>\n\n\n\n<table><tbody><tr><th>Plugin</th><td>Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream).</td></tr><tr><th>Direct Download</th><td>Download the <a href=\"https://wordpress.org/wordpress-6.5-RC4.zip\">RC4 version (zip)</a> and install it on a WordPress website.</td></tr><tr><th>Command Line</th><td>Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command:<br /><code>wp core update --version=6.5-RC</code>4</td></tr><tr><th>WordPress Playground</th><td>Use the <a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20[%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20]%20%7D\">6.5 RC4 WordPress Playground instance</a> (available within 35 minutes after the release is ready) to test the software directly in your browser without the need for a separate site or setup.</td></tr></tbody></table>\n\n\n\n<h2 class=\"wp-block-heading\">Here comes the haiku</h2>\n\n\n\n<p>With some extra time<br />Test, rinse, repeat, and refresh<br />WordPress will really shine</p>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post: <a href=\"https://profiles.wordpress.org/dansoschin/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>dansoschin</a>.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 16:34:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Lauren Stein\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Gravatar: New Gravatar Profile Features: Make It Yours\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=1223\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://blog.gravatar.com/2024/03/28/new-gravatar-profile-features-make-it-yours/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2701:\"<p class=\"has-medium-font-size\"><em>Gravatar Profiles are the newest, yet original, link in bio.</em></p>\n\n\n\n<p>Gravatar provided you a free profile page and home on the web long before all the Instagram influencers made it a thing. </p>\n\n\n\n<p>But we heard you. Your Gravatar profile page has always been a little too cookie-cutter. Now, you can customize it with fresh features that let you stand out online. </p>\n\n\n\n<p>Let&#8217;s dive in.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Your Links, Your Order</h2>\n\n\n\n<img width=\"660\" height=\"495\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/03/image-13.png?w=660\" alt=\"\" class=\"wp-image-1227\" />\n\n\n\n<p>Rearrange your verified links. Today&#8217;s highlight upfront, tomorrow&#8217;s passion project next. Flexibility, finally.</p>\n\n\n\n<p>You can also now hide individual verified accounts, keeping the connection in your Gravatar Profile but not displaying it on your public profile page.</p>\n\n\n\n<p>To rearrange, click the small button with 3 dots in the <em>Verified Accounts</em> menu.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Color Your Profile</h2>\n\n\n\n<img width=\"660\" height=\"495\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/03/image-16.png?w=660\" alt=\"\" class=\"wp-image-1238\" />\n\n\n\n<p>New background colors and overlays are here. Minimalist? Vibrant? It&#8217;s your call—your Gravatar, your palette.</p>\n\n\n\n<p>Buttons and links also get a color update. They used to always be blue, but now you can match them to your mood, your style, or your brand. It&#8217;s all in your hands.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Unique URL</h2>\n\n\n\n<img width=\"660\" height=\"495\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/03/image-15.png?w=660\" alt=\"\" class=\"wp-image-1239\" />\n\n\n\n<p>You may not like the URL for your profile, or you may want something easier to remember and share. Well, now you can edit your URL. </p>\n\n\n\n<p>Look for the Change profile URL link in the bottom left-side menu when editing your profile. Please note that editing your URL will also change your WordPress.com username.</p>\n\n\n\n<p>Make it memorable, make it you. Stand out in the digital crowd and share your URL with the world. </p>\n\n\n\n<h2 class=\"wp-block-heading\">Why These Updates?</h2>\n\n\n\n<p>Gravatar is your web-wide passport. We&#8217;re just making it more you. More control, more customization, more ways to express who you are.</p>\n\n\n\n<p>Jump into your <a href=\"https://gravatar.com/profile\">Gravatar account</a>. Play with the new settings. Rearrange, recolor, rename. Your digital identity awaits a makeover.</p>\n\n\n\n<p>We&#8217;re here for any questions. Welcome to the next level of personalizing your online presence. With more to come soon!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:34:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"Do The Woo Community: Welcome our Newest Sponsor Cloudways to the Woo ProductChat Show\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://dothewoo.io/welcome-our-newest-sponsor-cloudways-to-the-woo-productchat-show/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://dothewoo.io/welcome-our-newest-sponsor-cloudways-to-the-woo-productchat-show/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:123:\"<p>We welcome Cloudways, managed cloud hosting for WordPress and WooCommerce, as a sponsor of our Woo ProductChat show.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"Do The Woo Community: Database Optimization, Monitoring Tools, and Client Communication with Nenad Conić\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://dothewoo.io/database-optimization-monitoring-tools-and-client-communication-with-nenad-conic/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://dothewoo.io/database-optimization-monitoring-tools-and-client-communication-with-nenad-conic/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:142:\"<p>Nenad Conić from Maksimer gives tips on scaling WooCommerce, tools for optimizing the database for scalability in high traffic events.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"Do The Woo Community: The Path for Creating a Premium Plugin Extension with Maarten Belmans\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://dothewoo.io/the-path-for-creating-a-premium-plugin-extension-with-maarten-belmans/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://dothewoo.io/the-path-for-creating-a-premium-plugin-extension-with-maarten-belmans/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:139:\"<p>Great tips and insights for WordPress and WooCommerce builders who are creating a plugin that is an extension of an existing plugin.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"Do The Woo Community: Do the Woo is an Official Media Partner at CloudFest 2024\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://dothewoo.io/do-the-woo-is-an-official-media-partner-at-cloudfest-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://dothewoo.io/do-the-woo-is-an-official-media-partner-at-cloudfest-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"<p>Do the Woo will be covering both the hackathon and the conference during CloudFest 2024 at Europa-Park in Germany.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"Do The Woo Community: Woo Feature Request Board and WooCommerce Plugins for Sale\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://dothewoo.io/woo-feature-request-board-and-woocommerce-plugins-for-sale/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://dothewoo.io/woo-feature-request-board-and-woocommerce-plugins-for-sale/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:146:\"<p>In WooBits I amplify a hidden feature request board on Woo.com and 5 WooCommerce premium plugins for sale by our host Katie Keith at Barn2.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Do The Woo Community: The Importance of Product Testing in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://dothewoo.io/the-importance-of-product-testing-in-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://dothewoo.io/the-importance-of-product-testing-in-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"<p>WordPress contributors Pooja, Brian and Anand discuss how product testing is crucial and the learning process behind it. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"Do The Woo Community: Content Strategies for Woo and WordPress Businesses with Adam and Emma\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://dothewoo.io/content-strategies-for-woo-and-wordpress-businesses-with-adam-and-emma/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://dothewoo.io/content-strategies-for-woo-and-wordpress-businesses-with-adam-and-emma/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:144:\"<p>Adam and Emma talking about all things content when it comes to building brand recognition and trust for your Woo and WordPress business.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Do The Woo Community: More Takeaways from State of the Word with Miriam, Nik, Patricia and Mariano\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://dothewoo.io/more-takeaways-from-state-of-the-word-with-miriam-nik-patricia-and-mariano/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://dothewoo.io/more-takeaways-from-state-of-the-word-with-miriam-nik-patricia-and-mariano/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"<p>One more show with reflections and takeaways from State of the Word 2023.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"Do The Woo Community: AI, Accessibility, Security and Privacy in 2024 with Robbie and Robert\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://dothewoo.io/ai-accessibility-security-and-privacy-in-2024-with-robbie-and-robert/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://dothewoo.io/ai-accessibility-security-and-privacy-in-2024-with-robbie-and-robert/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:145:\"<p>Hosts Robbie Adair and Robert Jacobi discuss their predictions for 2024, focusing on the acronym ASP: Accessibility, Security, and Privacy</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"Do The Woo Community: Gutenberg, the Beginning to the Present with Tammie and Jonathan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://dothewoo.io/gutenberg-the-beginning-to-the-present-with-tammie-and-jonathan/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://dothewoo.io/gutenberg-the-beginning-to-the-present-with-tammie-and-jonathan/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"<p>Hosts Jonathan and Tammie reflect on their experiences with the Gutenberg project in WordPress. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"Do The Woo Community: The Future of SEO, Content and AI with Alex Moss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://dothewoo.io/the-future-of-seo-content-and-ai-with-alex-moss/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://dothewoo.io/the-future-of-seo-content-and-ai-with-alex-moss/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:128:\"<p>Discover how AI SEO and content creation impacts the future of WordPress and WooCommerce with Dave Lockie and Alex Moss. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"Do The Woo Community: Share Your Do the Woo Experience with a Guest Post on the BobWP Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://dothewoo.io/share-your-do-the-woo-experience-with-a-guest-post-on-the-bobwp-blog/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://dothewoo.io/share-your-do-the-woo-experience-with-a-guest-post-on-the-bobwp-blog/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"<p>If you have been a past sponsor, guest or guest host on our shows, consider a follow-up guest blog post on BobWP.com blog.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"Do The Woo Community: Do the Woo is a Sponsor and Media Partner for WordCamp Asia 2024\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://dothewoo.io/do-the-woo-is-a-sponsor-and-media-partner-for-wordcamp-asia-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://dothewoo.io/do-the-woo-is-a-sponsor-and-media-partner-for-wordcamp-asia-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"<p>We are returning to WordCamp Asia again, and proud to be a Media Partner again as well as a sponsor for the event.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"Do The Woo Community: Make. WordPress. Happy.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://dothewoo.io/make-wordpress-happy/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://dothewoo.io/make-wordpress-happy/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"<p>Starting 2024 on an optimistic note as I noticed more of my fellow WordPressers feeling more optimistic and happy about WordPress.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Do The Woo Community: Goodbye 2023 and Hello 2024\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://dothewoo.io/goodbye-2023-and-hello-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://dothewoo.io/goodbye-2023-and-hello-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"<p>As we look at the past year, and what 2024 holds, we are growing even more globally and elevating more voices. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"Do The Woo Community: A Post State of the Word Chat with Rocio Valdivia, Pooja Derashri &amp; José Ramón\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://dothewoo.io/a-post-state-of-the-word-chat-with-rocio-valdivia-pooja-derashri-jose-ramon/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://dothewoo.io/a-post-state-of-the-word-chat-with-rocio-valdivia-pooja-derashri-jose-ramon/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:168:\"<p>Listen to insights and experiences in the Spanish WordPress community, features and updates announced at SOTW, plus getting involved in the WordPress community. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"Do The Woo Community: Resources and Opportunities in WordPress for Speaking, Contributing and Connecting\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"https://dothewoo.io/resources-and-opportunities-in-wordpress-for-speaking-contributing-and-connecting/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"https://dothewoo.io/resources-and-opportunities-in-wordpress-for-speaking-contributing-and-connecting/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:123:\"<p>WordCamp opportunities, supporting underrepresented and connecting the WordPress community with resources and sites.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"Do The Woo Community: A Post Mortem Marketing Analysis of Black Friday aka Stuff You Should Do\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://dothewoo.io/a-post-mortem-marketing-analysis-of-black-friday-aka-stuff-you-should-do/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://dothewoo.io/a-post-mortem-marketing-analysis-of-black-friday-aka-stuff-you-should-do/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:136:\"<p>Adam and Emma discuss the importance of conducting a post-mortem analysis after a major marketing campaign, such as Black Friday.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"Do The Woo Community: End of the Year Emerging Tech with Kathy Zant and Dave Lockie\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://dothewoo.io/end-of-the-year-emerging-tech-with-kathy-zant-and-dave-lockie/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://dothewoo.io/end-of-the-year-emerging-tech-with-kathy-zant-and-dave-lockie/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:295:\"<p>In this episode, Kathy and Dave discuss the influence of AI and blockchain on content creation, the rise of businesses using OpenAI API, and the potential of using blockchain for content authentication. They also explore the options for WordPress content and online identity verification.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"Do The Woo Community: Page Builders, Documentation and an Scaling for Swifties\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://dothewoo.io/page-builders-documentation-and-an-scaling-for-swifties/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://dothewoo.io/page-builders-documentation-and-an-scaling-for-swifties/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:147:\"<p>A look at a couple of polls on page builders and documentation and the WordPressVIP team preparing for an onslaught of Swifties on Time.com.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"Do The Woo Community: Share a Question or Comment for the Do the Woo End-of-Year Show\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://dothewoo.io/share-a-question-or-comment-for-the-do-the-woo-end-of-year-show/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://dothewoo.io/share-a-question-or-comment-for-the-do-the-woo-end-of-year-show/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"<p>Want to share your favorite episode, host or show? Perhaps you have a burning question or comment. Here&#8217;s your chance.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"Do The Woo Community: Looking at 2023 and Moving into 2024 with Carl and Zach in Woo DevChat\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://dothewoo.io/looking-at-2023-and-moving-into-2024-with-carl-and-zach-in-woo-devchat/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://dothewoo.io/looking-at-2023-and-moving-into-2024-with-carl-and-zach-in-woo-devchat/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:141:\"<p>Carl Alexander and Zach Stepek, hosts of Woo DevChat at Do the Woo Podcast, end the year 2023 the only way these two could end a year.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:119:\"Do The Woo Community: Agency Client Relations, Team Work and Differentiating with Nuno Morgadinho and Jesper Wallmander\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:117:\"https://dothewoo.io/agency-client-relations-team-work-and-differentiating-with-nuno-morgadinho-and-jesper-wallmander/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:117:\"https://dothewoo.io/agency-client-relations-team-work-and-differentiating-with-nuno-morgadinho-and-jesper-wallmander/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:154:\"<p>Nuno Morgadinho from WidgiLabs and Jesper Wallmander from Wallmander Co chat about their experiences and insights into running a WooCommerce Agency</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"Do The Woo Community: Growing Meetups at the WordPress Community Day, Roma 2023\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://dothewoo.io/growing-meetups-at-the-wordpress-community-day-roma-2023/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://dothewoo.io/growing-meetups-at-the-wordpress-community-day-roma-2023/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:169:\"<p>In this show the organizers for this event share how the idea transpired for the Next-Gen event and the goals to help grow the Italian WordPress meetup community.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"Do The Woo Community: Rebranding Your WordPress Plugin Business with Robert Abela\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://dothewoo.io/rebranding-your-wordpress-plugin-business-with-robert-abela/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://dothewoo.io/rebranding-your-wordpress-plugin-business-with-robert-abela/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:147:\"<p>Robert Abela from Melapress shares his story of rebranding his business and also shares some insights into the under-rated user roles in WP.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"Do The Woo Community: Do the Woo is Headed to State of the Word 2023 in Madrid\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://dothewoo.io/do-the-woo-is-headed-to-state-of-the-word-2023-in-madrid/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://dothewoo.io/do-the-woo-is-headed-to-state-of-the-word-2023-in-madrid/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:160:\"<p>BobWP from Do the Woo will once again attend State of the Word. The SOTW 2023 will be in Madrid this year to celebrate Spain&#8217;s WordPress community.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Do The Woo Community: ChatGPT Told Me How I Can Do the Woo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://dothewoo.io/chatgpt-told-me-how-i-can-do-the-woo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://dothewoo.io/chatgpt-told-me-how-i-can-do-the-woo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"<p>How much can ChatGPT tell me about WooCommerce, and doing the Woo. Well, I found out and am sharing it in this weeks WooBits.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"Do The Woo Community: Working on Different Open Source Platforms and More with Ian Gordon and Philip James Wylie\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"https://dothewoo.io/working-on-different-open-source-platforms-and-more-with-ian-gordon-and-philip-james-wylie/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"https://dothewoo.io/working-on-different-open-source-platforms-and-more-with-ian-gordon-and-philip-james-wylie/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"<p>Ian and Philip from Kanuka Digital talk about WooCommerce, Magento, web specializations and the open source community.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"Do The Woo Community: The Backstory of the New Woo Branding with David Callaway\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://dothewoo.io/the-backstory-of-the-new-woo-branding-with-david-callaway/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://dothewoo.io/the-backstory-of-the-new-woo-branding-with-david-callaway/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"<p>David Callaway from Woo.com joins BobWP as they take a deeper dive into the latest WooCommerce branding.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"Do The Woo Community: All Things WordPress 6.4 with Anne McCarthy and Bud Kraus\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://dothewoo.io/all-things-wordpress-6-4-with-anne-mccarthy-and-bud-kraus/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://dothewoo.io/all-things-wordpress-6-4-with-anne-mccarthy-and-bud-kraus/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:145:\"<p>Anne McCarthy and Bud Kraus join Abha for a chat about the earlier release of WordPress 6.4 filled with insights and experiences from all.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"Do The Woo Community: Meetups and State of the Word Watch Parties with Devin Maeztri\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://dothewoo.io/meetups-and-state-of-the-word-watch-parties-with-devin-maeztri/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://dothewoo.io/meetups-and-state-of-the-word-watch-parties-with-devin-maeztri/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:135:\"<p>Devin Maeztri joins us as a new host and shares more about meetups and how to put together a State of the Word 2023 watch party.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"Do The Woo Community: WordPress Meetups Have Always Had a Place in My Heart\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://dothewoo.io/wordpress-meetups-have-always-had-a-place-in-my-heart/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://dothewoo.io/wordpress-meetups-have-always-had-a-place-in-my-heart/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:136:\"<p>A bit of reflection and good feelings seeing more meetups being organized. Plus a teaser for State of the Word and watch parties.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"Do The Woo Community: Now is the Time for Passkeys in WordPress, All the Time with Timothy Jacobs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://dothewoo.io/now-is-the-time-for-passkeys-in-wordpress-all-the-time-with-timothy-jacobs/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://dothewoo.io/now-is-the-time-for-passkeys-in-wordpress-all-the-time-with-timothy-jacobs/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:262:\"<p>On Emerging Tech, Timothy Jacobs of SolidWP explores passkeys, a security tech for WordPress. Eliminating passwords, it uses biometric data, ensuring user safety and resisting phishing. Adopted by major firms, passkeys promise enhanced WordPress security.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Do The Woo Community: Three Years Later, Why Woo Builders?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://dothewoo.io/three-years-later-why-woo-builders/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://dothewoo.io/three-years-later-why-woo-builders/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:143:\"<p>It started with Woo builders. And with the expectation of connecting the global community, it continues with Woo and WordPress builders.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"Do The Woo Community: De Nederlandse WordPress Community – The Dutch WordPress Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://dothewoo.io/de-nederlandse-wordpress-community-the-dutch-wordpress-community/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://dothewoo.io/de-nederlandse-wordpress-community-the-dutch-wordpress-community/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:157:\"<p>In ons programma Community Voices, WordPress Around the World zetten we de Nederlandse gemeenschap in de spotlight voor een gesprek in hun moedertaal.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Mar 2024 14:15:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sat, 06 Apr 2024 21:31:23 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:13:\"last-modified\";s:29:\"Sat, 06 Apr 2024 21:15:27 GMT\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";s:14:\"20220125223029\";}","no");

INSERT IGNORE INTO `wp13_options` VALUES 
("24473","_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9","1712482283","no"),
("24474","_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9","1712439083","no"),
("24475","_transient_timeout_dash_v2_88ae138922fe95674369b1cb3d215a2b","1712482283","no"),
("24476","_transient_dash_v2_88ae138922fe95674369b1cb3d215a2b","<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2024/04/episode-76-a-wordpress-6-5-sneak-peek/\'>WP Briefing: Episode 76: A WordPress 6.5 Sneak Peek</a></li><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2024/04/regina/\'>WordPress 6.5 “Regina”</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://gutenbergtimes.com/wordpress-6-5-register-font-collections-working-with-templates-or-playground-weekend-edition-290/\'>Gutenberg Times: WordPress 6.5, register Font collections, working with templates, or playground — Weekend Edition 290</a></li><li><a class=\'rsswidget\' href=\'https://gutenbergtimes.com/about-wordpress-6-5-all-in-one-list/\'>Gutenberg Times: About WordPress 6.5 – all in one list on blocks and site editor</a></li><li><a class=\'rsswidget\' href=\'https://dothewoo.io/introducing-groundbreaker-empowering-women-in-tech-in-uganda/\'>Do The Woo Community: Introducing Groundbreaker, Empowering Women in Tech in Uganda</a></li></ul></div>","no"),
("24477","can_compress_scripts","0","yes"),
("24567","csmm_pointers","a:1:{s:7:\"welcome\";b:1;}","yes"),
("24568","_site_transient_wp_plugin_dependencies_plugin_data","a:0:{}","no"),
("24569","_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a","1712459478","no"),
("24570","_site_transient_poptags_40cd750bba9870f18aada2478b24840a","O:8:\"stdClass\":100:{s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:6309;}s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4833;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2790;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2688;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:2068;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:1941;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1921;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:1690;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1582;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1571;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1549;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1514;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:1509;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1505;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1397;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1317;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1289;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1173;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1162;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:1160;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:1096;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:1029;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:1003;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:982;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:936;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:909;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:906;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:889;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:888;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:886;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:881;}s:5:\"block\";a:3:{s:4:\"name\";s:5:\"block\";s:4:\"slug\";s:5:\"block\";s:5:\"count\";i:878;}s:9:\"gutenberg\";a:3:{s:4:\"name\";s:9:\"gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:5:\"count\";i:867;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:796;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:789;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:784;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:781;}s:9:\"elementor\";a:3:{s:4:\"name\";s:9:\"elementor\";s:4:\"slug\";s:9:\"elementor\";s:5:\"count\";i:779;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:763;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:744;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:738;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:733;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:730;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:703;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:692;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:688;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:673;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:665;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:641;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:631;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:629;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:623;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:613;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:610;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:601;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:598;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:595;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:595;}s:8:\"shipping\";a:3:{s:4:\"name\";s:8:\"shipping\";s:4:\"slug\";s:8:\"shipping\";s:5:\"count\";i:592;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:577;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:576;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:574;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:574;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:573;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:568;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:552;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:546;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:545;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:545;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:535;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:532;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:530;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:520;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:515;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:512;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:512;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:507;}s:6:\"blocks\";a:3:{s:4:\"name\";s:6:\"blocks\";s:4:\"slug\";s:6:\"blocks\";s:5:\"count\";i:505;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:488;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:479;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:455;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:452;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:451;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:447;}s:8:\"payments\";a:3:{s:4:\"name\";s:8:\"payments\";s:4:\"slug\";s:8:\"payments\";s:5:\"count\";i:444;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:443;}s:7:\"gateway\";a:3:{s:4:\"name\";s:7:\"gateway\";s:4:\"slug\";s:7:\"gateway\";s:5:\"count\";i:438;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:433;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:428;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:428;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:428;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:425;}s:6:\"import\";a:3:{s:4:\"name\";s:6:\"import\";s:4:\"slug\";s:6:\"import\";s:5:\"count\";i:424;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:413;}s:8:\"checkout\";a:3:{s:4:\"name\";s:8:\"checkout\";s:4:\"slug\";s:8:\"checkout\";s:5:\"count\";i:412;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:409;}s:5:\"cache\";a:3:{s:4:\"name\";s:5:\"cache\";s:4:\"slug\";s:5:\"cache\";s:5:\"count\";i:408;}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";i:405;}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";i:396;}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";i:390;}}","no"),
("24572","_transient_timeout_mojo_plugin_assets","1712470306","no"),
("24573","_transient_mojo_plugin_assets","a:6:{s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:17:{s:4:\"date\";s:29:\"Sun, 07 Apr 2024 00:11:46 GMT\";s:12:\"content-type\";s:16:\"application/json\";s:13:\"last-modified\";s:29:\"Thu, 28 Mar 2024 19:14:36 GMT\";s:17:\"x-rgw-object-type\";s:6:\"Normal\";s:4:\"etag\";s:36:\"W/\"095c4a0d5107b856d2c63dc75d64da6a\"\";s:16:\"x-amz-request-id\";s:49:\"tx000003f4298c9dd704c93-006605c1ac-4f6a5923-nyc3b\";s:4:\"vary\";s:86:\"Origin, Access-Control-Request-Headers, Access-Control-Request-Method, Accept-Encoding\";s:25:\"strict-transport-security\";s:44:\"max-age=15552000; includeSubDomains; preload\";s:13:\"x-do-cdn-uuid\";s:36:\"db0a15ac-e200-43bb-b780-a78e60e36e05\";s:13:\"cache-control\";s:13:\"max-age=86400\";s:38:\"x-envoy-upstream-healthchecked-cluster\";s:0:\"\";s:15:\"cf-cache-status\";s:3:\"HIT\";s:3:\"age\";s:5:\"17803\";s:10:\"set-cookie\";s:260:\"__cf_bm=IGxX3khKe2RZH8adJUu7LOpOqj.UXRIelAzCMEs6WQI-1712448706-1.0.1.1-Z9IhTf9K2dsVY8TtsZ10IPqeRcqdTlZuW7uU4eGwUVAFmsiHaAedqYUZDQwYv4FhMkknGqZCJ7lJapAu3dzJkQ; path=/; expires=Sun, 07-Apr-24 00:41:46 GMT; domain=.cdn.hiive.space; HttpOnly; Secure; SameSite=None\";s:6:\"server\";s:10:\"cloudflare\";s:6:\"cf-ray\";s:20:\"8705cd61496d52ff-SLC\";s:16:\"content-encoding\";s:4:\"gzip\";}}s:4:\"body\";s:846:\"{\n   \"endurance-page-cache\": {\n      \"constant\": \"EPC_VERSION\",\n      \"version\": \"2.2.1\",\n      \"source\": \"https:\\/\\/raw.githubusercontent.com\\/bluehost\\/endurance-page-cache\\/production\\/endurance-page-cache.php\",\n      \"destination\": \"\\/mu-plugins\\/endurance-page-cache.php\"\n   },\n   \"endurance-browser-cache\": {\n      \"constant\": \"EBC_VERSION\",\n      \"version\": \"0.4\",\n      \"source\": \"https:\\/\\/raw.githubusercontent.com\\/bluehost\\/endurance-browser-cache\\/production\\/endurance-browser-cache.php\",\n      \"destination\": \"\\/mu-plugins\\/endurance-browser-cache.php\"\n   },\n   \"endurance-php-edge\": {\n      \"constant\": \"EPE_VERSION\",\n      \"version\": \"0.1\",\n      \"source\": \"https:\\/\\/raw.githubusercontent.com\\/bluehost\\/endurance-php-edge\\/production\\/endurance-php-edge.php\",\n      \"destination\": \"\\/mu-plugins\\/endurance-php-edge.php\"\n   }\n}\n\";s:8:\"response\";a:2:{s:4:\"code\";i:200;s:7:\"message\";s:2:\"OK\";}s:7:\"cookies\";a:1:{i:0;O:14:\"WP_Http_Cookie\":7:{s:4:\"name\";s:7:\"__cf_bm\";s:5:\"value\";s:149:\"IGxX3khKe2RZH8adJUu7LOpOqj.UXRIelAzCMEs6WQI-1712448706-1.0.1.1-Z9IhTf9K2dsVY8TtsZ10IPqeRcqdTlZuW7uU4eGwUVAFmsiHaAedqYUZDQwYv4FhMkknGqZCJ7lJapAu3dzJkQ\";s:7:\"expires\";i:1712450506;s:4:\"path\";s:1:\"/\";s:6:\"domain\";s:15:\"cdn.hiive.space\";s:4:\"port\";N;s:9:\"host_only\";b:0;}}s:8:\"filename\";N;s:13:\"http_response\";O:25:\"WP_HTTP_Requests_Response\":5:{s:11:\"\0*\0response\";O:23:\"WpOrg\\Requests\\Response\":10:{s:4:\"body\";s:846:\"{\n   \"endurance-page-cache\": {\n      \"constant\": \"EPC_VERSION\",\n      \"version\": \"2.2.1\",\n      \"source\": \"https:\\/\\/raw.githubusercontent.com\\/bluehost\\/endurance-page-cache\\/production\\/endurance-page-cache.php\",\n      \"destination\": \"\\/mu-plugins\\/endurance-page-cache.php\"\n   },\n   \"endurance-browser-cache\": {\n      \"constant\": \"EBC_VERSION\",\n      \"version\": \"0.4\",\n      \"source\": \"https:\\/\\/raw.githubusercontent.com\\/bluehost\\/endurance-browser-cache\\/production\\/endurance-browser-cache.php\",\n      \"destination\": \"\\/mu-plugins\\/endurance-browser-cache.php\"\n   },\n   \"endurance-php-edge\": {\n      \"constant\": \"EPE_VERSION\",\n      \"version\": \"0.1\",\n      \"source\": \"https:\\/\\/raw.githubusercontent.com\\/bluehost\\/endurance-php-edge\\/production\\/endurance-php-edge.php\",\n      \"destination\": \"\\/mu-plugins\\/endurance-php-edge.php\"\n   }\n}\n\";s:3:\"raw\";s:1841:\"HTTP/1.1 200 OK\r\nDate: Sun, 07 Apr 2024 00:11:46 GMT\r\nContent-Type: application/json\r\nTransfer-Encoding: chunked\r\nConnection: close\r\nlast-modified: Thu, 28 Mar 2024 19:14:36 GMT\r\nx-rgw-object-type: Normal\r\netag: W/\"095c4a0d5107b856d2c63dc75d64da6a\"\r\nx-amz-request-id: tx000003f4298c9dd704c93-006605c1ac-4f6a5923-nyc3b\r\nvary: Origin, Access-Control-Request-Headers, Access-Control-Request-Method, Accept-Encoding\r\nstrict-transport-security: max-age=15552000; includeSubDomains; preload\r\nx-do-cdn-uuid: db0a15ac-e200-43bb-b780-a78e60e36e05\r\nCache-Control: max-age=86400\r\nx-envoy-upstream-healthchecked-cluster: \r\nCF-Cache-Status: HIT\r\nAge: 17803\r\nSet-Cookie: __cf_bm=IGxX3khKe2RZH8adJUu7LOpOqj.UXRIelAzCMEs6WQI-1712448706-1.0.1.1-Z9IhTf9K2dsVY8TtsZ10IPqeRcqdTlZuW7uU4eGwUVAFmsiHaAedqYUZDQwYv4FhMkknGqZCJ7lJapAu3dzJkQ; path=/; expires=Sun, 07-Apr-24 00:41:46 GMT; domain=.cdn.hiive.space; HttpOnly; Secure; SameSite=None\r\nServer: cloudflare\r\nCF-RAY: 8705cd61496d52ff-SLC\r\nContent-Encoding: gzip\r\n\r\n{\n   \"endurance-page-cache\": {\n      \"constant\": \"EPC_VERSION\",\n      \"version\": \"2.2.1\",\n      \"source\": \"https:\\/\\/raw.githubusercontent.com\\/bluehost\\/endurance-page-cache\\/production\\/endurance-page-cache.php\",\n      \"destination\": \"\\/mu-plugins\\/endurance-page-cache.php\"\n   },\n   \"endurance-browser-cache\": {\n      \"constant\": \"EBC_VERSION\",\n      \"version\": \"0.4\",\n      \"source\": \"https:\\/\\/raw.githubusercontent.com\\/bluehost\\/endurance-browser-cache\\/production\\/endurance-browser-cache.php\",\n      \"destination\": \"\\/mu-plugins\\/endurance-browser-cache.php\"\n   },\n   \"endurance-php-edge\": {\n      \"constant\": \"EPE_VERSION\",\n      \"version\": \"0.1\",\n      \"source\": \"https:\\/\\/raw.githubusercontent.com\\/bluehost\\/endurance-php-edge\\/production\\/endurance-php-edge.php\",\n      \"destination\": \"\\/mu-plugins\\/endurance-php-edge.php\"\n   }\n}\n\";s:7:\"headers\";O:31:\"WpOrg\\Requests\\Response\\Headers\":1:{s:7:\"\0*\0data\";a:17:{s:4:\"date\";a:1:{i:0;s:29:\"Sun, 07 Apr 2024 00:11:46 GMT\";}s:12:\"content-type\";a:1:{i:0;s:16:\"application/json\";}s:13:\"last-modified\";a:1:{i:0;s:29:\"Thu, 28 Mar 2024 19:14:36 GMT\";}s:17:\"x-rgw-object-type\";a:1:{i:0;s:6:\"Normal\";}s:4:\"etag\";a:1:{i:0;s:36:\"W/\"095c4a0d5107b856d2c63dc75d64da6a\"\";}s:16:\"x-amz-request-id\";a:1:{i:0;s:49:\"tx000003f4298c9dd704c93-006605c1ac-4f6a5923-nyc3b\";}s:4:\"vary\";a:1:{i:0;s:86:\"Origin, Access-Control-Request-Headers, Access-Control-Request-Method, Accept-Encoding\";}s:25:\"strict-transport-security\";a:1:{i:0;s:44:\"max-age=15552000; includeSubDomains; preload\";}s:13:\"x-do-cdn-uuid\";a:1:{i:0;s:36:\"db0a15ac-e200-43bb-b780-a78e60e36e05\";}s:13:\"cache-control\";a:1:{i:0;s:13:\"max-age=86400\";}s:38:\"x-envoy-upstream-healthchecked-cluster\";a:1:{i:0;s:0:\"\";}s:15:\"cf-cache-status\";a:1:{i:0;s:3:\"HIT\";}s:3:\"age\";a:1:{i:0;s:5:\"17803\";}s:10:\"set-cookie\";a:1:{i:0;s:260:\"__cf_bm=IGxX3khKe2RZH8adJUu7LOpOqj.UXRIelAzCMEs6WQI-1712448706-1.0.1.1-Z9IhTf9K2dsVY8TtsZ10IPqeRcqdTlZuW7uU4eGwUVAFmsiHaAedqYUZDQwYv4FhMkknGqZCJ7lJapAu3dzJkQ; path=/; expires=Sun, 07-Apr-24 00:41:46 GMT; domain=.cdn.hiive.space; HttpOnly; Secure; SameSite=None\";}s:6:\"server\";a:1:{i:0;s:10:\"cloudflare\";}s:6:\"cf-ray\";a:1:{i:0;s:20:\"8705cd61496d52ff-SLC\";}s:16:\"content-encoding\";a:1:{i:0;s:4:\"gzip\";}}}s:11:\"status_code\";i:200;s:16:\"protocol_version\";d:1.100000000000000088817841970012523233890533447265625;s:7:\"success\";b:1;s:9:\"redirects\";i:0;s:3:\"url\";s:48:\"https://cdn.hiive.space/bluehost/mu-plugins.json\";s:7:\"history\";a:0:{}s:7:\"cookies\";O:25:\"WpOrg\\Requests\\Cookie\\Jar\":1:{s:10:\"\0*\0cookies\";a:1:{s:7:\"__cf_bm\";O:21:\"WpOrg\\Requests\\Cookie\":5:{s:4:\"name\";s:7:\"__cf_bm\";s:5:\"value\";s:149:\"IGxX3khKe2RZH8adJUu7LOpOqj.UXRIelAzCMEs6WQI-1712448706-1.0.1.1-Z9IhTf9K2dsVY8TtsZ10IPqeRcqdTlZuW7uU4eGwUVAFmsiHaAedqYUZDQwYv4FhMkknGqZCJ7lJapAu3dzJkQ\";s:10:\"attributes\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:6:{s:4:\"path\";s:1:\"/\";s:7:\"expires\";i:1712450506;s:6:\"domain\";s:15:\"cdn.hiive.space\";s:8:\"httponly\";b:1;s:6:\"secure\";b:1;s:8:\"samesite\";s:4:\"None\";}}s:5:\"flags\";a:4:{s:8:\"creation\";i:1712448706;s:11:\"last-access\";i:1712448706;s:10:\"persistent\";b:0;s:9:\"host-only\";b:0;}s:14:\"reference_time\";i:1712448706;}}}}s:11:\"\0*\0filename\";N;s:4:\"data\";N;s:7:\"headers\";N;s:6:\"status\";N;}}","no"),
("24574","_site_transient_timeout_theme_roots","1712450507","no"),
("24575","_site_transient_theme_roots","a:5:{s:4:\"Divi\";s:7:\"/themes\";s:16:\"twentytwentyfour\";s:7:\"/themes\";s:15:\"twentytwentyone\";s:7:\"/themes\";s:17:\"twentytwentythree\";s:7:\"/themes\";s:15:\"twentytwentytwo\";s:7:\"/themes\";}","no"),
("24583","_site_transient_update_plugins","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1712449032;s:8:\"response\";a:5:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"5.3.2\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.5.3.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:60:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=2818463\";s:2:\"1x\";s:60:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=2818463\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/akismet/assets/banner-1544x500.png?rev=2900731\";s:2:\"1x\";s:62:\"https://ps.w.org/akismet/assets/banner-772x250.png?rev=2900731\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.8\";s:6:\"tested\";s:5:\"6.4.3\";s:12:\"requires_php\";s:6:\"5.6.20\";s:16:\"requires_plugins\";a:0:{}}s:58:\"creative-mail-by-constant-contact/creative-mail-plugin.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:47:\"w.org/plugins/creative-mail-by-constant-contact\";s:4:\"slug\";s:33:\"creative-mail-by-constant-contact\";s:6:\"plugin\";s:58:\"creative-mail-by-constant-contact/creative-mail-plugin.php\";s:11:\"new_version\";s:5:\"1.6.7\";s:3:\"url\";s:64:\"https://wordpress.org/plugins/creative-mail-by-constant-contact/\";s:7:\"package\";s:82:\"https://downloads.wordpress.org/plugin/creative-mail-by-constant-contact.1.6.7.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:78:\"https://ps.w.org/creative-mail-by-constant-contact/assets/icon.svg?rev=2341439\";s:3:\"svg\";s:78:\"https://ps.w.org/creative-mail-by-constant-contact/assets/icon.svg?rev=2341439\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:89:\"https://ps.w.org/creative-mail-by-constant-contact/assets/banner-1544x500.png?rev=2821536\";s:2:\"1x\";s:88:\"https://ps.w.org/creative-mail-by-constant-contact/assets/banner-772x250.png?rev=2821536\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";s:6:\"tested\";s:5:\"6.1.5\";s:12:\"requires_php\";s:3:\"7.2\";s:16:\"requires_plugins\";a:0:{}}s:19:\"jetpack/jetpack.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:21:\"w.org/plugins/jetpack\";s:4:\"slug\";s:7:\"jetpack\";s:6:\"plugin\";s:19:\"jetpack/jetpack.php\";s:11:\"new_version\";s:4:\"13.3\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"package\";s:55:\"https://downloads.wordpress.org/plugin/jetpack.13.3.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:52:\"https://ps.w.org/jetpack/assets/icon.svg?rev=2819237\";s:3:\"svg\";s:52:\"https://ps.w.org/jetpack/assets/icon.svg?rev=2819237\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/jetpack/assets/banner-1544x500.png?rev=2653649\";s:2:\"1x\";s:62:\"https://ps.w.org/jetpack/assets/banner-772x250.png?rev=2653649\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.3\";s:6:\"tested\";s:3:\"6.5\";s:12:\"requires_php\";s:3:\"7.0\";s:16:\"requires_plugins\";a:0:{}}s:37:\"optinmonster/optin-monster-wp-api.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:26:\"w.org/plugins/optinmonster\";s:4:\"slug\";s:12:\"optinmonster\";s:6:\"plugin\";s:37:\"optinmonster/optin-monster-wp-api.php\";s:11:\"new_version\";s:6:\"2.16.0\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/optinmonster/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/optinmonster.2.16.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/optinmonster/assets/icon-256x256.png?rev=1145864\";s:2:\"1x\";s:65:\"https://ps.w.org/optinmonster/assets/icon-128x128.png?rev=1145864\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/optinmonster/assets/banner-1544x500.png?rev=2311621\";s:2:\"1x\";s:67:\"https://ps.w.org/optinmonster/assets/banner-772x250.png?rev=2311621\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.7\";s:6:\"tested\";s:5:\"6.4.3\";s:12:\"requires_php\";s:3:\"5.3\";s:16:\"requires_plugins\";a:0:{}}s:24:\"wpforms-lite/wpforms.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:26:\"w.org/plugins/wpforms-lite\";s:4:\"slug\";s:12:\"wpforms-lite\";s:6:\"plugin\";s:24:\"wpforms-lite/wpforms.php\";s:11:\"new_version\";s:7:\"1.8.7.2\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/wpforms-lite/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/wpforms-lite.1.8.7.2.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:57:\"https://ps.w.org/wpforms-lite/assets/icon.svg?rev=2574198\";s:3:\"svg\";s:57:\"https://ps.w.org/wpforms-lite/assets/icon.svg?rev=2574198\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/wpforms-lite/assets/banner-1544x500.png?rev=2602491\";s:2:\"1x\";s:67:\"https://ps.w.org/wpforms-lite/assets/banner-772x250.png?rev=2602491\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:72:\"https://ps.w.org/wpforms-lite/assets/banner-1544x500-rtl.png?rev=2602491\";s:2:\"1x\";s:71:\"https://ps.w.org/wpforms-lite/assets/banner-772x250-rtl.png?rev=2602491\";}s:8:\"requires\";s:3:\"5.5\";s:6:\"tested\";s:5:\"6.4.3\";s:12:\"requires_php\";s:3:\"7.0\";s:16:\"requires_plugins\";a:0:{}}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:2:{s:77:\"minimal-coming-soon-maintenance-mode/minimal-coming-soon-maintenance-mode.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:50:\"w.org/plugins/minimal-coming-soon-maintenance-mode\";s:4:\"slug\";s:36:\"minimal-coming-soon-maintenance-mode\";s:6:\"plugin\";s:77:\"minimal-coming-soon-maintenance-mode/minimal-coming-soon-maintenance-mode.php\";s:11:\"new_version\";s:4:\"2.38\";s:3:\"url\";s:67:\"https://wordpress.org/plugins/minimal-coming-soon-maintenance-mode/\";s:7:\"package\";s:84:\"https://downloads.wordpress.org/plugin/minimal-coming-soon-maintenance-mode.2.38.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:89:\"https://ps.w.org/minimal-coming-soon-maintenance-mode/assets/icon-256x256.png?rev=1797141\";s:2:\"1x\";s:89:\"https://ps.w.org/minimal-coming-soon-maintenance-mode/assets/icon-128x128.png?rev=1797141\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:92:\"https://ps.w.org/minimal-coming-soon-maintenance-mode/assets/banner-1544x500.png?rev=1807800\";s:2:\"1x\";s:91:\"https://ps.w.org/minimal-coming-soon-maintenance-mode/assets/banner-772x250.png?rev=1807800\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";}s:9:\"hello.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/hello-dolly\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:5:\"1.7.2\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/hello-dolly.1.7.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=2052855\";s:2:\"1x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=2052855\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/hello-dolly/assets/banner-1544x500.jpg?rev=2645582\";s:2:\"1x\";s:66:\"https://ps.w.org/hello-dolly/assets/banner-772x250.jpg?rev=2052855\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.6\";}}s:7:\"checked\";a:9:{s:19:\"akismet/akismet.php\";s:6:\"4.1.10\";s:77:\"minimal-coming-soon-maintenance-mode/minimal-coming-soon-maintenance-mode.php\";s:4:\"6.31\";s:58:\"creative-mail-by-constant-contact/creative-mail-plugin.php\";s:5:\"1.4.0\";s:33:\"duplicator-pro/duplicator-pro.php\";s:8:\"4.5.15.1\";s:9:\"hello.php\";s:5:\"1.7.2\";s:43:\"wp-plugin-hostgator/wp-plugin-hostgator.php\";s:5:\"1.2.4\";s:19:\"jetpack/jetpack.php\";s:5:\"9.9.2\";s:37:\"optinmonster/optin-monster-wp-api.php\";s:5:\"2.4.1\";s:24:\"wpforms-lite/wpforms.php\";s:7:\"1.6.7.3\";}}","no"),
("24584","_site_transient_et_update_all_plugins","O:8:\"stdClass\":3:{s:7:\"checked\";a:9:{s:19:\"akismet/akismet.php\";s:6:\"4.1.10\";s:77:\"minimal-coming-soon-maintenance-mode/minimal-coming-soon-maintenance-mode.php\";s:4:\"6.31\";s:58:\"creative-mail-by-constant-contact/creative-mail-plugin.php\";s:5:\"1.4.0\";s:33:\"duplicator-pro/duplicator-pro.php\";s:8:\"4.5.15.1\";s:9:\"hello.php\";s:5:\"1.7.2\";s:43:\"wp-plugin-hostgator/wp-plugin-hostgator.php\";s:5:\"1.2.4\";s:19:\"jetpack/jetpack.php\";s:5:\"9.9.2\";s:37:\"optinmonster/optin-monster-wp-api.php\";s:5:\"2.4.1\";s:24:\"wpforms-lite/wpforms.php\";s:7:\"1.6.7.3\";}s:8:\"response\";a:0:{}s:12:\"last_checked\";i:1712449032;}","no"),
("24585","duplicator_pro_license_key","activated","yes"),
("24586","duplicator_pro_capabilities","a:9:{s:20:\"duplicator_pro_basic\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:21:\"duplicator_pro_create\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:23:\"duplicator_pro_schedule\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:22:\"duplicator_pro_storage\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:29:\"duplicator_pro_backup_restore\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:21:\"duplicator_pro_import\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:21:\"duplicator_pro_export\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:23:\"duplicator_pro_settings\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:22:\"duplicator_pro_license\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}}","yes"),
("24587","edd_sl_a3082723c63b116f21b97dfd1be654bd","a:2:{s:7:\"timeout\";i:1712459833;s:5:\"value\";s:5:\"false\";}","no"),
("24588","duplicator_pro_plugin_version","4.5.15.1","yes"),
("24589","duplicator_pro_install_info","a:3:{s:7:\"version\";s:8:\"4.5.15.1\";s:4:\"time\";i:1712449033;s:10:\"updateTime\";i:1712449033;}","no"),
("24590","duplicator_pro_plugin_data_stats","{\n    \"CL_-=_-=\": \"Duplicator\\\\Utils\\\\UsageStatistics\\\\PluginData\",\n    \"lastSendTime\": 0,\n    \"identifier\": \"V8gt;D6U8YHP0yG207PTpjiyc7E8E,WT5xw&;q2joWqr\",\n    \"plugin\": \"dup-pro\",\n    \"pluginStatus\": \"active\",\n    \"anonymous\": false,\n    \"buildCount\": 0,\n    \"buildLastDate\": 0,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"packagesBuildCompFullCount\": 0,\n    \"packagesBuildCompDbOnlyCount\": 0,\n    \"packagesBuildCompMdOnlyCount\": 0,\n    \"packagesBuildCompCustomCount\": 0,\n    \"packagesBuildCompCustomOnlyActiveCount\": 0,\n    \"schedulesBuildCount\": 0,\n    \"schedulesBuildLastDate\": 0,\n    \"schedulesBuildFailedCount\": 0,\n    \"schedulesBuildFailedLastDate\": 0,\n    \"schedulesBuildCompFullCount\": 0,\n    \"schedulesBuildCompDbOnlyCount\": 0,\n    \"schedulesBuildCompMdOnlyCount\": 0,\n    \"schedulesBuildCompCustomCount\": 0,\n    \"schedulesBuildCompCustomOnlyActiveCount\": 0,\n    \"usedRecoveryCount\": 0,\n    \"siteSizeMB\": 205.219999999999998863131622783839702606201171875,\n    \"siteNumFiles\": 12367,\n    \"siteDbSizeMB\": 2.720000000000000195399252334027551114559173583984375,\n    \"siteDbNumTables\": 19\n}","yes"),
("24593","_transient_timeout_et_core_path","1712535433","no"),
("24594","_transient_et_core_path","/home3/pmoadvisory/iexperipress.com/wp-content/themes/Divi/core","no"),
("24595","_transient_timeout_et_core_version","1712535433","no"),
("24596","_transient_et_core_version","4.9.7","no"),
("24597","duplicator_pro_notifications","a:4:{s:6:\"update\";i:1712449033;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}","yes"),
("24598","duplicator_expire_tmp_cleanup_check","{\"expire\":1712535434,\"value\":true}","yes"),
("24599","duplicator_expire_daily_bootstrap_actions","{\"expire\":1712535434,\"value\":true}","yes"),
("24600","duplicator_expire_rename_delay","{\"expire\":1712492234,\"value\":true}","yes"),
("24602","duplicator_expire_duplicator_pro_frotend_delay","{\"expire\":1712449308,\"value\":true}","yes"),
("24603","duplicator_expire_license_check","{\"expire\":1712449309,\"value\":true}","yes"),
("24608","duplicator_pro_package_active","{\n    \"ID\": null,\n    \"VersionWP\": \"6.5\",\n    \"VersionDB\": \"5.6.41\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240407_iexpress\",\n    \"Hash\": \"f44b95cb59db8fbd6483_20240407002115\",\n    \"NameHash\": \"20240407_iexpress_f44b95cb59db8fbd6483_20240407002115\",\n    \"Type\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/iexperipress.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240407_iexpress_f44b95cb59db8fbd6483_20240407002115_scan.json\",\n    \"timer_start\": -1,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/.opcache\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/.tmb\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/ai1wm-backups\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/backups-dup-lite\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/backups-dup-pro\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/backupwordpress\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/bps-backup\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/cache\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/content\\/cache\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/contents\\/cache\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/managewp\\/backups\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/old-cache\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/updraft\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/wfcache\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/wishlist-backup\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/wpvividbackups\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/.htaccess\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/.user.ini\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/php.ini\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/web.config\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-config.php\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/debug.log\",\n            \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/wpforms\\/.htaccess.cpmh3129\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": null,\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home3\\/pmoadvisory\\/iexperipress.com\",\n        \"Size\": 215187845,\n        \"Dirs\": [],\n        \"DirCount\": 1891,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 10476,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [\n                    \"\\/home3\\/pmoadvisory\\/iexperipress.com\\/wp-content\\/uploads\\/wpforms\\/.htaccess.cpmh3129\"\n                ]\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"N7UPqLuk4iHRdbpVgzpF6FnlNNUJ92lAwZNcpqg\\/kNX9eNaeuowxNYSUxJw\\/QJQ4dd4UHMCsa3JxPsRHqXoJwQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"pmoadvis_wp74\",\n            \"tablesBaseCount\": 19,\n            \"tablesFinalCount\": 19,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 792,\n            \"tablesSizeOnDisk\": 2850816,\n            \"tablesList\": {\n                \"wp13_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"40\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp13_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp13_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp13_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"108\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp13_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp13_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp13_duplicator_backups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 147456\n                },\n                \"wp13_duplicator_entities\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp13_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp13_options\": {\n                    \"inaccurateRows\": \"241\",\n                    \"insertedRows\": 0,\n                    \"size\": 1097728\n                },\n                \"wp13_postmeta\": {\n                    \"inaccurateRows\": \"290\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp13_posts\": {\n                    \"inaccurateRows\": \"70\",\n                    \"insertedRows\": 0,\n                    \"size\": 557056\n                },\n                \"wp13_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp13_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp13_term_relationships\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp13_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp13_usermeta\": {\n                    \"inaccurateRows\": \"20\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp13_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp13_wpforms_tasks_meta\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"5.6.41\",\n            \"versionComment\": \"Percona Server (GPL), Release 84.1, Revision b308619\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHP\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release 84.1, Revision b308619\",\n        \"dbStorePathPublic\": \"\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 5,\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": 6,\n    \"version\": \"4.5.15.1\",\n    \"created\": \"2024-04-07 00:21:18\",\n    \"updated\": \"2024-04-07 00:21:18\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","yes");

INSERT IGNORE INTO `wp13_postmeta` VALUES 
("5","6","_edit_lock","1626064913:1"),
("6","6","_edit_last","1"),
("7","6","_et_pb_post_hide_nav","default"),
("8","6","_et_pb_page_layout","et_right_sidebar"),
("9","6","_et_pb_side_nav","off"),
("10","6","_et_pb_use_builder","on"),
("11","6","_et_gb_content_width",""),
("12","8","_wp_attached_file","2021/07/pr-firm_26.jpg"),
("13","8","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:977;s:4:\"file\";s:22:\"2021/07/pr-firm_26.jpg\";s:5:\"sizes\";a:14:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"pr-firm_26-300x153.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:153;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"pr-firm_26-1024x521.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:521;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"pr-firm_26-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"pr-firm_26-768x391.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:391;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:23:\"pr-firm_26-1536x782.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_26-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:23:\"pr-firm_26-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_26-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_26-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:23:\"pr-firm_26-1080x550.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:22:\"pr-firm_26-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:23:\"pr-firm_26-1280x651.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:651;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:22:\"pr-firm_26-980x499.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:499;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:22:\"pr-firm_26-480x244.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:244;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("14","9","_wp_attached_file","2021/07/pr-firm_18.jpg"),
("15","9","_wp_attachment_metadata","a:5:{s:5:\"width\";i:2560;s:6:\"height\";i:914;s:4:\"file\";s:22:\"2021/07/pr-firm_18.jpg\";s:5:\"sizes\";a:15:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"pr-firm_18-300x107.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:107;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"pr-firm_18-1024x366.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:366;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"pr-firm_18-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"pr-firm_18-768x274.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:274;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:23:\"pr-firm_18-1536x548.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:548;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"2048x2048\";a:4:{s:4:\"file\";s:23:\"pr-firm_18-2048x731.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:731;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_18-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:23:\"pr-firm_18-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_18-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_18-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:23:\"pr-firm_18-1080x386.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:386;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:22:\"pr-firm_18-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:23:\"pr-firm_18-1280x457.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:457;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:22:\"pr-firm_18-980x350.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:22:\"pr-firm_18-480x171.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:171;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("16","10","_wp_attached_file","2021/07/pr-firm-icon-6-dark.png"),
("17","10","_wp_attachment_metadata","a:5:{s:5:\"width\";i:48;s:6:\"height\";i:48;s:4:\"file\";s:31:\"2021/07/pr-firm-icon-6-dark.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("18","11","_wp_attached_file","2021/07/pr-firm-icon-10-dark.png"),
("19","11","_wp_attachment_metadata","a:5:{s:5:\"width\";i:48;s:6:\"height\";i:48;s:4:\"file\";s:32:\"2021/07/pr-firm-icon-10-dark.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("20","12","_wp_attached_file","2021/07/pr-firm-icon-3-dark.png"),
("21","12","_wp_attachment_metadata","a:5:{s:5:\"width\";i:48;s:6:\"height\";i:48;s:4:\"file\";s:31:\"2021/07/pr-firm-icon-3-dark.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("22","13","_wp_attached_file","2021/07/pr-firm-icon-5-dark.png"),
("23","13","_wp_attachment_metadata","a:5:{s:5:\"width\";i:48;s:6:\"height\";i:48;s:4:\"file\";s:31:\"2021/07/pr-firm-icon-5-dark.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("24","14","_wp_attached_file","2021/07/pr-firm-icon-1-dark.png"),
("25","14","_wp_attachment_metadata","a:5:{s:5:\"width\";i:48;s:6:\"height\";i:48;s:4:\"file\";s:31:\"2021/07/pr-firm-icon-1-dark.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("26","15","_wp_attached_file","2021/07/pr-firm-icon-7-dark.png"),
("27","15","_wp_attachment_metadata","a:5:{s:5:\"width\";i:48;s:6:\"height\";i:48;s:4:\"file\";s:31:\"2021/07/pr-firm-icon-7-dark.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("28","16","_wp_attached_file","2021/07/pr-firm_28.jpg"),
("29","16","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:533;s:4:\"file\";s:22:\"2021/07/pr-firm_28.jpg\";s:5:\"sizes\";a:8:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"pr-firm_28-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"pr-firm_28-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"pr-firm_28-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_28-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_28-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_28-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:22:\"pr-firm_28-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:22:\"pr-firm_28-480x320.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("30","17","_wp_attached_file","2021/07/pr-firm-icon-9-multicolor.png"),
("31","17","_wp_attachment_metadata","a:5:{s:5:\"width\";i:48;s:6:\"height\";i:48;s:4:\"file\";s:37:\"2021/07/pr-firm-icon-9-multicolor.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("32","18","_wp_attached_file","2021/07/pr-firm-icon-3-multicolor.png"),
("33","18","_wp_attachment_metadata","a:5:{s:5:\"width\";i:48;s:6:\"height\";i:48;s:4:\"file\";s:37:\"2021/07/pr-firm-icon-3-multicolor.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("34","19","_wp_attached_file","2021/07/pr-firm-icon-6-multicolor.png"),
("35","19","_wp_attachment_metadata","a:5:{s:5:\"width\";i:48;s:6:\"height\";i:48;s:4:\"file\";s:37:\"2021/07/pr-firm-icon-6-multicolor.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("36","20","_wp_attached_file","2021/07/pr-firm-icon-1-multicolor.png"),
("37","20","_wp_attachment_metadata","a:5:{s:5:\"width\";i:48;s:6:\"height\";i:48;s:4:\"file\";s:37:\"2021/07/pr-firm-icon-1-multicolor.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("38","6","_et_pb_built_for_post_type","page"),
("39","6","_et_pb_ab_subjects",""),
("40","6","_et_pb_enable_shortcode_tracking",""),
("41","6","_et_pb_ab_current_shortcode","[et_pb_split_track id=\"6\" /]"),
("42","6","_et_pb_custom_css",""),
("43","6","_et_pb_gutter_width","3"),
("44","6","_thumbnail_id","0"),
("45","6","_global_colors_info","{}"),
("46","6","_et_pb_first_image",""),
("47","6","_et_pb_truncate_post","<p><div class=\"et_pb_section et_pb_section_0 et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_with_border et_pb_row et_pb_row_0 et_pb_equal_columns\">\n				<div class=\"et_pb_column et_pb_column_1_2 et_pb_column_0  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_0  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Public Relations Services</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_2 et_pb_column_1  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_button_module_wrapper et_pb_button_0_wrapper et_pb_button_alignment_right et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_0 et_pb_bg_layout_light\" href=\"\">Make an Appointment</a>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_1 et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_1 et_pb_gutters2\">\n				<div class=\"et_pb_column et_pb_column_1_3 et_pb_column_2  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_0  et_pb_text_align_left  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-6-dark.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-10\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Brand Perception</span></h3>\n						<div class=\"et_pb_blurb_description\">Aliquam tincidunt mauris eu<br />\nVestibulum auctor dapibus neque.<br />\nNunc dignissim risus id metus.<br />\nCras ornare tristique elit.<br />\nVivamus vestibulum ntulla nec ante.<br />\nPraesent placerat risus quis eros.<br />\nFusce pellentesque suscipit.</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb --><div class=\"et_pb_button_module_wrapper et_pb_button_1_wrapper et_pb_button_alignment_left et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_1 et_pb_bg_layout_light\" href=\"\">Learn More</a>\n			</div>\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_3 et_pb_column_3  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_1  et_pb_text_align_left  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-10-dark.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-11\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Content Strategy</span></h3>\n						<div class=\"et_pb_blurb_description\">Aliquam tincidunt mauris eu<br />\nVestibulum auctor dapibus neque.<br />\nNunc dignissim risus id metus.<br />\nCras ornare tristique elit.<br />\nVivamus vestibulum ntulla nec ante.<br />\nPraesent placerat risus quis eros.<br />\nFusce pellentesque suscipit.</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb --><div class=\"et_pb_button_module_wrapper et_pb_button_2_wrapper et_pb_button_alignment_left et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_2 et_pb_bg_layout_light\" href=\"\">Learn More</a>\n			</div>\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_3 et_pb_column_4  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_2  et_pb_text_align_left  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-3-dark.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-12\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Social Media</span></h3>\n						<div class=\"et_pb_blurb_description\">Aliquam tincidunt mauris eu<br />\nVestibulum auctor dapibus neque.<br />\nNunc dignissim risus id metus.<br />\nCras ornare tristique elit.<br />\nVivamus vestibulum ntulla nec ante.<br />\nPraesent placerat risus quis eros.<br />\nFusce pellentesque suscipit.</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb --><div class=\"et_pb_button_module_wrapper et_pb_button_3_wrapper et_pb_button_alignment_left et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_3 et_pb_bg_layout_light\" href=\"\">Learn More</a>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class=\"et_pb_row et_pb_row_2 et_pb_gutters2\">\n				<div class=\"et_pb_column et_pb_column_1_3 et_pb_column_5  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_3  et_pb_text_align_left  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-5-dark.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-13\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Launch Success</span></h3>\n						<div class=\"et_pb_blurb_description\">Aliquam tincidunt mauris eu<br />\nVestibulum auctor dapibus neque.<br />\nNunc dignissim risus id metus.<br />\nCras ornare tristique elit.<br />\nVivamus vestibulum ntulla nec ante.<br />\nPraesent placerat risus quis eros.<br />\nFusce pellentesque suscipit.</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb --><div class=\"et_pb_button_module_wrapper et_pb_button_4_wrapper et_pb_button_alignment_left et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_4 et_pb_bg_layout_light\" href=\"\">Learn More</a>\n			</div>\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_3 et_pb_column_6  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_4  et_pb_text_align_left  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-1-dark.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-14\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Growth & Sales</span></h3>\n						<div class=\"et_pb_blurb_description\">Aliquam tincidunt mauris eu<br />\nVestibulum auctor dapibus neque.<br />\nNunc dignissim risus id metus.<br />\nCras ornare tristique elit.<br />\nVivamus vestibulum ntulla nec ante.<br />\nPraesent placerat risus quis eros.<br />\nFusce pellentesque suscipit.</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb --><div class=\"et_pb_button_module_wrapper et_pb_button_5_wrapper et_pb_button_alignment_left et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_5 et_pb_bg_layout_light\" href=\"\">Learn More</a>\n			</div>\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_3 et_pb_column_7  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_5  et_pb_text_align_left  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-7-dark.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-15\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Crisis Management</span></h3>\n						<div class=\"et_pb_blurb_description\">Aliquam tincidunt mauris eu<br />\nVestibulum auctor dapibus neque.<br />\nNunc dignissim risus id metus.<br />\nCras ornare tristique elit.<br />\nVivamus vestibulum ntulla nec ante.<br />\nPraesent placerat risus quis eros.<br />\nFusce pellentesque suscipit.</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb --><div class=\"et_pb_button_module_wrapper et_pb_button_6_wrapper et_pb_button_alignment_left et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_6 et_pb_bg_layout_light\" href=\"\">Learn More</a>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_2 et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_with_border et_pb_row et_pb_row_3 et_pb_equal_columns\">\n				<div class=\"et_pb_column et_pb_column_1_2 et_pb_column_8  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_1  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">Our Specialties<br />\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum ac diam sit amet quam vehicula elementum sed sit amet dui. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus magna justo,<br />\nlacinia eget consectetur sed, convallis at tellus. Nulla quis lorem ut libero malesuada feugiat. Quisque velit nisi, pretium ut lacinia in, elementum id enim. Quisque velit nisi, pretium ut lacinia in, elementum id enim.</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_2 et_pb_column_9  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_video et_pb_video_0\">\n				\n				\n				<div class=\"et_pb_video_box\"><iframe loading=\"lazy\" title=\"Divi. The Ultimate WordPress Theme And Visual Page Builder\" width=\"1080\" height=\"608\" src=\"https://www.youtube.com/embed/FkQuawiGWUw?feature=oembed\"  allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe></div>\n				<div style=\"background-image:url(https://iexperipress.com/wp-content/uploads/2021/07/pr-firm_28.jpg)\" class=\"et_pb_video_overlay\"><div class=\"et_pb_video_overlay_hover\"><a href=\"#\" class=\"et_pb_video_play\"></a></div></div>\n			</div><div class=\"et_pb_button_module_wrapper et_pb_button_7_wrapper et_pb_button_alignment_left et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_7 et_pb_bg_layout_light\" href=\"\">Contact Us</a>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class=\"et_pb_with_border et_pb_row et_pb_row_4 et_pb_gutters1\">\n				<div class=\"et_pb_with_border et_pb_column_1_4 et_pb_column et_pb_column_10 et_clickable  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_6  et_pb_text_align_left  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-9-multicolor.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-17\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Enterprise Companies</span></h3>\n						<div class=\"et_pb_blurb_description\">Nulla porttitor accumsan tincidunt. Pellentesque in ipsum id orci porta dapibus. Lorem</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_with_border et_pb_column_1_4 et_pb_column et_pb_column_11 et_clickable  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_7  et_pb_text_align_left  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-3-multicolor.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-18\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Consumer Products</span></h3>\n						<div class=\"et_pb_blurb_description\">Nulla porttitor accumsan tincidunt. Pellentesque in ipsum id orci porta dapibus.</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_with_border et_pb_column_1_4 et_pb_column et_pb_column_12 et_clickable  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_8  et_pb_text_align_left  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-6-multicolor.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-19\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Emerging Technology</span></h3>\n						<div class=\"et_pb_blurb_description\">Nulla porttitor accumsan tincidunt. Pellentesque in ipsum id orci porta dapibus</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_with_border et_pb_column_1_4 et_pb_column et_pb_column_13 et_clickable  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_9  et_pb_text_align_left  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-1-multicolor.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-20\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Financial Services</span></h3>\n						<div class=\"et_pb_blurb_description\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_3 et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_with_border et_pb_row et_pb_row_5\">\n				<div class=\"et_pb_column et_pb_column_4_4 et_pb_column_14  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_slider et_pb_slider_0 et_pb_slider_fullwidth_off\">\n				<div class=\"et_pb_slides\">\n					<div class=\"et_pb_slide et_pb_slide_0 et_pb_bg_layout_dark et_pb_media_alignment_center et-pb-active-slide\" data-slide-id=\"et_pb_slide_0\">\n				\n				\n				<div class=\"et_pb_container clearfix\">\n					<div class=\"et_pb_slider_container_inner\">\n						\n						<div class=\"et_pb_slide_description\">\n							<h2 class=\"et_pb_slide_title\">“Donec rutrum congue leo eget malesuada. Donec rutrum congue leo eget malesuada. Vivamus suscipit tortor eget felis”</h2><div class=\"et_pb_slide_content\">John Doe, CEO of Extra Space</div>\n							\n						</div> <!-- .et_pb_slide_description -->\n					</div>\n				</div> <!-- .et_pb_container -->\n				\n			</div> <!-- .et_pb_slide -->\n			<div class=\"et_pb_slide et_pb_slide_1 et_pb_bg_layout_dark et_pb_media_alignment_center\" data-slide-id=\"et_pb_slide_1\">\n				\n				\n				<div class=\"et_pb_container clearfix\">\n					<div class=\"et_pb_slider_container_inner\">\n						\n						<div class=\"et_pb_slide_description\">\n							<h2 class=\"et_pb_slide_title\">\"Vivamus magna justo, lacinia eget consectetur sed, convallis at tellus. Vestibulum ac diam sit amet quam vehicula elementum.\"</h2><div class=\"et_pb_slide_content\">Jane Smith, CEO of Monarch Inc.</div>\n							\n						</div> <!-- .et_pb_slide_description -->\n					</div>\n				</div> <!-- .et_pb_container -->\n				\n			</div> <!-- .et_pb_slide -->\n			<div class=\"et_pb_slide et_pb_slide_2 et_pb_bg_layout_dark et_pb_media_alignment_center\" data-slide-id=\"et_pb_slide_2\">\n				\n				\n				<div class=\"et_pb_container clearfix\">\n					<div class=\"et_pb_slider_container_inner\">\n						\n						<div class=\"et_pb_slide_description\">\n							<h2 class=\"et_pb_slide_title\">\"Vivamus magna justo, lacinia eget consectetur sed, convallis at tellus. Vestibulum ac diam sit amet quam vehicula elementum.\"</h2><div class=\"et_pb_slide_content\">Jane Smith, CEO of Monarch Inc.</div>\n							\n						</div> <!-- .et_pb_slide_description -->\n					</div>\n				</div> <!-- .et_pb_container -->\n				\n			</div> <!-- .et_pb_slide -->\n			\n				</div> <!-- .et_pb_slides -->\n				\n			</div> <!-- .et_pb_slider -->\n			<div class=\"et_pb_button_module_wrapper et_pb_button_8_wrapper et_pb_button_alignment_center et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_8 et_pb_bg_layout_light\" href=\"\">Get Started Today</a>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_with_border et_pb_section et_pb_section_4 et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_6 et_pb_equal_columns\">\n				<div class=\"et_pb_column et_pb_column_1_2 et_pb_column_15  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_2  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Get In Touch<br />\nGet In Touch</div>\n			</div> <!-- .et_pb_text --><div class=\"et_pb_button_module_wrapper et_pb_button_9_wrapper et_pb_button_alignment_left et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_9 et_pb_bg_layout_light\" href=\"\">Contact us</a>\n			</div>\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_2 et_pb_column_16  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_with_border et_pb_module et_pb_signup_0 et_pb_newsletter_layout_top_bottom et_pb_newsletter et_pb_subscribe clearfix  et_pb_text_align_left et_pb_bg_layout_light et_pb_no_bg et_pb_newsletter_description_no_content\">\n				\n				\n				<div class=\"et_pb_newsletter_description\"><h2 class=\"et_pb_module_header\">Subscribe</h2></div>\n				\n				<div class=\"et_pb_newsletter_form\">\n					<form method=\"post\">\n						<div class=\"et_pb_newsletter_result et_pb_newsletter_error\"></div>\n						<div class=\"et_pb_newsletter_result et_pb_newsletter_success\">\n							<h2>Success!</h2>\n						</div>\n						<div class=\"et_pb_newsletter_fields\">\n							\n							\n							\n					<p class=\"et_pb_newsletter_field et_pb_contact_field_last et_pb_contact_field_last_tablet et_pb_contact_field_last_phone\">\n						<label class=\"et_pb_contact_form_label\" for=\"et_pb_signup_email\" style=\"display: none;\">Email</label>\n						<input id=\"et_pb_signup_email\" class=\"input\" type=\"text\" placeholder=\"Email\" name=\"et_pb_signup_email\">\n					</p>\n							\n							\n					<p class=\"et_pb_newsletter_button_wrap\">\n						<a class=\"et_pb_newsletter_button et_pb_button\" href=\"#\" data-icon=\"\">\n							<span class=\"et_subscribe_loader\"></span>\n							<span class=\"et_pb_newsletter_button_text\">Subscribe</span>\n						</a>\n					</p>\n							\n						</div>\n						\n						<input type=\"hidden\" value=\"mailchimp\" name=\"et_pb_signup_provider\" />\n						<input type=\"hidden\" value=\"42d4a98af1\" name=\"et_pb_signup_list_id\" />\n						<input type=\"hidden\" value=\"SlavaET\" name=\"et_pb_signup_account_name\" />\n						<input type=\"hidden\" value=\"true\" name=\"et_pb_signup_ip_address\" /><input type=\"hidden\" value=\"acafb339ba08b646e11af2dd76cd8314\" name=\"et_pb_signup_checksum\" />\n					</form>\n				</div>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_with_border et_pb_section et_pb_section_5 et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_7 et_pb_gutters2\">\n				<div class=\"et_pb_column et_pb_column_1_4 et_pb_column_17  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_3  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Address<br />\n1234 Divi St. #1000 San Francisco, CA 94220</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_4 et_pb_column_18  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_4  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Phone<br />\n(255) 352-6258</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_4 et_pb_column_19  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_5  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Email<br />\ninfo@diviyoga.com</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_4 et_pb_column_20  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_6  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Follow Us</div>\n			</div> <!-- .et_pb_text --><ul class=\"et_pb_module et_pb_social_media_follow et_pb_social_media_follow_0 clearfix  et_pb_bg_layout_light\">\n				\n				\n				<li\n            class=\'et_pb_social_media_follow_network_0 et_pb_social_icon et_pb_social_network_link  et-social-facebook et_pb_social_media_follow_network_0\'><a\n              href=\'#\'\n              class=\'icon et_pb_with_border\'\n              title=\'Follow on Facebook\'\n               target=\"_blank\"><span\n                class=\'et_pb_social_media_follow_network_name\'\n                aria-hidden=\'true\'\n                >Follow</span></a></li><li\n            class=\'et_pb_social_media_follow_network_1 et_pb_social_icon et_pb_social_network_link  et-social-twitter et_pb_social_media_follow_network_1\'><a\n              href=\'#\'\n              class=\'icon et_pb_with_border\'\n              title=\'Follow on Twitter\'\n               target=\"_blank\"><span\n                class=\'et_pb_social_media_follow_network_name\'\n                aria-hidden=\'true\'\n                >Follow</span></a></li><li\n            class=\'et_pb_social_media_follow_network_2 et_pb_social_icon et_pb_social_network_link  et-social-youtube et_pb_social_media_follow_network_2\'><a\n              href=\'#\'\n              class=\'icon et_pb_with_border\'\n              title=\'Follow on Youtube\'\n               target=\"_blank\"><span\n                class=\'et_pb_social_media_follow_network_name\'\n                aria-hidden=\'true\'\n                >Follow</span></a></li>\n			</ul> <!-- .et_pb_counters -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --></p>\n"),
("48","6","_et_pb_truncate_post_date","2021-07-13 21:28:51"),
("49","6","_et_builder_version","VB|Divi|4.9.7"),
("50","6","_et_pb_show_page_creation","off"),
("51","6","et_enqueued_post_fonts","a:2:{s:6:\"family\";a:1:{s:11:\"et-gf-heebo\";s:45:\"Heebo:100,200,300,regular,500,600,700,800,900\";}s:6:\"subset\";a:1:{i:0;s:5:\"latin\";}}"),
("52","23","_et_autogenerated_title","0"),
("53","23","_et_default","1"),
("54","23","_et_enabled","1"),
("55","23","_et_header_layout_id","0"),
("56","23","_et_header_layout_enabled","1"),
("57","23","_et_body_layout_id","0"),
("58","23","_et_body_layout_enabled","1"),
("59","23","_et_footer_layout_id","0"),
("60","23","_et_footer_layout_enabled","1"),
("61","24","_et_autogenerated_title","1"),
("62","24","_et_default","0"),
("63","24","_et_enabled","1"),
("64","24","_et_header_layout_id","0"),
("65","24","_et_header_layout_enabled","0"),
("66","24","_et_body_layout_id","0"),
("67","24","_et_body_layout_enabled","1"),
("68","24","_et_footer_layout_id","0"),
("69","24","_et_footer_layout_enabled","0"),
("70","24","_et_use_on","singular:post_type:page:id:6"),
("74","24","_et_theme_builder_marked_as_unused","2021-07-12 04:38:22"),
("75","6","_wp_page_template","default"),
("76","26","_edit_lock","1626065150:1"),
("77","26","_et_pb_use_builder","on"),
("78","26","_et_gb_content_width",""),
("79","26","_edit_last","1"),
("80","26","_et_pb_post_hide_nav","default"),
("81","26","_et_pb_page_layout","et_right_sidebar"),
("82","26","_et_pb_side_nav","off"),
("83","28","_wp_attached_file","2021/07/pr-firm_12.jpg"),
("84","28","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:1121;s:4:\"file\";s:22:\"2021/07/pr-firm_12.jpg\";s:5:\"sizes\";a:10:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"pr-firm_12-214x300.jpg\";s:5:\"width\";i:214;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"pr-firm_12-731x1024.jpg\";s:5:\"width\";i:731;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"pr-firm_12-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"pr-firm_12-768x1076.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1076;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_12-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:22:\"pr-firm_12-800x675.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_12-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_12-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:22:\"pr-firm_12-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:22:\"pr-firm_12-480x673.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:673;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("85","29","_wp_attached_file","2021/07/pr-firm_13.jpg"),
("86","29","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:1121;s:4:\"file\";s:22:\"2021/07/pr-firm_13.jpg\";s:5:\"sizes\";a:10:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"pr-firm_13-214x300.jpg\";s:5:\"width\";i:214;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"pr-firm_13-731x1024.jpg\";s:5:\"width\";i:731;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"pr-firm_13-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"pr-firm_13-768x1076.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1076;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_13-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:22:\"pr-firm_13-800x675.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_13-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_13-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:22:\"pr-firm_13-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:22:\"pr-firm_13-480x673.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:673;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("87","30","_wp_attached_file","2021/07/pr-firm-icon-8-multicolor-2.png"),
("88","30","_wp_attachment_metadata","a:5:{s:5:\"width\";i:48;s:6:\"height\";i:48;s:4:\"file\";s:39:\"2021/07/pr-firm-icon-8-multicolor-2.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("89","31","_wp_attached_file","2021/07/pr-firm-icon-10-multicolor-1.png"),
("90","31","_wp_attachment_metadata","a:5:{s:5:\"width\";i:48;s:6:\"height\";i:48;s:4:\"file\";s:40:\"2021/07/pr-firm-icon-10-multicolor-1.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("91","32","_wp_attached_file","2021/07/pr-firm-icon-7-multicolor-1.png"),
("92","32","_wp_attachment_metadata","a:5:{s:5:\"width\";i:48;s:6:\"height\";i:48;s:4:\"file\";s:39:\"2021/07/pr-firm-icon-7-multicolor-1.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("93","33","_wp_attached_file","2021/07/pr-firm_29.jpg"),
("94","33","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:22:\"2021/07/pr-firm_29.jpg\";s:5:\"sizes\";a:14:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"pr-firm_29-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"pr-firm_29-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"pr-firm_29-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"pr-firm_29-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:24:\"pr-firm_29-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_29-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:23:\"pr-firm_29-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_29-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_29-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:23:\"pr-firm_29-1080x720.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:22:\"pr-firm_29-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:23:\"pr-firm_29-1280x853.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:853;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:22:\"pr-firm_29-980x653.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:653;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:22:\"pr-firm_29-480x320.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("95","34","_wp_attached_file","2021/07/pr-firm-icon-9-dark.png"),
("96","34","_wp_attachment_metadata","a:5:{s:5:\"width\";i:48;s:6:\"height\";i:48;s:4:\"file\";s:31:\"2021/07/pr-firm-icon-9-dark.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("97","35","_wp_attached_file","2021/07/pr-firm-icon-2-dark.png"),
("98","35","_wp_attachment_metadata","a:5:{s:5:\"width\";i:48;s:6:\"height\";i:48;s:4:\"file\";s:31:\"2021/07/pr-firm-icon-2-dark.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("99","36","_wp_attached_file","2021/07/pr-firm-icon-4-dark.png"),
("100","36","_wp_attachment_metadata","a:5:{s:5:\"width\";i:48;s:6:\"height\";i:48;s:4:\"file\";s:31:\"2021/07/pr-firm-icon-4-dark.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("101","26","_et_pb_built_for_post_type","page"),
("102","26","_et_pb_ab_subjects",""),
("103","26","_et_pb_enable_shortcode_tracking",""),
("104","26","_et_pb_ab_current_shortcode","[et_pb_split_track id=\"26\" /]"),
("105","26","_et_pb_custom_css",""),
("106","26","_et_pb_gutter_width","3"),
("107","26","_thumbnail_id","0"),
("108","26","_global_colors_info","{}"),
("109","26","_et_pb_first_image",""),
("110","26","_et_pb_truncate_post","<p><div class=\"et_pb_section et_pb_section_27 et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_36 et_pb_equal_columns et_pb_gutters2\">\n				<div class=\"et_pb_with_border et_pb_column_2_3 et_pb_column et_pb_column_78  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_40  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Divi Pr Firm<br />\nA Strategic Future</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_3 et_pb_column_79  et_pb_css_mix_blend_mode_passthrough et-last-child et_pb_column_empty\">\n				\n				\n				\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class=\"et_pb_with_border et_pb_row et_pb_row_37 et_pb_gutters2\">\n				<div class=\"et_pb_with_border et_pb_column_2_3 et_pb_column et_pb_column_80  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_button_module_wrapper et_pb_button_11_wrapper et_pb_button_alignment_right et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_11 et_pb_bg_layout_light\" href=\"\">Get Started</a>\n			</div>\n			</div> <!-- .et_pb_column --><div class=\"et_pb_with_border et_pb_column_1_3 et_pb_column et_pb_column_81  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_41  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Marketing. Brand. Sales.</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_28 et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_38\">\n				<div class=\"et_pb_column et_pb_column_1_3 et_pb_column_82  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_13  et_pb_text_align_left  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-8-multicolor-2.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-30\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Public & Media Relations</span></h3>\n						<div class=\"et_pb_blurb_description\">Nulla porttitor accumsan tincidunt. Pellentesque in ipsum id orci porta dapibus. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb --><div class=\"et_pb_button_module_wrapper et_pb_button_12_wrapper et_pb_button_alignment_left et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_12 et_pb_bg_layout_light\" href=\"\">Learn More</a>\n			</div>\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_3 et_pb_column_83  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_14  et_pb_text_align_left  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-10-multicolor-1.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-31\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Consumer Content</span></h3>\n						<div class=\"et_pb_blurb_description\">Nulla porttitor accumsan tincidunt. Pellentesque in ipsum id orci porta dapibus. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb --><div class=\"et_pb_button_module_wrapper et_pb_button_13_wrapper et_pb_button_alignment_left et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_13 et_pb_bg_layout_light\" href=\"\">Learn More</a>\n			</div>\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_3 et_pb_column_84  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_15  et_pb_text_align_left  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-7-multicolor-1.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-32\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Social Media</span></h3>\n						<div class=\"et_pb_blurb_description\">Nulla porttitor accumsan tincidunt. Pellentesque in ipsum id orci porta dapibus. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb --><div class=\"et_pb_button_module_wrapper et_pb_button_14_wrapper et_pb_button_alignment_left et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_14 et_pb_bg_layout_light\" href=\"\">Learn More</a>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class=\"et_pb_row et_pb_row_39 et_pb_gutters2\">\n				<div class=\"et_pb_column et_pb_column_1_6 et_pb_column_85  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_16 et_clickable  et_pb_text_align_center  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-6-dark.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-10\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Brand</span></h3>\n						\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_6 et_pb_column_86  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_17 et_clickable  et_pb_text_align_center  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-1-dark.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-14\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Growth</span></h3>\n						\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_6 et_pb_column_87  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_18 et_clickable  et_pb_text_align_center  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-5-dark.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-13\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Launch</span></h3>\n						\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_6 et_pb_column_88  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_19 et_clickable  et_pb_text_align_center  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-9-dark.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-34\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Biz Dev</span></h3>\n						\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_6 et_pb_column_89  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_20 et_clickable  et_pb_text_align_center  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-2-dark.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-35\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Crisis</span></h3>\n						\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_6 et_pb_column_90  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_21  et_pb_text_align_center  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-4-dark.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-36\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Online</span></h3>\n						\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_29 et_pb_equal_columns et_section_specialty\" >\n				\n				\n				\n				<div class=\"et_pb_row et_pb_gutters4\">\n					<div class=\"et_pb_column et_pb_column_1_2 et_pb_column_91   et_pb_specialty_column  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_with_border et_pb_row_inner et_pb_row_inner_1 et_pb_gutters2\">\n				<div class=\"et_pb_column et_pb_column_1_4 et_pb_column_inner et_pb_column_inner_2\">\n				\n				\n				<div class=\"et_pb_module et_pb_image et_pb_image_12\">\n				\n				\n				<span class=\"et_pb_image_wrap \"><img loading=\"lazy\" width=\"800\" height=\"1121\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm_12.jpg\" alt=\"\" title=\"pr-firm_12\" srcset=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm_12.jpg 800w, https://iexperipress.com/wp-content/uploads/2021/07/pr-firm_12-480x673.jpg 480w\" sizes=\"(min-width: 0px) and (max-width: 480px) 480px, (min-width: 481px) 800px, 100vw\" class=\"wp-image-28\" /></span>\n			</div>\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_4 et_pb_column_inner et_pb_column_inner_3 et-last-child\">\n				\n				\n				<div class=\"et_pb_with_border et_pb_module et_pb_image et_pb_image_13\">\n				\n				\n				<span class=\"et_pb_image_wrap has-box-shadow-overlay\"><div class=\"box-shadow-overlay\"></div><img loading=\"lazy\" width=\"800\" height=\"1121\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm_13.jpg\" alt=\"\" title=\"pr-firm_13\" srcset=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm_13.jpg 800w, https://iexperipress.com/wp-content/uploads/2021/07/pr-firm_13-480x673.jpg 480w\" sizes=\"(min-width: 0px) and (max-width: 480px) 480px, (min-width: 481px) 800px, 100vw\" class=\"wp-image-29\" /></span>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row_inner -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_2 et_pb_column_92    et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_42  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">Why Us?<br />\nNulla quis lorem ut libero malesuada feugiat. Curabitur aliquet quam id dui posuere blandit. Nulla quis lorem ut libero malesuada feugiat. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent sapien massa, convallis a pellentesque nec, egestas non nisi. Donec sollicitudin molestie malesuada.</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				</div> <!-- .et_pb_row -->\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_with_border et_pb_section et_pb_section_30 et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_40 et_pb_equal_columns\">\n				<div class=\"et_pb_column et_pb_column_1_2 et_pb_column_93  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_43  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Get In Touch<br />\nGet In Touch</div>\n			</div> <!-- .et_pb_text --><div class=\"et_pb_button_module_wrapper et_pb_button_15_wrapper et_pb_button_alignment_left et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_15 et_pb_bg_layout_light\" href=\"\">Contact us</a>\n			</div>\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_2 et_pb_column_94  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_with_border et_pb_module et_pb_signup_4 et_pb_newsletter_layout_top_bottom et_pb_newsletter et_pb_subscribe clearfix  et_pb_text_align_left et_pb_bg_layout_light et_pb_no_bg et_pb_newsletter_description_no_content\">\n				\n				\n				<div class=\"et_pb_newsletter_description\"><h2 class=\"et_pb_module_header\">Subscribe</h2></div>\n				\n				<div class=\"et_pb_newsletter_form\">\n					<form method=\"post\">\n						<div class=\"et_pb_newsletter_result et_pb_newsletter_error\"></div>\n						<div class=\"et_pb_newsletter_result et_pb_newsletter_success\">\n							<h2>Success!</h2>\n						</div>\n						<div class=\"et_pb_newsletter_fields\">\n							\n							\n							\n					<p class=\"et_pb_newsletter_field et_pb_contact_field_last et_pb_contact_field_last_tablet et_pb_contact_field_last_phone\">\n						<label class=\"et_pb_contact_form_label\" for=\"et_pb_signup_email\" style=\"display: none;\">Email</label>\n						<input id=\"et_pb_signup_email\" class=\"input\" type=\"text\" placeholder=\"Email\" name=\"et_pb_signup_email\">\n					</p>\n							\n							\n					<p class=\"et_pb_newsletter_button_wrap\">\n						<a class=\"et_pb_newsletter_button et_pb_button\" href=\"#\" data-icon=\"\">\n							<span class=\"et_subscribe_loader\"></span>\n							<span class=\"et_pb_newsletter_button_text\">Subscribe</span>\n						</a>\n					</p>\n							\n						</div>\n						\n						<input type=\"hidden\" value=\"mailchimp\" name=\"et_pb_signup_provider\" />\n						<input type=\"hidden\" value=\"42d4a98af1\" name=\"et_pb_signup_list_id\" />\n						<input type=\"hidden\" value=\"SlavaET\" name=\"et_pb_signup_account_name\" />\n						<input type=\"hidden\" value=\"true\" name=\"et_pb_signup_ip_address\" /><input type=\"hidden\" value=\"acafb339ba08b646e11af2dd76cd8314\" name=\"et_pb_signup_checksum\" />\n					</form>\n				</div>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_with_border et_pb_section et_pb_section_31 et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_41 et_pb_gutters2\">\n				<div class=\"et_pb_column et_pb_column_1_4 et_pb_column_95  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_44  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Address<br />\n1234 Divi St. #1000 San Francisco, CA 94220</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_4 et_pb_column_96  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_45  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Phone<br />\n(255) 352-6258</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_4 et_pb_column_97  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_46  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Email<br />\ninfo@diviyoga.com</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_4 et_pb_column_98  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_47  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Follow Us</div>\n			</div> <!-- .et_pb_text --><ul class=\"et_pb_module et_pb_social_media_follow et_pb_social_media_follow_5 clearfix  et_pb_bg_layout_light\">\n				\n				\n				<li\n            class=\'et_pb_social_media_follow_network_15 et_pb_social_icon et_pb_social_network_link  et-social-facebook et_pb_social_media_follow_network_15\'><a\n              href=\'#\'\n              class=\'icon et_pb_with_border\'\n              title=\'Follow on Facebook\'\n               target=\"_blank\"><span\n                class=\'et_pb_social_media_follow_network_name\'\n                aria-hidden=\'true\'\n                >Follow</span></a></li><li\n            class=\'et_pb_social_media_follow_network_16 et_pb_social_icon et_pb_social_network_link  et-social-twitter et_pb_social_media_follow_network_16\'><a\n              href=\'#\'\n              class=\'icon et_pb_with_border\'\n              title=\'Follow on Twitter\'\n               target=\"_blank\"><span\n                class=\'et_pb_social_media_follow_network_name\'\n                aria-hidden=\'true\'\n                >Follow</span></a></li><li\n            class=\'et_pb_social_media_follow_network_17 et_pb_social_icon et_pb_social_network_link  et-social-youtube et_pb_social_media_follow_network_17\'><a\n              href=\'#\'\n              class=\'icon et_pb_with_border\'\n              title=\'Follow on Youtube\'\n               target=\"_blank\"><span\n                class=\'et_pb_social_media_follow_network_name\'\n                aria-hidden=\'true\'\n                >Follow</span></a></li>\n			</ul> <!-- .et_pb_counters -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --></p>\n"),
("111","26","_et_pb_truncate_post_date","2021-07-13 21:28:35"),
("112","26","_et_builder_version","VB|Divi|4.9.7"),
("113","26","_et_pb_show_page_creation","off"),
("114","38","_edit_lock","1626065158:1"),
("115","38","_et_pb_use_builder","on"),
("116","38","_et_gb_content_width",""),
("117","38","_edit_last","1"),
("118","38","_et_pb_post_hide_nav","default"),
("119","38","_et_pb_page_layout","et_right_sidebar"),
("120","38","_et_pb_side_nav","off"),
("121","40","_wp_attached_file","2021/07/pr-firm_14.jpg"),
("122","40","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:1353;s:4:\"file\";s:22:\"2021/07/pr-firm_14.jpg\";s:5:\"sizes\";a:12:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"pr-firm_14-284x300.jpg\";s:5:\"width\";i:284;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"pr-firm_14-969x1024.jpg\";s:5:\"width\";i:969;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"pr-firm_14-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"pr-firm_14-768x812.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:812;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_14-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:23:\"pr-firm_14-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_14-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_14-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:24:\"pr-firm_14-1080x1142.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:1142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:22:\"pr-firm_14-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:23:\"pr-firm_14-980x1036.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:1036;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:22:\"pr-firm_14-480x507.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:507;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("123","41","_wp_attached_file","2021/07/logo_01-1.png"),
("124","41","_wp_attachment_metadata","a:5:{s:5:\"width\";i:226;s:6:\"height\";i:100;s:4:\"file\";s:21:\"2021/07/logo_01-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"logo_01-1-150x100.png\";s:5:\"width\";i:150;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("125","42","_wp_attached_file","2021/07/logo_04-1.png"),
("126","42","_wp_attachment_metadata","a:5:{s:5:\"width\";i:226;s:6:\"height\";i:100;s:4:\"file\";s:21:\"2021/07/logo_04-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"logo_04-1-150x100.png\";s:5:\"width\";i:150;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("127","43","_wp_attached_file","2021/07/logo_03.png"),
("128","43","_wp_attachment_metadata","a:5:{s:5:\"width\";i:226;s:6:\"height\";i:100;s:4:\"file\";s:19:\"2021/07/logo_03.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"logo_03-150x100.png\";s:5:\"width\";i:150;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("129","38","_et_pb_built_for_post_type","page"),
("130","38","_et_pb_ab_subjects",""),
("131","38","_et_pb_enable_shortcode_tracking",""),
("132","38","_et_pb_ab_current_shortcode","[et_pb_split_track id=\"38\" /]"),
("133","38","_et_pb_custom_css",""),
("134","38","_et_pb_gutter_width","3"),
("135","38","_thumbnail_id","0"),
("136","38","_global_colors_info","{}"),
("137","38","_et_pb_first_image",""),
("138","38","_et_pb_truncate_post","<p><div class=\"et_pb_section et_pb_section_20 et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_with_border et_pb_row et_pb_row_29\">\n				<div class=\"et_pb_column et_pb_column_1_2 et_pb_column_61  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_27  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">About Us</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_2 et_pb_column_62  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_28  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Donec velit neque, auctor sit amet aliquam vel, ullamcorper </div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_21 et_pb_equal_columns et_section_specialty\" >\n				\n				\n				\n				<div class=\"et_pb_row et_pb_gutters4\">\n					<div class=\"et_pb_column et_pb_column_1_2 et_pb_column_63   et_pb_specialty_column  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_with_border et_pb_row_inner et_pb_row_inner_0 et_pb_gutters2\">\n				<div class=\"et_pb_column et_pb_column_1_4 et_pb_column_inner et_pb_column_inner_0\">\n				\n				\n				<div class=\"et_pb_module et_pb_image et_pb_image_7\">\n				\n				\n				<span class=\"et_pb_image_wrap \"><img loading=\"lazy\" width=\"800\" height=\"1121\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm_12.jpg\" alt=\"\" title=\"pr-firm_12\" srcset=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm_12.jpg 800w, https://iexperipress.com/wp-content/uploads/2021/07/pr-firm_12-480x673.jpg 480w\" sizes=\"(min-width: 0px) and (max-width: 480px) 480px, (min-width: 481px) 800px, 100vw\" class=\"wp-image-28\" /></span>\n			</div>\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_4 et_pb_column_inner et_pb_column_inner_1 et-last-child\">\n				\n				\n				<div class=\"et_pb_with_border et_pb_module et_pb_image et_pb_image_8\">\n				\n				\n				<span class=\"et_pb_image_wrap has-box-shadow-overlay\"><div class=\"box-shadow-overlay\"></div><img loading=\"lazy\" width=\"800\" height=\"1121\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm_13.jpg\" alt=\"\" title=\"pr-firm_13\" srcset=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm_13.jpg 800w, https://iexperipress.com/wp-content/uploads/2021/07/pr-firm_13-480x673.jpg 480w\" sizes=\"(min-width: 0px) and (max-width: 480px) 480px, (min-width: 481px) 800px, 100vw\" class=\"wp-image-29\" /></span>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row_inner -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_2 et_pb_column_64    et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_29  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">Our Mission<br />\nNulla quis lorem ut libero malesuada feugiat. Curabitur aliquet quam id dui posuere blandit. Nulla quis lorem ut libero malesuada feugiat. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent sapien massa, convallis a pellentesque nec, egestas non nisi. Donec sollicitudin molestie malesuada.</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				</div> <!-- .et_pb_row -->\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_22 et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_30 et_pb_equal_columns\">\n				<div class=\"et_pb_column et_pb_column_1_2 et_pb_column_65  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_30  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">Our Mission<br />\nNulla quis lorem ut libero malesuada feugiat. Curabitur aliquet quam id dui posuere blandit. Nulla quis lorem ut libero malesuada feugiat. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent sapien massa, convallis a pellentesque nec, egestas non nisi. Donec sollicitudin molestie malesuada. <br />\nDonec rutrum congue leo eget malesuada. Vestibulum ac diam sit amet quam vehicula elementum sed sit amet dui. Praesent sapien massa, convallis a pellentesque nec, egestas non nisi. Sed porttitor lectus nibh. Curabitur arcu erat, accumsan id imperdiet et, porttitor at sem. Donec sollicitudin molestie malesuada. Sed porttitor lectus nibh. Nulla quis lorem ut libero malesuada feugiat. Nulla porttitor accumsan tincidunt.<br />\nNulla quis lorem ut libero malesuada feugiat. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec sollicitudin molestie malesuada. Vivamus suscipit tortor eget felis porttitor volutpat. Mauris blandit aliquet elit, eget tincidunt nibh pulvinar a. Vivamus magna justo, lacinia eget consectetur sed, convallis at tellus.</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_2 et_pb_column_66  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_video et_pb_video_1\">\n				\n				\n				<div class=\"et_pb_video_box\"><iframe loading=\"lazy\" title=\"Divi. The Ultimate WordPress Theme And Visual Page Builder\" width=\"1080\" height=\"608\" src=\"https://www.youtube.com/embed/FkQuawiGWUw?feature=oembed\"  allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe></div>\n				<div style=\"background-image:url(https://iexperipress.com/wp-content/uploads/2021/07/pr-firm_14.jpg)\" class=\"et_pb_video_overlay\"><div class=\"et_pb_video_overlay_hover\"><a href=\"#\" class=\"et_pb_video_play\"></a></div></div>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_23 et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_31\">\n				<div class=\"et_pb_column et_pb_column_4_4 et_pb_column_67  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_31  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">Awards &amp; Testimonials</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class=\"et_pb_with_border et_pb_row et_pb_row_32\">\n				<div class=\"et_pb_column et_pb_column_1_3 et_pb_column_68  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_image et_pb_image_9\">\n				\n				\n				<span class=\"et_pb_image_wrap \"><img loading=\"lazy\" width=\"226\" height=\"100\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/logo_01-1.png\" alt=\"\" title=\"logo_01\" class=\"wp-image-41\" /></span>\n			</div><div class=\"et_pb_module et_pb_text et_pb_text_32  et_pb_text_align_center et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">2018<br />\nNulla quis lorem ut libero malesuada feugiat. Curabitur aliquet quam id.</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_3 et_pb_column_69  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_image et_pb_image_10\">\n				\n				\n				<span class=\"et_pb_image_wrap \"><img loading=\"lazy\" width=\"226\" height=\"100\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/logo_04-1.png\" alt=\"\" title=\"logo_04-1\" class=\"wp-image-42\" /></span>\n			</div><div class=\"et_pb_module et_pb_text et_pb_text_33  et_pb_text_align_center et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">2019<br />\nDui posuere blandit. Nulla quis lorem ut libero malesuada feugiat.</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_3 et_pb_column_70  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_image et_pb_image_11\">\n				\n				\n				<span class=\"et_pb_image_wrap \"><img loading=\"lazy\" width=\"226\" height=\"100\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/logo_03.png\" alt=\"\" title=\"logo_03\" class=\"wp-image-43\" /></span>\n			</div><div class=\"et_pb_module et_pb_text et_pb_text_34  et_pb_text_align_center et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">2020<br />\nLorem ipsum dolor sit amet consectetur adipiscing elit.</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_24 et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_with_border et_pb_row et_pb_row_33\">\n				<div class=\"et_pb_column et_pb_column_4_4 et_pb_column_71  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_slider et_pb_slider_0 et_pb_slider_fullwidth_off\">\n				<div class=\"et_pb_slides\">\n					<div class=\"et_pb_slide et_pb_slide_0 et_pb_bg_layout_dark et_pb_media_alignment_center et-pb-active-slide\" data-slide-id=\"et_pb_slide_0\">\n				\n				\n				<div class=\"et_pb_container clearfix\">\n					<div class=\"et_pb_slider_container_inner\">\n						\n						<div class=\"et_pb_slide_description\">\n							<h2 class=\"et_pb_slide_title\">“Donec rutrum congue leo eget malesuada. Donec rutrum congue leo eget malesuada. Vivamus suscipit tortor eget felis”</h2><div class=\"et_pb_slide_content\">John Doe, CEO of Extra Space</div>\n							\n						</div> <!-- .et_pb_slide_description -->\n					</div>\n				</div> <!-- .et_pb_container -->\n				\n			</div> <!-- .et_pb_slide -->\n			<div class=\"et_pb_slide et_pb_slide_1 et_pb_bg_layout_dark et_pb_media_alignment_center\" data-slide-id=\"et_pb_slide_1\">\n				\n				\n				<div class=\"et_pb_container clearfix\">\n					<div class=\"et_pb_slider_container_inner\">\n						\n						<div class=\"et_pb_slide_description\">\n							<h2 class=\"et_pb_slide_title\">\"Vivamus magna justo, lacinia eget consectetur sed, convallis at tellus. Vestibulum ac diam sit amet quam vehicula elementum.\"</h2><div class=\"et_pb_slide_content\">Jane Smith, CEO of Monarch Inc.</div>\n							\n						</div> <!-- .et_pb_slide_description -->\n					</div>\n				</div> <!-- .et_pb_container -->\n				\n			</div> <!-- .et_pb_slide -->\n			<div class=\"et_pb_slide et_pb_slide_2 et_pb_bg_layout_dark et_pb_media_alignment_center\" data-slide-id=\"et_pb_slide_2\">\n				\n				\n				<div class=\"et_pb_container clearfix\">\n					<div class=\"et_pb_slider_container_inner\">\n						\n						<div class=\"et_pb_slide_description\">\n							<h2 class=\"et_pb_slide_title\">\"Vivamus magna justo, lacinia eget consectetur sed, convallis at tellus. Vestibulum ac diam sit amet quam vehicula elementum.\"</h2><div class=\"et_pb_slide_content\">Jane Smith, CEO of Monarch Inc.</div>\n							\n						</div> <!-- .et_pb_slide_description -->\n					</div>\n				</div> <!-- .et_pb_container -->\n				\n			</div> <!-- .et_pb_slide -->\n			\n				</div> <!-- .et_pb_slides -->\n				\n			</div> <!-- .et_pb_slider -->\n			<div class=\"et_pb_button_module_wrapper et_pb_button_9_wrapper et_pb_button_alignment_center et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_9 et_pb_bg_layout_light\" href=\"\">Get Started Today</a>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_with_border et_pb_section et_pb_section_25 et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_34 et_pb_equal_columns\">\n				<div class=\"et_pb_column et_pb_column_1_2 et_pb_column_72  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_35  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Get In Touch<br />\nGet In Touch</div>\n			</div> <!-- .et_pb_text --><div class=\"et_pb_button_module_wrapper et_pb_button_10_wrapper et_pb_button_alignment_left et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_10 et_pb_bg_layout_light\" href=\"\">Contact us</a>\n			</div>\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_2 et_pb_column_73  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_with_border et_pb_module et_pb_signup_3 et_pb_newsletter_layout_top_bottom et_pb_newsletter et_pb_subscribe clearfix  et_pb_text_align_left et_pb_bg_layout_light et_pb_no_bg et_pb_newsletter_description_no_content\">\n				\n				\n				<div class=\"et_pb_newsletter_description\"><h2 class=\"et_pb_module_header\">Subscribe</h2></div>\n				\n				<div class=\"et_pb_newsletter_form\">\n					<form method=\"post\">\n						<div class=\"et_pb_newsletter_result et_pb_newsletter_error\"></div>\n						<div class=\"et_pb_newsletter_result et_pb_newsletter_success\">\n							<h2>Success!</h2>\n						</div>\n						<div class=\"et_pb_newsletter_fields\">\n							\n							\n							\n					<p class=\"et_pb_newsletter_field et_pb_contact_field_last et_pb_contact_field_last_tablet et_pb_contact_field_last_phone\">\n						<label class=\"et_pb_contact_form_label\" for=\"et_pb_signup_email\" style=\"display: none;\">Email</label>\n						<input id=\"et_pb_signup_email\" class=\"input\" type=\"text\" placeholder=\"Email\" name=\"et_pb_signup_email\">\n					</p>\n							\n							\n					<p class=\"et_pb_newsletter_button_wrap\">\n						<a class=\"et_pb_newsletter_button et_pb_button\" href=\"#\" data-icon=\"\">\n							<span class=\"et_subscribe_loader\"></span>\n							<span class=\"et_pb_newsletter_button_text\">Subscribe</span>\n						</a>\n					</p>\n							\n						</div>\n						\n						<input type=\"hidden\" value=\"mailchimp\" name=\"et_pb_signup_provider\" />\n						<input type=\"hidden\" value=\"42d4a98af1\" name=\"et_pb_signup_list_id\" />\n						<input type=\"hidden\" value=\"SlavaET\" name=\"et_pb_signup_account_name\" />\n						<input type=\"hidden\" value=\"true\" name=\"et_pb_signup_ip_address\" /><input type=\"hidden\" value=\"acafb339ba08b646e11af2dd76cd8314\" name=\"et_pb_signup_checksum\" />\n					</form>\n				</div>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_with_border et_pb_section et_pb_section_26 et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_35 et_pb_gutters2\">\n				<div class=\"et_pb_column et_pb_column_1_4 et_pb_column_74  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_36  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Address<br />\n1234 Divi St. #1000 San Francisco, CA 94220</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_4 et_pb_column_75  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_37  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Phone<br />\n(255) 352-6258</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_4 et_pb_column_76  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_38  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Email<br />\ninfo@diviyoga.com</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_4 et_pb_column_77  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_39  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Follow Us</div>\n			</div> <!-- .et_pb_text --><ul class=\"et_pb_module et_pb_social_media_follow et_pb_social_media_follow_4 clearfix  et_pb_bg_layout_light\">\n				\n				\n				<li\n            class=\'et_pb_social_media_follow_network_12 et_pb_social_icon et_pb_social_network_link  et-social-facebook et_pb_social_media_follow_network_12\'><a\n              href=\'#\'\n              class=\'icon et_pb_with_border\'\n              title=\'Follow on Facebook\'\n               target=\"_blank\"><span\n                class=\'et_pb_social_media_follow_network_name\'\n                aria-hidden=\'true\'\n                >Follow</span></a></li><li\n            class=\'et_pb_social_media_follow_network_13 et_pb_social_icon et_pb_social_network_link  et-social-twitter et_pb_social_media_follow_network_13\'><a\n              href=\'#\'\n              class=\'icon et_pb_with_border\'\n              title=\'Follow on Twitter\'\n               target=\"_blank\"><span\n                class=\'et_pb_social_media_follow_network_name\'\n                aria-hidden=\'true\'\n                >Follow</span></a></li><li\n            class=\'et_pb_social_media_follow_network_14 et_pb_social_icon et_pb_social_network_link  et-social-youtube et_pb_social_media_follow_network_14\'><a\n              href=\'#\'\n              class=\'icon et_pb_with_border\'\n              title=\'Follow on Youtube\'\n               target=\"_blank\"><span\n                class=\'et_pb_social_media_follow_network_name\'\n                aria-hidden=\'true\'\n                >Follow</span></a></li>\n			</ul> <!-- .et_pb_counters -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --></p>\n"),
("139","38","_et_pb_truncate_post_date","2021-07-13 21:28:34"),
("140","38","_et_builder_version","VB|Divi|4.9.7"),
("141","38","_et_pb_show_page_creation","off"),
("148","26","_wp_page_template","default"),
("149","38","_wp_page_template","default"),
("150","47","_edit_lock","1626065182:1"),
("151","47","_et_pb_use_builder","on"),
("152","47","_et_gb_content_width",""),
("153","47","_edit_last","1"),
("154","47","_et_pb_post_hide_nav","default"),
("155","47","_et_pb_page_layout","et_right_sidebar"),
("156","47","_et_pb_side_nav","off"),
("157","49","_wp_attached_file","2021/07/pr-firm_27.jpg"),
("158","49","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:943;s:4:\"file\";s:22:\"2021/07/pr-firm_27.jpg\";s:5:\"sizes\";a:14:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"pr-firm_27-300x147.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"pr-firm_27-1024x503.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:503;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"pr-firm_27-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"pr-firm_27-768x377.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:377;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:23:\"pr-firm_27-1536x754.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:754;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_27-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:23:\"pr-firm_27-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_27-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_27-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:23:\"pr-firm_27-1080x530.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:530;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:22:\"pr-firm_27-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:23:\"pr-firm_27-1280x629.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:629;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:22:\"pr-firm_27-980x481.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:481;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:22:\"pr-firm_27-480x236.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:236;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("159","47","_et_pb_built_for_post_type","page"),
("160","47","_et_pb_ab_subjects",""),
("161","47","_et_pb_enable_shortcode_tracking",""),
("162","47","_et_pb_ab_current_shortcode","[et_pb_split_track id=\"47\" /]"),
("163","47","_et_pb_custom_css",""),
("164","47","_et_pb_gutter_width","3"),
("165","47","_thumbnail_id","0"),
("166","47","_global_colors_info","{}"),
("167","47","_et_pb_first_image",""),
("168","47","_et_pb_truncate_post","<p><div class=\"et_pb_section et_pb_section_14 et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_with_border et_pb_row et_pb_row_22\">\n				<div class=\"et_pb_column et_pb_column_1_2 et_pb_column_46  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_17  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Contact</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_2 et_pb_column_47  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<ul class=\"et_pb_module et_pb_social_media_follow et_pb_social_media_follow_2 clearfix  et_pb_text_align_right et_pb_bg_layout_light\">\n				\n				\n				<li\n            class=\'et_pb_social_media_follow_network_6 et_pb_social_icon et_pb_social_network_link  et-social-facebook et_pb_social_media_follow_network_6\'><a\n              href=\'#\'\n              class=\'icon et_pb_with_border\'\n              title=\'Follow on Facebook\'\n               target=\"_blank\"><span\n                class=\'et_pb_social_media_follow_network_name\'\n                aria-hidden=\'true\'\n                >Follow</span></a></li><li\n            class=\'et_pb_social_media_follow_network_7 et_pb_social_icon et_pb_social_network_link  et-social-twitter et_pb_social_media_follow_network_7\'><a\n              href=\'#\'\n              class=\'icon et_pb_with_border\'\n              title=\'Follow on Twitter\'\n               target=\"_blank\"><span\n                class=\'et_pb_social_media_follow_network_name\'\n                aria-hidden=\'true\'\n                >Follow</span></a></li><li\n            class=\'et_pb_social_media_follow_network_8 et_pb_social_icon et_pb_social_network_link  et-social-youtube et_pb_social_media_follow_network_8\'><a\n              href=\'#\'\n              class=\'icon et_pb_with_border\'\n              title=\'Follow on Youtube\'\n               target=\"_blank\"><span\n                class=\'et_pb_social_media_follow_network_name\'\n                aria-hidden=\'true\'\n                >Follow</span></a></li>\n			</ul> <!-- .et_pb_counters -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class=\"et_pb_row et_pb_row_23\">\n				<div class=\"et_pb_column et_pb_column_4_4 et_pb_column_48  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_18  et_pb_text_align_right et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">Opening hours Monday &#8211; Friday 08.00 &#8211; 16.00</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_15 et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_with_border et_pb_row et_pb_row_24 et_pb_equal_columns et_pb_gutters2\">\n				<div class=\"et_pb_column et_pb_column_1_3 et_pb_column_49  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_19  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">Phone<br />\n(255) 352-6258</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_3 et_pb_column_50  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_20  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">Address<br />\n1234 Divi St. #1000 San Francisco, CA 94220</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_3 et_pb_column_51  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_21  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">Email<br />\ninfo@diviprfirm.com</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_16 et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_25 et_pb_equal_columns et_pb_gutters2\">\n				<div class=\"et_pb_column et_pb_column_3_4 et_pb_column_52  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				\n			<div id=\"et_pb_contact_form_0\" class=\"et_pb_with_border et_pb_module et_pb_contact_form_0 et_pb_contact_form_container clearfix\" data-form_unique_num=\"0\">\n				\n				\n				<h2 class=\"et_pb_contact_main_title\">Send Us A Message</h2>\n				<div class=\"et-pb-contact-message\"></div>\n				\n				<div class=\"et_pb_contact\">\n					<form class=\"et_pb_contact_form clearfix\" method=\"post\" action=\"https://iexperipress.com/?=Search&#038;s=1\">\n						<p class=\"et_pb_contact_field et_pb_contact_field_0 et_pb_contact_field_half\" data-id=\"name\" data-type=\"input\">\n				\n				\n				<label for=\"et_pb_contact_name_0\" class=\"et_pb_contact_form_label\">Name</label>\n				<input type=\"text\" id=\"et_pb_contact_name_0\" class=\"input\" value=\"\" name=\"et_pb_contact_name_0\" data-required_mark=\"required\" data-field_type=\"input\" data-original_id=\"name\" placeholder=\"Name\">\n			</p><p class=\"et_pb_contact_field et_pb_contact_field_1 et_pb_contact_field_half et_pb_contact_field_last\" data-id=\"email\" data-type=\"email\">\n				\n				\n				<label for=\"et_pb_contact_email_0\" class=\"et_pb_contact_form_label\">Email Address</label>\n				<input type=\"text\" id=\"et_pb_contact_email_0\" class=\"input\" value=\"\" name=\"et_pb_contact_email_0\" data-required_mark=\"required\" data-field_type=\"email\" data-original_id=\"email\" placeholder=\"Email Address\">\n			</p><p class=\"et_pb_contact_field et_pb_contact_field_2 et_pb_contact_field_last\" data-id=\"message\" data-type=\"text\">\n				\n				\n				<label for=\"et_pb_contact_message_0\" class=\"et_pb_contact_form_label\">Message</label>\n				<textarea name=\"et_pb_contact_message_0\" id=\"et_pb_contact_message_0\" class=\"et_pb_contact_message input\" data-required_mark=\"required\" data-field_type=\"text\" data-original_id=\"message\" placeholder=\"Message\"></textarea>\n			</p>\n						<input type=\"hidden\" value=\"et_contact_proccess\" name=\"et_pb_contactform_submit_0\"/>\n						<div class=\"et_contact_bottom_container\">\n							\n							<button type=\"submit\" name=\"et_builder_submit_button\" class=\"et_pb_contact_submit et_pb_button\">Submit</button>\n						</div>\n						<input type=\"hidden\" id=\"_wpnonce-et-pb-contact-form-submitted-0\" name=\"_wpnonce-et-pb-contact-form-submitted-0\" value=\"451a25b09d\" /><input type=\"hidden\" name=\"_wp_http_referer\" value=\"/?=Search&amp;s=1\" />\n					</form>\n				</div> <!-- .et_pb_contact -->\n			</div> <!-- .et_pb_contact_form_container -->\n			\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_4 et_pb_column_53  et_pb_css_mix_blend_mode_passthrough et-last-child et_pb_column_empty\">\n				\n				\n				\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_17 et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_26 et_pb_equal_columns et_pb_gutters2\">\n				<div class=\"et_pb_column et_pb_column_4_4 et_pb_column_54  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_map_0 et_pb_map_container\" data-grayscale=\"100\">\n				\n				\n				<div class=\"et_pb_map\" data-center-lat=\"37.7749295\" data-center-lng=\"-122.4194155\" data-zoom=\"18\" data-mouse-wheel=\"off\" data-mobile-dragging=\"on\"></div>\n				<div class=\"et_pb_map_pin\" data-lat=\"37.7749295\" data-lng=\"-122.4194155\" data-title=\"\">\n				\n				\n			</div>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_with_border et_pb_section et_pb_section_18 et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_27 et_pb_equal_columns\">\n				<div class=\"et_pb_column et_pb_column_1_2 et_pb_column_55  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_22  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Get In Touch<br />\nGet In Touch</div>\n			</div> <!-- .et_pb_text --><div class=\"et_pb_button_module_wrapper et_pb_button_8_wrapper et_pb_button_alignment_left et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_8 et_pb_bg_layout_light\" href=\"\">Contact us</a>\n			</div>\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_2 et_pb_column_56  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_with_border et_pb_module et_pb_signup_2 et_pb_newsletter_layout_top_bottom et_pb_newsletter et_pb_subscribe clearfix  et_pb_text_align_left et_pb_bg_layout_light et_pb_no_bg et_pb_newsletter_description_no_content\">\n				\n				\n				<div class=\"et_pb_newsletter_description\"><h2 class=\"et_pb_module_header\">Subscribe</h2></div>\n				\n				<div class=\"et_pb_newsletter_form\">\n					<form method=\"post\">\n						<div class=\"et_pb_newsletter_result et_pb_newsletter_error\"></div>\n						<div class=\"et_pb_newsletter_result et_pb_newsletter_success\">\n							<h2>Success!</h2>\n						</div>\n						<div class=\"et_pb_newsletter_fields\">\n							\n							\n							\n					<p class=\"et_pb_newsletter_field et_pb_contact_field_last et_pb_contact_field_last_tablet et_pb_contact_field_last_phone\">\n						<label class=\"et_pb_contact_form_label\" for=\"et_pb_signup_email\" style=\"display: none;\">Email</label>\n						<input id=\"et_pb_signup_email\" class=\"input\" type=\"text\" placeholder=\"Email\" name=\"et_pb_signup_email\">\n					</p>\n							\n							\n					<p class=\"et_pb_newsletter_button_wrap\">\n						<a class=\"et_pb_newsletter_button et_pb_button\" href=\"#\" data-icon=\"\">\n							<span class=\"et_subscribe_loader\"></span>\n							<span class=\"et_pb_newsletter_button_text\">Subscribe</span>\n						</a>\n					</p>\n							\n						</div>\n						\n						<input type=\"hidden\" value=\"mailchimp\" name=\"et_pb_signup_provider\" />\n						<input type=\"hidden\" value=\"42d4a98af1\" name=\"et_pb_signup_list_id\" />\n						<input type=\"hidden\" value=\"SlavaET\" name=\"et_pb_signup_account_name\" />\n						<input type=\"hidden\" value=\"true\" name=\"et_pb_signup_ip_address\" /><input type=\"hidden\" value=\"acafb339ba08b646e11af2dd76cd8314\" name=\"et_pb_signup_checksum\" />\n					</form>\n				</div>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_with_border et_pb_section et_pb_section_19 et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_28 et_pb_gutters2\">\n				<div class=\"et_pb_column et_pb_column_1_4 et_pb_column_57  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_23  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Address<br />\n1234 Divi St. #1000 San Francisco, CA 94220</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_4 et_pb_column_58  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_24  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Phone<br />\n(255) 352-6258</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_4 et_pb_column_59  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_25  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Email<br />\ninfo@diviyoga.com</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_4 et_pb_column_60  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_26  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Follow Us</div>\n			</div> <!-- .et_pb_text --><ul class=\"et_pb_module et_pb_social_media_follow et_pb_social_media_follow_3 clearfix  et_pb_bg_layout_light\">\n				\n				\n				<li\n            class=\'et_pb_social_media_follow_network_9 et_pb_social_icon et_pb_social_network_link  et-social-facebook et_pb_social_media_follow_network_9\'><a\n              href=\'#\'\n              class=\'icon et_pb_with_border\'\n              title=\'Follow on Facebook\'\n               target=\"_blank\"><span\n                class=\'et_pb_social_media_follow_network_name\'\n                aria-hidden=\'true\'\n                >Follow</span></a></li><li\n            class=\'et_pb_social_media_follow_network_10 et_pb_social_icon et_pb_social_network_link  et-social-twitter et_pb_social_media_follow_network_10\'><a\n              href=\'#\'\n              class=\'icon et_pb_with_border\'\n              title=\'Follow on Twitter\'\n               target=\"_blank\"><span\n                class=\'et_pb_social_media_follow_network_name\'\n                aria-hidden=\'true\'\n                >Follow</span></a></li><li\n            class=\'et_pb_social_media_follow_network_11 et_pb_social_icon et_pb_social_network_link  et-social-youtube et_pb_social_media_follow_network_11\'><a\n              href=\'#\'\n              class=\'icon et_pb_with_border\'\n              title=\'Follow on Youtube\'\n               target=\"_blank\"><span\n                class=\'et_pb_social_media_follow_network_name\'\n                aria-hidden=\'true\'\n                >Follow</span></a></li>\n			</ul> <!-- .et_pb_counters -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --></p>\n"),
("169","47","_et_pb_truncate_post_date","2021-07-13 21:28:34"),
("170","47","_et_builder_version","VB|Divi|4.9.7"),
("171","47","_et_pb_show_page_creation","off"),
("172","51","_edit_lock","1626065454:1"),
("173","51","_edit_last","1"),
("174","51","_et_pb_post_hide_nav","default"),
("175","51","_et_pb_page_layout","et_right_sidebar"),
("176","51","_et_pb_side_nav","off"),
("177","51","_et_pb_use_builder","on"),
("178","51","_et_gb_content_width",""),
("179","53","_wp_attached_file","2021/07/pr-firm_25.jpg"),
("180","53","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:958;s:4:\"file\";s:22:\"2021/07/pr-firm_25.jpg\";s:5:\"sizes\";a:14:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"pr-firm_25-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"pr-firm_25-1024x511.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:511;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"pr-firm_25-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"pr-firm_25-768x383.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:383;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:23:\"pr-firm_25-1536x766.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:766;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_25-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:23:\"pr-firm_25-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_25-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_25-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:23:\"pr-firm_25-1080x539.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:539;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:22:\"pr-firm_25-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:23:\"pr-firm_25-1280x639.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:639;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:22:\"pr-firm_25-980x489.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:489;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:22:\"pr-firm_25-480x240.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("181","51","_et_pb_built_for_post_type","page"),
("182","51","_et_pb_ab_subjects",""),
("183","51","_et_pb_enable_shortcode_tracking",""),
("184","51","_et_pb_ab_current_shortcode","[et_pb_split_track id=\"51\" /]"),
("185","51","_et_pb_custom_css",""),
("186","51","_et_pb_gutter_width","3"),
("187","51","_thumbnail_id","0"),
("188","51","_global_colors_info","{}"),
("189","51","_et_pb_first_image",""),
("190","51","_et_pb_truncate_post","<p><div class=\"et_pb_section et_pb_section_10 et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_with_border et_pb_row et_pb_row_17 et_pb_equal_columns\">\n				<div class=\"et_pb_column et_pb_column_1_2 et_pb_column_35  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_11  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">News</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_2 et_pb_column_36  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_button_module_wrapper et_pb_button_6_wrapper et_pb_button_alignment_right et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_6 et_pb_bg_layout_light\" href=\"\">Subscribe</a>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_11 et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_18 et_pb_equal_columns et_pb_gutters1\">\n				<div class=\"et_pb_column et_pb_column_3_5 et_pb_column_37  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_post_slider et_pb_post_slider_0 et_pb_slider et_pb_post_slider_image_background et_pb_slider_fullwidth_off et_pb_slider_with_overlay\">\n				\n				\n				<div class=\"et_pb_slides\">\n									<div class=\"et_pb_slide et_pb_slide_with_no_image et_pb_bg_layout_light et_pb_post_slide-1\"  >\n													<div class=\"et_pb_slide_overlay_container\"></div>\n								<div class=\"et_pb_container clearfix\">\n					<div class=\"et_pb_slider_container_inner\">\n												<div class=\"et_pb_slide_description\">\n															<h2 class=\"et_pb_slide_title\"><a href=\"https://iexperipress.com/hello-world/\">Hello world!</a></h2>\n								<div class=\"et_pb_slide_content\n																\">\n									<div>Welcome to WordPress. This is your first post. Edit or delete it, then start writing!</div>								</div>\n														<div class=\"et_pb_button_wrapper\"><a class=\"et_pb_button et_pb_more_button\" href=\"https://iexperipress.com/hello-world/\">Read More</a></div>						</div> <!-- .et_pb_slide_description -->\n											</div>\n				</div> <!-- .et_pb_container -->\n			</div> <!-- .et_pb_slide -->\n				\n				</div> <!-- .et_pb_slides -->\n				\n			</div> <!-- .et_pb_slider -->\n			\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_2_5 et_pb_column_38  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_with_border et_pb_module et_pb_blog_1 et_pb_posts et_pb_bg_layout_light \">\n				\n				\n				<div class=\"et_pb_ajax_pagination_container\">\n					\n			<article id=\"post-1\" class=\"et_pb_post clearfix et_pb_no_thumb et_pb_blog_item_1_0 post-1 post type-post status-publish format-standard hentry category-uncategorized\">\n\n				\n														<h2 class=\"entry-title\"><a href=\"https://iexperipress.com/hello-world/\">Hello world!</a></h2>\n				\n					<div class=\"post-content\"><div class=\"post-content-inner\"><p>Welcome to WordPress. This is your first post. Edit or delete it, then start writing!</p>\n</div></div>			\n			</article> <!-- .et_pb_post -->\n				\n				</div>\n				</div> <!-- .et_pb_posts --> \n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class=\"et_pb_row et_pb_row_19\">\n				<div class=\"et_pb_column et_pb_column_4_4 et_pb_column_39  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_with_border et_pb_module et_pb_blog_2 et_clickable et_pb_blog_grid_wrapper et_pb_bg_layout_light\">\n					<div class=\"et_pb_blog_grid clearfix \">\n					\n					\n					<div class=\"et_pb_ajax_pagination_container\">\n						<div class=\"et_pb_salvattore_content\" data-columns>\n			<article id=\"post-1\" class=\"et_pb_post clearfix et_pb_no_thumb et_pb_has_overlay et_pb_blog_item_2_0 post-1 post type-post status-publish format-standard hentry category-uncategorized\">\n\n				\n														<h2 class=\"entry-title\"><a href=\"https://iexperipress.com/hello-world/\">Hello world!</a></h2>\n				\n					<div class=\"post-content\"><div class=\"post-content-inner\"><p>Welcome to WordPress. This is your first post. Edit or delete it, then start writing!</p>\n</div></div>			\n			</article> <!-- .et_pb_post -->\n				</div><!-- .et_pb_salvattore_content --><div><div class=\"pagination clearfix\">\n	<div class=\"alignleft\"></div>\n	<div class=\"alignright\"></div>\n</div></div></div> <!-- .et_pb_posts -->\n					</div>\n					 \n				</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_with_border et_pb_section et_pb_section_12 et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_20 et_pb_equal_columns\">\n				<div class=\"et_pb_column et_pb_column_1_2 et_pb_column_40  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_12  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Get In Touch<br />\nGet In Touch</div>\n			</div> <!-- .et_pb_text --><div class=\"et_pb_button_module_wrapper et_pb_button_7_wrapper et_pb_button_alignment_left et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_7 et_pb_bg_layout_light\" href=\"\">Contact us</a>\n			</div>\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_2 et_pb_column_41  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_with_border et_pb_module et_pb_signup_1 et_pb_newsletter_layout_top_bottom et_pb_newsletter et_pb_subscribe clearfix  et_pb_text_align_left et_pb_bg_layout_light et_pb_no_bg et_pb_newsletter_description_no_content\">\n				\n				\n				<div class=\"et_pb_newsletter_description\"><h2 class=\"et_pb_module_header\">Subscribe</h2></div>\n				\n				<div class=\"et_pb_newsletter_form\">\n					<form method=\"post\">\n						<div class=\"et_pb_newsletter_result et_pb_newsletter_error\"></div>\n						<div class=\"et_pb_newsletter_result et_pb_newsletter_success\">\n							<h2>Success!</h2>\n						</div>\n						<div class=\"et_pb_newsletter_fields\">\n							\n							\n							\n					<p class=\"et_pb_newsletter_field et_pb_contact_field_last et_pb_contact_field_last_tablet et_pb_contact_field_last_phone\">\n						<label class=\"et_pb_contact_form_label\" for=\"et_pb_signup_email\" style=\"display: none;\">Email</label>\n						<input id=\"et_pb_signup_email\" class=\"input\" type=\"text\" placeholder=\"Email\" name=\"et_pb_signup_email\">\n					</p>\n							\n							\n					<p class=\"et_pb_newsletter_button_wrap\">\n						<a class=\"et_pb_newsletter_button et_pb_button\" href=\"#\" data-icon=\"\">\n							<span class=\"et_subscribe_loader\"></span>\n							<span class=\"et_pb_newsletter_button_text\">Subscribe</span>\n						</a>\n					</p>\n							\n						</div>\n						\n						<input type=\"hidden\" value=\"mailchimp\" name=\"et_pb_signup_provider\" />\n						<input type=\"hidden\" value=\"42d4a98af1\" name=\"et_pb_signup_list_id\" />\n						<input type=\"hidden\" value=\"SlavaET\" name=\"et_pb_signup_account_name\" />\n						<input type=\"hidden\" value=\"true\" name=\"et_pb_signup_ip_address\" /><input type=\"hidden\" value=\"acafb339ba08b646e11af2dd76cd8314\" name=\"et_pb_signup_checksum\" />\n					</form>\n				</div>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_with_border et_pb_section et_pb_section_13 et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_21 et_pb_gutters2\">\n				<div class=\"et_pb_column et_pb_column_1_4 et_pb_column_42  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_13  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Address<br />\n1234 Divi St. #1000 San Francisco, CA 94220</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_4 et_pb_column_43  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_14  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Phone<br />\n(255) 352-6258</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_4 et_pb_column_44  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_15  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Email<br />\ninfo@diviyoga.com</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_4 et_pb_column_45  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_16  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Follow Us</div>\n			</div> <!-- .et_pb_text --><ul class=\"et_pb_module et_pb_social_media_follow et_pb_social_media_follow_1 clearfix  et_pb_bg_layout_light\">\n				\n				\n				<li\n            class=\'et_pb_social_media_follow_network_3 et_pb_social_icon et_pb_social_network_link  et-social-facebook et_pb_social_media_follow_network_3\'><a\n              href=\'#\'\n              class=\'icon et_pb_with_border\'\n              title=\'Follow on Facebook\'\n               target=\"_blank\"><span\n                class=\'et_pb_social_media_follow_network_name\'\n                aria-hidden=\'true\'\n                >Follow</span></a></li><li\n            class=\'et_pb_social_media_follow_network_4 et_pb_social_icon et_pb_social_network_link  et-social-twitter et_pb_social_media_follow_network_4\'><a\n              href=\'#\'\n              class=\'icon et_pb_with_border\'\n              title=\'Follow on Twitter\'\n               target=\"_blank\"><span\n                class=\'et_pb_social_media_follow_network_name\'\n                aria-hidden=\'true\'\n                >Follow</span></a></li><li\n            class=\'et_pb_social_media_follow_network_5 et_pb_social_icon et_pb_social_network_link  et-social-youtube et_pb_social_media_follow_network_5\'><a\n              href=\'#\'\n              class=\'icon et_pb_with_border\'\n              title=\'Follow on Youtube\'\n               target=\"_blank\"><span\n                class=\'et_pb_social_media_follow_network_name\'\n                aria-hidden=\'true\'\n                >Follow</span></a></li>\n			</ul> <!-- .et_pb_counters -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --></p>\n"),
("191","51","_et_pb_truncate_post_date","2021-07-13 21:28:33"),
("192","51","_et_builder_version","VB|Divi|4.9.7"),
("193","51","_et_pb_show_page_creation","off"),
("194","56","_edit_lock","1626065565:1"),
("195","56","_et_pb_use_builder","on"),
("196","56","_et_gb_content_width",""),
("197","56","_edit_last","1"),
("198","56","_et_pb_post_hide_nav","default"),
("199","56","_et_pb_page_layout","et_right_sidebar"),
("200","56","_et_pb_side_nav","off"),
("201","58","_wp_attached_file","2021/07/pr-firm_24.jpg"),
("202","58","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:984;s:4:\"file\";s:22:\"2021/07/pr-firm_24.jpg\";s:5:\"sizes\";a:14:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"pr-firm_24-300x154.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:154;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"pr-firm_24-1024x525.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:525;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"pr-firm_24-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"pr-firm_24-768x394.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:394;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:23:\"pr-firm_24-1536x787.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:787;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_24-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:23:\"pr-firm_24-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_24-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_24-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:23:\"pr-firm_24-1080x554.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:554;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:22:\"pr-firm_24-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:23:\"pr-firm_24-1280x656.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:656;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:22:\"pr-firm_24-980x502.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:502;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:22:\"pr-firm_24-480x246.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");

INSERT IGNORE INTO `wp13_postmeta` VALUES 
("203","59","_wp_attached_file","2021/07/pr-firm_02.jpg"),
("204","59","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:996;s:4:\"file\";s:22:\"2021/07/pr-firm_02.jpg\";s:5:\"sizes\";a:12:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"pr-firm_02-300x233.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:233;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"pr-firm_02-1024x797.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:797;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"pr-firm_02-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"pr-firm_02-768x598.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:598;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_02-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:23:\"pr-firm_02-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_02-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_02-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:23:\"pr-firm_02-1080x840.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:840;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:22:\"pr-firm_02-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:22:\"pr-firm_02-980x763.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:763;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:22:\"pr-firm_02-480x374.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:374;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("205","60","_wp_attached_file","2021/07/pr-firm_04.jpg"),
("206","60","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:978;s:4:\"file\";s:22:\"2021/07/pr-firm_04.jpg\";s:5:\"sizes\";a:14:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"pr-firm_04-300x153.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:153;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"pr-firm_04-1024x522.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:522;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"pr-firm_04-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"pr-firm_04-768x391.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:391;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:23:\"pr-firm_04-1536x782.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_04-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:23:\"pr-firm_04-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_04-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:22:\"pr-firm_04-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:23:\"pr-firm_04-1080x550.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:550;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:22:\"pr-firm_04-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:23:\"pr-firm_04-1280x652.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:652;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:22:\"pr-firm_04-980x499.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:499;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:22:\"pr-firm_04-480x245.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("207","61","_wp_attached_file","2021/07/logo_08.png"),
("208","61","_wp_attachment_metadata","a:5:{s:5:\"width\";i:226;s:6:\"height\";i:100;s:4:\"file\";s:19:\"2021/07/logo_08.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"logo_08-150x100.png\";s:5:\"width\";i:150;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("209","62","_wp_attached_file","2021/07/logo_04.png"),
("210","62","_wp_attachment_metadata","a:5:{s:5:\"width\";i:226;s:6:\"height\";i:100;s:4:\"file\";s:19:\"2021/07/logo_04.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"logo_04-150x100.png\";s:5:\"width\";i:150;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("211","63","_wp_attached_file","2021/07/logo_02.png"),
("212","63","_wp_attachment_metadata","a:5:{s:5:\"width\";i:226;s:6:\"height\";i:100;s:4:\"file\";s:19:\"2021/07/logo_02.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"logo_02-150x100.png\";s:5:\"width\";i:150;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("213","64","_wp_attached_file","2021/07/logo_01.png"),
("214","64","_wp_attachment_metadata","a:5:{s:5:\"width\";i:226;s:6:\"height\";i:100;s:4:\"file\";s:19:\"2021/07/logo_01.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"logo_01-150x100.png\";s:5:\"width\";i:150;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("215","65","_wp_attached_file","2021/07/logo_05.png"),
("216","65","_wp_attachment_metadata","a:5:{s:5:\"width\";i:226;s:6:\"height\";i:100;s:4:\"file\";s:19:\"2021/07/logo_05.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"logo_05-150x100.png\";s:5:\"width\";i:150;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("217","66","_wp_attached_file","2021/07/logo_06.png"),
("218","66","_wp_attachment_metadata","a:5:{s:5:\"width\";i:226;s:6:\"height\";i:100;s:4:\"file\";s:19:\"2021/07/logo_06.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"logo_06-150x100.png\";s:5:\"width\";i:150;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}"),
("219","56","_et_pb_built_for_post_type","page"),
("220","56","_et_pb_ab_subjects",""),
("221","56","_et_pb_enable_shortcode_tracking",""),
("222","56","_et_pb_ab_current_shortcode","[et_pb_split_track id=\"56\" /]"),
("223","56","_et_pb_custom_css",""),
("224","56","_et_pb_gutter_width","3"),
("225","56","_thumbnail_id","0"),
("226","56","_global_colors_info","{}"),
("227","56","_et_pb_first_image",""),
("228","56","_et_pb_truncate_post","<p><div class=\"et_pb_section et_pb_section_0 et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_with_border et_pb_row et_pb_row_0\">\n				<div class=\"et_pb_column et_pb_column_4_4 et_pb_column_0  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_0  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Divi Pr Firm<br />\nA Strategic Future<br />\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla quis lorem ut libero malesuada feugiat.</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class=\"et_pb_with_border et_pb_row et_pb_row_1\">\n				<div class=\"et_pb_column et_pb_column_4_4 et_pb_column_1  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_button_module_wrapper et_pb_button_0_wrapper et_pb_button_alignment_right et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_0 et_pb_bg_layout_light\" href=\"\">Schedule a Call</a>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_1 et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_2 et_pb_gutters2\">\n				<div class=\"et_pb_column et_pb_column_1_3 et_pb_column_2  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_0  et_pb_text_align_left  et_pb_blurb_position_top et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-8-multicolor-2.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-30\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Public & Media Relations</span></h3>\n						<div class=\"et_pb_blurb_description\">Nulla porttitor accumsan tincidunt. Pellentesque in ipsum id orci porta dapibus. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb --><div class=\"et_pb_button_module_wrapper et_pb_button_1_wrapper et_pb_button_alignment_left et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_1 et_pb_bg_layout_light\" href=\"\">Learn More</a>\n			</div>\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_3 et_pb_column_3  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_1  et_pb_text_align_left  et_pb_blurb_position_top et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-10-multicolor-1.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-31\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Consumer Content</span></h3>\n						<div class=\"et_pb_blurb_description\">Nulla porttitor accumsan tincidunt. Pellentesque in ipsum id orci porta dapibus. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb --><div class=\"et_pb_button_module_wrapper et_pb_button_2_wrapper et_pb_button_alignment_left et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_2 et_pb_bg_layout_light\" href=\"\">Learn More</a>\n			</div>\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_3 et_pb_column_4  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_2  et_pb_text_align_left  et_pb_blurb_position_top et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-7-multicolor-1.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-32\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Social Media</span></h3>\n						<div class=\"et_pb_blurb_description\">Nulla porttitor accumsan tincidunt. Pellentesque in ipsum id orci porta dapibus. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb --><div class=\"et_pb_button_module_wrapper et_pb_button_3_wrapper et_pb_button_alignment_left et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_3 et_pb_bg_layout_light\" href=\"\">Learn More</a>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_2 et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_3\">\n				<div class=\"et_pb_column et_pb_column_4_4 et_pb_column_5  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_1  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">What we do for you</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class=\"et_pb_row et_pb_row_4 et_pb_gutters2\">\n				<div class=\"et_pb_column et_pb_column_1_3 et_pb_column_6  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_3  et_pb_text_align_left  et_pb_blurb_position_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><span class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone et-pb-icon\">&#x4c;</span></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Brand Perception</span></h3>\n						<div class=\"et_pb_blurb_description\">Nulla porttitor accumsan tincidunt. Pellentesque in ipsum id orci porta dapibus. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_3 et_pb_column_7  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_4  et_pb_text_align_left  et_pb_blurb_position_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><span class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone et-pb-icon\">&#x4c;</span></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Investments & Acquisitions</span></h3>\n						<div class=\"et_pb_blurb_description\">Nulla porttitor accumsan tincidunt. Pellentesque in ipsum id orci porta dapibus. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_3 et_pb_column_8  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_5  et_pb_text_align_left  et_pb_blurb_position_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><span class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone et-pb-icon\">&#x4c;</span></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Crisis Management</span></h3>\n						<div class=\"et_pb_blurb_description\">Nulla porttitor accumsan tincidunt. Pellentesque in ipsum id orci porta dapibus. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class=\"et_pb_row et_pb_row_5 et_pb_gutters2\">\n				<div class=\"et_pb_column et_pb_column_1_3 et_pb_column_9  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_6  et_pb_text_align_left  et_pb_blurb_position_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><span class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone et-pb-icon\">&#x4c;</span></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Launch Success</span></h3>\n						<div class=\"et_pb_blurb_description\">Nulla porttitor accumsan tincidunt. Pellentesque in ipsum id orci porta dapibus. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_3 et_pb_column_10  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_7  et_pb_text_align_left  et_pb_blurb_position_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><span class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone et-pb-icon\">&#x4c;</span></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Customer Reach</span></h3>\n						<div class=\"et_pb_blurb_description\">Nulla porttitor accumsan tincidunt. Pellentesque in ipsum id orci porta dapibus. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_3 et_pb_column_11  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_8  et_pb_text_align_left  et_pb_blurb_position_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><span class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone et-pb-icon\">&#x4c;</span></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Growth & Sales</span></h3>\n						<div class=\"et_pb_blurb_description\">Nulla porttitor accumsan tincidunt. Pellentesque in ipsum id orci porta dapibus. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_3 et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_6 et_pb_gutters4\">\n				<div class=\"et_pb_with_border et_pb_column_1_2 et_pb_column et_pb_column_12  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_with_border et_pb_module et_pb_image et_pb_image_0\">\n				\n				\n				<span class=\"et_pb_image_wrap has-box-shadow-overlay\"><div class=\"box-shadow-overlay\"></div><img loading=\"lazy\" width=\"1280\" height=\"996\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm_02.jpg\" alt=\"\" title=\"pr-firm_02\" srcset=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm_02.jpg 1280w, https://iexperipress.com/wp-content/uploads/2021/07/pr-firm_02-980x763.jpg 980w, https://iexperipress.com/wp-content/uploads/2021/07/pr-firm_02-480x374.jpg 480w\" sizes=\"(min-width: 0px) and (max-width: 480px) 480px, (min-width: 481px) and (max-width: 980px) 980px, (min-width: 981px) 1280px, 100vw\" class=\"wp-image-59\" /></span>\n			</div>\n			</div> <!-- .et_pb_column --><div class=\"et_pb_with_border et_pb_column_1_2 et_pb_column et_pb_column_13  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_2  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">About Us<br />\nMauris blandit aliquet elit, eget tincidunt nibh pulvinar a. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae. Donec velit neque, auctor sit amet aliquam vel, ullamcorper sit amet ligula. Vivamus magna justo</div>\n			</div> <!-- .et_pb_text --><div class=\"et_pb_button_module_wrapper et_pb_button_4_wrapper et_pb_button_alignment_left et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_4 et_pb_bg_layout_light\" href=\"\">Learn More</a>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_4 et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_7\">\n				<div class=\"et_pb_column et_pb_column_4_4 et_pb_column_14  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_3  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">Our Industries</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class=\"et_pb_row et_pb_row_8 et_pb_gutters2\">\n				<div class=\"et_pb_with_border et_pb_column_1_2 et_pb_column et_pb_column_15 et_clickable  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_9  et_pb_text_align_left  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-9-multicolor.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-17\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Enterprise Companies</span></h3>\n						<div class=\"et_pb_blurb_description\">Nulla porttitor accumsan tincidunt. Pellentesque in ipsum id orci porta dapibus. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_with_border et_pb_column_1_2 et_pb_column et_pb_column_16 et_clickable  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_10  et_pb_text_align_left  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-3-multicolor.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-18\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Consumer Products</span></h3>\n						<div class=\"et_pb_blurb_description\">Nulla porttitor accumsan tincidunt. Pellentesque in ipsum id orci porta dapibus. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class=\"et_pb_row et_pb_row_9 et_pb_gutters2\">\n				<div class=\"et_pb_with_border et_pb_column_1_2 et_pb_column et_pb_column_17 et_clickable  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_11  et_pb_text_align_left  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-6-multicolor.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-19\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Emerging Technology</span></h3>\n						<div class=\"et_pb_blurb_description\">Nulla porttitor accumsan tincidunt. Pellentesque in ipsum id orci porta dapibus. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_with_border et_pb_column_1_2 et_pb_column et_pb_column_18 et_clickable  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_12  et_pb_text_align_left  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><img loading=\"lazy\" width=\"48\" height=\"48\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/pr-firm-icon-1-multicolor.png\" alt=\"\" class=\"et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone wp-image-20\" /></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h3 class=\"et_pb_module_header\"><span>Financial Services</span></h3>\n						<div class=\"et_pb_blurb_description\">Nulla porttitor accumsan tincidunt. Pellentesque in ipsum id orci porta dapibus. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_5 et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_with_border et_pb_row et_pb_row_10\">\n				<div class=\"et_pb_column et_pb_column_4_4 et_pb_column_19  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_video et_pb_video_0\">\n				\n				\n				<div class=\"et_pb_video_box\"><iframe loading=\"lazy\" title=\"Divi. The Ultimate WordPress Theme And Visual Page Builder\" width=\"1080\" height=\"608\" src=\"https://www.youtube.com/embed/FkQuawiGWUw?feature=oembed\"  allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe></div>\n				<div style=\"background-image:url(https://iexperipress.com/wp-content/uploads/2021/07/pr-firm_04.jpg)\" class=\"et_pb_video_overlay\"><div class=\"et_pb_video_overlay_hover\"><a href=\"#\" class=\"et_pb_video_play\"></a></div></div>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_6 et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_with_border et_pb_row et_pb_row_11\">\n				<div class=\"et_pb_column et_pb_column_4_4 et_pb_column_20  et_pb_css_mix_blend_mode_passthrough et-last-child et_pb_column_empty\">\n				\n				\n				\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class=\"et_pb_row et_pb_row_12\">\n				<div class=\"et_pb_column et_pb_column_4_4 et_pb_column_21  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_4  et_pb_text_align_center et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">“Vivamus suscipit tortor eget felis porttitor volutpat. Donec sollicitudin.”</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class=\"et_pb_row et_pb_row_13 et_pb_gutters2\">\n				<div class=\"et_pb_column et_pb_column_1_6 et_pb_column_22  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_image et_pb_image_1\">\n				\n				\n				<span class=\"et_pb_image_wrap \"><img loading=\"lazy\" width=\"226\" height=\"100\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/logo_08.png\" alt=\"\" title=\"logo_08\" class=\"wp-image-61\" /></span>\n			</div>\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_6 et_pb_column_23  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_image et_pb_image_2\">\n				\n				\n				<span class=\"et_pb_image_wrap \"><img loading=\"lazy\" width=\"226\" height=\"100\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/logo_04.png\" alt=\"\" title=\"logo_04\" class=\"wp-image-62\" /></span>\n			</div>\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_6 et_pb_column_24  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_image et_pb_image_3\">\n				\n				\n				<span class=\"et_pb_image_wrap \"><img loading=\"lazy\" width=\"226\" height=\"100\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/logo_02.png\" alt=\"\" title=\"logo_02\" class=\"wp-image-63\" /></span>\n			</div>\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_6 et_pb_column_25  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_image et_pb_image_4\">\n				\n				\n				<span class=\"et_pb_image_wrap \"><img loading=\"lazy\" width=\"226\" height=\"100\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/logo_01.png\" alt=\"\" title=\"logo_01\" class=\"wp-image-64\" /></span>\n			</div>\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_6 et_pb_column_26  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_image et_pb_image_5\">\n				\n				\n				<span class=\"et_pb_image_wrap \"><img loading=\"lazy\" width=\"226\" height=\"100\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/logo_05.png\" alt=\"\" title=\"logo_05\" class=\"wp-image-65\" /></span>\n			</div>\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_6 et_pb_column_27  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_image et_pb_image_6\">\n				\n				\n				<span class=\"et_pb_image_wrap \"><img loading=\"lazy\" width=\"226\" height=\"100\" src=\"https://iexperipress.com/wp-content/uploads/2021/07/logo_06.png\" alt=\"\" title=\"logo_06\" class=\"wp-image-66\" /></span>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_7 et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_14\">\n				<div class=\"et_pb_column et_pb_column_4_4 et_pb_column_28  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_5  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">Articles</div>\n			</div> <!-- .et_pb_text --><div class=\"et_pb_with_border et_pb_module et_pb_blog_0 et_clickable et_pb_blog_grid_wrapper et_pb_bg_layout_light\">\n					<div class=\"et_pb_blog_grid clearfix \">\n					\n					\n					<div class=\"et_pb_ajax_pagination_container\">\n						<div class=\"et_pb_salvattore_content\" data-columns>\n			<article id=\"post-1\" class=\"et_pb_post clearfix et_pb_no_thumb et_pb_has_overlay et_pb_blog_item_0_0 post-1 post type-post status-publish format-standard hentry category-uncategorized\">\n\n				\n														<h2 class=\"entry-title\"><a href=\"https://iexperipress.com/hello-world/\">Hello world!</a></h2>\n				\n					<div class=\"post-content\"><div class=\"post-content-inner\"><p>Welcome to WordPress. This is your first post. Edit or delete it, then start writing!</p>\n</div></div>			\n			</article> <!-- .et_pb_post -->\n				</div><!-- .et_pb_salvattore_content -->\n					</div>\n					</div> <!-- .et_pb_posts --> \n				</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_with_border et_pb_section et_pb_section_8 et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_15 et_pb_equal_columns\">\n				<div class=\"et_pb_column et_pb_column_1_2 et_pb_column_29  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_6  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Get In Touch<br />\nGet In Touch</div>\n			</div> <!-- .et_pb_text --><div class=\"et_pb_button_module_wrapper et_pb_button_5_wrapper et_pb_button_alignment_left et_pb_module \">\n				<a class=\"et_pb_button et_pb_button_5 et_pb_bg_layout_light\" href=\"\">Contact us</a>\n			</div>\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_2 et_pb_column_30  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_with_border et_pb_module et_pb_signup_0 et_pb_newsletter_layout_top_bottom et_pb_newsletter et_pb_subscribe clearfix  et_pb_text_align_left et_pb_bg_layout_light et_pb_no_bg et_pb_newsletter_description_no_content\">\n				\n				\n				<div class=\"et_pb_newsletter_description\"><h2 class=\"et_pb_module_header\">Subscribe</h2></div>\n				\n				<div class=\"et_pb_newsletter_form\">\n					<form method=\"post\">\n						<div class=\"et_pb_newsletter_result et_pb_newsletter_error\"></div>\n						<div class=\"et_pb_newsletter_result et_pb_newsletter_success\">\n							<h2>Success!</h2>\n						</div>\n						<div class=\"et_pb_newsletter_fields\">\n							\n							\n							\n					<p class=\"et_pb_newsletter_field et_pb_contact_field_last et_pb_contact_field_last_tablet et_pb_contact_field_last_phone\">\n						<label class=\"et_pb_contact_form_label\" for=\"et_pb_signup_email\" style=\"display: none;\">Email</label>\n						<input id=\"et_pb_signup_email\" class=\"input\" type=\"text\" placeholder=\"Email\" name=\"et_pb_signup_email\">\n					</p>\n							\n							\n					<p class=\"et_pb_newsletter_button_wrap\">\n						<a class=\"et_pb_newsletter_button et_pb_button\" href=\"#\" data-icon=\"\">\n							<span class=\"et_subscribe_loader\"></span>\n							<span class=\"et_pb_newsletter_button_text\">Subscribe</span>\n						</a>\n					</p>\n							\n						</div>\n						\n						<input type=\"hidden\" value=\"mailchimp\" name=\"et_pb_signup_provider\" />\n						<input type=\"hidden\" value=\"42d4a98af1\" name=\"et_pb_signup_list_id\" />\n						<input type=\"hidden\" value=\"SlavaET\" name=\"et_pb_signup_account_name\" />\n						<input type=\"hidden\" value=\"true\" name=\"et_pb_signup_ip_address\" /><input type=\"hidden\" value=\"acafb339ba08b646e11af2dd76cd8314\" name=\"et_pb_signup_checksum\" />\n					</form>\n				</div>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_with_border et_pb_section et_pb_section_9 et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_16 et_pb_gutters2\">\n				<div class=\"et_pb_column et_pb_column_1_4 et_pb_column_31  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_7  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Address<br />\n1234 Divi St. #1000 San Francisco, CA 94220</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_4 et_pb_column_32  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_8  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Phone<br />\n(255) 352-6258</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_4 et_pb_column_33  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_9  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Email<br />\ninfo@diviyoga.com</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_4 et_pb_column_34  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_10  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Follow Us</div>\n			</div> <!-- .et_pb_text --><ul class=\"et_pb_module et_pb_social_media_follow et_pb_social_media_follow_0 clearfix  et_pb_bg_layout_light\">\n				\n				\n				<li\n            class=\'et_pb_social_media_follow_network_0 et_pb_social_icon et_pb_social_network_link  et-social-facebook et_pb_social_media_follow_network_0\'><a\n              href=\'#\'\n              class=\'icon et_pb_with_border\'\n              title=\'Follow on Facebook\'\n               target=\"_blank\"><span\n                class=\'et_pb_social_media_follow_network_name\'\n                aria-hidden=\'true\'\n                >Follow</span></a></li><li\n            class=\'et_pb_social_media_follow_network_1 et_pb_social_icon et_pb_social_network_link  et-social-twitter et_pb_social_media_follow_network_1\'><a\n              href=\'#\'\n              class=\'icon et_pb_with_border\'\n              title=\'Follow on Twitter\'\n               target=\"_blank\"><span\n                class=\'et_pb_social_media_follow_network_name\'\n                aria-hidden=\'true\'\n                >Follow</span></a></li><li\n            class=\'et_pb_social_media_follow_network_2 et_pb_social_icon et_pb_social_network_link  et-social-youtube et_pb_social_media_follow_network_2\'><a\n              href=\'#\'\n              class=\'icon et_pb_with_border\'\n              title=\'Follow on Youtube\'\n               target=\"_blank\"><span\n                class=\'et_pb_social_media_follow_network_name\'\n                aria-hidden=\'true\'\n                >Follow</span></a></li>\n			</ul> <!-- .et_pb_counters -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --></p>\n"),
("229","56","_et_pb_truncate_post_date","2021-07-13 21:28:33"),
("230","56","_et_builder_version","VB|Divi|4.9.7"),
("231","56","_et_pb_show_page_creation","off"),
("232","68","_et_autogenerated_title","1"),
("233","68","_et_default","0"),
("234","68","_et_enabled","1"),
("235","68","_et_header_layout_id","0"),
("236","68","_et_header_layout_enabled","1"),
("237","68","_et_body_layout_id","0"),
("238","68","_et_body_layout_enabled","1"),
("239","68","_et_footer_layout_id","0"),
("240","68","_et_footer_layout_enabled","0"),
("241","68","_et_use_on","singular:post_type:page:all"),
("242","22","_et_template","23"),
("243","22","_et_template","68"),
("244","69","_menu_item_type","post_type"),
("245","69","_menu_item_menu_item_parent","0"),
("246","69","_menu_item_object_id","56"),
("247","69